// components/services/storage/public/mojom/cache_storage_control.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_CACHE_STORAGE_CONTROL_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_CACHE_STORAGE_CONTROL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/services/storage/public/mojom/cache_storage_control.mojom-features.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/cache_storage_control.mojom-shared.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/cache_storage_control.mojom-forward.h"  // IWYU pragma: export
#include "components/services/storage/public/mojom/buckets/bucket_locator.mojom.h"
#include "components/services/storage/public/mojom/storage_policy_update.mojom-forward.h"
#include "components/services/storage/public/mojom/storage_usage_info.mojom-forward.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom.h"
#include "services/network/public/mojom/document_isolation_policy.mojom.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-forward.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace storage::mojom {

class CacheStorageObserverProxy;

template <typename ImplRefTraits>
class CacheStorageObserverStub;

class CacheStorageObserverRequestValidator;


class CacheStorageObserver
    : public CacheStorageObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CacheStorageObserverInterfaceBase;
  using Proxy_ = CacheStorageObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = CacheStorageObserverStub<ImplRefTraits>;

  using RequestValidator_ = CacheStorageObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCacheListChangedMinVersion = 0,
    kOnCacheContentChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnCacheListChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnCacheContentChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CacheStorageObserver() = default;

  
  virtual void OnCacheListChanged(const ::storage::BucketLocator& bucket_locator) = 0;

  
  virtual void OnCacheContentChanged(const ::storage::BucketLocator& bucket_locator, const std::string& cache_name) = 0;
};

class CacheStorageControlProxy;

template <typename ImplRefTraits>
class CacheStorageControlStub;

class CacheStorageControlRequestValidator;


class CacheStorageControl
    : public CacheStorageControlInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CacheStorageControlInterfaceBase;
  using Proxy_ = CacheStorageControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = CacheStorageControlStub<ImplRefTraits>;

  using RequestValidator_ = CacheStorageControlRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddReceiverMinVersion = 0,
    kAddObserverMinVersion = 0,
    kApplyPolicyUpdatesMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddReceiver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ApplyPolicyUpdates_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CacheStorageControl() = default;

  
  virtual void AddReceiver(const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy, ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> coep_reporter, const ::network::DocumentIsolationPolicy& document_isolation_policy, ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter> dip_reporter, const ::storage::BucketLocator& bucket_locator, CacheStorageOwner owner, ::mojo::PendingReceiver<::blink::mojom::CacheStorage> receiver) = 0;

  
  virtual void AddObserver(::mojo::PendingRemote<CacheStorageObserver> observer) = 0;

  
  virtual void ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates) = 0;
};



class  CacheStorageObserverProxy
    : public CacheStorageObserver {
 public:
  using InterfaceType = CacheStorageObserver;

  explicit CacheStorageObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnCacheListChanged(const ::storage::BucketLocator& bucket_locator) final;
  
  void OnCacheContentChanged(const ::storage::BucketLocator& bucket_locator, const std::string& cache_name) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CacheStorageControlProxy
    : public CacheStorageControl {
 public:
  using InterfaceType = CacheStorageControl;

  explicit CacheStorageControlProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddReceiver(const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy, ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> coep_reporter, const ::network::DocumentIsolationPolicy& document_isolation_policy, ::mojo::PendingRemote<::network::mojom::DocumentIsolationPolicyReporter> dip_reporter, const ::storage::BucketLocator& bucket_locator, CacheStorageOwner owner, ::mojo::PendingReceiver<::blink::mojom::CacheStorage> receiver) final;
  
  void AddObserver(::mojo::PendingRemote<CacheStorageObserver> observer) final;
  
  void ApplyPolicyUpdates(std::vector<::storage::mojom::StoragePolicyUpdatePtr> policy_updates) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CacheStorageObserverStubDispatch {
 public:
  static bool Accept(CacheStorageObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CacheStorageObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CacheStorageObserver>>
class CacheStorageObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CacheStorageObserverStub() = default;
  ~CacheStorageObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CacheStorageObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CacheStorageObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CacheStorageControlStubDispatch {
 public:
  static bool Accept(CacheStorageControl* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CacheStorageControl* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CacheStorageControl>>
class CacheStorageControlStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CacheStorageControlStub() = default;
  ~CacheStorageControlStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CacheStorageControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CacheStorageControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CacheStorageObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CacheStorageControlRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // storage::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_CACHE_STORAGE_CONTROL_MOJOM_H_