// device/vr/public/mojom/xr_session.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_SHARED_H_
#define DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "device/vr/public/mojom/xr_session.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace device::mojom {
class XRTrackedImageDataView;

class XRDepthOptionsDataView;

class XRSessionOptionsDataView;

class XrFrameStatisticsDataView;

class XrLogMessageDataView;



}  // device::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::XRTrackedImageDataView> {
  using Data = ::device::mojom::internal::XRTrackedImage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRDepthOptionsDataView> {
  using Data = ::device::mojom::internal::XRDepthOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XRSessionOptionsDataView> {
  using Data = ::device::mojom::internal::XRSessionOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XrFrameStatisticsDataView> {
  using Data = ::device::mojom::internal::XrFrameStatistics_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::XrLogMessageDataView> {
  using Data = ::device::mojom::internal::XrLogMessage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class RequestSessionError : int32_t {
  
  EXISTING_IMMERSIVE_SESSION = 1,
  
  INVALID_CLIENT = 2,
  
  USER_DENIED_CONSENT = 3,
  
  NO_RUNTIME_FOUND = 4,
  
  UNKNOWN_RUNTIME_ERROR = 5,
  
  RUNTIME_INSTALL_FAILURE = 6,
  
  RUNTIMES_CHANGED = 7,
  
  FULLSCREEN_ERROR = 8,
  
  UNKNOWN_FAILURE = 9,
  kMinValue = 1,
  kMaxValue = 9,
};

COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, RequestSessionError value);
inline bool IsKnownEnumValue(RequestSessionError value) {
  return internal::RequestSessionError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRSessionFeature : int32_t {
  
  REF_SPACE_VIEWER = 1,
  
  REF_SPACE_LOCAL = 2,
  
  REF_SPACE_LOCAL_FLOOR = 3,
  
  REF_SPACE_BOUNDED_FLOOR = 4,
  
  REF_SPACE_UNBOUNDED = 5,
  
  DOM_OVERLAY = 6,
  
  HIT_TEST = 7,
  
  LIGHT_ESTIMATION = 8,
  
  ANCHORS = 9,
  
  CAMERA_ACCESS = 10,
  
  PLANE_DETECTION = 11,
  
  DEPTH = 12,
  
  IMAGE_TRACKING = 13,
  
  HAND_INPUT = 14,
  
  SECONDARY_VIEWS = 15,
  
  LAYERS = 16,
  
  FRONT_FACING = 17,
  
  WEBGPU = 18,
  kMinValue = 1,
  kMaxValue = 18,
};

COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRSessionFeature value);
inline bool IsKnownEnumValue(XRSessionFeature value) {
  return internal::XRSessionFeature_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRSessionMode : int32_t {
  
  kInline = 1,
  
  kImmersiveVr = 2,
  
  kImmersiveAr = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRSessionMode value);
inline bool IsKnownEnumValue(XRSessionMode value) {
  return internal::XRSessionMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRDepthUsage : int32_t {
  
  kCPUOptimized = 1,
  
  kGPUOptimized = 2,
  kMinValue = 1,
  kMaxValue = 2,
};

COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRDepthUsage value);
inline bool IsKnownEnumValue(XRDepthUsage value) {
  return internal::XRDepthUsage_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class XRDepthDataFormat : int32_t {
  
  kLuminanceAlpha = 1,
  
  kFloat32 = 2,
  
  kUnsignedShort = 3,
  kMinValue = 1,
  kMaxValue = 3,
};

COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) std::ostream& operator<<(std::ostream& os, XRDepthDataFormat value);
inline bool IsKnownEnumValue(XRDepthDataFormat value) {
  return internal::XRDepthDataFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class XRTrackedImageDataView {
 public:
  XRTrackedImageDataView() = default;

  XRTrackedImageDataView(
      internal::XRTrackedImage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBitmapDataView(
      ::skia::mojom::BitmapN32DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitmap(UserType* output) {
    
    auto* pointer = data_->bitmap.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32DataView>(
        pointer, output, message_);
  }
  inline void GetSizeInPixelsDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSizeInPixels(UserType* output) {
    
    auto* pointer = data_->size_in_pixels.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  float width_in_meters() const {
    return data_->width_in_meters;
  }
 private:
  internal::XRTrackedImage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRDepthOptionsDataView {
 public:
  XRDepthOptionsDataView() = default;

  XRDepthOptionsDataView(
      internal::XRDepthOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUsagePreferencesDataView(
      mojo::ArrayDataView<XRDepthUsage>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsagePreferences(UserType* output) {
    
    auto* pointer = data_->usage_preferences.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRDepthUsage>>(
        pointer, output, message_);
  }
  inline void GetDataFormatPreferencesDataView(
      mojo::ArrayDataView<XRDepthDataFormat>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataFormatPreferences(UserType* output) {
    
    auto* pointer = data_->data_format_preferences.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRDepthDataFormat>>(
        pointer, output, message_);
  }
 private:
  internal::XRDepthOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XRSessionOptionsDataView {
 public:
  XRSessionOptionsDataView() = default;

  XRSessionOptionsDataView(
      internal::XRSessionOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::device::mojom::XRSessionMode>(
        data_value, output);
  }
  XRSessionMode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::XRSessionMode>(data_->mode));
  }
  inline void GetRequiredFeaturesDataView(
      mojo::ArrayDataView<XRSessionFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequiredFeatures(UserType* output) {
    
    auto* pointer = data_->required_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        pointer, output, message_);
  }
  inline void GetOptionalFeaturesDataView(
      mojo::ArrayDataView<XRSessionFeature>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOptionalFeatures(UserType* output) {
    
    auto* pointer = data_->optional_features.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        pointer, output, message_);
  }
  inline void GetTrackedImagesDataView(
      mojo::ArrayDataView<XRTrackedImageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrackedImages(UserType* output) {
    
    auto* pointer = data_->tracked_images.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::XRTrackedImageDataView>>(
        pointer, output, message_);
  }
  inline void GetDepthOptionsDataView(
      XRDepthOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDepthOptions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::XRDepthOptionsDataView, UserType>(),
    "Attempting to read the optional `depth_options` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDepthOptions` instead "
    "of `ReadDepthOptions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->depth_options.Get();
    return mojo::internal::Deserialize<::device::mojom::XRDepthOptionsDataView>(
        pointer, output, message_);
  }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
 private:
  internal::XRSessionOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XrFrameStatisticsDataView {
 public:
  XrFrameStatisticsDataView() = default;

  XrFrameStatisticsDataView(
      internal::XrFrameStatistics_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  uint64_t num_frames() const {
    return data_->num_frames;
  }
  uint64_t dropped_frames() const {
    return data_->dropped_frames;
  }
  inline void GetFrameDataTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameDataTime(UserType* output) {
    
    auto* pointer = data_->frame_data_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetPageAnimationFrameTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageAnimationFrameTime(UserType* output) {
    
    auto* pointer = data_->page_animation_frame_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetSubmitFrameTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubmitFrameTime(UserType* output) {
    
    auto* pointer = data_->submit_frame_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::XrFrameStatistics_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class XrLogMessageDataView {
 public:
  XrLogMessageDataView() = default;

  XrLogMessageDataView(
      internal::XrLogMessage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint64_t trace_id() const {
    return data_->trace_id;
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::XrLogMessage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // device::mojom

namespace std {

template <>
struct hash<::device::mojom::RequestSessionError>
    : public mojo::internal::EnumHashImpl<::device::mojom::RequestSessionError> {};

template <>
struct hash<::device::mojom::XRSessionFeature>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRSessionFeature> {};

template <>
struct hash<::device::mojom::XRSessionMode>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRSessionMode> {};

template <>
struct hash<::device::mojom::XRDepthUsage>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRDepthUsage> {};

template <>
struct hash<::device::mojom::XRDepthDataFormat>
    : public mojo::internal::EnumHashImpl<::device::mojom::XRDepthDataFormat> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::RequestSessionError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::RequestSessionError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::RequestSessionError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionFeature, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRSessionFeature, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRSessionFeature>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRSessionMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRSessionMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthUsage, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRDepthUsage, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRDepthUsage>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthDataFormat, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::XRDepthDataFormat, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::XRDepthDataFormat>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRTrackedImageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRTrackedImageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRTrackedImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::bitmap(input)) in_bitmap = Traits::bitmap(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bitmap)::BaseType> bitmap_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
        in_bitmap, bitmap_fragment);
    fragment->bitmap.Set(
        bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bitmap.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bitmap in XRTrackedImage struct");
    decltype(Traits::size_in_pixels(input)) in_size_in_pixels = Traits::size_in_pixels(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->size_in_pixels)::BaseType> size_in_pixels_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_size_in_pixels, size_in_pixels_fragment);
    fragment->size_in_pixels.Set(
        size_in_pixels_fragment.is_null() ? nullptr : size_in_pixels_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->size_in_pixels.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null size_in_pixels in XRTrackedImage struct");
    fragment->width_in_meters = Traits::width_in_meters(input);
  }

  static bool Deserialize(::device::mojom::internal::XRTrackedImage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRTrackedImageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRDepthOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRDepthOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRDepthOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::usage_preferences(input)) in_usage_preferences = Traits::usage_preferences(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->usage_preferences)::BaseType>
        usage_preferences_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& usage_preferences_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRDepthUsage_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRDepthUsage>>(
        in_usage_preferences, usage_preferences_fragment, &usage_preferences_validate_params);
    fragment->usage_preferences.Set(
        usage_preferences_fragment.is_null() ? nullptr : usage_preferences_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->usage_preferences.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null usage_preferences in XRDepthOptions struct");
    decltype(Traits::data_format_preferences(input)) in_data_format_preferences = Traits::data_format_preferences(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data_format_preferences)::BaseType>
        data_format_preferences_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_format_preferences_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRDepthDataFormat_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRDepthDataFormat>>(
        in_data_format_preferences, data_format_preferences_fragment, &data_format_preferences_validate_params);
    fragment->data_format_preferences.Set(
        data_format_preferences_fragment.is_null() ? nullptr : data_format_preferences_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data_format_preferences.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data_format_preferences in XRDepthOptions struct");
  }

  static bool Deserialize(::device::mojom::internal::XRDepthOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRDepthOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XRSessionOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XRSessionOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XRSessionOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::device::mojom::XRSessionMode>(
        Traits::mode(input), &fragment->mode);
    decltype(Traits::required_features(input)) in_required_features = Traits::required_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->required_features)::BaseType>
        required_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& required_features_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        in_required_features, required_features_fragment, &required_features_validate_params);
    fragment->required_features.Set(
        required_features_fragment.is_null() ? nullptr : required_features_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->required_features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null required_features in XRSessionOptions struct");
    decltype(Traits::optional_features(input)) in_optional_features = Traits::optional_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->optional_features)::BaseType>
        optional_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& optional_features_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::device::mojom::internal::XRSessionFeature_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRSessionFeature>>(
        in_optional_features, optional_features_fragment, &optional_features_validate_params);
    fragment->optional_features.Set(
        optional_features_fragment.is_null() ? nullptr : optional_features_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->optional_features.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null optional_features in XRSessionOptions struct");
    decltype(Traits::tracked_images(input)) in_tracked_images = Traits::tracked_images(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tracked_images)::BaseType>
        tracked_images_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& tracked_images_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::XRTrackedImageDataView>>(
        in_tracked_images, tracked_images_fragment, &tracked_images_validate_params);
    fragment->tracked_images.Set(
        tracked_images_fragment.is_null() ? nullptr : tracked_images_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tracked_images.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tracked_images in XRSessionOptions struct");
    decltype(Traits::depth_options(input)) in_depth_options = Traits::depth_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->depth_options)::BaseType> depth_options_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::XRDepthOptionsDataView>(
        in_depth_options, depth_options_fragment);
    fragment->depth_options.Set(
        depth_options_fragment.is_null() ? nullptr : depth_options_fragment.data());
    fragment->trace_id = Traits::trace_id(input);
  }

  static bool Deserialize(::device::mojom::internal::XRSessionOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XRSessionOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XrFrameStatisticsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XrFrameStatisticsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XrFrameStatistics_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->trace_id = Traits::trace_id(input);
    decltype(Traits::duration(input)) in_duration = Traits::duration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->duration)::BaseType> duration_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_duration, duration_fragment);
    fragment->duration.Set(
        duration_fragment.is_null() ? nullptr : duration_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->duration.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null duration in XrFrameStatistics struct");
    fragment->num_frames = Traits::num_frames(input);
    fragment->dropped_frames = Traits::dropped_frames(input);
    decltype(Traits::frame_data_time(input)) in_frame_data_time = Traits::frame_data_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_data_time)::BaseType> frame_data_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_frame_data_time, frame_data_time_fragment);
    fragment->frame_data_time.Set(
        frame_data_time_fragment.is_null() ? nullptr : frame_data_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_data_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_data_time in XrFrameStatistics struct");
    decltype(Traits::page_animation_frame_time(input)) in_page_animation_frame_time = Traits::page_animation_frame_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_animation_frame_time)::BaseType> page_animation_frame_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_page_animation_frame_time, page_animation_frame_time_fragment);
    fragment->page_animation_frame_time.Set(
        page_animation_frame_time_fragment.is_null() ? nullptr : page_animation_frame_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->page_animation_frame_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null page_animation_frame_time in XrFrameStatistics struct");
    decltype(Traits::submit_frame_time(input)) in_submit_frame_time = Traits::submit_frame_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->submit_frame_time)::BaseType> submit_frame_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_submit_frame_time, submit_frame_time_fragment);
    fragment->submit_frame_time.Set(
        submit_frame_time_fragment.is_null() ? nullptr : submit_frame_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->submit_frame_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null submit_frame_time in XrFrameStatistics struct");
  }

  static bool Deserialize(::device::mojom::internal::XrFrameStatistics_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XrFrameStatisticsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::XrLogMessageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::XrLogMessageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::XrLogMessage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->trace_id = Traits::trace_id(input);
    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_message, message_fragment);
    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->message.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in XrLogMessage struct");
  }

  static bool Deserialize(::device::mojom::internal::XrLogMessage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::XrLogMessageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {

inline void XRTrackedImageDataView::GetBitmapDataView(
    ::skia::mojom::BitmapN32DataView* output) {
  auto pointer = data_->bitmap.Get();
  *output = ::skia::mojom::BitmapN32DataView(pointer, message_);
}
inline void XRTrackedImageDataView::GetSizeInPixelsDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->size_in_pixels.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void XRDepthOptionsDataView::GetUsagePreferencesDataView(
    mojo::ArrayDataView<XRDepthUsage>* output) {
  auto pointer = data_->usage_preferences.Get();
  *output = mojo::ArrayDataView<XRDepthUsage>(pointer, message_);
}
inline void XRDepthOptionsDataView::GetDataFormatPreferencesDataView(
    mojo::ArrayDataView<XRDepthDataFormat>* output) {
  auto pointer = data_->data_format_preferences.Get();
  *output = mojo::ArrayDataView<XRDepthDataFormat>(pointer, message_);
}


inline void XRSessionOptionsDataView::GetRequiredFeaturesDataView(
    mojo::ArrayDataView<XRSessionFeature>* output) {
  auto pointer = data_->required_features.Get();
  *output = mojo::ArrayDataView<XRSessionFeature>(pointer, message_);
}
inline void XRSessionOptionsDataView::GetOptionalFeaturesDataView(
    mojo::ArrayDataView<XRSessionFeature>* output) {
  auto pointer = data_->optional_features.Get();
  *output = mojo::ArrayDataView<XRSessionFeature>(pointer, message_);
}
inline void XRSessionOptionsDataView::GetTrackedImagesDataView(
    mojo::ArrayDataView<XRTrackedImageDataView>* output) {
  auto pointer = data_->tracked_images.Get();
  *output = mojo::ArrayDataView<XRTrackedImageDataView>(pointer, message_);
}
inline void XRSessionOptionsDataView::GetDepthOptionsDataView(
    XRDepthOptionsDataView* output) {
  auto pointer = data_->depth_options.Get();
  *output = XRDepthOptionsDataView(pointer, message_);
}


inline void XrFrameStatisticsDataView::GetDurationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->duration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void XrFrameStatisticsDataView::GetFrameDataTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->frame_data_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void XrFrameStatisticsDataView::GetPageAnimationFrameTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->page_animation_frame_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void XrFrameStatisticsDataView::GetSubmitFrameTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->submit_frame_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void XrLogMessageDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::RequestSessionError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::RequestSessionError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRSessionFeature> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRSessionFeature value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRSessionMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRSessionMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRDepthUsage> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRDepthUsage value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(DEVICE_XR_COMMON_MOJO_BINDINGS_SHARED) TraceFormatTraits<::device::mojom::XRDepthDataFormat> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::XRDepthDataFormat value);
};

} // namespace perfetto

#endif  // DEVICE_VR_PUBLIC_MOJOM_XR_SESSION_MOJOM_SHARED_H_