// media/mojo/mojom/speech_recognition_recognition_context.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RECOGNITION_CONTEXT_MOJOM_BLINK_H_
#define MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RECOGNITION_CONTEXT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/speech_recognition_recognition_context.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition_recognition_context.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/speech_recognition_recognition_context.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media::mojom::blink {





class BLINK_PLATFORM_EXPORT SpeechRecognitionPhrase {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeechRecognitionPhrase, T>::value>;
  using DataView = SpeechRecognitionPhraseDataView;
  using Data_ = internal::SpeechRecognitionPhrase_Data;

  template <typename... Args>
  static SpeechRecognitionPhrasePtr New(Args&&... args) {
    return SpeechRecognitionPhrasePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeechRecognitionPhrasePtr From(const U& u) {
    return mojo::TypeConverter<SpeechRecognitionPhrasePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeechRecognitionPhrase>::Convert(*this);
  }


  SpeechRecognitionPhrase();

  SpeechRecognitionPhrase(
      const WTF::String& phrase,
      float boost);


  ~SpeechRecognitionPhrase();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeechRecognitionPhrasePtr>
  SpeechRecognitionPhrasePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeechRecognitionPhrase::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpeechRecognitionPhrase::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpeechRecognitionPhrase::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionPhrase::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeechRecognitionPhrase::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeechRecognitionPhrase_UnserializedMessageContext<
            UserType, SpeechRecognitionPhrase::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpeechRecognitionPhrase::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpeechRecognitionPhrase::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeechRecognitionPhrase_UnserializedMessageContext<
            UserType, SpeechRecognitionPhrase::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeechRecognitionPhrase::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::String phrase;
  
  float boost;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeechRecognitionPhrase::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeechRecognitionPhrase::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeechRecognitionPhrase::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeechRecognitionPhrase::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_PLATFORM_EXPORT SpeechRecognitionRecognitionContext {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeechRecognitionRecognitionContext, T>::value>;
  using DataView = SpeechRecognitionRecognitionContextDataView;
  using Data_ = internal::SpeechRecognitionRecognitionContext_Data;

  template <typename... Args>
  static SpeechRecognitionRecognitionContextPtr New(Args&&... args) {
    return SpeechRecognitionRecognitionContextPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeechRecognitionRecognitionContextPtr From(const U& u) {
    return mojo::TypeConverter<SpeechRecognitionRecognitionContextPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeechRecognitionRecognitionContext>::Convert(*this);
  }


  SpeechRecognitionRecognitionContext();

  explicit SpeechRecognitionRecognitionContext(
      WTF::Vector<SpeechRecognitionPhrasePtr> phrases);

SpeechRecognitionRecognitionContext(const SpeechRecognitionRecognitionContext&) = delete;
SpeechRecognitionRecognitionContext& operator=(const SpeechRecognitionRecognitionContext&) = delete;

  ~SpeechRecognitionRecognitionContext();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeechRecognitionRecognitionContextPtr>
  SpeechRecognitionRecognitionContextPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeechRecognitionRecognitionContext::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpeechRecognitionRecognitionContext::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpeechRecognitionRecognitionContext::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeechRecognitionRecognitionContext::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeechRecognitionRecognitionContext::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeechRecognitionRecognitionContext_UnserializedMessageContext<
            UserType, SpeechRecognitionRecognitionContext::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpeechRecognitionRecognitionContext::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpeechRecognitionRecognitionContext::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeechRecognitionRecognitionContext_UnserializedMessageContext<
            UserType, SpeechRecognitionRecognitionContext::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeechRecognitionRecognitionContext::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  WTF::Vector<SpeechRecognitionPhrasePtr> phrases;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeechRecognitionRecognitionContext::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeechRecognitionRecognitionContext::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeechRecognitionRecognitionContext::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeechRecognitionRecognitionContext::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SpeechRecognitionPhrasePtr SpeechRecognitionPhrase::Clone() const {
  return New(
      mojo::Clone(phrase),
      mojo::Clone(boost)
  );
}

template <typename T, SpeechRecognitionPhrase::EnableIfSame<T>*>
bool SpeechRecognitionPhrase::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->phrase, other_struct.phrase))
    return false;
  if (!mojo::Equals(this->boost, other_struct.boost))
    return false;
  return true;
}

template <typename T, SpeechRecognitionPhrase::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.phrase < rhs.phrase)
    return true;
  if (rhs.phrase < lhs.phrase)
    return false;
  if (lhs.boost < rhs.boost)
    return true;
  if (rhs.boost < lhs.boost)
    return false;
  return false;
}
template <typename StructPtrType>
SpeechRecognitionRecognitionContextPtr SpeechRecognitionRecognitionContext::Clone() const {
  return New(
      mojo::Clone(phrases)
  );
}

template <typename T, SpeechRecognitionRecognitionContext::EnableIfSame<T>*>
bool SpeechRecognitionRecognitionContext::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->phrases, other_struct.phrases))
    return false;
  return true;
}

template <typename T, SpeechRecognitionRecognitionContext::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.phrases < rhs.phrases)
    return true;
  if (rhs.phrases < lhs.phrases)
    return false;
  return false;
}


}  // media::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::SpeechRecognitionPhrase::DataView,
                                         ::media::mojom::blink::SpeechRecognitionPhrasePtr> {
  static bool IsNull(const ::media::mojom::blink::SpeechRecognitionPhrasePtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::SpeechRecognitionPhrasePtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::SpeechRecognitionPhrase::phrase)& phrase(
      const ::media::mojom::blink::SpeechRecognitionPhrasePtr& input) {
    return input->phrase;
  }

  static decltype(::media::mojom::blink::SpeechRecognitionPhrase::boost) boost(
      const ::media::mojom::blink::SpeechRecognitionPhrasePtr& input) {
    return input->boost;
  }

  static bool Read(::media::mojom::blink::SpeechRecognitionPhrase::DataView input, ::media::mojom::blink::SpeechRecognitionPhrasePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media::mojom::blink::SpeechRecognitionRecognitionContext::DataView,
                                         ::media::mojom::blink::SpeechRecognitionRecognitionContextPtr> {
  static bool IsNull(const ::media::mojom::blink::SpeechRecognitionRecognitionContextPtr& input) { return !input; }
  static void SetToNull(::media::mojom::blink::SpeechRecognitionRecognitionContextPtr* output) { output->reset(); }

  static const decltype(::media::mojom::blink::SpeechRecognitionRecognitionContext::phrases)& phrases(
      const ::media::mojom::blink::SpeechRecognitionRecognitionContextPtr& input) {
    return input->phrases;
  }

  static bool Read(::media::mojom::blink::SpeechRecognitionRecognitionContext::DataView input, ::media::mojom::blink::SpeechRecognitionRecognitionContextPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_SPEECH_RECOGNITION_RECOGNITION_CONTEXT_MOJOM_BLINK_H_