// qtwebengine/browser/qtwebenginepage.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QTWEBENGINE_BROWSER_QTWEBENGINEPAGE_MOJOM_H_
#define QTWEBENGINE_BROWSER_QTWEBENGINEPAGE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "qtwebengine/browser/qtwebenginepage.mojom-features.h"  // IWYU pragma: export
#include "qtwebengine/browser/qtwebenginepage.mojom-shared.h"  // IWYU pragma: export
#include "qtwebengine/browser/qtwebenginepage.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace qtwebenginepage::mojom {

class WebEnginePageRenderFrameProxy;

template <typename ImplRefTraits>
class WebEnginePageRenderFrameStub;

class WebEnginePageRenderFrameRequestValidator;
class WebEnginePageRenderFrameResponseValidator;


class WebEnginePageRenderFrame
    : public WebEnginePageRenderFrameInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebEnginePageRenderFrameInterfaceBase;
  using Proxy_ = WebEnginePageRenderFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebEnginePageRenderFrameStub<ImplRefTraits>;

  using RequestValidator_ = WebEnginePageRenderFrameRequestValidator;
  using ResponseValidator_ = WebEnginePageRenderFrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kFetchDocumentMarkupMinVersion = 0,
    kFetchDocumentInnerTextMinVersion = 0,
    kSetBackgroundColorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct FetchDocumentMarkup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FetchDocumentInnerText_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBackgroundColor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebEnginePageRenderFrame() = default;


  using FetchDocumentMarkupCallback = base::OnceCallback<void(uint64_t, const std::string&)>;
  
  virtual void FetchDocumentMarkup(uint64_t requestId, FetchDocumentMarkupCallback callback) = 0;


  using FetchDocumentInnerTextCallback = base::OnceCallback<void(uint64_t, const std::string&)>;
  
  virtual void FetchDocumentInnerText(uint64_t requestId, FetchDocumentInnerTextCallback callback) = 0;

  
  virtual void SetBackgroundColor(uint32_t color) = 0;
};



class  WebEnginePageRenderFrameProxy
    : public WebEnginePageRenderFrame {
 public:
  using InterfaceType = WebEnginePageRenderFrame;

  explicit WebEnginePageRenderFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void FetchDocumentMarkup(uint64_t requestId, FetchDocumentMarkupCallback callback) final;
  
  void FetchDocumentInnerText(uint64_t requestId, FetchDocumentInnerTextCallback callback) final;
  
  void SetBackgroundColor(uint32_t color) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebEnginePageRenderFrameStubDispatch {
 public:
  static bool Accept(WebEnginePageRenderFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebEnginePageRenderFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebEnginePageRenderFrame>>
class WebEnginePageRenderFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebEnginePageRenderFrameStub() = default;
  ~WebEnginePageRenderFrameStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebEnginePageRenderFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebEnginePageRenderFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebEnginePageRenderFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebEnginePageRenderFrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // qtwebenginepage::mojom

namespace mojo {

}  // namespace mojo

#endif  // QTWEBENGINE_BROWSER_QTWEBENGINEPAGE_MOJOM_H_