// services/network/public/mojom/cookie_partition_key.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/cookie_partition_key.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cookie_partition_key.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* AncestorChainBitToStringHelper(AncestorChainBit value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AncestorChainBit::kSameSite:
      return "kSameSite";
    case AncestorChainBit::kCrossSite:
      return "kCrossSite";
    default:
      return nullptr;
  }
}

std::string AncestorChainBitToString(AncestorChainBit value) {
  const char *str = AncestorChainBitToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AncestorChainBit value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AncestorChainBit value) {
  return os << AncestorChainBitToString(value);
}

namespace internal {


// static
bool CookiePartitionKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CookiePartitionKey_Data* object =
      static_cast<const CookiePartitionKey_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->nonce, validation_context))
    return false;


  if (!::network::mojom::internal::AncestorChainBit_Data
        ::Validate(object->ancestor_chain_bit, validation_context))
    return false;

  return true;
}

CookiePartitionKey_Data::CookiePartitionKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CookiePartitionKeyCollection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CookiePartitionKeyCollection_Data* object =
      static_cast<const CookiePartitionKeyCollection_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->keys, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->keys, validation_context,
                                         &keys_validate_params)) {
    return false;
  }

  return true;
}

CookiePartitionKeyCollection_Data::CookiePartitionKeyCollection_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::AncestorChainBit>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::AncestorChainBit value) {
  return std::move(context).WriteString(::network::mojom::AncestorChainBitToString(value));
}

} // namespace perfetto