// services/network/public/mojom/document_isolation_policy.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/document_isolation_policy.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/document_isolation_policy.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* DocumentIsolationPolicyValueToStringHelper(DocumentIsolationPolicyValue value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DocumentIsolationPolicyValue::kNone:
      return "kNone";
    case DocumentIsolationPolicyValue::kIsolateAndRequireCorp:
      return "kIsolateAndRequireCorp";
    case DocumentIsolationPolicyValue::kIsolateAndCredentialless:
      return "kIsolateAndCredentialless";
    default:
      return nullptr;
  }
}

std::string DocumentIsolationPolicyValueToString(DocumentIsolationPolicyValue value) {
  const char *str = DocumentIsolationPolicyValueToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DocumentIsolationPolicyValue value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DocumentIsolationPolicyValue value) {
  return os << DocumentIsolationPolicyValueToString(value);
}

namespace internal {


// static
bool DocumentIsolationPolicy_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentIsolationPolicy_Data* object =
      static_cast<const DocumentIsolationPolicy_Data*>(data);


  if (!::network::mojom::internal::DocumentIsolationPolicyValue_Data
        ::Validate(object->value, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& reporting_endpoint_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reporting_endpoint, validation_context,
                                         &reporting_endpoint_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::DocumentIsolationPolicyValue_Data
        ::Validate(object->report_only_value, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& report_only_reporting_endpoint_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->report_only_reporting_endpoint, validation_context,
                                         &report_only_reporting_endpoint_validate_params)) {
    return false;
  }

  return true;
}

DocumentIsolationPolicy_Data::DocumentIsolationPolicy_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params_Data* object =
      static_cast<const DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->blocked_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->blocked_url, validation_context))
    return false;


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->destination, validation_context))
    return false;

  return true;
}

DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params_Data::DocumentIsolationPolicyReporter_QueueCorpViolationReport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DocumentIsolationPolicyReporter_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DocumentIsolationPolicyReporter_Clone_Params_Data* object =
      static_cast<const DocumentIsolationPolicyReporter_Clone_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DocumentIsolationPolicyReporter_Clone_Params_Data::DocumentIsolationPolicyReporter_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::DocumentIsolationPolicyValue>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::DocumentIsolationPolicyValue value) {
  return std::move(context).WriteString(::network::mojom::DocumentIsolationPolicyValueToString(value));
}

} // namespace perfetto