// services/network/public/mojom/network_param.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_PARAM_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_PARAM_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_param.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/scheme_host_port.mojom-shared.h"



#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace network::mojom {
class AuthChallengeInfoDataView;

using AuthCredentialsDataView = mojo::native::NativeStructDataView;

using CertVerifyResultDataView = mojo::native::NativeStructDataView;

using HttpResponseHeadersDataView = mojo::native::NativeStructDataView;

class HttpVersionDataView;

class HostPortPairDataView;

class ProxyServerDataView;

class ProxyChainDataView;

class ResolveErrorInfoDataView;

class SSLCertRequestInfoDataView;

using SSLInfoDataView = mojo::native::NativeStructDataView;

using X509CertificateDataView = mojo::native::NativeStructDataView;

class NetLogSourceDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::AuthChallengeInfoDataView> {
  using Data = ::network::mojom::internal::AuthChallengeInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::HttpVersionDataView> {
  using Data = ::network::mojom::internal::HttpVersion_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::HostPortPairDataView> {
  using Data = ::network::mojom::internal::HostPortPair_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ProxyServerDataView> {
  using Data = ::network::mojom::internal::ProxyServer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ProxyChainDataView> {
  using Data = ::network::mojom::internal::ProxyChain_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ResolveErrorInfoDataView> {
  using Data = ::network::mojom::internal::ResolveErrorInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SSLCertRequestInfoDataView> {
  using Data = ::network::mojom::internal::SSLCertRequestInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetLogSourceDataView> {
  using Data = ::network::mojom::internal::NetLogSource_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class ProxyScheme : int32_t {
  
  kInvalid = 0,
  
  kHttp = 1,
  
  kSocks4 = 2,
  
  kSocks5 = 3,
  
  kHttps = 4,
  
  kQuic = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, ProxyScheme value);
inline bool IsKnownEnumValue(ProxyScheme value) {
  return internal::ProxyScheme_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class AuthChallengeInfoDataView {
 public:
  AuthChallengeInfoDataView() = default;

  AuthChallengeInfoDataView(
      internal::AuthChallengeInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_proxy() const {
    return data_->is_proxy;
  }
  inline void GetChallengerDataView(
      ::url::mojom::SchemeHostPortDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChallenger(UserType* output) {
    
    auto* pointer = data_->challenger.Get();
    return mojo::internal::Deserialize<::url::mojom::SchemeHostPortDataView>(
        pointer, output, message_);
  }
  inline void GetSchemeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScheme(UserType* output) {
    
    auto* pointer = data_->scheme.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRealmDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRealm(UserType* output) {
    
    auto* pointer = data_->realm.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetChallengeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChallenge(UserType* output) {
    
    auto* pointer = data_->challenge.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPathDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::AuthChallengeInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HttpVersionDataView {
 public:
  HttpVersionDataView() = default;

  HttpVersionDataView(
      internal::HttpVersion_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint16_t major_value() const {
    return data_->major_value;
  }
  uint16_t minor_value() const {
    return data_->minor_value;
  }
 private:
  internal::HttpVersion_Data* data_ = nullptr;
};


class HostPortPairDataView {
 public:
  HostPortPairDataView() = default;

  HostPortPairDataView(
      internal::HostPortPair_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHost(UserType* output) {
    
    auto* pointer = data_->host.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint16_t port() const {
    return data_->port;
  }
 private:
  internal::HostPortPair_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProxyServerDataView {
 public:
  ProxyServerDataView() = default;

  ProxyServerDataView(
      internal::ProxyServer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadScheme(UserType* output) const {
    auto data_value = data_->scheme;
    return mojo::internal::Deserialize<::network::mojom::ProxyScheme>(
        data_value, output);
  }
  ProxyScheme scheme() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ProxyScheme>(data_->scheme));
  }
  inline void GetHostAndPortDataView(
      HostPortPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostAndPort(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::HostPortPairDataView, UserType>(),
    "Attempting to read the optional `host_and_port` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHostAndPort` instead "
    "of `ReadHostAndPort if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->host_and_port.Get();
    return mojo::internal::Deserialize<::network::mojom::HostPortPairDataView>(
        pointer, output, message_);
  }
 private:
  internal::ProxyServer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ProxyChainDataView {
 public:
  ProxyChainDataView() = default;

  ProxyChainDataView(
      internal::ProxyChain_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProxyServersDataView(
      mojo::ArrayDataView<ProxyServerDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxyServers(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::network::mojom::ProxyServerDataView>, UserType>(),
    "Attempting to read the optional `proxy_servers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadProxyServers` instead "
    "of `ReadProxyServers if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->proxy_servers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::ProxyServerDataView>>(
        pointer, output, message_);
  }
  int32_t ip_protection_chain_id() const {
    return data_->ip_protection_chain_id;
  }
 private:
  internal::ProxyChain_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResolveErrorInfoDataView {
 public:
  ResolveErrorInfoDataView() = default;

  ResolveErrorInfoDataView(
      internal::ResolveErrorInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t error() const {
    return data_->error;
  }
  bool is_secure_network_error() const {
    return data_->is_secure_network_error;
  }
 private:
  internal::ResolveErrorInfo_Data* data_ = nullptr;
};


class SSLCertRequestInfoDataView {
 public:
  SSLCertRequestInfoDataView() = default;

  SSLCertRequestInfoDataView(
      internal::SSLCertRequestInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHostAndPortDataView(
      HostPortPairDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostAndPort(UserType* output) {
    
    auto* pointer = data_->host_and_port.Get();
    return mojo::internal::Deserialize<::network::mojom::HostPortPairDataView>(
        pointer, output, message_);
  }
  bool is_proxy() const {
    return data_->is_proxy;
  }
  inline void GetCertAuthoritiesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCertAuthorities(UserType* output) {
    
    auto* pointer = data_->cert_authorities.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetSignatureAlgorithmsDataView(
      mojo::ArrayDataView<uint16_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignatureAlgorithms(UserType* output) {
    
    auto* pointer = data_->signature_algorithms.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint16_t>>(
        pointer, output, message_);
  }
 private:
  internal::SSLCertRequestInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetLogSourceDataView {
 public:
  NetLogSourceDataView() = default;

  NetLogSourceDataView(
      internal::NetLogSource_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  uint32_t source_type() const {
    return data_->source_type;
  }
  uint32_t source_id() const {
    return data_->source_id;
  }
  inline void GetStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStartTime(UserType* output) {
    
    auto* pointer = data_->start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::NetLogSource_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

template <>
struct hash<::network::mojom::ProxyScheme>
    : public mojo::internal::EnumHashImpl<::network::mojom::ProxyScheme> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyScheme, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ProxyScheme, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ProxyScheme>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::AuthChallengeInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::AuthChallengeInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::AuthChallengeInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->is_proxy = Traits::is_proxy(input);
    decltype(Traits::challenger(input)) in_challenger = Traits::challenger(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->challenger)::BaseType> challenger_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::SchemeHostPortDataView>(
        in_challenger, challenger_fragment);
    fragment->challenger.Set(
        challenger_fragment.is_null() ? nullptr : challenger_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->challenger.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null challenger in AuthChallengeInfo struct");
    decltype(Traits::scheme(input)) in_scheme = Traits::scheme(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scheme)::BaseType> scheme_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_scheme, scheme_fragment);
    fragment->scheme.Set(
        scheme_fragment.is_null() ? nullptr : scheme_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scheme.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scheme in AuthChallengeInfo struct");
    decltype(Traits::realm(input)) in_realm = Traits::realm(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->realm)::BaseType> realm_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_realm, realm_fragment);
    fragment->realm.Set(
        realm_fragment.is_null() ? nullptr : realm_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->realm.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null realm in AuthChallengeInfo struct");
    decltype(Traits::challenge(input)) in_challenge = Traits::challenge(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->challenge)::BaseType> challenge_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_challenge, challenge_fragment);
    fragment->challenge.Set(
        challenge_fragment.is_null() ? nullptr : challenge_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->challenge.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null challenge in AuthChallengeInfo struct");
    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_path, path_fragment);
    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->path.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in AuthChallengeInfo struct");
  }

  static bool Deserialize(::network::mojom::internal::AuthChallengeInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::AuthChallengeInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HttpVersionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HttpVersionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HttpVersion_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->major_value = Traits::major_value(input);
    fragment->minor_value = Traits::minor_value(input);
  }

  static bool Deserialize(::network::mojom::internal::HttpVersion_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::HttpVersionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HostPortPairDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HostPortPairDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HostPortPair_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::host(input)) in_host = Traits::host(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host)::BaseType> host_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_host, host_fragment);
    fragment->host.Set(
        host_fragment.is_null() ? nullptr : host_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->host.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host in HostPortPair struct");
    fragment->port = Traits::port(input);
  }

  static bool Deserialize(::network::mojom::internal::HostPortPair_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::HostPortPairDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyServerDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyServerDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyServer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::network::mojom::ProxyScheme>(
        Traits::scheme(input), &fragment->scheme);
    decltype(Traits::host_and_port(input)) in_host_and_port = Traits::host_and_port(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host_and_port)::BaseType> host_and_port_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
        in_host_and_port, host_and_port_fragment);
    fragment->host_and_port.Set(
        host_and_port_fragment.is_null() ? nullptr : host_and_port_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::ProxyServer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ProxyServerDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ProxyChainDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ProxyChainDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ProxyChain_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::proxy_servers(input)) in_proxy_servers = Traits::proxy_servers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxy_servers)::BaseType>
        proxy_servers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& proxy_servers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ProxyServerDataView>>(
        in_proxy_servers, proxy_servers_fragment, &proxy_servers_validate_params);
    fragment->proxy_servers.Set(
        proxy_servers_fragment.is_null() ? nullptr : proxy_servers_fragment.data());
    fragment->ip_protection_chain_id = Traits::ip_protection_chain_id(input);
  }

  static bool Deserialize(::network::mojom::internal::ProxyChain_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ProxyChainDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ResolveErrorInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ResolveErrorInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ResolveErrorInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->error = Traits::error(input);
    fragment->is_secure_network_error = Traits::is_secure_network_error(input);
  }

  static bool Deserialize(::network::mojom::internal::ResolveErrorInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ResolveErrorInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SSLCertRequestInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SSLCertRequestInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SSLCertRequestInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::host_and_port(input)) in_host_and_port = Traits::host_and_port(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host_and_port)::BaseType> host_and_port_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
        in_host_and_port, host_and_port_fragment);
    fragment->host_and_port.Set(
        host_and_port_fragment.is_null() ? nullptr : host_and_port_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->host_and_port.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null host_and_port in SSLCertRequestInfo struct");
    fragment->is_proxy = Traits::is_proxy(input);
    decltype(Traits::cert_authorities(input)) in_cert_authorities = Traits::cert_authorities(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cert_authorities)::BaseType>
        cert_authorities_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cert_authorities_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_cert_authorities, cert_authorities_fragment, &cert_authorities_validate_params);
    fragment->cert_authorities.Set(
        cert_authorities_fragment.is_null() ? nullptr : cert_authorities_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cert_authorities.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cert_authorities in SSLCertRequestInfo struct");
    decltype(Traits::signature_algorithms(input)) in_signature_algorithms = Traits::signature_algorithms(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->signature_algorithms)::BaseType>
        signature_algorithms_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& signature_algorithms_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>>(
        in_signature_algorithms, signature_algorithms_fragment, &signature_algorithms_validate_params);
    fragment->signature_algorithms.Set(
        signature_algorithms_fragment.is_null() ? nullptr : signature_algorithms_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->signature_algorithms.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signature_algorithms in SSLCertRequestInfo struct");
  }

  static bool Deserialize(::network::mojom::internal::SSLCertRequestInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SSLCertRequestInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NetLogSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetLogSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NetLogSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->source_type = Traits::source_type(input);
    fragment->source_id = Traits::source_id(input);
    decltype(Traits::start_time(input)) in_start_time = Traits::start_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->start_time)::BaseType> start_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_start_time, start_time_fragment);
    fragment->start_time.Set(
        start_time_fragment.is_null() ? nullptr : start_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->start_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_time in NetLogSource struct");
  }

  static bool Deserialize(::network::mojom::internal::NetLogSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NetLogSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void AuthChallengeInfoDataView::GetChallengerDataView(
    ::url::mojom::SchemeHostPortDataView* output) {
  auto pointer = data_->challenger.Get();
  *output = ::url::mojom::SchemeHostPortDataView(pointer, message_);
}
inline void AuthChallengeInfoDataView::GetSchemeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->scheme.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AuthChallengeInfoDataView::GetRealmDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->realm.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AuthChallengeInfoDataView::GetChallengeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->challenge.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AuthChallengeInfoDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void HostPortPairDataView::GetHostDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void ProxyServerDataView::GetHostAndPortDataView(
    HostPortPairDataView* output) {
  auto pointer = data_->host_and_port.Get();
  *output = HostPortPairDataView(pointer, message_);
}


inline void ProxyChainDataView::GetProxyServersDataView(
    mojo::ArrayDataView<ProxyServerDataView>* output) {
  auto pointer = data_->proxy_servers.Get();
  *output = mojo::ArrayDataView<ProxyServerDataView>(pointer, message_);
}




inline void SSLCertRequestInfoDataView::GetHostAndPortDataView(
    HostPortPairDataView* output) {
  auto pointer = data_->host_and_port.Get();
  *output = HostPortPairDataView(pointer, message_);
}
inline void SSLCertRequestInfoDataView::GetCertAuthoritiesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->cert_authorities.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void SSLCertRequestInfoDataView::GetSignatureAlgorithmsDataView(
    mojo::ArrayDataView<uint16_t>* output) {
  auto pointer = data_->signature_algorithms.Get();
  *output = mojo::ArrayDataView<uint16_t>(pointer, message_);
}


inline void NetLogSourceDataView::GetStartTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->start_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ProxyScheme> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ProxyScheme value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_PARAM_MOJOM_SHARED_H_