// services/service_manager/public/mojom/interface_provider.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/service_manager/public/mojom/interface_provider.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/service_manager/public/mojom/interface_provider.mojom-params-data.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-shared-message-ids.h"

#include "services/service_manager/public/mojom/interface_provider.mojom-import-headers.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-test-utils.h"


namespace service_manager::mojom {
const char InterfaceProvider::Name_[] = "service_manager.mojom.InterfaceProvider";

InterfaceProvider::IPCStableHashFunction InterfaceProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::InterfaceProvider>(message.name())) {
    case messages::InterfaceProvider::kGetInterface: {
      return &InterfaceProvider::GetInterface_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* InterfaceProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::InterfaceProvider>(message.name())) {
      case messages::InterfaceProvider::kGetInterface:
            return "Receive service_manager::mojom::InterfaceProvider::GetInterface";
    }
  } else {
    switch (static_cast<messages::InterfaceProvider>(message.name())) {
      case messages::InterfaceProvider::kGetInterface:
            return "Receive reply service_manager::mojom::InterfaceProvider::GetInterface";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t InterfaceProvider::GetInterface_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)service_manager::mojom::InterfaceProvider::GetInterface");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

InterfaceProviderProxy::InterfaceProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void InterfaceProviderProxy::GetInterface(
    const std::string& in_interface_name, ::mojo::ScopedMessagePipeHandle in_pipe) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send service_manager::mojom::InterfaceProvider::GetInterface", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("interface_name"), in_interface_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pipe"), in_pipe,
                        "<value of type ::mojo::ScopedMessagePipeHandle>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::InterfaceProvider::kGetInterface), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::service_manager::mojom::internal::InterfaceProvider_GetInterface_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->interface_name)::BaseType> interface_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_interface_name, interface_name_fragment);
  params->interface_name.Set(
      interface_name_fragment.is_null() ? nullptr : interface_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->interface_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null interface_name in InterfaceProvider.GetInterface request");
  mojo::internal::Serialize<mojo::ScopedMessagePipeHandle>(
      in_pipe, &params->pipe, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pipe),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid pipe in InterfaceProvider.GetInterface request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(InterfaceProvider::Name_);
  message.set_method_name("GetInterface");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool InterfaceProviderStubDispatch::Accept(
    InterfaceProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::InterfaceProvider>(message->header()->name)) {
    case messages::InterfaceProvider::kGetInterface: {
      DCHECK(message->is_serialized());
      internal::InterfaceProvider_GetInterface_Params_Data* params =
          reinterpret_cast<internal::InterfaceProvider_GetInterface_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for InterfaceProvider.0
      bool success = true;
      std::string p_interface_name{};
      ::mojo::ScopedMessagePipeHandle p_pipe{};
      InterfaceProvider_GetInterface_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInterfaceName(&p_interface_name))
        success = false;
      if (success)
        p_pipe = input_data_view.TakePipe();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            InterfaceProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetInterface(        
        std::move(p_interface_name), 
        std::move(p_pipe));
      return true;
    }
  }
  return false;
}

// static
bool InterfaceProviderStubDispatch::AcceptWithResponder(
    InterfaceProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::InterfaceProvider>(message->header()->name)) {
    case messages::InterfaceProvider::kGetInterface: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kInterfaceProviderValidationInfo[] = {
    {base::to_underlying(messages::InterfaceProvider::kGetInterface),
     { &internal::InterfaceProvider_GetInterface_Params_Data::Validate,
      nullptr /* no response */}},
};

bool InterfaceProviderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::service_manager::mojom::InterfaceProvider::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kInterfaceProviderValidationInfo);
}



}  // service_manager::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace service_manager::mojom {


void InterfaceProviderInterceptorForTesting::GetInterface(const std::string& interface_name, ::mojo::ScopedMessagePipeHandle pipe) {
  GetForwardingInterface()->GetInterface(
    std::move(interface_name)
    , 
    std::move(pipe)
    );
}
InterfaceProviderAsyncWaiter::InterfaceProviderAsyncWaiter(
    InterfaceProvider* proxy) : proxy_(proxy) {}

InterfaceProviderAsyncWaiter::~InterfaceProviderAsyncWaiter() = default;






}  // service_manager::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif