// third_party/blink/public/mojom/mediasession/media_session.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/mediasession/media_session.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/mediasession/media_session.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/mediasession/media_session.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "services/media_session/public/mojom/media_session.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class MediaSessionClientProxy;

template <typename ImplRefTraits>
class MediaSessionClientStub;

class MediaSessionClientRequestValidator;


class BLINK_COMMON_EXPORT MediaSessionClient
    : public MediaSessionClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaSessionClientInterfaceBase;
  using Proxy_ = MediaSessionClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaSessionClientStub<ImplRefTraits>;

  using RequestValidator_ = MediaSessionClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kDidReceiveActionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DidReceiveAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaSessionClient() = default;

  
  virtual void DidReceiveAction(::media_session::mojom::MediaSessionAction action, MediaSessionActionDetailsPtr details) = 0;
};

class MediaSessionServiceProxy;

template <typename ImplRefTraits>
class MediaSessionServiceStub;

class MediaSessionServiceRequestValidator;


class BLINK_COMMON_EXPORT MediaSessionService
    : public MediaSessionServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MediaSessionServiceInterfaceBase;
  using Proxy_ = MediaSessionServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaSessionServiceStub<ImplRefTraits>;

  using RequestValidator_ = MediaSessionServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kSetPlaybackStateMinVersion = 0,
    kSetPositionStateMinVersion = 0,
    kSetMetadataMinVersion = 0,
    kSetMicrophoneStateMinVersion = 0,
    kSetCameraStateMinVersion = 0,
    kEnableActionMinVersion = 0,
    kDisableActionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPlaybackState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPositionState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMetadata_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMicrophoneState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCameraState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisableAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MediaSessionService() = default;

  
  virtual void SetClient(::mojo::PendingRemote<MediaSessionClient> client) = 0;

  
  virtual void SetPlaybackState(MediaSessionPlaybackState state) = 0;

  
  virtual void SetPositionState(const std::optional<::media_session::MediaPosition>& position) = 0;

  
  virtual void SetMetadata(SpecMediaMetadataPtr metadata) = 0;

  
  virtual void SetMicrophoneState(::media_session::mojom::MicrophoneState microphone_state) = 0;

  
  virtual void SetCameraState(::media_session::mojom::CameraState camera_state) = 0;

  
  virtual void EnableAction(::media_session::mojom::MediaSessionAction action) = 0;

  
  virtual void DisableAction(::media_session::mojom::MediaSessionAction action) = 0;
};



class BLINK_COMMON_EXPORT MediaSessionClientProxy
    : public MediaSessionClient {
 public:
  using InterfaceType = MediaSessionClient;

  explicit MediaSessionClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DidReceiveAction(::media_session::mojom::MediaSessionAction action, MediaSessionActionDetailsPtr details) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT MediaSessionServiceProxy
    : public MediaSessionService {
 public:
  using InterfaceType = MediaSessionService;

  explicit MediaSessionServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingRemote<MediaSessionClient> client) final;
  
  void SetPlaybackState(MediaSessionPlaybackState state) final;
  
  void SetPositionState(const std::optional<::media_session::MediaPosition>& position) final;
  
  void SetMetadata(SpecMediaMetadataPtr metadata) final;
  
  void SetMicrophoneState(::media_session::mojom::MicrophoneState microphone_state) final;
  
  void SetCameraState(::media_session::mojom::CameraState camera_state) final;
  
  void EnableAction(::media_session::mojom::MediaSessionAction action) final;
  
  void DisableAction(::media_session::mojom::MediaSessionAction action) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT MediaSessionClientStubDispatch {
 public:
  static bool Accept(MediaSessionClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaSessionClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaSessionClient>>
class MediaSessionClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaSessionClientStub() = default;
  ~MediaSessionClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT MediaSessionServiceStubDispatch {
 public:
  static bool Accept(MediaSessionService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaSessionService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaSessionService>>
class MediaSessionServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaSessionServiceStub() = default;
  ~MediaSessionServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT MediaSessionClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT MediaSessionServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};







class BLINK_COMMON_EXPORT MediaSessionActionDetails {
 public:
  using DataView = MediaSessionActionDetailsDataView;
  using Data_ = internal::MediaSessionActionDetails_Data;
  using Tag = Data_::MediaSessionActionDetails_Tag;

  template <typename... Args>
  static MediaSessionActionDetailsPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |seek_to|.
  static MediaSessionActionDetailsPtr
  NewSeekTo(
      MediaSessionSeekToDetailsPtr value) {
    auto result = MediaSessionActionDetailsPtr(std::in_place);
    result->set_seek_to(std::move(value));
    return result;
  }

  template <typename U>
  static MediaSessionActionDetailsPtr From(const U& u) {
    return mojo::TypeConverter<MediaSessionActionDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaSessionActionDetails>::Convert(*this);
  }

  MediaSessionActionDetails();
  ~MediaSessionActionDetails();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  MediaSessionActionDetails(const MediaSessionActionDetails& other) = delete;
  MediaSessionActionDetails& operator=(const MediaSessionActionDetails& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = MediaSessionActionDetailsPtr>
  MediaSessionActionDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, MediaSessionActionDetails>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, MediaSessionActionDetails>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }


  
  bool is_seek_to() const { return tag_ == Tag::kSeekTo; }

  
  MediaSessionSeekToDetailsPtr& get_seek_to() const {
    CHECK(tag_ == Tag::kSeekTo);
    return *(data_.seek_to);
  }

  
  void set_seek_to(
      MediaSessionSeekToDetailsPtr seek_to);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaSessionActionDetails::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<MediaSessionActionDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    MediaSessionSeekToDetailsPtr* seek_to;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class BLINK_COMMON_EXPORT MediaSessionSeekToDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaSessionSeekToDetails, T>::value>;
  using DataView = MediaSessionSeekToDetailsDataView;
  using Data_ = internal::MediaSessionSeekToDetails_Data;

  template <typename... Args>
  static MediaSessionSeekToDetailsPtr New(Args&&... args) {
    return MediaSessionSeekToDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaSessionSeekToDetailsPtr From(const U& u) {
    return mojo::TypeConverter<MediaSessionSeekToDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaSessionSeekToDetails>::Convert(*this);
  }


  MediaSessionSeekToDetails();

  MediaSessionSeekToDetails(
      ::base::TimeDelta seek_time,
      bool fast_seek);


  ~MediaSessionSeekToDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaSessionSeekToDetailsPtr>
  MediaSessionSeekToDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaSessionSeekToDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaSessionSeekToDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaSessionSeekToDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaSessionSeekToDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaSessionSeekToDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaSessionSeekToDetails_UnserializedMessageContext<
            UserType, MediaSessionSeekToDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaSessionSeekToDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaSessionSeekToDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaSessionSeekToDetails_UnserializedMessageContext<
            UserType, MediaSessionSeekToDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaSessionSeekToDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeDelta seek_time;
  
  bool fast_seek;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaSessionSeekToDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaSessionSeekToDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaSessionSeekToDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaSessionSeekToDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_COMMON_EXPORT SpecMediaMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpecMediaMetadata, T>::value>;
  using DataView = SpecMediaMetadataDataView;
  using Data_ = internal::SpecMediaMetadata_Data;

  template <typename... Args>
  static SpecMediaMetadataPtr New(Args&&... args) {
    return SpecMediaMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpecMediaMetadataPtr From(const U& u) {
    return mojo::TypeConverter<SpecMediaMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpecMediaMetadata>::Convert(*this);
  }


  SpecMediaMetadata();

  SpecMediaMetadata(
      const ::std::u16string& title,
      const ::std::u16string& artist,
      const ::std::u16string& album,
      std::vector<::media_session::MediaImage> artwork,
      std::vector<::media_session::ChapterInformation> chapterInfo);


  ~SpecMediaMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpecMediaMetadataPtr>
  SpecMediaMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpecMediaMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpecMediaMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpecMediaMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpecMediaMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpecMediaMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpecMediaMetadata_UnserializedMessageContext<
            UserType, SpecMediaMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpecMediaMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpecMediaMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpecMediaMetadata_UnserializedMessageContext<
            UserType, SpecMediaMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpecMediaMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string title;
  
  ::std::u16string artist;
  
  ::std::u16string album;
  
  std::vector<::media_session::MediaImage> artwork;
  
  std::vector<::media_session::ChapterInformation> chapterInfo;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpecMediaMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpecMediaMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpecMediaMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpecMediaMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
MediaSessionActionDetailsPtr MediaSessionActionDetails::Clone() const {
  switch (tag_) {
    case Tag::kSeekTo:
      return NewSeekTo(
          mojo::Clone(*data_.seek_to));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, MediaSessionActionDetails>::value>::type*>
bool MediaSessionActionDetails::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kSeekTo:
      return mojo::Equals(*(data_.seek_to), *(other.data_.seek_to));
  }

  return false;
}
template <typename StructPtrType>
MediaSessionSeekToDetailsPtr MediaSessionSeekToDetails::Clone() const {
  return New(
      mojo::Clone(seek_time),
      mojo::Clone(fast_seek)
  );
}

template <typename T, MediaSessionSeekToDetails::EnableIfSame<T>*>
bool MediaSessionSeekToDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->seek_time, other_struct.seek_time))
    return false;
  if (!mojo::Equals(this->fast_seek, other_struct.fast_seek))
    return false;
  return true;
}

template <typename T, MediaSessionSeekToDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.seek_time < rhs.seek_time)
    return true;
  if (rhs.seek_time < lhs.seek_time)
    return false;
  if (lhs.fast_seek < rhs.fast_seek)
    return true;
  if (rhs.fast_seek < lhs.fast_seek)
    return false;
  return false;
}
template <typename StructPtrType>
SpecMediaMetadataPtr SpecMediaMetadata::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(artist),
      mojo::Clone(album),
      mojo::Clone(artwork),
      mojo::Clone(chapterInfo)
  );
}

template <typename T, SpecMediaMetadata::EnableIfSame<T>*>
bool SpecMediaMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->artist, other_struct.artist))
    return false;
  if (!mojo::Equals(this->album, other_struct.album))
    return false;
  if (!mojo::Equals(this->artwork, other_struct.artwork))
    return false;
  if (!mojo::Equals(this->chapterInfo, other_struct.chapterInfo))
    return false;
  return true;
}

template <typename T, SpecMediaMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.artist < rhs.artist)
    return true;
  if (rhs.artist < lhs.artist)
    return false;
  if (lhs.album < rhs.album)
    return true;
  if (rhs.album < lhs.album)
    return false;
  if (lhs.artwork < rhs.artwork)
    return true;
  if (rhs.artwork < lhs.artwork)
    return false;
  if (lhs.chapterInfo < rhs.chapterInfo)
    return true;
  if (rhs.chapterInfo < lhs.chapterInfo)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::MediaSessionSeekToDetails::DataView,
                                         ::blink::mojom::MediaSessionSeekToDetailsPtr> {
  static bool IsNull(const ::blink::mojom::MediaSessionSeekToDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::MediaSessionSeekToDetailsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::MediaSessionSeekToDetails::seek_time)& seek_time(
      const ::blink::mojom::MediaSessionSeekToDetailsPtr& input) {
    return input->seek_time;
  }

  static decltype(::blink::mojom::MediaSessionSeekToDetails::fast_seek) fast_seek(
      const ::blink::mojom::MediaSessionSeekToDetailsPtr& input) {
    return input->fast_seek;
  }

  static bool Read(::blink::mojom::MediaSessionSeekToDetails::DataView input, ::blink::mojom::MediaSessionSeekToDetailsPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SpecMediaMetadata::DataView,
                                         ::blink::mojom::SpecMediaMetadataPtr> {
  static bool IsNull(const ::blink::mojom::SpecMediaMetadataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SpecMediaMetadataPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SpecMediaMetadata::title)& title(
      const ::blink::mojom::SpecMediaMetadataPtr& input) {
    return input->title;
  }

  static const decltype(::blink::mojom::SpecMediaMetadata::artist)& artist(
      const ::blink::mojom::SpecMediaMetadataPtr& input) {
    return input->artist;
  }

  static const decltype(::blink::mojom::SpecMediaMetadata::album)& album(
      const ::blink::mojom::SpecMediaMetadataPtr& input) {
    return input->album;
  }

  static const decltype(::blink::mojom::SpecMediaMetadata::artwork)& artwork(
      const ::blink::mojom::SpecMediaMetadataPtr& input) {
    return input->artwork;
  }

  static const decltype(::blink::mojom::SpecMediaMetadata::chapterInfo)& chapterInfo(
      const ::blink::mojom::SpecMediaMetadataPtr& input) {
    return input->chapterInfo;
  }

  static bool Read(::blink::mojom::SpecMediaMetadata::DataView input, ::blink::mojom::SpecMediaMetadataPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT UnionTraits<::blink::mojom::MediaSessionActionDetails::DataView,
                                        ::blink::mojom::MediaSessionActionDetailsPtr> {
  static bool IsNull(const ::blink::mojom::MediaSessionActionDetailsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::MediaSessionActionDetailsPtr* output) { output->reset(); }

  static ::blink::mojom::MediaSessionActionDetails::Tag GetTag(const ::blink::mojom::MediaSessionActionDetailsPtr& input) {
    return input->which();
  }

  static const ::blink::mojom::MediaSessionSeekToDetailsPtr& seek_to(const ::blink::mojom::MediaSessionActionDetailsPtr& input) {
    return input->get_seek_to();
  }

  static bool Read(::blink::mojom::MediaSessionActionDetails::DataView input, ::blink::mojom::MediaSessionActionDetailsPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIASESSION_MEDIA_SESSION_MOJOM_H_