// third_party/blink/public/mojom/partitioned_popins/partitioned_popin_params.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PARTITIONED_POPINS_PARTITIONED_POPIN_PARAMS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PARTITIONED_POPINS_PARTITIONED_POPIN_PARAMS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/partitioned_popins/partitioned_popin_params.mojom-shared-internal.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class PartitionedPopinParamsDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PartitionedPopinParamsDataView> {
  using Data = ::blink::mojom::internal::PartitionedPopinParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class PartitionedPopinParamsDataView {
 public:
  PartitionedPopinParamsDataView() = default;

  PartitionedPopinParamsDataView(
      internal::PartitionedPopinParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetOpenerTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOpenerTopFrameOrigin(UserType* output) {
    
    auto* pointer = data_->opener_top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetOpenerSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOpenerSiteForCookies(UserType* output) {
    
    auto* pointer = data_->opener_site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, message_);
  }
 private:
  internal::PartitionedPopinParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PartitionedPopinParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PartitionedPopinParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PartitionedPopinParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::opener_top_frame_origin(input)) in_opener_top_frame_origin = Traits::opener_top_frame_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->opener_top_frame_origin)::BaseType> opener_top_frame_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_opener_top_frame_origin, opener_top_frame_origin_fragment);
    fragment->opener_top_frame_origin.Set(
        opener_top_frame_origin_fragment.is_null() ? nullptr : opener_top_frame_origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->opener_top_frame_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null opener_top_frame_origin in PartitionedPopinParams struct");
    decltype(Traits::opener_site_for_cookies(input)) in_opener_site_for_cookies = Traits::opener_site_for_cookies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->opener_site_for_cookies)::BaseType> opener_site_for_cookies_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
        in_opener_site_for_cookies, opener_site_for_cookies_fragment);
    fragment->opener_site_for_cookies.Set(
        opener_site_for_cookies_fragment.is_null() ? nullptr : opener_site_for_cookies_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->opener_site_for_cookies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null opener_site_for_cookies in PartitionedPopinParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::PartitionedPopinParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PartitionedPopinParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void PartitionedPopinParamsDataView::GetOpenerTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->opener_top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void PartitionedPopinParamsDataView::GetOpenerSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->opener_site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PARTITIONED_POPINS_PARTITIONED_POPIN_PARAMS_MOJOM_SHARED_H_