// A Bison parser, made by GNU Bison 3.8.2.

// Skeleton interface for Bison LALR(1) parsers in C++

// Copyright (C) 2002-2015, 2018-2021 Free Software Foundation, Inc.

// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// As a special exception, you may create a larger work that contains
// part or all of the Bison parser skeleton and distribute that work
// under terms of your choice, so long as that work isn't itself a
// parser generator using the skeleton or a modified version thereof
// as a parser skeleton.  Alternatively, if you modify or redistribute
// the parser skeleton itself, you may (at your option) remove this
// special exception, which will cause the skeleton and the resulting
// Bison output files to be licensed under the GNU General Public
// License without this special exception.

// This special exception was added by the Free Software Foundation in
// version 2.2 of Bison.


/**
 ** \file /build/rgbds/src/rgbds/src/asm/parser.hpp
 ** Define the yy::parser class.
 */

// C++ LALR(1) parser skeleton written by Akim Demaille.

// DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
// especially those whose name start with YY_ or yy_.  They are
// private implementation details that can be changed or removed.

#ifndef YY_YY_BUILD_RGBDS_SRC_RGBDS_SRC_ASM_PARSER_HPP_INCLUDED
# define YY_YY_BUILD_RGBDS_SRC_RGBDS_SRC_ASM_PARSER_HPP_INCLUDED
// "%code requires" blocks.
#line 7 "asm/parser.y"

	#include <stdint.h>
	#include <string>
	#include <variant>
	#include <vector>

	#include "linkdefs.hpp"

	#include "asm/actions.hpp"
	#include "asm/lexer.hpp"
	#include "asm/macro.hpp"
	#include "asm/rpn.hpp"
	#include "asm/section.hpp"

	struct ForArgs {
		int32_t start;
		int32_t stop;
		int32_t step;
	};

	struct StrFmtArgList {
		std::string format;
		std::vector<std::variant<uint32_t, std::string>> args;
	};

#line 75 "/build/rgbds/src/rgbds/src/asm/parser.hpp"


# include <cstdlib> // std::abort
# include <iostream>
# include <stdexcept>
# include <string>
# include <vector>

#if defined __cplusplus
# define YY_CPLUSPLUS __cplusplus
#else
# define YY_CPLUSPLUS 199711L
#endif

// Support move semantics when possible.
#if 201103L <= YY_CPLUSPLUS
# define YY_MOVE           std::move
# define YY_MOVE_OR_COPY   move
# define YY_MOVE_REF(Type) Type&&
# define YY_RVREF(Type)    Type&&
# define YY_COPY(Type)     Type
#else
# define YY_MOVE
# define YY_MOVE_OR_COPY   copy
# define YY_MOVE_REF(Type) Type&
# define YY_RVREF(Type)    const Type&
# define YY_COPY(Type)     const Type&
#endif

// Support noexcept when possible.
#if 201103L <= YY_CPLUSPLUS
# define YY_NOEXCEPT noexcept
# define YY_NOTHROW
#else
# define YY_NOEXCEPT
# define YY_NOTHROW throw ()
#endif

// Support constexpr when possible.
#if 201703 <= YY_CPLUSPLUS
# define YY_CONSTEXPR constexpr
#else
# define YY_CONSTEXPR
#endif



#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Debug traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

namespace yy {
#line 210 "/build/rgbds/src/rgbds/src/asm/parser.hpp"




  /// A Bison parser.
  class parser
  {
  public:
#ifdef YYSTYPE
# ifdef __GNUC__
#  pragma GCC message "bison: do not #define YYSTYPE in C++, use %define api.value.type"
# endif
    typedef YYSTYPE value_type;
#else
  /// A buffer to store and retrieve objects.
  ///
  /// Sort of a variant, but does not keep track of the nature
  /// of the stored data, since that knowledge is available
  /// via the current parser state.
  class value_type
  {
  public:
    /// Type of *this.
    typedef value_type self_type;

    /// Empty construction.
    value_type () YY_NOEXCEPT
      : yyraw_ ()
    {}

    /// Construct and fill.
    template <typename T>
    value_type (YY_RVREF (T) t)
    {
      new (yyas_<T> ()) T (YY_MOVE (t));
    }

#if 201103L <= YY_CPLUSPLUS
    /// Non copyable.
    value_type (const self_type&) = delete;
    /// Non copyable.
    self_type& operator= (const self_type&) = delete;
#endif

    /// Destruction, allowed only if empty.
    ~value_type () YY_NOEXCEPT
    {}

# if 201103L <= YY_CPLUSPLUS
    /// Instantiate a \a T in here from \a t.
    template <typename T, typename... U>
    T&
    emplace (U&&... u)
    {
      return *new (yyas_<T> ()) T (std::forward <U>(u)...);
    }
# else
    /// Instantiate an empty \a T in here.
    template <typename T>
    T&
    emplace ()
    {
      return *new (yyas_<T> ()) T ();
    }

    /// Instantiate a \a T in here from \a t.
    template <typename T>
    T&
    emplace (const T& t)
    {
      return *new (yyas_<T> ()) T (t);
    }
# endif

    /// Instantiate an empty \a T in here.
    /// Obsolete, use emplace.
    template <typename T>
    T&
    build ()
    {
      return emplace<T> ();
    }

    /// Instantiate a \a T in here from \a t.
    /// Obsolete, use emplace.
    template <typename T>
    T&
    build (const T& t)
    {
      return emplace<T> (t);
    }

    /// Accessor to a built \a T.
    template <typename T>
    T&
    as () YY_NOEXCEPT
    {
      return *yyas_<T> ();
    }

    /// Const accessor to a built \a T (for %printer).
    template <typename T>
    const T&
    as () const YY_NOEXCEPT
    {
      return *yyas_<T> ();
    }

    /// Swap the content with \a that, of same type.
    ///
    /// Both variants must be built beforehand, because swapping the actual
    /// data requires reading it (with as()), and this is not possible on
    /// unconstructed variants: it would require some dynamic testing, which
    /// should not be the variant's responsibility.
    /// Swapping between built and (possibly) non-built is done with
    /// self_type::move ().
    template <typename T>
    void
    swap (self_type& that) YY_NOEXCEPT
    {
      std::swap (as<T> (), that.as<T> ());
    }

    /// Move the content of \a that to this.
    ///
    /// Destroys \a that.
    template <typename T>
    void
    move (self_type& that)
    {
# if 201103L <= YY_CPLUSPLUS
      emplace<T> (std::move (that.as<T> ()));
# else
      emplace<T> ();
      swap<T> (that);
# endif
      that.destroy<T> ();
    }

# if 201103L <= YY_CPLUSPLUS
    /// Move the content of \a that to this.
    template <typename T>
    void
    move (self_type&& that)
    {
      emplace<T> (std::move (that.as<T> ()));
      that.destroy<T> ();
    }
#endif

    /// Copy the content of \a that to this.
    template <typename T>
    void
    copy (const self_type& that)
    {
      emplace<T> (that.as<T> ());
    }

    /// Destroy the stored \a T.
    template <typename T>
    void
    destroy ()
    {
      as<T> ().~T ();
    }

  private:
#if YY_CPLUSPLUS < 201103L
    /// Non copyable.
    value_type (const self_type&);
    /// Non copyable.
    self_type& operator= (const self_type&);
#endif

    /// Accessor to raw memory as \a T.
    template <typename T>
    T*
    yyas_ () YY_NOEXCEPT
    {
      void *yyp = yyraw_;
      return static_cast<T*> (yyp);
     }

    /// Const accessor to raw memory as \a T.
    template <typename T>
    const T*
    yyas_ () const YY_NOEXCEPT
    {
      const void *yyp = yyraw_;
      return static_cast<const T*> (yyp);
     }

    /// An auxiliary type to compute the largest semantic type.
    union union_type
    {
      // align_spec
      char dummy1[sizeof (AlignmentSpec)];

      // assert_type
      char dummy2[sizeof (AssertionType)];

      // capture_rept
      // capture_macro
      char dummy3[sizeof (Capture)];

      // reloc_3bit
      // reloc_8bit
      // reloc_16bit
      // relocexpr
      // relocexpr_no_str
      // op_mem_ind
      // op_a_n
      // op_sp_offset
      char dummy4[sizeof (Expression)];

      // for_args
      char dummy5[sizeof (ForArgs)];

      // compound_eq
      char dummy6[sizeof (RPNCommand)];

      // sect_mod
      char dummy7[sizeof (SectionModifier)];

      // sect_attrs
      char dummy8[sizeof (SectionSpec)];

      // sect_type
      char dummy9[sizeof (SectionType)];

      // strfmt_args
      // strfmt_va_args
      char dummy10[sizeof (StrFmtArgList)];

      // maybe_quiet
      char dummy11[sizeof (bool)];

      // "number"
      // shift_const
      // rs_uconst
      // uconst
      // iconst
      // precision_arg
      // sect_org
      // op_a_r
      // ccode_expr
      // ccode
      // reg_r
      // reg_r_no_a
      // reg_a
      // reg_tt
      // reg_ss
      // reg_tt_no_af
      // reg_bc_or_de
      // reg_rr
      char dummy12[sizeof (int32_t)];

      // macro_args
      char dummy13[sizeof (std::shared_ptr<MacroArgs>)];

      // "string"
      // "character"
      // "symbol"
      // "label"
      // "local label"
      // "anonymous label"
      // "quiet macro"
      // def_id
      // redef_id
      // scoped_sym_no_anon
      // scoped_sym
      // def_numeric
      // def_equ
      // redef_equ
      // def_set
      // def_rb
      // def_rw
      // def_rl
      // def_equs
      // redef_equs
      // fragment_literal
      // fragment_literal_name
      // string_literal
      // string
      // strcat_args
      char dummy14[sizeof (std::string)];

      // ds_args
      char dummy15[sizeof (std::vector<Expression>)];

      // charmap_args
      char dummy16[sizeof (std::vector<int32_t>)];

      // purge_args
      char dummy17[sizeof (std::vector<std::string>)];
    };

    /// The size of the largest semantic type.
    enum { size = sizeof (union_type) };

    /// A buffer to store semantic values.
    union
    {
      /// Strongest alignment constraints.
      long double yyalign_me_;
      /// A buffer large enough to store any of the semantic values.
      char yyraw_[size];
    };
  };

#endif
    /// Backward compatibility (Bison 3.8).
    typedef value_type semantic_type;


    /// Syntax errors thrown from user actions.
    struct syntax_error : std::runtime_error
    {
      syntax_error (const std::string& m)
        : std::runtime_error (m)
      {}

      syntax_error (const syntax_error& s)
        : std::runtime_error (s.what ())
      {}

      ~syntax_error () YY_NOEXCEPT YY_NOTHROW;
    };

    /// Token kinds.
    struct token
    {
      enum token_kind_type
      {
        YYEMPTY = -2,
    YYEOF = 0,                     // "end of file"
    YYerror = 1,                   // error
    YYUNDEF = 2,                   // "invalid token"
    NEWLINE = 3,                   // "end of line"
    EOB = 4,                       // "end of buffer"
    EOL = 5,                       // "end of fragment literal"
    COMMA = 6,                     // ","
    COLON = 7,                     // ":"
    DOUBLE_COLON = 8,              // "::"
    LBRACK = 9,                    // "["
    RBRACK = 10,                   // "]"
    LBRACKS = 11,                  // "[["
    RBRACKS = 12,                  // "]]"
    LPAREN = 13,                   // "("
    RPAREN = 14,                   // ")"
    QUESTIONMARK = 15,             // "?"
    OP_ADD = 16,                   // "+"
    OP_SUB = 17,                   // "-"
    OP_MUL = 18,                   // "*"
    OP_DIV = 19,                   // "/"
    OP_MOD = 20,                   // "%"
    OP_EXP = 21,                   // "**"
    OP_CAT = 22,                   // "++"
    OP_STREQU = 23,                // "==="
    OP_STRNE = 24,                 // "!=="
    OP_LOGICEQU = 25,              // "=="
    OP_LOGICNE = 26,               // "!="
    OP_LOGICLT = 27,               // "<"
    OP_LOGICGT = 28,               // ">"
    OP_LOGICLE = 29,               // "<="
    OP_LOGICGE = 30,               // ">="
    OP_LOGICAND = 31,              // "&&"
    OP_LOGICOR = 32,               // "||"
    OP_LOGICNOT = 33,              // "!"
    OP_AND = 34,                   // "&"
    OP_OR = 35,                    // "|"
    OP_XOR = 36,                   // "^"
    OP_SHL = 37,                   // "<<"
    OP_SHR = 38,                   // ">>"
    OP_USHR = 39,                  // ">>>"
    OP_NOT = 40,                   // "~"
    NEG = 41,                      // NEG
    POP_EQUAL = 42,                // "="
    POP_ADDEQ = 43,                // "+="
    POP_SUBEQ = 44,                // "-="
    POP_MULEQ = 45,                // "*="
    POP_DIVEQ = 46,                // "/="
    POP_MODEQ = 47,                // "%="
    POP_ANDEQ = 48,                // "&="
    POP_OREQ = 49,                 // "|="
    POP_XOREQ = 50,                // "^="
    POP_SHLEQ = 51,                // "<<="
    POP_SHREQ = 52,                // ">>="
    TOKEN_A = 53,                  // "a"
    TOKEN_B = 54,                  // "b"
    TOKEN_C = 55,                  // "c"
    TOKEN_D = 56,                  // "d"
    TOKEN_E = 57,                  // "e"
    TOKEN_H = 58,                  // "h"
    TOKEN_L = 59,                  // "l"
    MODE_AF = 60,                  // "af"
    MODE_BC = 61,                  // "bc"
    MODE_DE = 62,                  // "de"
    MODE_HL = 63,                  // "hl"
    MODE_SP = 64,                  // "sp"
    MODE_HL_INC = 65,              // "hli/hl+"
    MODE_HL_DEC = 66,              // "hld/hl-"
    CC_Z = 67,                     // "z"
    CC_NZ = 68,                    // "nz"
    CC_NC = 69,                    // "nc"
    SM83_ADC = 70,                 // "adc"
    SM83_ADD = 71,                 // "add"
    SM83_AND = 72,                 // "and"
    SM83_BIT = 73,                 // "bit"
    SM83_CALL = 74,                // "call"
    SM83_CCF = 75,                 // "ccf"
    SM83_CP = 76,                  // "cp"
    SM83_CPL = 77,                 // "cpl"
    SM83_DAA = 78,                 // "daa"
    SM83_DEC = 79,                 // "dec"
    SM83_DI = 80,                  // "di"
    SM83_EI = 81,                  // "ei"
    SM83_HALT = 82,                // "halt"
    SM83_INC = 83,                 // "inc"
    SM83_JP = 84,                  // "jp"
    SM83_JR = 85,                  // "jr"
    SM83_LDD = 86,                 // "ldd"
    SM83_LDH = 87,                 // "ldh"
    SM83_LDI = 88,                 // "ldi"
    SM83_LD = 89,                  // "ld"
    SM83_NOP = 90,                 // "nop"
    SM83_OR = 91,                  // "or"
    SM83_POP = 92,                 // "pop"
    SM83_PUSH = 93,                // "push"
    SM83_RES = 94,                 // "res"
    SM83_RETI = 95,                // "reti"
    SM83_RET = 96,                 // "ret"
    SM83_RLA = 97,                 // "rla"
    SM83_RLCA = 98,                // "rlca"
    SM83_RLC = 99,                 // "rlc"
    SM83_RL = 100,                 // "rl"
    SM83_RRA = 101,                // "rra"
    SM83_RRCA = 102,               // "rrca"
    SM83_RRC = 103,                // "rrc"
    SM83_RR = 104,                 // "rr"
    SM83_RST = 105,                // "rst"
    SM83_SBC = 106,                // "sbc"
    SM83_SCF = 107,                // "scf"
    SM83_SET = 108,                // "set"
    SM83_SLA = 109,                // "sla"
    SM83_SRA = 110,                // "sra"
    SM83_SRL = 111,                // "srl"
    SM83_STOP = 112,               // "stop"
    SM83_SUB = 113,                // "sub"
    SM83_SWAP = 114,               // "swap"
    SM83_XOR = 115,                // "xor"
    POP_ALIGN = 116,               // "ALIGN"
    POP_ASSERT = 117,              // "ASSERT"
    POP_BREAK = 118,               // "BREAK"
    POP_CHARMAP = 119,             // "CHARMAP"
    POP_DB = 120,                  // "DB"
    POP_DL = 121,                  // "DL"
    POP_DS = 122,                  // "DS"
    POP_DW = 123,                  // "DW"
    POP_ELIF = 124,                // "ELIF"
    POP_ELSE = 125,                // "ELSE"
    POP_ENDC = 126,                // "ENDC"
    POP_ENDL = 127,                // "ENDL"
    POP_ENDM = 128,                // "ENDM"
    POP_ENDR = 129,                // "ENDR"
    POP_ENDSECTION = 130,          // "ENDSECTION"
    POP_ENDU = 131,                // "ENDU"
    POP_EQU = 132,                 // "EQU"
    POP_EQUS = 133,                // "EQUS"
    POP_EXPORT = 134,              // "EXPORT"
    POP_FAIL = 135,                // "FAIL"
    POP_FATAL = 136,               // "FATAL"
    POP_FOR = 137,                 // "FOR"
    POP_FRAGMENT = 138,            // "FRAGMENT"
    POP_IF = 139,                  // "IF"
    POP_INCBIN = 140,              // "INCBIN"
    POP_INCLUDE = 141,             // "INCLUDE"
    POP_LOAD = 142,                // "LOAD"
    POP_MACRO = 143,               // "MACRO"
    POP_NEWCHARMAP = 144,          // "NEWCHARMAP"
    POP_NEXTU = 145,               // "NEXTU"
    POP_OPT = 146,                 // "OPT"
    POP_POPC = 147,                // "POPC"
    POP_POPO = 148,                // "POPO"
    POP_POPS = 149,                // "POPS"
    POP_PRINTLN = 150,             // "PRINTLN"
    POP_PRINT = 151,               // "PRINT"
    POP_PURGE = 152,               // "PURGE"
    POP_PUSHC = 153,               // "PUSHC"
    POP_PUSHO = 154,               // "PUSHO"
    POP_PUSHS = 155,               // "PUSHS"
    POP_RB = 156,                  // "RB"
    POP_REDEF = 157,               // "REDEF"
    POP_REPT = 158,                // "REPT"
    POP_RSRESET = 159,             // "RSRESET"
    POP_RSSET = 160,               // "RSSET"
    POP_RW = 161,                  // "RW"
    POP_SECTION = 162,             // "SECTION"
    POP_SETCHARMAP = 163,          // "SETCHARMAP"
    POP_SHIFT = 164,               // "SHIFT"
    POP_STATIC_ASSERT = 165,       // "STATIC_ASSERT"
    POP_UNION = 166,               // "UNION"
    POP_WARN = 167,                // "WARN"
    OP_ACOS = 168,                 // "ACOS"
    OP_ASIN = 169,                 // "ASIN"
    OP_ATAN = 170,                 // "ATAN"
    OP_ATAN2 = 171,                // "ATAN2"
    OP_BANK = 172,                 // "BANK"
    OP_BITWIDTH = 173,             // "BITWIDTH"
    OP_BYTELEN = 174,              // "BYTELEN"
    OP_CEIL = 175,                 // "CEIL"
    OP_CHARCMP = 176,              // "CHARCMP"
    OP_CHARLEN = 177,              // "CHARLEN"
    OP_CHARSIZE = 178,             // "CHARSIZE"
    OP_CHARSUB = 179,              // "CHARSUB"
    OP_CHARVAL = 180,              // "CHARVAL"
    OP_COS = 181,                  // "COS"
    OP_DEF = 182,                  // "DEF"
    OP_FDIV = 183,                 // "FDIV"
    OP_FLOOR = 184,                // "FLOOR"
    OP_FMOD = 185,                 // "FMOD"
    OP_FMUL = 186,                 // "FMUL"
    OP_HIGH = 187,                 // "HIGH"
    OP_INCHARMAP = 188,            // "INCHARMAP"
    OP_ISCONST = 189,              // "ISCONST"
    OP_LOG = 190,                  // "LOG"
    OP_LOW = 191,                  // "LOW"
    OP_POW = 192,                  // "POW"
    OP_READFILE = 193,             // "READFILE"
    OP_REVCHAR = 194,              // "REVCHAR"
    OP_ROUND = 195,                // "ROUND"
    OP_SIN = 196,                  // "SIN"
    OP_SIZEOF = 197,               // "SIZEOF"
    OP_STARTOF = 198,              // "STARTOF"
    OP_STRBYTE = 199,              // "STRBYTE"
    OP_STRCAT = 200,               // "STRCAT"
    OP_STRCHAR = 201,              // "STRCHAR"
    OP_STRCMP = 202,               // "STRCMP"
    OP_STRFIND = 203,              // "STRFIND"
    OP_STRFMT = 204,               // "STRFMT"
    OP_STRIN = 205,                // "STRIN"
    OP_STRLEN = 206,               // "STRLEN"
    OP_STRLWR = 207,               // "STRLWR"
    OP_STRRFIND = 208,             // "STRRFIND"
    OP_STRRIN = 209,               // "STRRIN"
    OP_STRRPL = 210,               // "STRRPL"
    OP_STRSLICE = 211,             // "STRSLICE"
    OP_STRSUB = 212,               // "STRSUB"
    OP_STRUPR = 213,               // "STRUPR"
    OP_TAN = 214,                  // "TAN"
    OP_TZCOUNT = 215,              // "TZCOUNT"
    SECT_HRAM = 216,               // "HRAM"
    SECT_OAM = 217,                // "OAM"
    SECT_ROM0 = 218,               // "ROM0"
    SECT_ROMX = 219,               // "ROMX"
    SECT_SRAM = 220,               // "SRAM"
    SECT_VRAM = 221,               // "VRAM"
    SECT_WRAM0 = 222,              // "WRAM0"
    SECT_WRAMX = 223,              // "WRAMX"
    NUMBER = 224,                  // "number"
    STRING = 225,                  // "string"
    CHARACTER = 226,               // "character"
    SYMBOL = 227,                  // "symbol"
    LABEL = 228,                   // "label"
    LOCAL = 229,                   // "local label"
    ANON = 230,                    // "anonymous label"
    QMACRO = 231                   // "quiet macro"
      };
      /// Backward compatibility alias (Bison 3.6).
      typedef token_kind_type yytokentype;
    };

    /// Token kind, as returned by yylex.
    typedef token::token_kind_type token_kind_type;

    /// Backward compatibility alias (Bison 3.6).
    typedef token_kind_type token_type;

    /// Symbol kinds.
    struct symbol_kind
    {
      enum symbol_kind_type
      {
        YYNTOKENS = 232, ///< Number of tokens.
        S_YYEMPTY = -2,
        S_YYEOF = 0,                             // "end of file"
        S_YYerror = 1,                           // error
        S_YYUNDEF = 2,                           // "invalid token"
        S_NEWLINE = 3,                           // "end of line"
        S_EOB = 4,                               // "end of buffer"
        S_EOL = 5,                               // "end of fragment literal"
        S_COMMA = 6,                             // ","
        S_COLON = 7,                             // ":"
        S_DOUBLE_COLON = 8,                      // "::"
        S_LBRACK = 9,                            // "["
        S_RBRACK = 10,                           // "]"
        S_LBRACKS = 11,                          // "[["
        S_RBRACKS = 12,                          // "]]"
        S_LPAREN = 13,                           // "("
        S_RPAREN = 14,                           // ")"
        S_QUESTIONMARK = 15,                     // "?"
        S_OP_ADD = 16,                           // "+"
        S_OP_SUB = 17,                           // "-"
        S_OP_MUL = 18,                           // "*"
        S_OP_DIV = 19,                           // "/"
        S_OP_MOD = 20,                           // "%"
        S_OP_EXP = 21,                           // "**"
        S_OP_CAT = 22,                           // "++"
        S_OP_STREQU = 23,                        // "==="
        S_OP_STRNE = 24,                         // "!=="
        S_OP_LOGICEQU = 25,                      // "=="
        S_OP_LOGICNE = 26,                       // "!="
        S_OP_LOGICLT = 27,                       // "<"
        S_OP_LOGICGT = 28,                       // ">"
        S_OP_LOGICLE = 29,                       // "<="
        S_OP_LOGICGE = 30,                       // ">="
        S_OP_LOGICAND = 31,                      // "&&"
        S_OP_LOGICOR = 32,                       // "||"
        S_OP_LOGICNOT = 33,                      // "!"
        S_OP_AND = 34,                           // "&"
        S_OP_OR = 35,                            // "|"
        S_OP_XOR = 36,                           // "^"
        S_OP_SHL = 37,                           // "<<"
        S_OP_SHR = 38,                           // ">>"
        S_OP_USHR = 39,                          // ">>>"
        S_OP_NOT = 40,                           // "~"
        S_NEG = 41,                              // NEG
        S_POP_EQUAL = 42,                        // "="
        S_POP_ADDEQ = 43,                        // "+="
        S_POP_SUBEQ = 44,                        // "-="
        S_POP_MULEQ = 45,                        // "*="
        S_POP_DIVEQ = 46,                        // "/="
        S_POP_MODEQ = 47,                        // "%="
        S_POP_ANDEQ = 48,                        // "&="
        S_POP_OREQ = 49,                         // "|="
        S_POP_XOREQ = 50,                        // "^="
        S_POP_SHLEQ = 51,                        // "<<="
        S_POP_SHREQ = 52,                        // ">>="
        S_TOKEN_A = 53,                          // "a"
        S_TOKEN_B = 54,                          // "b"
        S_TOKEN_C = 55,                          // "c"
        S_TOKEN_D = 56,                          // "d"
        S_TOKEN_E = 57,                          // "e"
        S_TOKEN_H = 58,                          // "h"
        S_TOKEN_L = 59,                          // "l"
        S_MODE_AF = 60,                          // "af"
        S_MODE_BC = 61,                          // "bc"
        S_MODE_DE = 62,                          // "de"
        S_MODE_HL = 63,                          // "hl"
        S_MODE_SP = 64,                          // "sp"
        S_MODE_HL_INC = 65,                      // "hli/hl+"
        S_MODE_HL_DEC = 66,                      // "hld/hl-"
        S_CC_Z = 67,                             // "z"
        S_CC_NZ = 68,                            // "nz"
        S_CC_NC = 69,                            // "nc"
        S_SM83_ADC = 70,                         // "adc"
        S_SM83_ADD = 71,                         // "add"
        S_SM83_AND = 72,                         // "and"
        S_SM83_BIT = 73,                         // "bit"
        S_SM83_CALL = 74,                        // "call"
        S_SM83_CCF = 75,                         // "ccf"
        S_SM83_CP = 76,                          // "cp"
        S_SM83_CPL = 77,                         // "cpl"
        S_SM83_DAA = 78,                         // "daa"
        S_SM83_DEC = 79,                         // "dec"
        S_SM83_DI = 80,                          // "di"
        S_SM83_EI = 81,                          // "ei"
        S_SM83_HALT = 82,                        // "halt"
        S_SM83_INC = 83,                         // "inc"
        S_SM83_JP = 84,                          // "jp"
        S_SM83_JR = 85,                          // "jr"
        S_SM83_LDD = 86,                         // "ldd"
        S_SM83_LDH = 87,                         // "ldh"
        S_SM83_LDI = 88,                         // "ldi"
        S_SM83_LD = 89,                          // "ld"
        S_SM83_NOP = 90,                         // "nop"
        S_SM83_OR = 91,                          // "or"
        S_SM83_POP = 92,                         // "pop"
        S_SM83_PUSH = 93,                        // "push"
        S_SM83_RES = 94,                         // "res"
        S_SM83_RETI = 95,                        // "reti"
        S_SM83_RET = 96,                         // "ret"
        S_SM83_RLA = 97,                         // "rla"
        S_SM83_RLCA = 98,                        // "rlca"
        S_SM83_RLC = 99,                         // "rlc"
        S_SM83_RL = 100,                         // "rl"
        S_SM83_RRA = 101,                        // "rra"
        S_SM83_RRCA = 102,                       // "rrca"
        S_SM83_RRC = 103,                        // "rrc"
        S_SM83_RR = 104,                         // "rr"
        S_SM83_RST = 105,                        // "rst"
        S_SM83_SBC = 106,                        // "sbc"
        S_SM83_SCF = 107,                        // "scf"
        S_SM83_SET = 108,                        // "set"
        S_SM83_SLA = 109,                        // "sla"
        S_SM83_SRA = 110,                        // "sra"
        S_SM83_SRL = 111,                        // "srl"
        S_SM83_STOP = 112,                       // "stop"
        S_SM83_SUB = 113,                        // "sub"
        S_SM83_SWAP = 114,                       // "swap"
        S_SM83_XOR = 115,                        // "xor"
        S_POP_ALIGN = 116,                       // "ALIGN"
        S_POP_ASSERT = 117,                      // "ASSERT"
        S_POP_BREAK = 118,                       // "BREAK"
        S_POP_CHARMAP = 119,                     // "CHARMAP"
        S_POP_DB = 120,                          // "DB"
        S_POP_DL = 121,                          // "DL"
        S_POP_DS = 122,                          // "DS"
        S_POP_DW = 123,                          // "DW"
        S_POP_ELIF = 124,                        // "ELIF"
        S_POP_ELSE = 125,                        // "ELSE"
        S_POP_ENDC = 126,                        // "ENDC"
        S_POP_ENDL = 127,                        // "ENDL"
        S_POP_ENDM = 128,                        // "ENDM"
        S_POP_ENDR = 129,                        // "ENDR"
        S_POP_ENDSECTION = 130,                  // "ENDSECTION"
        S_POP_ENDU = 131,                        // "ENDU"
        S_POP_EQU = 132,                         // "EQU"
        S_POP_EQUS = 133,                        // "EQUS"
        S_POP_EXPORT = 134,                      // "EXPORT"
        S_POP_FAIL = 135,                        // "FAIL"
        S_POP_FATAL = 136,                       // "FATAL"
        S_POP_FOR = 137,                         // "FOR"
        S_POP_FRAGMENT = 138,                    // "FRAGMENT"
        S_POP_IF = 139,                          // "IF"
        S_POP_INCBIN = 140,                      // "INCBIN"
        S_POP_INCLUDE = 141,                     // "INCLUDE"
        S_POP_LOAD = 142,                        // "LOAD"
        S_POP_MACRO = 143,                       // "MACRO"
        S_POP_NEWCHARMAP = 144,                  // "NEWCHARMAP"
        S_POP_NEXTU = 145,                       // "NEXTU"
        S_POP_OPT = 146,                         // "OPT"
        S_POP_POPC = 147,                        // "POPC"
        S_POP_POPO = 148,                        // "POPO"
        S_POP_POPS = 149,                        // "POPS"
        S_POP_PRINTLN = 150,                     // "PRINTLN"
        S_POP_PRINT = 151,                       // "PRINT"
        S_POP_PURGE = 152,                       // "PURGE"
        S_POP_PUSHC = 153,                       // "PUSHC"
        S_POP_PUSHO = 154,                       // "PUSHO"
        S_POP_PUSHS = 155,                       // "PUSHS"
        S_POP_RB = 156,                          // "RB"
        S_POP_REDEF = 157,                       // "REDEF"
        S_POP_REPT = 158,                        // "REPT"
        S_POP_RSRESET = 159,                     // "RSRESET"
        S_POP_RSSET = 160,                       // "RSSET"
        S_POP_RW = 161,                          // "RW"
        S_POP_SECTION = 162,                     // "SECTION"
        S_POP_SETCHARMAP = 163,                  // "SETCHARMAP"
        S_POP_SHIFT = 164,                       // "SHIFT"
        S_POP_STATIC_ASSERT = 165,               // "STATIC_ASSERT"
        S_POP_UNION = 166,                       // "UNION"
        S_POP_WARN = 167,                        // "WARN"
        S_OP_ACOS = 168,                         // "ACOS"
        S_OP_ASIN = 169,                         // "ASIN"
        S_OP_ATAN = 170,                         // "ATAN"
        S_OP_ATAN2 = 171,                        // "ATAN2"
        S_OP_BANK = 172,                         // "BANK"
        S_OP_BITWIDTH = 173,                     // "BITWIDTH"
        S_OP_BYTELEN = 174,                      // "BYTELEN"
        S_OP_CEIL = 175,                         // "CEIL"
        S_OP_CHARCMP = 176,                      // "CHARCMP"
        S_OP_CHARLEN = 177,                      // "CHARLEN"
        S_OP_CHARSIZE = 178,                     // "CHARSIZE"
        S_OP_CHARSUB = 179,                      // "CHARSUB"
        S_OP_CHARVAL = 180,                      // "CHARVAL"
        S_OP_COS = 181,                          // "COS"
        S_OP_DEF = 182,                          // "DEF"
        S_OP_FDIV = 183,                         // "FDIV"
        S_OP_FLOOR = 184,                        // "FLOOR"
        S_OP_FMOD = 185,                         // "FMOD"
        S_OP_FMUL = 186,                         // "FMUL"
        S_OP_HIGH = 187,                         // "HIGH"
        S_OP_INCHARMAP = 188,                    // "INCHARMAP"
        S_OP_ISCONST = 189,                      // "ISCONST"
        S_OP_LOG = 190,                          // "LOG"
        S_OP_LOW = 191,                          // "LOW"
        S_OP_POW = 192,                          // "POW"
        S_OP_READFILE = 193,                     // "READFILE"
        S_OP_REVCHAR = 194,                      // "REVCHAR"
        S_OP_ROUND = 195,                        // "ROUND"
        S_OP_SIN = 196,                          // "SIN"
        S_OP_SIZEOF = 197,                       // "SIZEOF"
        S_OP_STARTOF = 198,                      // "STARTOF"
        S_OP_STRBYTE = 199,                      // "STRBYTE"
        S_OP_STRCAT = 200,                       // "STRCAT"
        S_OP_STRCHAR = 201,                      // "STRCHAR"
        S_OP_STRCMP = 202,                       // "STRCMP"
        S_OP_STRFIND = 203,                      // "STRFIND"
        S_OP_STRFMT = 204,                       // "STRFMT"
        S_OP_STRIN = 205,                        // "STRIN"
        S_OP_STRLEN = 206,                       // "STRLEN"
        S_OP_STRLWR = 207,                       // "STRLWR"
        S_OP_STRRFIND = 208,                     // "STRRFIND"
        S_OP_STRRIN = 209,                       // "STRRIN"
        S_OP_STRRPL = 210,                       // "STRRPL"
        S_OP_STRSLICE = 211,                     // "STRSLICE"
        S_OP_STRSUB = 212,                       // "STRSUB"
        S_OP_STRUPR = 213,                       // "STRUPR"
        S_OP_TAN = 214,                          // "TAN"
        S_OP_TZCOUNT = 215,                      // "TZCOUNT"
        S_SECT_HRAM = 216,                       // "HRAM"
        S_SECT_OAM = 217,                        // "OAM"
        S_SECT_ROM0 = 218,                       // "ROM0"
        S_SECT_ROMX = 219,                       // "ROMX"
        S_SECT_SRAM = 220,                       // "SRAM"
        S_SECT_VRAM = 221,                       // "VRAM"
        S_SECT_WRAM0 = 222,                      // "WRAM0"
        S_SECT_WRAMX = 223,                      // "WRAMX"
        S_NUMBER = 224,                          // "number"
        S_STRING = 225,                          // "string"
        S_CHARACTER = 226,                       // "character"
        S_SYMBOL = 227,                          // "symbol"
        S_LABEL = 228,                           // "label"
        S_LOCAL = 229,                           // "local label"
        S_ANON = 230,                            // "anonymous label"
        S_QMACRO = 231,                          // "quiet macro"
        S_YYACCEPT = 232,                        // $accept
        S_asm_file = 233,                        // asm_file
        S_lines = 234,                           // lines
        S_235_1 = 235,                           // $@1
        S_diff_mark = 236,                       // diff_mark
        S_line = 237,                            // line
        S_endofline = 238,                       // endofline
        S_line_directive = 239,                  // line_directive
        S_if = 240,                              // if
        S_elif = 241,                            // elif
        S_else = 242,                            // else
        S_plain_directive = 243,                 // plain_directive
        S_endc = 244,                            // endc
        S_def_id = 245,                          // def_id
        S_246_2 = 246,                           // $@2
        S_redef_id = 247,                        // redef_id
        S_248_3 = 248,                           // $@3
        S_scoped_sym_no_anon = 249,              // scoped_sym_no_anon
        S_scoped_sym = 250,                      // scoped_sym
        S_label = 251,                           // label
        S_macro_invocation = 252,                // macro_invocation
        S_253_4 = 253,                           // $@4
        S_254_5 = 254,                           // $@5
        S_macro_args = 255,                      // macro_args
        S_directive = 256,                       // directive
        S_def_numeric = 257,                     // def_numeric
        S_trailing_comma = 258,                  // trailing_comma
        S_compound_eq = 259,                     // compound_eq
        S_align = 260,                           // align
        S_align_spec = 261,                      // align_spec
        S_opt = 262,                             // opt
        S_263_6 = 263,                           // $@6
        S_opt_list = 264,                        // opt_list
        S_opt_list_entry = 265,                  // opt_list_entry
        S_popo = 266,                            // popo
        S_pusho = 267,                           // pusho
        S_268_7 = 268,                           // $@7
        S_pusho_opt_list = 269,                  // pusho_opt_list
        S_pops = 270,                            // pops
        S_pushs = 271,                           // pushs
        S_endsection = 272,                      // endsection
        S_fail = 273,                            // fail
        S_warn = 274,                            // warn
        S_assert_type = 275,                     // assert_type
        S_assert = 276,                          // assert
        S_shift = 277,                           // shift
        S_shift_const = 278,                     // shift_const
        S_load = 279,                            // load
        S_maybe_quiet = 280,                     // maybe_quiet
        S_rept = 281,                            // rept
        S_for = 282,                             // for
        S_283_8 = 283,                           // $@8
        S_284_9 = 284,                           // $@9
        S_capture_rept = 285,                    // capture_rept
        S_for_args = 286,                        // for_args
        S_break = 287,                           // break
        S_macro_def = 288,                       // macro_def
        S_289_10 = 289,                          // $@10
        S_290_11 = 290,                          // $@11
        S_capture_macro = 291,                   // capture_macro
        S_rsset = 292,                           // rsset
        S_rsreset = 293,                         // rsreset
        S_rs_uconst = 294,                       // rs_uconst
        S_union = 295,                           // union
        S_nextu = 296,                           // nextu
        S_endu = 297,                            // endu
        S_def_equ = 298,                         // def_equ
        S_redef_equ = 299,                       // redef_equ
        S_def_set = 300,                         // def_set
        S_def_rb = 301,                          // def_rb
        S_def_rw = 302,                          // def_rw
        S_def_rl = 303,                          // def_rl
        S_def_equs = 304,                        // def_equs
        S_redef_equs = 305,                      // redef_equs
        S_purge = 306,                           // purge
        S_307_12 = 307,                          // $@12
        S_purge_args = 308,                      // purge_args
        S_export = 309,                          // export
        S_export_list = 310,                     // export_list
        S_export_list_entry = 311,               // export_list_entry
        S_export_def = 312,                      // export_def
        S_include = 313,                         // include
        S_incbin = 314,                          // incbin
        S_charmap = 315,                         // charmap
        S_charmap_args = 316,                    // charmap_args
        S_newcharmap = 317,                      // newcharmap
        S_setcharmap = 318,                      // setcharmap
        S_pushc = 319,                           // pushc
        S_pushc_setcharmap = 320,                // pushc_setcharmap
        S_popc = 321,                            // popc
        S_print = 322,                           // print
        S_println = 323,                         // println
        S_print_exprs = 324,                     // print_exprs
        S_print_expr = 325,                      // print_expr
        S_reloc_3bit = 326,                      // reloc_3bit
        S_constlist_8bit = 327,                  // constlist_8bit
        S_constlist_8bit_entry = 328,            // constlist_8bit_entry
        S_constlist_16bit = 329,                 // constlist_16bit
        S_constlist_16bit_entry = 330,           // constlist_16bit_entry
        S_constlist_32bit = 331,                 // constlist_32bit
        S_constlist_32bit_entry = 332,           // constlist_32bit_entry
        S_reloc_8bit = 333,                      // reloc_8bit
        S_reloc_16bit = 334,                     // reloc_16bit
        S_fragment_literal = 335,                // fragment_literal
        S_fragment_literal_name = 336,           // fragment_literal_name
        S_relocexpr = 337,                       // relocexpr
        S_relocexpr_no_str = 338,                // relocexpr_no_str
        S_339_13 = 339,                          // $@13
        S_uconst = 340,                          // uconst
        S_iconst = 341,                          // iconst
        S_precision_arg = 342,                   // precision_arg
        S_string_literal = 343,                  // string_literal
        S_string = 344,                          // string
        S_strcat_args = 345,                     // strcat_args
        S_strfmt_args = 346,                     // strfmt_args
        S_strfmt_va_args = 347,                  // strfmt_va_args
        S_section = 348,                         // section
        S_pushs_section = 349,                   // pushs_section
        S_sect_mod = 350,                        // sect_mod
        S_sect_type = 351,                       // sect_type
        S_sect_org = 352,                        // sect_org
        S_sect_attrs = 353,                      // sect_attrs
        S_data = 354,                            // data
        S_datum = 355,                           // datum
        S_ds = 356,                              // ds
        S_ds_args = 357,                         // ds_args
        S_db = 358,                              // db
        S_dw = 359,                              // dw
        S_dl = 360,                              // dl
        S_sm83_adc = 361,                        // sm83_adc
        S_sm83_add = 362,                        // sm83_add
        S_sm83_and = 363,                        // sm83_and
        S_sm83_bit = 364,                        // sm83_bit
        S_sm83_call = 365,                       // sm83_call
        S_sm83_ccf = 366,                        // sm83_ccf
        S_sm83_cp = 367,                         // sm83_cp
        S_sm83_cpl = 368,                        // sm83_cpl
        S_sm83_daa = 369,                        // sm83_daa
        S_sm83_dec = 370,                        // sm83_dec
        S_sm83_di = 371,                         // sm83_di
        S_sm83_ei = 372,                         // sm83_ei
        S_sm83_halt = 373,                       // sm83_halt
        S_sm83_inc = 374,                        // sm83_inc
        S_sm83_jp = 375,                         // sm83_jp
        S_sm83_jr = 376,                         // sm83_jr
        S_sm83_ldi = 377,                        // sm83_ldi
        S_sm83_ldd = 378,                        // sm83_ldd
        S_sm83_ldh = 379,                        // sm83_ldh
        S_c_ind = 380,                           // c_ind
        S_ff00_c_ind = 381,                      // ff00_c_ind
        S_sm83_ld = 382,                         // sm83_ld
        S_sm83_ld_hl = 383,                      // sm83_ld_hl
        S_sm83_ld_sp = 384,                      // sm83_ld_sp
        S_sm83_ld_mem = 385,                     // sm83_ld_mem
        S_sm83_ld_c_ind = 386,                   // sm83_ld_c_ind
        S_sm83_ld_rr = 387,                      // sm83_ld_rr
        S_sm83_ld_r_no_a = 388,                  // sm83_ld_r_no_a
        S_sm83_ld_a = 389,                       // sm83_ld_a
        S_sm83_ld_ss = 390,                      // sm83_ld_ss
        S_sm83_nop = 391,                        // sm83_nop
        S_sm83_or = 392,                         // sm83_or
        S_sm83_pop = 393,                        // sm83_pop
        S_sm83_push = 394,                       // sm83_push
        S_sm83_res = 395,                        // sm83_res
        S_sm83_ret = 396,                        // sm83_ret
        S_sm83_reti = 397,                       // sm83_reti
        S_sm83_rl = 398,                         // sm83_rl
        S_sm83_rla = 399,                        // sm83_rla
        S_sm83_rlc = 400,                        // sm83_rlc
        S_sm83_rlca = 401,                       // sm83_rlca
        S_sm83_rr = 402,                         // sm83_rr
        S_sm83_rra = 403,                        // sm83_rra
        S_sm83_rrc = 404,                        // sm83_rrc
        S_sm83_rrca = 405,                       // sm83_rrca
        S_sm83_rst = 406,                        // sm83_rst
        S_sm83_sbc = 407,                        // sm83_sbc
        S_sm83_scf = 408,                        // sm83_scf
        S_sm83_set = 409,                        // sm83_set
        S_sm83_sla = 410,                        // sm83_sla
        S_sm83_sra = 411,                        // sm83_sra
        S_sm83_srl = 412,                        // sm83_srl
        S_sm83_stop = 413,                       // sm83_stop
        S_sm83_sub = 414,                        // sm83_sub
        S_sm83_swap = 415,                       // sm83_swap
        S_sm83_xor = 416,                        // sm83_xor
        S_op_mem_ind = 417,                      // op_mem_ind
        S_op_a_r = 418,                          // op_a_r
        S_op_a_n = 419,                          // op_a_n
        S_op_sp_offset = 420,                    // op_sp_offset
        S_MODE_R8 = 421,                         // MODE_R8
        S_MODE_R16 = 422,                        // MODE_R16
        S_MODE_A = 423,                          // MODE_A
        S_MODE_B = 424,                          // MODE_B
        S_MODE_C = 425,                          // MODE_C
        S_MODE_D = 426,                          // MODE_D
        S_MODE_E = 427,                          // MODE_E
        S_MODE_H = 428,                          // MODE_H
        S_MODE_L = 429,                          // MODE_L
        S_ccode_expr = 430,                      // ccode_expr
        S_ccode = 431,                           // ccode
        S_reg_r = 432,                           // reg_r
        S_reg_r_no_a = 433,                      // reg_r_no_a
        S_reg_a = 434,                           // reg_a
        S_reg_tt = 435,                          // reg_tt
        S_reg_ss = 436,                          // reg_ss
        S_reg_tt_no_af = 437,                    // reg_tt_no_af
        S_reg_bc_or_de = 438,                    // reg_bc_or_de
        S_reg_rr = 439,                          // reg_rr
        S_hl_ind_inc = 440,                      // hl_ind_inc
        S_hl_ind_dec = 441                       // hl_ind_dec
      };
    };

    /// (Internal) symbol kind.
    typedef symbol_kind::symbol_kind_type symbol_kind_type;

    /// The number of tokens.
    static const symbol_kind_type YYNTOKENS = symbol_kind::YYNTOKENS;

    /// A complete symbol.
    ///
    /// Expects its Base type to provide access to the symbol kind
    /// via kind ().
    ///
    /// Provide access to semantic value.
    template <typename Base>
    struct basic_symbol : Base
    {
      /// Alias to Base.
      typedef Base super_type;

      /// Default constructor.
      basic_symbol () YY_NOEXCEPT
        : value ()
      {}

#if 201103L <= YY_CPLUSPLUS
      /// Move constructor.
      basic_symbol (basic_symbol&& that)
        : Base (std::move (that))
        , value ()
      {
        switch (this->kind ())
    {
      case symbol_kind::S_align_spec: // align_spec
        value.move< AlignmentSpec > (std::move (that.value));
        break;

      case symbol_kind::S_assert_type: // assert_type
        value.move< AssertionType > (std::move (that.value));
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        value.move< Capture > (std::move (that.value));
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        value.move< Expression > (std::move (that.value));
        break;

      case symbol_kind::S_for_args: // for_args
        value.move< ForArgs > (std::move (that.value));
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        value.move< RPNCommand > (std::move (that.value));
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        value.move< SectionModifier > (std::move (that.value));
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        value.move< SectionSpec > (std::move (that.value));
        break;

      case symbol_kind::S_sect_type: // sect_type
        value.move< SectionType > (std::move (that.value));
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        value.move< StrFmtArgList > (std::move (that.value));
        break;

      case symbol_kind::S_maybe_quiet: // maybe_quiet
        value.move< bool > (std::move (that.value));
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        value.move< int32_t > (std::move (that.value));
        break;

      case symbol_kind::S_macro_args: // macro_args
        value.move< std::shared_ptr<MacroArgs> > (std::move (that.value));
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_QMACRO: // "quiet macro"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        value.move< std::string > (std::move (that.value));
        break;

      case symbol_kind::S_ds_args: // ds_args
        value.move< std::vector<Expression> > (std::move (that.value));
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        value.move< std::vector<int32_t> > (std::move (that.value));
        break;

      case symbol_kind::S_purge_args: // purge_args
        value.move< std::vector<std::string> > (std::move (that.value));
        break;

      default:
        break;
    }

      }
#endif

      /// Copy constructor.
      basic_symbol (const basic_symbol& that);

      /// Constructors for typed symbols.
#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t)
        : Base (t)
      {}
#else
      basic_symbol (typename Base::kind_type t)
        : Base (t)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, AlignmentSpec&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const AlignmentSpec& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, AssertionType&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const AssertionType& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, Capture&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const Capture& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, Expression&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const Expression& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, ForArgs&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const ForArgs& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, RPNCommand&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const RPNCommand& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, SectionModifier&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const SectionModifier& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, SectionSpec&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const SectionSpec& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, SectionType&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const SectionType& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, StrFmtArgList&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const StrFmtArgList& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, bool&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const bool& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, int32_t&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const int32_t& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, std::shared_ptr<MacroArgs>&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const std::shared_ptr<MacroArgs>& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, std::string&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const std::string& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, std::vector<Expression>&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const std::vector<Expression>& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, std::vector<int32_t>&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const std::vector<int32_t>& v)
        : Base (t)
        , value (v)
      {}
#endif

#if 201103L <= YY_CPLUSPLUS
      basic_symbol (typename Base::kind_type t, std::vector<std::string>&& v)
        : Base (t)
        , value (std::move (v))
      {}
#else
      basic_symbol (typename Base::kind_type t, const std::vector<std::string>& v)
        : Base (t)
        , value (v)
      {}
#endif

      /// Destroy the symbol.
      ~basic_symbol ()
      {
        clear ();
      }



      /// Destroy contents, and record that is empty.
      void clear () YY_NOEXCEPT
      {
        // User destructor.
        symbol_kind_type yykind = this->kind ();
        basic_symbol<Base>& yysym = *this;
        (void) yysym;
        switch (yykind)
        {
       default:
          break;
        }

        // Value type destructor.
switch (yykind)
    {
      case symbol_kind::S_align_spec: // align_spec
        value.template destroy< AlignmentSpec > ();
        break;

      case symbol_kind::S_assert_type: // assert_type
        value.template destroy< AssertionType > ();
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        value.template destroy< Capture > ();
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        value.template destroy< Expression > ();
        break;

      case symbol_kind::S_for_args: // for_args
        value.template destroy< ForArgs > ();
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        value.template destroy< RPNCommand > ();
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        value.template destroy< SectionModifier > ();
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        value.template destroy< SectionSpec > ();
        break;

      case symbol_kind::S_sect_type: // sect_type
        value.template destroy< SectionType > ();
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        value.template destroy< StrFmtArgList > ();
        break;

      case symbol_kind::S_maybe_quiet: // maybe_quiet
        value.template destroy< bool > ();
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        value.template destroy< int32_t > ();
        break;

      case symbol_kind::S_macro_args: // macro_args
        value.template destroy< std::shared_ptr<MacroArgs> > ();
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_QMACRO: // "quiet macro"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        value.template destroy< std::string > ();
        break;

      case symbol_kind::S_ds_args: // ds_args
        value.template destroy< std::vector<Expression> > ();
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        value.template destroy< std::vector<int32_t> > ();
        break;

      case symbol_kind::S_purge_args: // purge_args
        value.template destroy< std::vector<std::string> > ();
        break;

      default:
        break;
    }

        Base::clear ();
      }

      /// The user-facing name of this symbol.
      const char *name () const YY_NOEXCEPT
      {
        return parser::symbol_name (this->kind ());
      }

      /// Backward compatibility (Bison 3.6).
      symbol_kind_type type_get () const YY_NOEXCEPT;

      /// Whether empty.
      bool empty () const YY_NOEXCEPT;

      /// Destructive move, \a s is emptied into this.
      void move (basic_symbol& s);

      /// The semantic value.
      value_type value;

    private:
#if YY_CPLUSPLUS < 201103L
      /// Assignment operator.
      basic_symbol& operator= (const basic_symbol& that);
#endif
    };

    /// Type access provider for token (enum) based symbols.
    struct by_kind
    {
      /// The symbol kind as needed by the constructor.
      typedef token_kind_type kind_type;

      /// Default constructor.
      by_kind () YY_NOEXCEPT;

#if 201103L <= YY_CPLUSPLUS
      /// Move constructor.
      by_kind (by_kind&& that) YY_NOEXCEPT;
#endif

      /// Copy constructor.
      by_kind (const by_kind& that) YY_NOEXCEPT;

      /// Constructor from (external) token numbers.
      by_kind (kind_type t) YY_NOEXCEPT;



      /// Record that this symbol is empty.
      void clear () YY_NOEXCEPT;

      /// Steal the symbol kind from \a that.
      void move (by_kind& that);

      /// The (internal) type number (corresponding to \a type).
      /// \a empty when empty.
      symbol_kind_type kind () const YY_NOEXCEPT;

      /// Backward compatibility (Bison 3.6).
      symbol_kind_type type_get () const YY_NOEXCEPT;

      /// The symbol kind.
      /// \a S_YYEMPTY when empty.
      symbol_kind_type kind_;
    };

    /// Backward compatibility for a private implementation detail (Bison 3.6).
    typedef by_kind by_type;

    /// "External" symbols: returned by the scanner.
    struct symbol_type : basic_symbol<by_kind>
    {
      /// Superclass.
      typedef basic_symbol<by_kind> super_type;

      /// Empty symbol.
      symbol_type () YY_NOEXCEPT {}

      /// Constructor for valueless symbols, and symbols from each type.
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok)
        : super_type (token_kind_type (tok))
#else
      symbol_type (int tok)
        : super_type (token_kind_type (tok))
#endif
      {}
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, int32_t v)
        : super_type (token_kind_type (tok), std::move (v))
#else
      symbol_type (int tok, const int32_t& v)
        : super_type (token_kind_type (tok), v)
#endif
      {}
#if 201103L <= YY_CPLUSPLUS
      symbol_type (int tok, std::string v)
        : super_type (token_kind_type (tok), std::move (v))
#else
      symbol_type (int tok, const std::string& v)
        : super_type (token_kind_type (tok), v)
#endif
      {}
    };

    /// Build a parser object.
    parser ();
    virtual ~parser ();

#if 201103L <= YY_CPLUSPLUS
    /// Non copyable.
    parser (const parser&) = delete;
    /// Non copyable.
    parser& operator= (const parser&) = delete;
#endif

    /// Parse.  An alias for parse ().
    /// \returns  0 iff parsing succeeded.
    int operator() ();

    /// Parse.
    /// \returns  0 iff parsing succeeded.
    virtual int parse ();

#if YYDEBUG
    /// The current debugging stream.
    std::ostream& debug_stream () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging stream.
    void set_debug_stream (std::ostream &);

    /// Type for debugging levels.
    typedef int debug_level_type;
    /// The current debugging level.
    debug_level_type debug_level () const YY_ATTRIBUTE_PURE;
    /// Set the current debugging level.
    void set_debug_level (debug_level_type l);
#endif

    /// Report a syntax error.
    /// \param msg    a description of the syntax error.
    virtual void error (const std::string& msg);

    /// Report a syntax error.
    void error (const syntax_error& err);

    /// The user-facing name of the symbol whose (internal) number is
    /// YYSYMBOL.  No bounds checking.
    static const char *symbol_name (symbol_kind_type yysymbol);

    // Implementation of make_symbol for each token kind.
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YYEOF ()
      {
        return symbol_type (token::YYEOF);
      }
#else
      static
      symbol_type
      make_YYEOF ()
      {
        return symbol_type (token::YYEOF);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YYerror ()
      {
        return symbol_type (token::YYerror);
      }
#else
      static
      symbol_type
      make_YYerror ()
      {
        return symbol_type (token::YYerror);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_YYUNDEF ()
      {
        return symbol_type (token::YYUNDEF);
      }
#else
      static
      symbol_type
      make_YYUNDEF ()
      {
        return symbol_type (token::YYUNDEF);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NEWLINE ()
      {
        return symbol_type (token::NEWLINE);
      }
#else
      static
      symbol_type
      make_NEWLINE ()
      {
        return symbol_type (token::NEWLINE);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EOB ()
      {
        return symbol_type (token::EOB);
      }
#else
      static
      symbol_type
      make_EOB ()
      {
        return symbol_type (token::EOB);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_EOL ()
      {
        return symbol_type (token::EOL);
      }
#else
      static
      symbol_type
      make_EOL ()
      {
        return symbol_type (token::EOL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COMMA ()
      {
        return symbol_type (token::COMMA);
      }
#else
      static
      symbol_type
      make_COMMA ()
      {
        return symbol_type (token::COMMA);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_COLON ()
      {
        return symbol_type (token::COLON);
      }
#else
      static
      symbol_type
      make_COLON ()
      {
        return symbol_type (token::COLON);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_DOUBLE_COLON ()
      {
        return symbol_type (token::DOUBLE_COLON);
      }
#else
      static
      symbol_type
      make_DOUBLE_COLON ()
      {
        return symbol_type (token::DOUBLE_COLON);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LBRACK ()
      {
        return symbol_type (token::LBRACK);
      }
#else
      static
      symbol_type
      make_LBRACK ()
      {
        return symbol_type (token::LBRACK);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RBRACK ()
      {
        return symbol_type (token::RBRACK);
      }
#else
      static
      symbol_type
      make_RBRACK ()
      {
        return symbol_type (token::RBRACK);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LBRACKS ()
      {
        return symbol_type (token::LBRACKS);
      }
#else
      static
      symbol_type
      make_LBRACKS ()
      {
        return symbol_type (token::LBRACKS);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RBRACKS ()
      {
        return symbol_type (token::RBRACKS);
      }
#else
      static
      symbol_type
      make_RBRACKS ()
      {
        return symbol_type (token::RBRACKS);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LPAREN ()
      {
        return symbol_type (token::LPAREN);
      }
#else
      static
      symbol_type
      make_LPAREN ()
      {
        return symbol_type (token::LPAREN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_RPAREN ()
      {
        return symbol_type (token::RPAREN);
      }
#else
      static
      symbol_type
      make_RPAREN ()
      {
        return symbol_type (token::RPAREN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_QUESTIONMARK ()
      {
        return symbol_type (token::QUESTIONMARK);
      }
#else
      static
      symbol_type
      make_QUESTIONMARK ()
      {
        return symbol_type (token::QUESTIONMARK);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_ADD ()
      {
        return symbol_type (token::OP_ADD);
      }
#else
      static
      symbol_type
      make_OP_ADD ()
      {
        return symbol_type (token::OP_ADD);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_SUB ()
      {
        return symbol_type (token::OP_SUB);
      }
#else
      static
      symbol_type
      make_OP_SUB ()
      {
        return symbol_type (token::OP_SUB);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_MUL ()
      {
        return symbol_type (token::OP_MUL);
      }
#else
      static
      symbol_type
      make_OP_MUL ()
      {
        return symbol_type (token::OP_MUL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_DIV ()
      {
        return symbol_type (token::OP_DIV);
      }
#else
      static
      symbol_type
      make_OP_DIV ()
      {
        return symbol_type (token::OP_DIV);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_MOD ()
      {
        return symbol_type (token::OP_MOD);
      }
#else
      static
      symbol_type
      make_OP_MOD ()
      {
        return symbol_type (token::OP_MOD);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_EXP ()
      {
        return symbol_type (token::OP_EXP);
      }
#else
      static
      symbol_type
      make_OP_EXP ()
      {
        return symbol_type (token::OP_EXP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_CAT ()
      {
        return symbol_type (token::OP_CAT);
      }
#else
      static
      symbol_type
      make_OP_CAT ()
      {
        return symbol_type (token::OP_CAT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STREQU ()
      {
        return symbol_type (token::OP_STREQU);
      }
#else
      static
      symbol_type
      make_OP_STREQU ()
      {
        return symbol_type (token::OP_STREQU);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRNE ()
      {
        return symbol_type (token::OP_STRNE);
      }
#else
      static
      symbol_type
      make_OP_STRNE ()
      {
        return symbol_type (token::OP_STRNE);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_LOGICEQU ()
      {
        return symbol_type (token::OP_LOGICEQU);
      }
#else
      static
      symbol_type
      make_OP_LOGICEQU ()
      {
        return symbol_type (token::OP_LOGICEQU);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_LOGICNE ()
      {
        return symbol_type (token::OP_LOGICNE);
      }
#else
      static
      symbol_type
      make_OP_LOGICNE ()
      {
        return symbol_type (token::OP_LOGICNE);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_LOGICLT ()
      {
        return symbol_type (token::OP_LOGICLT);
      }
#else
      static
      symbol_type
      make_OP_LOGICLT ()
      {
        return symbol_type (token::OP_LOGICLT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_LOGICGT ()
      {
        return symbol_type (token::OP_LOGICGT);
      }
#else
      static
      symbol_type
      make_OP_LOGICGT ()
      {
        return symbol_type (token::OP_LOGICGT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_LOGICLE ()
      {
        return symbol_type (token::OP_LOGICLE);
      }
#else
      static
      symbol_type
      make_OP_LOGICLE ()
      {
        return symbol_type (token::OP_LOGICLE);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_LOGICGE ()
      {
        return symbol_type (token::OP_LOGICGE);
      }
#else
      static
      symbol_type
      make_OP_LOGICGE ()
      {
        return symbol_type (token::OP_LOGICGE);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_LOGICAND ()
      {
        return symbol_type (token::OP_LOGICAND);
      }
#else
      static
      symbol_type
      make_OP_LOGICAND ()
      {
        return symbol_type (token::OP_LOGICAND);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_LOGICOR ()
      {
        return symbol_type (token::OP_LOGICOR);
      }
#else
      static
      symbol_type
      make_OP_LOGICOR ()
      {
        return symbol_type (token::OP_LOGICOR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_LOGICNOT ()
      {
        return symbol_type (token::OP_LOGICNOT);
      }
#else
      static
      symbol_type
      make_OP_LOGICNOT ()
      {
        return symbol_type (token::OP_LOGICNOT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_AND ()
      {
        return symbol_type (token::OP_AND);
      }
#else
      static
      symbol_type
      make_OP_AND ()
      {
        return symbol_type (token::OP_AND);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_OR ()
      {
        return symbol_type (token::OP_OR);
      }
#else
      static
      symbol_type
      make_OP_OR ()
      {
        return symbol_type (token::OP_OR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_XOR ()
      {
        return symbol_type (token::OP_XOR);
      }
#else
      static
      symbol_type
      make_OP_XOR ()
      {
        return symbol_type (token::OP_XOR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_SHL ()
      {
        return symbol_type (token::OP_SHL);
      }
#else
      static
      symbol_type
      make_OP_SHL ()
      {
        return symbol_type (token::OP_SHL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_SHR ()
      {
        return symbol_type (token::OP_SHR);
      }
#else
      static
      symbol_type
      make_OP_SHR ()
      {
        return symbol_type (token::OP_SHR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_USHR ()
      {
        return symbol_type (token::OP_USHR);
      }
#else
      static
      symbol_type
      make_OP_USHR ()
      {
        return symbol_type (token::OP_USHR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_NOT ()
      {
        return symbol_type (token::OP_NOT);
      }
#else
      static
      symbol_type
      make_OP_NOT ()
      {
        return symbol_type (token::OP_NOT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NEG ()
      {
        return symbol_type (token::NEG);
      }
#else
      static
      symbol_type
      make_NEG ()
      {
        return symbol_type (token::NEG);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_EQUAL ()
      {
        return symbol_type (token::POP_EQUAL);
      }
#else
      static
      symbol_type
      make_POP_EQUAL ()
      {
        return symbol_type (token::POP_EQUAL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_ADDEQ ()
      {
        return symbol_type (token::POP_ADDEQ);
      }
#else
      static
      symbol_type
      make_POP_ADDEQ ()
      {
        return symbol_type (token::POP_ADDEQ);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_SUBEQ ()
      {
        return symbol_type (token::POP_SUBEQ);
      }
#else
      static
      symbol_type
      make_POP_SUBEQ ()
      {
        return symbol_type (token::POP_SUBEQ);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_MULEQ ()
      {
        return symbol_type (token::POP_MULEQ);
      }
#else
      static
      symbol_type
      make_POP_MULEQ ()
      {
        return symbol_type (token::POP_MULEQ);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_DIVEQ ()
      {
        return symbol_type (token::POP_DIVEQ);
      }
#else
      static
      symbol_type
      make_POP_DIVEQ ()
      {
        return symbol_type (token::POP_DIVEQ);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_MODEQ ()
      {
        return symbol_type (token::POP_MODEQ);
      }
#else
      static
      symbol_type
      make_POP_MODEQ ()
      {
        return symbol_type (token::POP_MODEQ);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_ANDEQ ()
      {
        return symbol_type (token::POP_ANDEQ);
      }
#else
      static
      symbol_type
      make_POP_ANDEQ ()
      {
        return symbol_type (token::POP_ANDEQ);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_OREQ ()
      {
        return symbol_type (token::POP_OREQ);
      }
#else
      static
      symbol_type
      make_POP_OREQ ()
      {
        return symbol_type (token::POP_OREQ);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_XOREQ ()
      {
        return symbol_type (token::POP_XOREQ);
      }
#else
      static
      symbol_type
      make_POP_XOREQ ()
      {
        return symbol_type (token::POP_XOREQ);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_SHLEQ ()
      {
        return symbol_type (token::POP_SHLEQ);
      }
#else
      static
      symbol_type
      make_POP_SHLEQ ()
      {
        return symbol_type (token::POP_SHLEQ);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_SHREQ ()
      {
        return symbol_type (token::POP_SHREQ);
      }
#else
      static
      symbol_type
      make_POP_SHREQ ()
      {
        return symbol_type (token::POP_SHREQ);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOKEN_A ()
      {
        return symbol_type (token::TOKEN_A);
      }
#else
      static
      symbol_type
      make_TOKEN_A ()
      {
        return symbol_type (token::TOKEN_A);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOKEN_B ()
      {
        return symbol_type (token::TOKEN_B);
      }
#else
      static
      symbol_type
      make_TOKEN_B ()
      {
        return symbol_type (token::TOKEN_B);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOKEN_C ()
      {
        return symbol_type (token::TOKEN_C);
      }
#else
      static
      symbol_type
      make_TOKEN_C ()
      {
        return symbol_type (token::TOKEN_C);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOKEN_D ()
      {
        return symbol_type (token::TOKEN_D);
      }
#else
      static
      symbol_type
      make_TOKEN_D ()
      {
        return symbol_type (token::TOKEN_D);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOKEN_E ()
      {
        return symbol_type (token::TOKEN_E);
      }
#else
      static
      symbol_type
      make_TOKEN_E ()
      {
        return symbol_type (token::TOKEN_E);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOKEN_H ()
      {
        return symbol_type (token::TOKEN_H);
      }
#else
      static
      symbol_type
      make_TOKEN_H ()
      {
        return symbol_type (token::TOKEN_H);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_TOKEN_L ()
      {
        return symbol_type (token::TOKEN_L);
      }
#else
      static
      symbol_type
      make_TOKEN_L ()
      {
        return symbol_type (token::TOKEN_L);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_AF ()
      {
        return symbol_type (token::MODE_AF);
      }
#else
      static
      symbol_type
      make_MODE_AF ()
      {
        return symbol_type (token::MODE_AF);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_BC ()
      {
        return symbol_type (token::MODE_BC);
      }
#else
      static
      symbol_type
      make_MODE_BC ()
      {
        return symbol_type (token::MODE_BC);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_DE ()
      {
        return symbol_type (token::MODE_DE);
      }
#else
      static
      symbol_type
      make_MODE_DE ()
      {
        return symbol_type (token::MODE_DE);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_HL ()
      {
        return symbol_type (token::MODE_HL);
      }
#else
      static
      symbol_type
      make_MODE_HL ()
      {
        return symbol_type (token::MODE_HL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_SP ()
      {
        return symbol_type (token::MODE_SP);
      }
#else
      static
      symbol_type
      make_MODE_SP ()
      {
        return symbol_type (token::MODE_SP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_HL_INC ()
      {
        return symbol_type (token::MODE_HL_INC);
      }
#else
      static
      symbol_type
      make_MODE_HL_INC ()
      {
        return symbol_type (token::MODE_HL_INC);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_MODE_HL_DEC ()
      {
        return symbol_type (token::MODE_HL_DEC);
      }
#else
      static
      symbol_type
      make_MODE_HL_DEC ()
      {
        return symbol_type (token::MODE_HL_DEC);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CC_Z ()
      {
        return symbol_type (token::CC_Z);
      }
#else
      static
      symbol_type
      make_CC_Z ()
      {
        return symbol_type (token::CC_Z);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CC_NZ ()
      {
        return symbol_type (token::CC_NZ);
      }
#else
      static
      symbol_type
      make_CC_NZ ()
      {
        return symbol_type (token::CC_NZ);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CC_NC ()
      {
        return symbol_type (token::CC_NC);
      }
#else
      static
      symbol_type
      make_CC_NC ()
      {
        return symbol_type (token::CC_NC);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_ADC ()
      {
        return symbol_type (token::SM83_ADC);
      }
#else
      static
      symbol_type
      make_SM83_ADC ()
      {
        return symbol_type (token::SM83_ADC);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_ADD ()
      {
        return symbol_type (token::SM83_ADD);
      }
#else
      static
      symbol_type
      make_SM83_ADD ()
      {
        return symbol_type (token::SM83_ADD);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_AND ()
      {
        return symbol_type (token::SM83_AND);
      }
#else
      static
      symbol_type
      make_SM83_AND ()
      {
        return symbol_type (token::SM83_AND);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_BIT ()
      {
        return symbol_type (token::SM83_BIT);
      }
#else
      static
      symbol_type
      make_SM83_BIT ()
      {
        return symbol_type (token::SM83_BIT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_CALL ()
      {
        return symbol_type (token::SM83_CALL);
      }
#else
      static
      symbol_type
      make_SM83_CALL ()
      {
        return symbol_type (token::SM83_CALL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_CCF ()
      {
        return symbol_type (token::SM83_CCF);
      }
#else
      static
      symbol_type
      make_SM83_CCF ()
      {
        return symbol_type (token::SM83_CCF);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_CP ()
      {
        return symbol_type (token::SM83_CP);
      }
#else
      static
      symbol_type
      make_SM83_CP ()
      {
        return symbol_type (token::SM83_CP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_CPL ()
      {
        return symbol_type (token::SM83_CPL);
      }
#else
      static
      symbol_type
      make_SM83_CPL ()
      {
        return symbol_type (token::SM83_CPL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_DAA ()
      {
        return symbol_type (token::SM83_DAA);
      }
#else
      static
      symbol_type
      make_SM83_DAA ()
      {
        return symbol_type (token::SM83_DAA);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_DEC ()
      {
        return symbol_type (token::SM83_DEC);
      }
#else
      static
      symbol_type
      make_SM83_DEC ()
      {
        return symbol_type (token::SM83_DEC);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_DI ()
      {
        return symbol_type (token::SM83_DI);
      }
#else
      static
      symbol_type
      make_SM83_DI ()
      {
        return symbol_type (token::SM83_DI);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_EI ()
      {
        return symbol_type (token::SM83_EI);
      }
#else
      static
      symbol_type
      make_SM83_EI ()
      {
        return symbol_type (token::SM83_EI);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_HALT ()
      {
        return symbol_type (token::SM83_HALT);
      }
#else
      static
      symbol_type
      make_SM83_HALT ()
      {
        return symbol_type (token::SM83_HALT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_INC ()
      {
        return symbol_type (token::SM83_INC);
      }
#else
      static
      symbol_type
      make_SM83_INC ()
      {
        return symbol_type (token::SM83_INC);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_JP ()
      {
        return symbol_type (token::SM83_JP);
      }
#else
      static
      symbol_type
      make_SM83_JP ()
      {
        return symbol_type (token::SM83_JP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_JR ()
      {
        return symbol_type (token::SM83_JR);
      }
#else
      static
      symbol_type
      make_SM83_JR ()
      {
        return symbol_type (token::SM83_JR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_LDD ()
      {
        return symbol_type (token::SM83_LDD);
      }
#else
      static
      symbol_type
      make_SM83_LDD ()
      {
        return symbol_type (token::SM83_LDD);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_LDH ()
      {
        return symbol_type (token::SM83_LDH);
      }
#else
      static
      symbol_type
      make_SM83_LDH ()
      {
        return symbol_type (token::SM83_LDH);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_LDI ()
      {
        return symbol_type (token::SM83_LDI);
      }
#else
      static
      symbol_type
      make_SM83_LDI ()
      {
        return symbol_type (token::SM83_LDI);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_LD ()
      {
        return symbol_type (token::SM83_LD);
      }
#else
      static
      symbol_type
      make_SM83_LD ()
      {
        return symbol_type (token::SM83_LD);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_NOP ()
      {
        return symbol_type (token::SM83_NOP);
      }
#else
      static
      symbol_type
      make_SM83_NOP ()
      {
        return symbol_type (token::SM83_NOP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_OR ()
      {
        return symbol_type (token::SM83_OR);
      }
#else
      static
      symbol_type
      make_SM83_OR ()
      {
        return symbol_type (token::SM83_OR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_POP ()
      {
        return symbol_type (token::SM83_POP);
      }
#else
      static
      symbol_type
      make_SM83_POP ()
      {
        return symbol_type (token::SM83_POP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_PUSH ()
      {
        return symbol_type (token::SM83_PUSH);
      }
#else
      static
      symbol_type
      make_SM83_PUSH ()
      {
        return symbol_type (token::SM83_PUSH);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_RES ()
      {
        return symbol_type (token::SM83_RES);
      }
#else
      static
      symbol_type
      make_SM83_RES ()
      {
        return symbol_type (token::SM83_RES);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_RETI ()
      {
        return symbol_type (token::SM83_RETI);
      }
#else
      static
      symbol_type
      make_SM83_RETI ()
      {
        return symbol_type (token::SM83_RETI);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_RET ()
      {
        return symbol_type (token::SM83_RET);
      }
#else
      static
      symbol_type
      make_SM83_RET ()
      {
        return symbol_type (token::SM83_RET);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_RLA ()
      {
        return symbol_type (token::SM83_RLA);
      }
#else
      static
      symbol_type
      make_SM83_RLA ()
      {
        return symbol_type (token::SM83_RLA);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_RLCA ()
      {
        return symbol_type (token::SM83_RLCA);
      }
#else
      static
      symbol_type
      make_SM83_RLCA ()
      {
        return symbol_type (token::SM83_RLCA);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_RLC ()
      {
        return symbol_type (token::SM83_RLC);
      }
#else
      static
      symbol_type
      make_SM83_RLC ()
      {
        return symbol_type (token::SM83_RLC);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_RL ()
      {
        return symbol_type (token::SM83_RL);
      }
#else
      static
      symbol_type
      make_SM83_RL ()
      {
        return symbol_type (token::SM83_RL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_RRA ()
      {
        return symbol_type (token::SM83_RRA);
      }
#else
      static
      symbol_type
      make_SM83_RRA ()
      {
        return symbol_type (token::SM83_RRA);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_RRCA ()
      {
        return symbol_type (token::SM83_RRCA);
      }
#else
      static
      symbol_type
      make_SM83_RRCA ()
      {
        return symbol_type (token::SM83_RRCA);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_RRC ()
      {
        return symbol_type (token::SM83_RRC);
      }
#else
      static
      symbol_type
      make_SM83_RRC ()
      {
        return symbol_type (token::SM83_RRC);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_RR ()
      {
        return symbol_type (token::SM83_RR);
      }
#else
      static
      symbol_type
      make_SM83_RR ()
      {
        return symbol_type (token::SM83_RR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_RST ()
      {
        return symbol_type (token::SM83_RST);
      }
#else
      static
      symbol_type
      make_SM83_RST ()
      {
        return symbol_type (token::SM83_RST);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_SBC ()
      {
        return symbol_type (token::SM83_SBC);
      }
#else
      static
      symbol_type
      make_SM83_SBC ()
      {
        return symbol_type (token::SM83_SBC);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_SCF ()
      {
        return symbol_type (token::SM83_SCF);
      }
#else
      static
      symbol_type
      make_SM83_SCF ()
      {
        return symbol_type (token::SM83_SCF);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_SET ()
      {
        return symbol_type (token::SM83_SET);
      }
#else
      static
      symbol_type
      make_SM83_SET ()
      {
        return symbol_type (token::SM83_SET);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_SLA ()
      {
        return symbol_type (token::SM83_SLA);
      }
#else
      static
      symbol_type
      make_SM83_SLA ()
      {
        return symbol_type (token::SM83_SLA);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_SRA ()
      {
        return symbol_type (token::SM83_SRA);
      }
#else
      static
      symbol_type
      make_SM83_SRA ()
      {
        return symbol_type (token::SM83_SRA);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_SRL ()
      {
        return symbol_type (token::SM83_SRL);
      }
#else
      static
      symbol_type
      make_SM83_SRL ()
      {
        return symbol_type (token::SM83_SRL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_STOP ()
      {
        return symbol_type (token::SM83_STOP);
      }
#else
      static
      symbol_type
      make_SM83_STOP ()
      {
        return symbol_type (token::SM83_STOP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_SUB ()
      {
        return symbol_type (token::SM83_SUB);
      }
#else
      static
      symbol_type
      make_SM83_SUB ()
      {
        return symbol_type (token::SM83_SUB);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_SWAP ()
      {
        return symbol_type (token::SM83_SWAP);
      }
#else
      static
      symbol_type
      make_SM83_SWAP ()
      {
        return symbol_type (token::SM83_SWAP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SM83_XOR ()
      {
        return symbol_type (token::SM83_XOR);
      }
#else
      static
      symbol_type
      make_SM83_XOR ()
      {
        return symbol_type (token::SM83_XOR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_ALIGN ()
      {
        return symbol_type (token::POP_ALIGN);
      }
#else
      static
      symbol_type
      make_POP_ALIGN ()
      {
        return symbol_type (token::POP_ALIGN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_ASSERT ()
      {
        return symbol_type (token::POP_ASSERT);
      }
#else
      static
      symbol_type
      make_POP_ASSERT ()
      {
        return symbol_type (token::POP_ASSERT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_BREAK ()
      {
        return symbol_type (token::POP_BREAK);
      }
#else
      static
      symbol_type
      make_POP_BREAK ()
      {
        return symbol_type (token::POP_BREAK);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_CHARMAP ()
      {
        return symbol_type (token::POP_CHARMAP);
      }
#else
      static
      symbol_type
      make_POP_CHARMAP ()
      {
        return symbol_type (token::POP_CHARMAP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_DB ()
      {
        return symbol_type (token::POP_DB);
      }
#else
      static
      symbol_type
      make_POP_DB ()
      {
        return symbol_type (token::POP_DB);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_DL ()
      {
        return symbol_type (token::POP_DL);
      }
#else
      static
      symbol_type
      make_POP_DL ()
      {
        return symbol_type (token::POP_DL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_DS ()
      {
        return symbol_type (token::POP_DS);
      }
#else
      static
      symbol_type
      make_POP_DS ()
      {
        return symbol_type (token::POP_DS);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_DW ()
      {
        return symbol_type (token::POP_DW);
      }
#else
      static
      symbol_type
      make_POP_DW ()
      {
        return symbol_type (token::POP_DW);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_ELIF ()
      {
        return symbol_type (token::POP_ELIF);
      }
#else
      static
      symbol_type
      make_POP_ELIF ()
      {
        return symbol_type (token::POP_ELIF);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_ELSE ()
      {
        return symbol_type (token::POP_ELSE);
      }
#else
      static
      symbol_type
      make_POP_ELSE ()
      {
        return symbol_type (token::POP_ELSE);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_ENDC ()
      {
        return symbol_type (token::POP_ENDC);
      }
#else
      static
      symbol_type
      make_POP_ENDC ()
      {
        return symbol_type (token::POP_ENDC);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_ENDL ()
      {
        return symbol_type (token::POP_ENDL);
      }
#else
      static
      symbol_type
      make_POP_ENDL ()
      {
        return symbol_type (token::POP_ENDL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_ENDM ()
      {
        return symbol_type (token::POP_ENDM);
      }
#else
      static
      symbol_type
      make_POP_ENDM ()
      {
        return symbol_type (token::POP_ENDM);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_ENDR ()
      {
        return symbol_type (token::POP_ENDR);
      }
#else
      static
      symbol_type
      make_POP_ENDR ()
      {
        return symbol_type (token::POP_ENDR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_ENDSECTION ()
      {
        return symbol_type (token::POP_ENDSECTION);
      }
#else
      static
      symbol_type
      make_POP_ENDSECTION ()
      {
        return symbol_type (token::POP_ENDSECTION);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_ENDU ()
      {
        return symbol_type (token::POP_ENDU);
      }
#else
      static
      symbol_type
      make_POP_ENDU ()
      {
        return symbol_type (token::POP_ENDU);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_EQU ()
      {
        return symbol_type (token::POP_EQU);
      }
#else
      static
      symbol_type
      make_POP_EQU ()
      {
        return symbol_type (token::POP_EQU);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_EQUS ()
      {
        return symbol_type (token::POP_EQUS);
      }
#else
      static
      symbol_type
      make_POP_EQUS ()
      {
        return symbol_type (token::POP_EQUS);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_EXPORT ()
      {
        return symbol_type (token::POP_EXPORT);
      }
#else
      static
      symbol_type
      make_POP_EXPORT ()
      {
        return symbol_type (token::POP_EXPORT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_FAIL ()
      {
        return symbol_type (token::POP_FAIL);
      }
#else
      static
      symbol_type
      make_POP_FAIL ()
      {
        return symbol_type (token::POP_FAIL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_FATAL ()
      {
        return symbol_type (token::POP_FATAL);
      }
#else
      static
      symbol_type
      make_POP_FATAL ()
      {
        return symbol_type (token::POP_FATAL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_FOR ()
      {
        return symbol_type (token::POP_FOR);
      }
#else
      static
      symbol_type
      make_POP_FOR ()
      {
        return symbol_type (token::POP_FOR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_FRAGMENT ()
      {
        return symbol_type (token::POP_FRAGMENT);
      }
#else
      static
      symbol_type
      make_POP_FRAGMENT ()
      {
        return symbol_type (token::POP_FRAGMENT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_IF ()
      {
        return symbol_type (token::POP_IF);
      }
#else
      static
      symbol_type
      make_POP_IF ()
      {
        return symbol_type (token::POP_IF);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_INCBIN ()
      {
        return symbol_type (token::POP_INCBIN);
      }
#else
      static
      symbol_type
      make_POP_INCBIN ()
      {
        return symbol_type (token::POP_INCBIN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_INCLUDE ()
      {
        return symbol_type (token::POP_INCLUDE);
      }
#else
      static
      symbol_type
      make_POP_INCLUDE ()
      {
        return symbol_type (token::POP_INCLUDE);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_LOAD ()
      {
        return symbol_type (token::POP_LOAD);
      }
#else
      static
      symbol_type
      make_POP_LOAD ()
      {
        return symbol_type (token::POP_LOAD);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_MACRO ()
      {
        return symbol_type (token::POP_MACRO);
      }
#else
      static
      symbol_type
      make_POP_MACRO ()
      {
        return symbol_type (token::POP_MACRO);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_NEWCHARMAP ()
      {
        return symbol_type (token::POP_NEWCHARMAP);
      }
#else
      static
      symbol_type
      make_POP_NEWCHARMAP ()
      {
        return symbol_type (token::POP_NEWCHARMAP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_NEXTU ()
      {
        return symbol_type (token::POP_NEXTU);
      }
#else
      static
      symbol_type
      make_POP_NEXTU ()
      {
        return symbol_type (token::POP_NEXTU);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_OPT ()
      {
        return symbol_type (token::POP_OPT);
      }
#else
      static
      symbol_type
      make_POP_OPT ()
      {
        return symbol_type (token::POP_OPT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_POPC ()
      {
        return symbol_type (token::POP_POPC);
      }
#else
      static
      symbol_type
      make_POP_POPC ()
      {
        return symbol_type (token::POP_POPC);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_POPO ()
      {
        return symbol_type (token::POP_POPO);
      }
#else
      static
      symbol_type
      make_POP_POPO ()
      {
        return symbol_type (token::POP_POPO);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_POPS ()
      {
        return symbol_type (token::POP_POPS);
      }
#else
      static
      symbol_type
      make_POP_POPS ()
      {
        return symbol_type (token::POP_POPS);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_PRINTLN ()
      {
        return symbol_type (token::POP_PRINTLN);
      }
#else
      static
      symbol_type
      make_POP_PRINTLN ()
      {
        return symbol_type (token::POP_PRINTLN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_PRINT ()
      {
        return symbol_type (token::POP_PRINT);
      }
#else
      static
      symbol_type
      make_POP_PRINT ()
      {
        return symbol_type (token::POP_PRINT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_PURGE ()
      {
        return symbol_type (token::POP_PURGE);
      }
#else
      static
      symbol_type
      make_POP_PURGE ()
      {
        return symbol_type (token::POP_PURGE);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_PUSHC ()
      {
        return symbol_type (token::POP_PUSHC);
      }
#else
      static
      symbol_type
      make_POP_PUSHC ()
      {
        return symbol_type (token::POP_PUSHC);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_PUSHO ()
      {
        return symbol_type (token::POP_PUSHO);
      }
#else
      static
      symbol_type
      make_POP_PUSHO ()
      {
        return symbol_type (token::POP_PUSHO);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_PUSHS ()
      {
        return symbol_type (token::POP_PUSHS);
      }
#else
      static
      symbol_type
      make_POP_PUSHS ()
      {
        return symbol_type (token::POP_PUSHS);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_RB ()
      {
        return symbol_type (token::POP_RB);
      }
#else
      static
      symbol_type
      make_POP_RB ()
      {
        return symbol_type (token::POP_RB);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_REDEF ()
      {
        return symbol_type (token::POP_REDEF);
      }
#else
      static
      symbol_type
      make_POP_REDEF ()
      {
        return symbol_type (token::POP_REDEF);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_REPT ()
      {
        return symbol_type (token::POP_REPT);
      }
#else
      static
      symbol_type
      make_POP_REPT ()
      {
        return symbol_type (token::POP_REPT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_RSRESET ()
      {
        return symbol_type (token::POP_RSRESET);
      }
#else
      static
      symbol_type
      make_POP_RSRESET ()
      {
        return symbol_type (token::POP_RSRESET);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_RSSET ()
      {
        return symbol_type (token::POP_RSSET);
      }
#else
      static
      symbol_type
      make_POP_RSSET ()
      {
        return symbol_type (token::POP_RSSET);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_RW ()
      {
        return symbol_type (token::POP_RW);
      }
#else
      static
      symbol_type
      make_POP_RW ()
      {
        return symbol_type (token::POP_RW);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_SECTION ()
      {
        return symbol_type (token::POP_SECTION);
      }
#else
      static
      symbol_type
      make_POP_SECTION ()
      {
        return symbol_type (token::POP_SECTION);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_SETCHARMAP ()
      {
        return symbol_type (token::POP_SETCHARMAP);
      }
#else
      static
      symbol_type
      make_POP_SETCHARMAP ()
      {
        return symbol_type (token::POP_SETCHARMAP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_SHIFT ()
      {
        return symbol_type (token::POP_SHIFT);
      }
#else
      static
      symbol_type
      make_POP_SHIFT ()
      {
        return symbol_type (token::POP_SHIFT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_STATIC_ASSERT ()
      {
        return symbol_type (token::POP_STATIC_ASSERT);
      }
#else
      static
      symbol_type
      make_POP_STATIC_ASSERT ()
      {
        return symbol_type (token::POP_STATIC_ASSERT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_UNION ()
      {
        return symbol_type (token::POP_UNION);
      }
#else
      static
      symbol_type
      make_POP_UNION ()
      {
        return symbol_type (token::POP_UNION);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_POP_WARN ()
      {
        return symbol_type (token::POP_WARN);
      }
#else
      static
      symbol_type
      make_POP_WARN ()
      {
        return symbol_type (token::POP_WARN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_ACOS ()
      {
        return symbol_type (token::OP_ACOS);
      }
#else
      static
      symbol_type
      make_OP_ACOS ()
      {
        return symbol_type (token::OP_ACOS);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_ASIN ()
      {
        return symbol_type (token::OP_ASIN);
      }
#else
      static
      symbol_type
      make_OP_ASIN ()
      {
        return symbol_type (token::OP_ASIN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_ATAN ()
      {
        return symbol_type (token::OP_ATAN);
      }
#else
      static
      symbol_type
      make_OP_ATAN ()
      {
        return symbol_type (token::OP_ATAN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_ATAN2 ()
      {
        return symbol_type (token::OP_ATAN2);
      }
#else
      static
      symbol_type
      make_OP_ATAN2 ()
      {
        return symbol_type (token::OP_ATAN2);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_BANK ()
      {
        return symbol_type (token::OP_BANK);
      }
#else
      static
      symbol_type
      make_OP_BANK ()
      {
        return symbol_type (token::OP_BANK);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_BITWIDTH ()
      {
        return symbol_type (token::OP_BITWIDTH);
      }
#else
      static
      symbol_type
      make_OP_BITWIDTH ()
      {
        return symbol_type (token::OP_BITWIDTH);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_BYTELEN ()
      {
        return symbol_type (token::OP_BYTELEN);
      }
#else
      static
      symbol_type
      make_OP_BYTELEN ()
      {
        return symbol_type (token::OP_BYTELEN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_CEIL ()
      {
        return symbol_type (token::OP_CEIL);
      }
#else
      static
      symbol_type
      make_OP_CEIL ()
      {
        return symbol_type (token::OP_CEIL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_CHARCMP ()
      {
        return symbol_type (token::OP_CHARCMP);
      }
#else
      static
      symbol_type
      make_OP_CHARCMP ()
      {
        return symbol_type (token::OP_CHARCMP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_CHARLEN ()
      {
        return symbol_type (token::OP_CHARLEN);
      }
#else
      static
      symbol_type
      make_OP_CHARLEN ()
      {
        return symbol_type (token::OP_CHARLEN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_CHARSIZE ()
      {
        return symbol_type (token::OP_CHARSIZE);
      }
#else
      static
      symbol_type
      make_OP_CHARSIZE ()
      {
        return symbol_type (token::OP_CHARSIZE);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_CHARSUB ()
      {
        return symbol_type (token::OP_CHARSUB);
      }
#else
      static
      symbol_type
      make_OP_CHARSUB ()
      {
        return symbol_type (token::OP_CHARSUB);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_CHARVAL ()
      {
        return symbol_type (token::OP_CHARVAL);
      }
#else
      static
      symbol_type
      make_OP_CHARVAL ()
      {
        return symbol_type (token::OP_CHARVAL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_COS ()
      {
        return symbol_type (token::OP_COS);
      }
#else
      static
      symbol_type
      make_OP_COS ()
      {
        return symbol_type (token::OP_COS);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_DEF ()
      {
        return symbol_type (token::OP_DEF);
      }
#else
      static
      symbol_type
      make_OP_DEF ()
      {
        return symbol_type (token::OP_DEF);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_FDIV ()
      {
        return symbol_type (token::OP_FDIV);
      }
#else
      static
      symbol_type
      make_OP_FDIV ()
      {
        return symbol_type (token::OP_FDIV);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_FLOOR ()
      {
        return symbol_type (token::OP_FLOOR);
      }
#else
      static
      symbol_type
      make_OP_FLOOR ()
      {
        return symbol_type (token::OP_FLOOR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_FMOD ()
      {
        return symbol_type (token::OP_FMOD);
      }
#else
      static
      symbol_type
      make_OP_FMOD ()
      {
        return symbol_type (token::OP_FMOD);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_FMUL ()
      {
        return symbol_type (token::OP_FMUL);
      }
#else
      static
      symbol_type
      make_OP_FMUL ()
      {
        return symbol_type (token::OP_FMUL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_HIGH ()
      {
        return symbol_type (token::OP_HIGH);
      }
#else
      static
      symbol_type
      make_OP_HIGH ()
      {
        return symbol_type (token::OP_HIGH);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_INCHARMAP ()
      {
        return symbol_type (token::OP_INCHARMAP);
      }
#else
      static
      symbol_type
      make_OP_INCHARMAP ()
      {
        return symbol_type (token::OP_INCHARMAP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_ISCONST ()
      {
        return symbol_type (token::OP_ISCONST);
      }
#else
      static
      symbol_type
      make_OP_ISCONST ()
      {
        return symbol_type (token::OP_ISCONST);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_LOG ()
      {
        return symbol_type (token::OP_LOG);
      }
#else
      static
      symbol_type
      make_OP_LOG ()
      {
        return symbol_type (token::OP_LOG);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_LOW ()
      {
        return symbol_type (token::OP_LOW);
      }
#else
      static
      symbol_type
      make_OP_LOW ()
      {
        return symbol_type (token::OP_LOW);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_POW ()
      {
        return symbol_type (token::OP_POW);
      }
#else
      static
      symbol_type
      make_OP_POW ()
      {
        return symbol_type (token::OP_POW);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_READFILE ()
      {
        return symbol_type (token::OP_READFILE);
      }
#else
      static
      symbol_type
      make_OP_READFILE ()
      {
        return symbol_type (token::OP_READFILE);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_REVCHAR ()
      {
        return symbol_type (token::OP_REVCHAR);
      }
#else
      static
      symbol_type
      make_OP_REVCHAR ()
      {
        return symbol_type (token::OP_REVCHAR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_ROUND ()
      {
        return symbol_type (token::OP_ROUND);
      }
#else
      static
      symbol_type
      make_OP_ROUND ()
      {
        return symbol_type (token::OP_ROUND);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_SIN ()
      {
        return symbol_type (token::OP_SIN);
      }
#else
      static
      symbol_type
      make_OP_SIN ()
      {
        return symbol_type (token::OP_SIN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_SIZEOF ()
      {
        return symbol_type (token::OP_SIZEOF);
      }
#else
      static
      symbol_type
      make_OP_SIZEOF ()
      {
        return symbol_type (token::OP_SIZEOF);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STARTOF ()
      {
        return symbol_type (token::OP_STARTOF);
      }
#else
      static
      symbol_type
      make_OP_STARTOF ()
      {
        return symbol_type (token::OP_STARTOF);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRBYTE ()
      {
        return symbol_type (token::OP_STRBYTE);
      }
#else
      static
      symbol_type
      make_OP_STRBYTE ()
      {
        return symbol_type (token::OP_STRBYTE);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRCAT ()
      {
        return symbol_type (token::OP_STRCAT);
      }
#else
      static
      symbol_type
      make_OP_STRCAT ()
      {
        return symbol_type (token::OP_STRCAT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRCHAR ()
      {
        return symbol_type (token::OP_STRCHAR);
      }
#else
      static
      symbol_type
      make_OP_STRCHAR ()
      {
        return symbol_type (token::OP_STRCHAR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRCMP ()
      {
        return symbol_type (token::OP_STRCMP);
      }
#else
      static
      symbol_type
      make_OP_STRCMP ()
      {
        return symbol_type (token::OP_STRCMP);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRFIND ()
      {
        return symbol_type (token::OP_STRFIND);
      }
#else
      static
      symbol_type
      make_OP_STRFIND ()
      {
        return symbol_type (token::OP_STRFIND);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRFMT ()
      {
        return symbol_type (token::OP_STRFMT);
      }
#else
      static
      symbol_type
      make_OP_STRFMT ()
      {
        return symbol_type (token::OP_STRFMT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRIN ()
      {
        return symbol_type (token::OP_STRIN);
      }
#else
      static
      symbol_type
      make_OP_STRIN ()
      {
        return symbol_type (token::OP_STRIN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRLEN ()
      {
        return symbol_type (token::OP_STRLEN);
      }
#else
      static
      symbol_type
      make_OP_STRLEN ()
      {
        return symbol_type (token::OP_STRLEN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRLWR ()
      {
        return symbol_type (token::OP_STRLWR);
      }
#else
      static
      symbol_type
      make_OP_STRLWR ()
      {
        return symbol_type (token::OP_STRLWR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRRFIND ()
      {
        return symbol_type (token::OP_STRRFIND);
      }
#else
      static
      symbol_type
      make_OP_STRRFIND ()
      {
        return symbol_type (token::OP_STRRFIND);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRRIN ()
      {
        return symbol_type (token::OP_STRRIN);
      }
#else
      static
      symbol_type
      make_OP_STRRIN ()
      {
        return symbol_type (token::OP_STRRIN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRRPL ()
      {
        return symbol_type (token::OP_STRRPL);
      }
#else
      static
      symbol_type
      make_OP_STRRPL ()
      {
        return symbol_type (token::OP_STRRPL);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRSLICE ()
      {
        return symbol_type (token::OP_STRSLICE);
      }
#else
      static
      symbol_type
      make_OP_STRSLICE ()
      {
        return symbol_type (token::OP_STRSLICE);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRSUB ()
      {
        return symbol_type (token::OP_STRSUB);
      }
#else
      static
      symbol_type
      make_OP_STRSUB ()
      {
        return symbol_type (token::OP_STRSUB);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_STRUPR ()
      {
        return symbol_type (token::OP_STRUPR);
      }
#else
      static
      symbol_type
      make_OP_STRUPR ()
      {
        return symbol_type (token::OP_STRUPR);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_TAN ()
      {
        return symbol_type (token::OP_TAN);
      }
#else
      static
      symbol_type
      make_OP_TAN ()
      {
        return symbol_type (token::OP_TAN);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_OP_TZCOUNT ()
      {
        return symbol_type (token::OP_TZCOUNT);
      }
#else
      static
      symbol_type
      make_OP_TZCOUNT ()
      {
        return symbol_type (token::OP_TZCOUNT);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SECT_HRAM ()
      {
        return symbol_type (token::SECT_HRAM);
      }
#else
      static
      symbol_type
      make_SECT_HRAM ()
      {
        return symbol_type (token::SECT_HRAM);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SECT_OAM ()
      {
        return symbol_type (token::SECT_OAM);
      }
#else
      static
      symbol_type
      make_SECT_OAM ()
      {
        return symbol_type (token::SECT_OAM);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SECT_ROM0 ()
      {
        return symbol_type (token::SECT_ROM0);
      }
#else
      static
      symbol_type
      make_SECT_ROM0 ()
      {
        return symbol_type (token::SECT_ROM0);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SECT_ROMX ()
      {
        return symbol_type (token::SECT_ROMX);
      }
#else
      static
      symbol_type
      make_SECT_ROMX ()
      {
        return symbol_type (token::SECT_ROMX);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SECT_SRAM ()
      {
        return symbol_type (token::SECT_SRAM);
      }
#else
      static
      symbol_type
      make_SECT_SRAM ()
      {
        return symbol_type (token::SECT_SRAM);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SECT_VRAM ()
      {
        return symbol_type (token::SECT_VRAM);
      }
#else
      static
      symbol_type
      make_SECT_VRAM ()
      {
        return symbol_type (token::SECT_VRAM);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SECT_WRAM0 ()
      {
        return symbol_type (token::SECT_WRAM0);
      }
#else
      static
      symbol_type
      make_SECT_WRAM0 ()
      {
        return symbol_type (token::SECT_WRAM0);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SECT_WRAMX ()
      {
        return symbol_type (token::SECT_WRAMX);
      }
#else
      static
      symbol_type
      make_SECT_WRAMX ()
      {
        return symbol_type (token::SECT_WRAMX);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_NUMBER (int32_t v)
      {
        return symbol_type (token::NUMBER, std::move (v));
      }
#else
      static
      symbol_type
      make_NUMBER (const int32_t& v)
      {
        return symbol_type (token::NUMBER, v);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_STRING (std::string v)
      {
        return symbol_type (token::STRING, std::move (v));
      }
#else
      static
      symbol_type
      make_STRING (const std::string& v)
      {
        return symbol_type (token::STRING, v);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_CHARACTER (std::string v)
      {
        return symbol_type (token::CHARACTER, std::move (v));
      }
#else
      static
      symbol_type
      make_CHARACTER (const std::string& v)
      {
        return symbol_type (token::CHARACTER, v);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_SYMBOL (std::string v)
      {
        return symbol_type (token::SYMBOL, std::move (v));
      }
#else
      static
      symbol_type
      make_SYMBOL (const std::string& v)
      {
        return symbol_type (token::SYMBOL, v);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LABEL (std::string v)
      {
        return symbol_type (token::LABEL, std::move (v));
      }
#else
      static
      symbol_type
      make_LABEL (const std::string& v)
      {
        return symbol_type (token::LABEL, v);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_LOCAL (std::string v)
      {
        return symbol_type (token::LOCAL, std::move (v));
      }
#else
      static
      symbol_type
      make_LOCAL (const std::string& v)
      {
        return symbol_type (token::LOCAL, v);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_ANON (std::string v)
      {
        return symbol_type (token::ANON, std::move (v));
      }
#else
      static
      symbol_type
      make_ANON (const std::string& v)
      {
        return symbol_type (token::ANON, v);
      }
#endif
#if 201103L <= YY_CPLUSPLUS
      static
      symbol_type
      make_QMACRO (std::string v)
      {
        return symbol_type (token::QMACRO, std::move (v));
      }
#else
      static
      symbol_type
      make_QMACRO (const std::string& v)
      {
        return symbol_type (token::QMACRO, v);
      }
#endif


    class context
    {
    public:
      context (const parser& yyparser, const symbol_type& yyla);
      const symbol_type& lookahead () const YY_NOEXCEPT { return yyla_; }
      symbol_kind_type token () const YY_NOEXCEPT { return yyla_.kind (); }
      /// Put in YYARG at most YYARGN of the expected tokens, and return the
      /// number of tokens stored in YYARG.  If YYARG is null, return the
      /// number of expected tokens (guaranteed to be less than YYNTOKENS).
      int expected_tokens (symbol_kind_type yyarg[], int yyargn) const;

    private:
      const parser& yyparser_;
      const symbol_type& yyla_;
    };

  private:
#if YY_CPLUSPLUS < 201103L
    /// Non copyable.
    parser (const parser&);
    /// Non copyable.
    parser& operator= (const parser&);
#endif

    /// Check the lookahead yytoken.
    /// \returns  true iff the token will be eventually shifted.
    bool yy_lac_check_ (symbol_kind_type yytoken) const;
    /// Establish the initial context if no initial context currently exists.
    /// \returns  true iff the token will be eventually shifted.
    bool yy_lac_establish_ (symbol_kind_type yytoken);
    /// Discard any previous initial lookahead context because of event.
    /// \param event  the event which caused the lookahead to be discarded.
    ///               Only used for debbuging output.
    void yy_lac_discard_ (const char* event);

    /// Stored state numbers (used for stacks).
    typedef short state_type;

    /// The arguments of the error message.
    int yy_syntax_error_arguments_ (const context& yyctx,
                                    symbol_kind_type yyarg[], int yyargn) const;

    /// Generate an error message.
    /// \param yyctx     the context in which the error occurred.
    virtual std::string yysyntax_error_ (const context& yyctx) const;
    /// Compute post-reduction state.
    /// \param yystate   the current state
    /// \param yysym     the nonterminal to push on the stack
    static state_type yy_lr_goto_state_ (state_type yystate, int yysym);

    /// Whether the given \c yypact_ value indicates a defaulted state.
    /// \param yyvalue   the value to check
    static bool yy_pact_value_is_default_ (int yyvalue) YY_NOEXCEPT;

    /// Whether the given \c yytable_ value indicates a syntax error.
    /// \param yyvalue   the value to check
    static bool yy_table_value_is_error_ (int yyvalue) YY_NOEXCEPT;

    static const short yypact_ninf_;
    static const short yytable_ninf_;

    /// Convert a scanner token kind \a t to a symbol kind.
    /// In theory \a t should be a token_kind_type, but character literals
    /// are valid, yet not members of the token_kind_type enum.
    static symbol_kind_type yytranslate_ (int t) YY_NOEXCEPT;



    // Tables.
    // YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
    // STATE-NUM.
    static const short yypact_[];

    // YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
    // Performed when YYTABLE does not specify something else to do.  Zero
    // means the default is an error.
    static const short yydefact_[];

    // YYPGOTO[NTERM-NUM].
    static const short yypgoto_[];

    // YYDEFGOTO[NTERM-NUM].
    static const short yydefgoto_[];

    // YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
    // positive, shift that token.  If negative, reduce the rule whose
    // number is the opposite.  If YYTABLE_NINF, syntax error.
    static const short yytable_[];

    static const short yycheck_[];

    // YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
    // state STATE-NUM.
    static const short yystos_[];

    // YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.
    static const short yyr1_[];

    // YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.
    static const signed char yyr2_[];


#if YYDEBUG
    // YYRLINE[YYN] -- Source line where rule number YYN was defined.
    static const short yyrline_[];
    /// Report on the debug stream that the rule \a r is going to be reduced.
    virtual void yy_reduce_print_ (int r) const;
    /// Print the state stack on the debug stream.
    virtual void yy_stack_print_ () const;

    /// Debugging level.
    int yydebug_;
    /// Debug stream.
    std::ostream* yycdebug_;

    /// \brief Display a symbol kind, value and location.
    /// \param yyo    The output stream.
    /// \param yysym  The symbol.
    template <typename Base>
    void yy_print_ (std::ostream& yyo, const basic_symbol<Base>& yysym) const;
#endif

    /// \brief Reclaim the memory associated to a symbol.
    /// \param yymsg     Why this token is reclaimed.
    ///                  If null, print nothing.
    /// \param yysym     The symbol.
    template <typename Base>
    void yy_destroy_ (const char* yymsg, basic_symbol<Base>& yysym) const;

  private:
    /// Type access provider for state based symbols.
    struct by_state
    {
      /// Default constructor.
      by_state () YY_NOEXCEPT;

      /// The symbol kind as needed by the constructor.
      typedef state_type kind_type;

      /// Constructor.
      by_state (kind_type s) YY_NOEXCEPT;

      /// Copy constructor.
      by_state (const by_state& that) YY_NOEXCEPT;

      /// Record that this symbol is empty.
      void clear () YY_NOEXCEPT;

      /// Steal the symbol kind from \a that.
      void move (by_state& that);

      /// The symbol kind (corresponding to \a state).
      /// \a symbol_kind::S_YYEMPTY when empty.
      symbol_kind_type kind () const YY_NOEXCEPT;

      /// The state number used to denote an empty symbol.
      /// We use the initial state, as it does not have a value.
      enum { empty_state = 0 };

      /// The state.
      /// \a empty when empty.
      state_type state;
    };

    /// "Internal" symbol: element of the stack.
    struct stack_symbol_type : basic_symbol<by_state>
    {
      /// Superclass.
      typedef basic_symbol<by_state> super_type;
      /// Construct an empty symbol.
      stack_symbol_type ();
      /// Move or copy construction.
      stack_symbol_type (YY_RVREF (stack_symbol_type) that);
      /// Steal the contents from \a sym to build this.
      stack_symbol_type (state_type s, YY_MOVE_REF (symbol_type) sym);
#if YY_CPLUSPLUS < 201103L
      /// Assignment, needed by push_back by some old implementations.
      /// Moves the contents of that.
      stack_symbol_type& operator= (stack_symbol_type& that);

      /// Assignment, needed by push_back by other implementations.
      /// Needed by some other old implementations.
      stack_symbol_type& operator= (const stack_symbol_type& that);
#endif
    };

    /// A stack with random access from its top.
    template <typename T, typename S = std::vector<T> >
    class stack
    {
    public:
      // Hide our reversed order.
      typedef typename S::iterator iterator;
      typedef typename S::const_iterator const_iterator;
      typedef typename S::size_type size_type;
      typedef typename std::ptrdiff_t index_type;

      stack (size_type n = 200) YY_NOEXCEPT
        : seq_ (n)
      {}

#if 201103L <= YY_CPLUSPLUS
      /// Non copyable.
      stack (const stack&) = delete;
      /// Non copyable.
      stack& operator= (const stack&) = delete;
#endif

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      const T&
      operator[] (index_type i) const
      {
        return seq_[size_type (size () - 1 - i)];
      }

      /// Random access.
      ///
      /// Index 0 returns the topmost element.
      T&
      operator[] (index_type i)
      {
        return seq_[size_type (size () - 1 - i)];
      }

      /// Steal the contents of \a t.
      ///
      /// Close to move-semantics.
      void
      push (YY_MOVE_REF (T) t)
      {
        seq_.push_back (T ());
        operator[] (0).move (t);
      }

      /// Pop elements from the stack.
      void
      pop (std::ptrdiff_t n = 1) YY_NOEXCEPT
      {
        for (; 0 < n; --n)
          seq_.pop_back ();
      }

      /// Pop all elements from the stack.
      void
      clear () YY_NOEXCEPT
      {
        seq_.clear ();
      }

      /// Number of elements on the stack.
      index_type
      size () const YY_NOEXCEPT
      {
        return index_type (seq_.size ());
      }

      /// Iterator on top of the stack (going downwards).
      const_iterator
      begin () const YY_NOEXCEPT
      {
        return seq_.begin ();
      }

      /// Bottom of the stack.
      const_iterator
      end () const YY_NOEXCEPT
      {
        return seq_.end ();
      }

      /// Present a slice of the top of a stack.
      class slice
      {
      public:
        slice (const stack& stack, index_type range) YY_NOEXCEPT
          : stack_ (stack)
          , range_ (range)
        {}

        const T&
        operator[] (index_type i) const
        {
          return stack_[range_ - i];
        }

      private:
        const stack& stack_;
        index_type range_;
      };

    private:
#if YY_CPLUSPLUS < 201103L
      /// Non copyable.
      stack (const stack&);
      /// Non copyable.
      stack& operator= (const stack&);
#endif
      /// The wrapped container.
      S seq_;
    };


    /// Stack type.
    typedef stack<stack_symbol_type> stack_type;

    /// The stack.
    stack_type yystack_;
    /// The stack for LAC.
    /// Logically, the yy_lac_stack's lifetime is confined to the function
    /// yy_lac_check_. We just store it as a member of this class to hold
    /// on to the memory and to avoid frequent reallocations.
    /// Since yy_lac_check_ is const, this member must be mutable.
    mutable std::vector<state_type> yylac_stack_;
    /// Whether an initial LAC context was established.
    bool yy_lac_established_;


    /// Push a new state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param sym  the symbol
    /// \warning the contents of \a s.value is stolen.
    void yypush_ (const char* m, YY_MOVE_REF (stack_symbol_type) sym);

    /// Push a new look ahead token on the state on the stack.
    /// \param m    a debug message to display
    ///             if null, no trace is output.
    /// \param s    the state
    /// \param sym  the symbol (for its value and location).
    /// \warning the contents of \a sym.value is stolen.
    void yypush_ (const char* m, state_type s, YY_MOVE_REF (symbol_type) sym);

    /// Pop \a n symbols from the stack.
    void yypop_ (int n = 1) YY_NOEXCEPT;

    /// Constants.
    enum
    {
      yylast_ = 4377,     ///< Last index in yytable_.
      yynnts_ = 210,  ///< Number of nonterminal symbols.
      yyfinal_ = 5 ///< Termination state number.
    };



  };

  inline
  parser::symbol_kind_type
  parser::yytranslate_ (int t) YY_NOEXCEPT
  {
    return static_cast<symbol_kind_type> (t);
  }

  // basic_symbol.
  template <typename Base>
  parser::basic_symbol<Base>::basic_symbol (const basic_symbol& that)
    : Base (that)
    , value ()
  {
    switch (this->kind ())
    {
      case symbol_kind::S_align_spec: // align_spec
        value.copy< AlignmentSpec > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_assert_type: // assert_type
        value.copy< AssertionType > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        value.copy< Capture > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        value.copy< Expression > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_for_args: // for_args
        value.copy< ForArgs > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        value.copy< RPNCommand > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        value.copy< SectionModifier > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        value.copy< SectionSpec > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_sect_type: // sect_type
        value.copy< SectionType > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        value.copy< StrFmtArgList > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_maybe_quiet: // maybe_quiet
        value.copy< bool > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        value.copy< int32_t > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_macro_args: // macro_args
        value.copy< std::shared_ptr<MacroArgs> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_QMACRO: // "quiet macro"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        value.copy< std::string > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_ds_args: // ds_args
        value.copy< std::vector<Expression> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        value.copy< std::vector<int32_t> > (YY_MOVE (that.value));
        break;

      case symbol_kind::S_purge_args: // purge_args
        value.copy< std::vector<std::string> > (YY_MOVE (that.value));
        break;

      default:
        break;
    }

  }




  template <typename Base>
  parser::symbol_kind_type
  parser::basic_symbol<Base>::type_get () const YY_NOEXCEPT
  {
    return this->kind ();
  }


  template <typename Base>
  bool
  parser::basic_symbol<Base>::empty () const YY_NOEXCEPT
  {
    return this->kind () == symbol_kind::S_YYEMPTY;
  }

  template <typename Base>
  void
  parser::basic_symbol<Base>::move (basic_symbol& s)
  {
    super_type::move (s);
    switch (this->kind ())
    {
      case symbol_kind::S_align_spec: // align_spec
        value.move< AlignmentSpec > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_assert_type: // assert_type
        value.move< AssertionType > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_capture_rept: // capture_rept
      case symbol_kind::S_capture_macro: // capture_macro
        value.move< Capture > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_reloc_3bit: // reloc_3bit
      case symbol_kind::S_reloc_8bit: // reloc_8bit
      case symbol_kind::S_reloc_16bit: // reloc_16bit
      case symbol_kind::S_relocexpr: // relocexpr
      case symbol_kind::S_relocexpr_no_str: // relocexpr_no_str
      case symbol_kind::S_op_mem_ind: // op_mem_ind
      case symbol_kind::S_op_a_n: // op_a_n
      case symbol_kind::S_op_sp_offset: // op_sp_offset
        value.move< Expression > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_for_args: // for_args
        value.move< ForArgs > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_compound_eq: // compound_eq
        value.move< RPNCommand > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_sect_mod: // sect_mod
        value.move< SectionModifier > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_sect_attrs: // sect_attrs
        value.move< SectionSpec > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_sect_type: // sect_type
        value.move< SectionType > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_strfmt_args: // strfmt_args
      case symbol_kind::S_strfmt_va_args: // strfmt_va_args
        value.move< StrFmtArgList > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_maybe_quiet: // maybe_quiet
        value.move< bool > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_NUMBER: // "number"
      case symbol_kind::S_shift_const: // shift_const
      case symbol_kind::S_rs_uconst: // rs_uconst
      case symbol_kind::S_uconst: // uconst
      case symbol_kind::S_iconst: // iconst
      case symbol_kind::S_precision_arg: // precision_arg
      case symbol_kind::S_sect_org: // sect_org
      case symbol_kind::S_op_a_r: // op_a_r
      case symbol_kind::S_ccode_expr: // ccode_expr
      case symbol_kind::S_ccode: // ccode
      case symbol_kind::S_reg_r: // reg_r
      case symbol_kind::S_reg_r_no_a: // reg_r_no_a
      case symbol_kind::S_reg_a: // reg_a
      case symbol_kind::S_reg_tt: // reg_tt
      case symbol_kind::S_reg_ss: // reg_ss
      case symbol_kind::S_reg_tt_no_af: // reg_tt_no_af
      case symbol_kind::S_reg_bc_or_de: // reg_bc_or_de
      case symbol_kind::S_reg_rr: // reg_rr
        value.move< int32_t > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_macro_args: // macro_args
        value.move< std::shared_ptr<MacroArgs> > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_STRING: // "string"
      case symbol_kind::S_CHARACTER: // "character"
      case symbol_kind::S_SYMBOL: // "symbol"
      case symbol_kind::S_LABEL: // "label"
      case symbol_kind::S_LOCAL: // "local label"
      case symbol_kind::S_ANON: // "anonymous label"
      case symbol_kind::S_QMACRO: // "quiet macro"
      case symbol_kind::S_def_id: // def_id
      case symbol_kind::S_redef_id: // redef_id
      case symbol_kind::S_scoped_sym_no_anon: // scoped_sym_no_anon
      case symbol_kind::S_scoped_sym: // scoped_sym
      case symbol_kind::S_def_numeric: // def_numeric
      case symbol_kind::S_def_equ: // def_equ
      case symbol_kind::S_redef_equ: // redef_equ
      case symbol_kind::S_def_set: // def_set
      case symbol_kind::S_def_rb: // def_rb
      case symbol_kind::S_def_rw: // def_rw
      case symbol_kind::S_def_rl: // def_rl
      case symbol_kind::S_def_equs: // def_equs
      case symbol_kind::S_redef_equs: // redef_equs
      case symbol_kind::S_fragment_literal: // fragment_literal
      case symbol_kind::S_fragment_literal_name: // fragment_literal_name
      case symbol_kind::S_string_literal: // string_literal
      case symbol_kind::S_string: // string
      case symbol_kind::S_strcat_args: // strcat_args
        value.move< std::string > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_ds_args: // ds_args
        value.move< std::vector<Expression> > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_charmap_args: // charmap_args
        value.move< std::vector<int32_t> > (YY_MOVE (s.value));
        break;

      case symbol_kind::S_purge_args: // purge_args
        value.move< std::vector<std::string> > (YY_MOVE (s.value));
        break;

      default:
        break;
    }

  }

  // by_kind.
  inline
  parser::by_kind::by_kind () YY_NOEXCEPT
    : kind_ (symbol_kind::S_YYEMPTY)
  {}

#if 201103L <= YY_CPLUSPLUS
  inline
  parser::by_kind::by_kind (by_kind&& that) YY_NOEXCEPT
    : kind_ (that.kind_)
  {
    that.clear ();
  }
#endif

  inline
  parser::by_kind::by_kind (const by_kind& that) YY_NOEXCEPT
    : kind_ (that.kind_)
  {}

  inline
  parser::by_kind::by_kind (token_kind_type t) YY_NOEXCEPT
    : kind_ (yytranslate_ (t))
  {}



  inline
  void
  parser::by_kind::clear () YY_NOEXCEPT
  {
    kind_ = symbol_kind::S_YYEMPTY;
  }

  inline
  void
  parser::by_kind::move (by_kind& that)
  {
    kind_ = that.kind_;
    that.clear ();
  }

  inline
  parser::symbol_kind_type
  parser::by_kind::kind () const YY_NOEXCEPT
  {
    return kind_;
  }


  inline
  parser::symbol_kind_type
  parser::by_kind::type_get () const YY_NOEXCEPT
  {
    return this->kind ();
  }


} // yy
#line 6091 "/build/rgbds/src/rgbds/src/asm/parser.hpp"




#endif // !YY_YY_BUILD_RGBDS_SRC_RGBDS_SRC_ASM_PARSER_HPP_INCLUDED
