/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "bin/default/librpc/gen_ndr/ndr_svcctl.h"
#include "bin/default/librpc/gen_ndr/ndr_svcctl_c.h"

/* svcctl - client functions generated by pidl */

struct dcerpc_svcctl_CloseServiceHandle_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CloseServiceHandle_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CloseServiceHandle_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_CloseServiceHandle *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CloseServiceHandle_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CloseServiceHandle_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CLOSESERVICEHANDLE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CloseServiceHandle_r_done, req);

	return req;
}

static void dcerpc_svcctl_CloseServiceHandle_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CloseServiceHandle_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_CloseServiceHandle_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_CloseServiceHandle_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CloseServiceHandle_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_CloseServiceHandle *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CLOSESERVICEHANDLE, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_CloseServiceHandle_state {
	struct svcctl_CloseServiceHandle orig;
	struct svcctl_CloseServiceHandle tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CloseServiceHandle_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CloseServiceHandle_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_handle /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CloseServiceHandle_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CloseServiceHandle_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_CloseServiceHandle_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_CloseServiceHandle_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CloseServiceHandle_done, req);
	return req;
}

static void dcerpc_svcctl_CloseServiceHandle_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_CloseServiceHandle_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CloseServiceHandle_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_CloseServiceHandle_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CloseServiceHandle_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_svcctl_CloseServiceHandle_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CloseServiceHandle_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CloseServiceHandle(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_handle /* [in,out] [ref] */,
					  WERROR *result)
{
	struct svcctl_CloseServiceHandle r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_CloseServiceHandle_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_ControlService_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ControlService_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ControlService_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_ControlService *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ControlService_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ControlService_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CONTROLSERVICE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ControlService_r_done, req);

	return req;
}

static void dcerpc_svcctl_ControlService_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ControlService_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_ControlService_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_ControlService_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ControlService_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_ControlService *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CONTROLSERVICE, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_ControlService_state {
	struct svcctl_ControlService orig;
	struct svcctl_ControlService tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ControlService_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ControlService_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_handle /* [in] [ref] */,
						     enum SERVICE_CONTROL _control /* [in]  */,
						     struct SERVICE_STATUS *_service_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ControlService_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ControlService_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.control = _control;

	/* Out parameters */
	state->orig.out.service_status = _service_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_ControlService_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_ControlService_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ControlService_done, req);
	return req;
}

static void dcerpc_svcctl_ControlService_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_ControlService_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ControlService_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_ControlService_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.service_status = *state->tmp.out.service_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ControlService_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_svcctl_ControlService_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ControlService_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ControlService(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_handle /* [in] [ref] */,
				      enum SERVICE_CONTROL _control /* [in]  */,
				      struct SERVICE_STATUS *_service_status /* [out] [ref] */,
				      WERROR *result)
{
	struct svcctl_ControlService r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.control = _control;

	/* Out parameters */
	r.out.service_status = _service_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_ControlService_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_service_status = *r.out.service_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_DeleteService_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_DeleteService_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_DeleteService_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_DeleteService *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_DeleteService_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_DeleteService_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_DELETESERVICE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_DeleteService_r_done, req);

	return req;
}

static void dcerpc_svcctl_DeleteService_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_DeleteService_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_DeleteService_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_DeleteService_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_DeleteService_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_DeleteService *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_DELETESERVICE, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_DeleteService_state {
	struct svcctl_DeleteService orig;
	struct svcctl_DeleteService tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_DeleteService_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_DeleteService_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_DeleteService_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_DeleteService_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_DeleteService_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_DeleteService_done, req);
	return req;
}

static void dcerpc_svcctl_DeleteService_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_DeleteService_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_DeleteService_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_DeleteService_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_DeleteService_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_svcctl_DeleteService_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_DeleteService_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_DeleteService(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in] [ref] */,
				     WERROR *result)
{
	struct svcctl_DeleteService r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_DeleteService_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_LockServiceDatabase_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_LockServiceDatabase_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_LockServiceDatabase_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_LockServiceDatabase *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_LockServiceDatabase_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_LockServiceDatabase_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_LOCKSERVICEDATABASE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_LockServiceDatabase_r_done, req);

	return req;
}

static void dcerpc_svcctl_LockServiceDatabase_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_LockServiceDatabase_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_LockServiceDatabase_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_LockServiceDatabase_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_LockServiceDatabase_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_LockServiceDatabase *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_LOCKSERVICEDATABASE, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_LockServiceDatabase_state {
	struct svcctl_LockServiceDatabase orig;
	struct svcctl_LockServiceDatabase tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_LockServiceDatabase_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_LockServiceDatabase_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  struct policy_handle *_lock /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_LockServiceDatabase_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_LockServiceDatabase_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.lock = _lock;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_LockServiceDatabase_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_LockServiceDatabase_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_LockServiceDatabase_done, req);
	return req;
}

static void dcerpc_svcctl_LockServiceDatabase_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_LockServiceDatabase_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_LockServiceDatabase_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_LockServiceDatabase_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lock = *state->tmp.out.lock;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_LockServiceDatabase_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_svcctl_LockServiceDatabase_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_LockServiceDatabase_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_LockServiceDatabase(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   struct policy_handle *_lock /* [out] [ref] */,
					   WERROR *result)
{
	struct svcctl_LockServiceDatabase r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.lock = _lock;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_LockServiceDatabase_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lock = *r.out.lock;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceObjectSecurity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceObjectSecurity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceObjectSecurity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceObjectSecurity *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceObjectSecurity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceObjectSecurity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICEOBJECTSECURITY, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceObjectSecurity_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceObjectSecurity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceObjectSecurity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceObjectSecurity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceObjectSecurity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceObjectSecurity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceObjectSecurity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICEOBJECTSECURITY, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceObjectSecurity_state {
	struct svcctl_QueryServiceObjectSecurity orig;
	struct svcctl_QueryServiceObjectSecurity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceObjectSecurity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceObjectSecurity_send(TALLOC_CTX *mem_ctx,
								 struct tevent_context *ev,
								 struct dcerpc_binding_handle *h,
								 struct policy_handle *_handle /* [in] [ref] */,
								 uint32_t _security_flags /* [in]  */,
								 uint8_t *_buffer /* [out] [ref,size_is(offered)] */,
								 uint32_t _offered /* [in] [range(0,0x40000)] */,
								 uint32_t *_needed /* [out] [range(0,0x40000),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceObjectSecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceObjectSecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.security_flags = _security_flags;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceObjectSecurity_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceObjectSecurity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceObjectSecurity_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceObjectSecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceObjectSecurity_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceObjectSecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceObjectSecurity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = state->tmp.in.offered;
		if (state->orig.out.buffer != state->tmp.out.buffer) {
			memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
		}
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceObjectSecurity_recv(struct tevent_req *req,
						       TALLOC_CTX *mem_ctx,
						       WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceObjectSecurity_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceObjectSecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceObjectSecurity(struct dcerpc_binding_handle *h,
						  TALLOC_CTX *mem_ctx,
						  struct policy_handle *_handle /* [in] [ref] */,
						  uint32_t _security_flags /* [in]  */,
						  uint8_t *_buffer /* [out] [ref,size_is(offered)] */,
						  uint32_t _offered /* [in] [range(0,0x40000)] */,
						  uint32_t *_needed /* [out] [range(0,0x40000),ref] */,
						  WERROR *result)
{
	struct svcctl_QueryServiceObjectSecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.security_flags = _security_flags;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceObjectSecurity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = r.in.offered;
		if (_buffer != r.out.buffer) {
			memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
		}
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_SetServiceObjectSecurity_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_SetServiceObjectSecurity_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_SetServiceObjectSecurity_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_SetServiceObjectSecurity *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_SetServiceObjectSecurity_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_SetServiceObjectSecurity_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_SETSERVICEOBJECTSECURITY, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_SetServiceObjectSecurity_r_done, req);

	return req;
}

static void dcerpc_svcctl_SetServiceObjectSecurity_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_SetServiceObjectSecurity_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_SetServiceObjectSecurity_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_SetServiceObjectSecurity_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_SetServiceObjectSecurity_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_SetServiceObjectSecurity *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_SETSERVICEOBJECTSECURITY, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_SetServiceObjectSecurity_state {
	struct svcctl_SetServiceObjectSecurity orig;
	struct svcctl_SetServiceObjectSecurity tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_SetServiceObjectSecurity_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_SetServiceObjectSecurity_send(TALLOC_CTX *mem_ctx,
							       struct tevent_context *ev,
							       struct dcerpc_binding_handle *h,
							       struct policy_handle *_handle /* [in] [ref] */,
							       uint32_t _security_flags /* [in]  */,
							       uint8_t *_buffer /* [in] [ref,size_is(offered)] */,
							       uint32_t _offered /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_SetServiceObjectSecurity_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_SetServiceObjectSecurity_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.security_flags = _security_flags;
	state->orig.in.buffer = _buffer;
	state->orig.in.offered = _offered;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_SetServiceObjectSecurity_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_SetServiceObjectSecurity_done, req);
	return req;
}

static void dcerpc_svcctl_SetServiceObjectSecurity_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_SetServiceObjectSecurity_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_SetServiceObjectSecurity_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_SetServiceObjectSecurity_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_SetServiceObjectSecurity_recv(struct tevent_req *req,
						     TALLOC_CTX *mem_ctx,
						     WERROR *result)
{
	struct dcerpc_svcctl_SetServiceObjectSecurity_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_SetServiceObjectSecurity_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_SetServiceObjectSecurity(struct dcerpc_binding_handle *h,
						TALLOC_CTX *mem_ctx,
						struct policy_handle *_handle /* [in] [ref] */,
						uint32_t _security_flags /* [in]  */,
						uint8_t *_buffer /* [in] [ref,size_is(offered)] */,
						uint32_t _offered /* [in]  */,
						WERROR *result)
{
	struct svcctl_SetServiceObjectSecurity r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.security_flags = _security_flags;
	r.in.buffer = _buffer;
	r.in.offered = _offered;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_SetServiceObjectSecurity_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceStatus_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceStatus_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceStatus_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceStatus *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceStatus_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceStatus_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICESTATUS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceStatus_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceStatus_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceStatus_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceStatus_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceStatus_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceStatus_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceStatus *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICESTATUS, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceStatus_state {
	struct svcctl_QueryServiceStatus orig;
	struct svcctl_QueryServiceStatus tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceStatus_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceStatus_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_handle /* [in] [ref] */,
							 struct SERVICE_STATUS *_service_status /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceStatus_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceStatus_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;

	/* Out parameters */
	state->orig.out.service_status = _service_status;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceStatus_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceStatus_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceStatus_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceStatus_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceStatus_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceStatus_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceStatus_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.service_status = *state->tmp.out.service_status;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceStatus_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceStatus_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceStatus_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceStatus(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_handle /* [in] [ref] */,
					  struct SERVICE_STATUS *_service_status /* [out] [ref] */,
					  WERROR *result)
{
	struct svcctl_QueryServiceStatus r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;

	/* Out parameters */
	r.out.service_status = _service_status;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceStatus_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_service_status = *r.out.service_status;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_UnlockServiceDatabase_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_UnlockServiceDatabase_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_UnlockServiceDatabase_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_UnlockServiceDatabase *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_UnlockServiceDatabase_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_UnlockServiceDatabase_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_UNLOCKSERVICEDATABASE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_UnlockServiceDatabase_r_done, req);

	return req;
}

static void dcerpc_svcctl_UnlockServiceDatabase_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_UnlockServiceDatabase_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_UnlockServiceDatabase_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_UnlockServiceDatabase_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_UnlockServiceDatabase_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_UnlockServiceDatabase *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_UNLOCKSERVICEDATABASE, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_UnlockServiceDatabase_state {
	struct svcctl_UnlockServiceDatabase orig;
	struct svcctl_UnlockServiceDatabase tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_UnlockServiceDatabase_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_UnlockServiceDatabase_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle *_lock /* [in,out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_UnlockServiceDatabase_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_UnlockServiceDatabase_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.lock = _lock;

	/* Out parameters */
	state->orig.out.lock = _lock;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_UnlockServiceDatabase_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_UnlockServiceDatabase_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_UnlockServiceDatabase_done, req);
	return req;
}

static void dcerpc_svcctl_UnlockServiceDatabase_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_UnlockServiceDatabase_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_UnlockServiceDatabase_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_UnlockServiceDatabase_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lock = *state->tmp.out.lock;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_UnlockServiceDatabase_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_svcctl_UnlockServiceDatabase_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_UnlockServiceDatabase_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_UnlockServiceDatabase(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *_lock /* [in,out] [ref] */,
					     WERROR *result)
{
	struct svcctl_UnlockServiceDatabase r;
	NTSTATUS status;

	/* In parameters */
	r.in.lock = _lock;

	/* Out parameters */
	r.out.lock = _lock;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_UnlockServiceDatabase_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lock = *r.out.lock;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_SCSetServiceBitsW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_SCSetServiceBitsW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_SCSetServiceBitsW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_SCSetServiceBitsW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_SCSetServiceBitsW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_SCSetServiceBitsW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_SCSETSERVICEBITSW, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_SCSetServiceBitsW_r_done, req);

	return req;
}

static void dcerpc_svcctl_SCSetServiceBitsW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_SCSetServiceBitsW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_SCSetServiceBitsW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_SCSetServiceBitsW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_SCSETSERVICEBITSW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_SCSetServiceBitsW_state {
	struct svcctl_SCSetServiceBitsW orig;
	struct svcctl_SCSetServiceBitsW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_SCSetServiceBitsW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_SCSetServiceBitsW_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in] [ref] */,
							uint32_t _bits /* [in]  */,
							uint32_t _bitson /* [in]  */,
							uint32_t _immediate /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_SCSetServiceBitsW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_SCSetServiceBitsW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.bits = _bits;
	state->orig.in.bitson = _bitson;
	state->orig.in.immediate = _immediate;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_SCSetServiceBitsW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_SCSetServiceBitsW_done, req);
	return req;
}

static void dcerpc_svcctl_SCSetServiceBitsW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_SCSetServiceBitsW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_SCSetServiceBitsW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_SCSetServiceBitsW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsW_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_svcctl_SCSetServiceBitsW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_SCSetServiceBitsW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsW(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in] [ref] */,
					 uint32_t _bits /* [in]  */,
					 uint32_t _bitson /* [in]  */,
					 uint32_t _immediate /* [in]  */,
					 WERROR *result)
{
	struct svcctl_SCSetServiceBitsW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.bits = _bits;
	r.in.bitson = _bitson;
	r.in.immediate = _immediate;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_SCSetServiceBitsW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_ChangeServiceConfigW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfigW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfigW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_ChangeServiceConfigW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfigW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfigW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIGW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfigW_r_done, req);

	return req;
}

static void dcerpc_svcctl_ChangeServiceConfigW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_ChangeServiceConfigW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_ChangeServiceConfigW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_ChangeServiceConfigW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIGW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_ChangeServiceConfigW_state {
	struct svcctl_ChangeServiceConfigW orig;
	struct svcctl_ChangeServiceConfigW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfigW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfigW_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_handle /* [in] [ref] */,
							   uint32_t _type /* [in]  */,
							   enum svcctl_StartType _start_type /* [in]  */,
							   enum svcctl_ErrorControl _error_control /* [in]  */,
							   const char *_binary_path /* [in] [charset(UTF16),unique] */,
							   const char *_load_order_group /* [in] [charset(UTF16),unique] */,
							   uint32_t *_tag_id /* [in,out] [unique] */,
							   const char *_dependencies /* [in] [charset(UTF16),size_is(dwDependSize),unique] */,
							   uint32_t _dwDependSize /* [in] [range(0,SC_MAX_DEPEND_SIZE)] */,
							   const char *_service_start_name /* [in] [charset(UTF16),range(0,SC_MAX_ACCOUNT_NAME_LENGTH),unique] */,
							   const char *_password /* [in] [charset(UTF16),size_is(dwPwSize),unique] */,
							   uint32_t _dwPwSize /* [in] [range(0,SC_MAX_PWD_SIZE)] */,
							   const char *_display_name /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfigW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfigW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.type = _type;
	state->orig.in.start_type = _start_type;
	state->orig.in.error_control = _error_control;
	state->orig.in.binary_path = _binary_path;
	state->orig.in.load_order_group = _load_order_group;
	state->orig.in.tag_id = _tag_id;
	state->orig.in.dependencies = _dependencies;
	state->orig.in.dwDependSize = _dwDependSize;
	state->orig.in.service_start_name = _service_start_name;
	state->orig.in.password = _password;
	state->orig.in.dwPwSize = _dwPwSize;
	state->orig.in.display_name = _display_name;

	/* Out parameters */
	state->orig.out.tag_id = _tag_id;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_ChangeServiceConfigW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_ChangeServiceConfigW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfigW_done, req);
	return req;
}

static void dcerpc_svcctl_ChangeServiceConfigW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_ChangeServiceConfigW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfigW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_ChangeServiceConfigW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.tag_id && state->tmp.out.tag_id) {
		*state->orig.out.tag_id = *state->tmp.out.tag_id;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigW_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_svcctl_ChangeServiceConfigW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfigW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigW(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_handle /* [in] [ref] */,
					    uint32_t _type /* [in]  */,
					    enum svcctl_StartType _start_type /* [in]  */,
					    enum svcctl_ErrorControl _error_control /* [in]  */,
					    const char *_binary_path /* [in] [charset(UTF16),unique] */,
					    const char *_load_order_group /* [in] [charset(UTF16),unique] */,
					    uint32_t *_tag_id /* [in,out] [unique] */,
					    const char *_dependencies /* [in] [charset(UTF16),size_is(dwDependSize),unique] */,
					    uint32_t _dwDependSize /* [in] [range(0,SC_MAX_DEPEND_SIZE)] */,
					    const char *_service_start_name /* [in] [charset(UTF16),range(0,SC_MAX_ACCOUNT_NAME_LENGTH),unique] */,
					    const char *_password /* [in] [charset(UTF16),size_is(dwPwSize),unique] */,
					    uint32_t _dwPwSize /* [in] [range(0,SC_MAX_PWD_SIZE)] */,
					    const char *_display_name /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */,
					    WERROR *result)
{
	struct svcctl_ChangeServiceConfigW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.type = _type;
	r.in.start_type = _start_type;
	r.in.error_control = _error_control;
	r.in.binary_path = _binary_path;
	r.in.load_order_group = _load_order_group;
	r.in.tag_id = _tag_id;
	r.in.dependencies = _dependencies;
	r.in.dwDependSize = _dwDependSize;
	r.in.service_start_name = _service_start_name;
	r.in.password = _password;
	r.in.dwPwSize = _dwPwSize;
	r.in.display_name = _display_name;

	/* Out parameters */
	r.out.tag_id = _tag_id;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_ChangeServiceConfigW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_tag_id && r.out.tag_id) {
		*_tag_id = *r.out.tag_id;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_CreateServiceW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateServiceW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateServiceW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_CreateServiceW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateServiceW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateServiceW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATESERVICEW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateServiceW_r_done, req);

	return req;
}

static void dcerpc_svcctl_CreateServiceW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateServiceW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_CreateServiceW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_CreateServiceW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateServiceW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_CreateServiceW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATESERVICEW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_CreateServiceW_state {
	struct svcctl_CreateServiceW orig;
	struct svcctl_CreateServiceW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateServiceW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateServiceW_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_scmanager_handle /* [in] [ref] */,
						     const char *_ServiceName /* [in] [charset(UTF16)] */,
						     const char *_DisplayName /* [in] [charset(UTF16),unique] */,
						     uint32_t _desired_access /* [in]  */,
						     uint32_t _type /* [in]  */,
						     enum svcctl_StartType _start_type /* [in]  */,
						     enum svcctl_ErrorControl _error_control /* [in]  */,
						     const char *_binary_path /* [in] [charset(UTF16)] */,
						     const char *_LoadOrderGroupKey /* [in] [charset(UTF16),unique] */,
						     uint32_t *_TagId /* [in,out] [unique] */,
						     uint8_t *_dependencies /* [in] [size_is(dependencies_size),unique] */,
						     uint32_t _dependencies_size /* [in]  */,
						     const char *_service_start_name /* [in] [charset(UTF16),unique] */,
						     uint8_t *_password /* [in] [size_is(password_size),unique] */,
						     uint32_t _password_size /* [in]  */,
						     struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateServiceW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateServiceW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.scmanager_handle = _scmanager_handle;
	state->orig.in.ServiceName = _ServiceName;
	state->orig.in.DisplayName = _DisplayName;
	state->orig.in.desired_access = _desired_access;
	state->orig.in.type = _type;
	state->orig.in.start_type = _start_type;
	state->orig.in.error_control = _error_control;
	state->orig.in.binary_path = _binary_path;
	state->orig.in.LoadOrderGroupKey = _LoadOrderGroupKey;
	state->orig.in.TagId = _TagId;
	state->orig.in.dependencies = _dependencies;
	state->orig.in.dependencies_size = _dependencies_size;
	state->orig.in.service_start_name = _service_start_name;
	state->orig.in.password = _password;
	state->orig.in.password_size = _password_size;

	/* Out parameters */
	state->orig.out.TagId = _TagId;
	state->orig.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_CreateServiceW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_CreateServiceW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateServiceW_done, req);
	return req;
}

static void dcerpc_svcctl_CreateServiceW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_CreateServiceW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateServiceW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_CreateServiceW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.TagId && state->tmp.out.TagId) {
		*state->orig.out.TagId = *state->tmp.out.TagId;
	}
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateServiceW_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_svcctl_CreateServiceW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateServiceW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateServiceW(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_scmanager_handle /* [in] [ref] */,
				      const char *_ServiceName /* [in] [charset(UTF16)] */,
				      const char *_DisplayName /* [in] [charset(UTF16),unique] */,
				      uint32_t _desired_access /* [in]  */,
				      uint32_t _type /* [in]  */,
				      enum svcctl_StartType _start_type /* [in]  */,
				      enum svcctl_ErrorControl _error_control /* [in]  */,
				      const char *_binary_path /* [in] [charset(UTF16)] */,
				      const char *_LoadOrderGroupKey /* [in] [charset(UTF16),unique] */,
				      uint32_t *_TagId /* [in,out] [unique] */,
				      uint8_t *_dependencies /* [in] [size_is(dependencies_size),unique] */,
				      uint32_t _dependencies_size /* [in]  */,
				      const char *_service_start_name /* [in] [charset(UTF16),unique] */,
				      uint8_t *_password /* [in] [size_is(password_size),unique] */,
				      uint32_t _password_size /* [in]  */,
				      struct policy_handle *_handle /* [out] [ref] */,
				      WERROR *result)
{
	struct svcctl_CreateServiceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager_handle = _scmanager_handle;
	r.in.ServiceName = _ServiceName;
	r.in.DisplayName = _DisplayName;
	r.in.desired_access = _desired_access;
	r.in.type = _type;
	r.in.start_type = _start_type;
	r.in.error_control = _error_control;
	r.in.binary_path = _binary_path;
	r.in.LoadOrderGroupKey = _LoadOrderGroupKey;
	r.in.TagId = _TagId;
	r.in.dependencies = _dependencies;
	r.in.dependencies_size = _dependencies_size;
	r.in.service_start_name = _service_start_name;
	r.in.password = _password;
	r.in.password_size = _password_size;

	/* Out parameters */
	r.out.TagId = _TagId;
	r.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_CreateServiceW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_TagId && r.out.TagId) {
		*_TagId = *r.out.TagId;
	}
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_EnumDependentServicesW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumDependentServicesW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumDependentServicesW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_EnumDependentServicesW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumDependentServicesW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumDependentServicesW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMDEPENDENTSERVICESW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumDependentServicesW_r_done, req);

	return req;
}

static void dcerpc_svcctl_EnumDependentServicesW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_EnumDependentServicesW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_EnumDependentServicesW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_EnumDependentServicesW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMDEPENDENTSERVICESW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_EnumDependentServicesW_state {
	struct svcctl_EnumDependentServicesW orig;
	struct svcctl_EnumDependentServicesW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumDependentServicesW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumDependentServicesW_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle *_service /* [in] [ref] */,
							     enum svcctl_ServiceState _state /* [in]  */,
							     uint8_t *_service_status /* [out] [ref,size_is(offered)] */,
							     uint32_t _offered /* [in] [range(0,0x40000)] */,
							     uint32_t *_needed /* [out] [range(0,0x40000),ref] */,
							     uint32_t *_services_returned /* [out] [range(0,0x40000),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumDependentServicesW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumDependentServicesW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.service = _service;
	state->orig.in.state = _state;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.service_status = _service_status;
	state->orig.out.needed = _needed;
	state->orig.out.services_returned = _services_returned;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_EnumDependentServicesW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_EnumDependentServicesW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumDependentServicesW_done, req);
	return req;
}

static void dcerpc_svcctl_EnumDependentServicesW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_EnumDependentServicesW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumDependentServicesW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_EnumDependentServicesW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_service_status;
		_copy_len_service_status = state->tmp.in.offered;
		if (state->orig.out.service_status != state->tmp.out.service_status) {
			memcpy(state->orig.out.service_status, state->tmp.out.service_status, _copy_len_service_status * sizeof(*state->orig.out.service_status));
		}
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.services_returned = *state->tmp.out.services_returned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesW_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_svcctl_EnumDependentServicesW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumDependentServicesW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesW(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *_service /* [in] [ref] */,
					      enum svcctl_ServiceState _state /* [in]  */,
					      uint8_t *_service_status /* [out] [ref,size_is(offered)] */,
					      uint32_t _offered /* [in] [range(0,0x40000)] */,
					      uint32_t *_needed /* [out] [range(0,0x40000),ref] */,
					      uint32_t *_services_returned /* [out] [range(0,0x40000),ref] */,
					      WERROR *result)
{
	struct svcctl_EnumDependentServicesW r;
	NTSTATUS status;

	/* In parameters */
	r.in.service = _service;
	r.in.state = _state;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.service_status = _service_status;
	r.out.needed = _needed;
	r.out.services_returned = _services_returned;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_EnumDependentServicesW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_service_status;
		_copy_len_service_status = r.in.offered;
		if (_service_status != r.out.service_status) {
			memcpy(_service_status, r.out.service_status, _copy_len_service_status * sizeof(*_service_status));
		}
	}
	*_needed = *r.out.needed;
	*_services_returned = *r.out.services_returned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_EnumServicesStatusW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumServicesStatusW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumServicesStatusW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_EnumServicesStatusW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumServicesStatusW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumServicesStatusW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMSERVICESSTATUSW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumServicesStatusW_r_done, req);

	return req;
}

static void dcerpc_svcctl_EnumServicesStatusW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_EnumServicesStatusW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_EnumServicesStatusW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_EnumServicesStatusW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMSERVICESSTATUSW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_EnumServicesStatusW_state {
	struct svcctl_EnumServicesStatusW orig;
	struct svcctl_EnumServicesStatusW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumServicesStatusW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumServicesStatusW_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint32_t _type /* [in]  */,
							  enum svcctl_ServiceState _state /* [in]  */,
							  uint8_t *_service /* [out] [ref,size_is(offered)] */,
							  uint32_t _offered /* [in] [range(0,0x40000)] */,
							  uint32_t *_needed /* [out] [range(0,0x40000),ref] */,
							  uint32_t *_services_returned /* [out] [range(0,0x40000),ref] */,
							  uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumServicesStatusW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumServicesStatusW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.type = _type;
	state->orig.in.state = _state;
	state->orig.in.offered = _offered;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.service = _service;
	state->orig.out.needed = _needed;
	state->orig.out.services_returned = _services_returned;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_EnumServicesStatusW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_EnumServicesStatusW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumServicesStatusW_done, req);
	return req;
}

static void dcerpc_svcctl_EnumServicesStatusW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_EnumServicesStatusW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumServicesStatusW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_EnumServicesStatusW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_service;
		_copy_len_service = state->tmp.in.offered;
		if (state->orig.out.service != state->tmp.out.service) {
			memcpy(state->orig.out.service, state->tmp.out.service, _copy_len_service * sizeof(*state->orig.out.service));
		}
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.services_returned = *state->tmp.out.services_returned;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusW_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_svcctl_EnumServicesStatusW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumServicesStatusW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusW(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   uint32_t _type /* [in]  */,
					   enum svcctl_ServiceState _state /* [in]  */,
					   uint8_t *_service /* [out] [ref,size_is(offered)] */,
					   uint32_t _offered /* [in] [range(0,0x40000)] */,
					   uint32_t *_needed /* [out] [range(0,0x40000),ref] */,
					   uint32_t *_services_returned /* [out] [range(0,0x40000),ref] */,
					   uint32_t *_resume_handle /* [in,out] [unique] */,
					   WERROR *result)
{
	struct svcctl_EnumServicesStatusW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.type = _type;
	r.in.state = _state;
	r.in.offered = _offered;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.service = _service;
	r.out.needed = _needed;
	r.out.services_returned = _services_returned;
	r.out.resume_handle = _resume_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_EnumServicesStatusW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_service;
		_copy_len_service = r.in.offered;
		if (_service != r.out.service) {
			memcpy(_service, r.out.service, _copy_len_service * sizeof(*_service));
		}
	}
	*_needed = *r.out.needed;
	*_services_returned = *r.out.services_returned;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_OpenSCManagerW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenSCManagerW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenSCManagerW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_OpenSCManagerW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenSCManagerW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenSCManagerW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSCMANAGERW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenSCManagerW_r_done, req);

	return req;
}

static void dcerpc_svcctl_OpenSCManagerW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenSCManagerW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_OpenSCManagerW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_OpenSCManagerW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenSCManagerW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_OpenSCManagerW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSCMANAGERW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_OpenSCManagerW_state {
	struct svcctl_OpenSCManagerW orig;
	struct svcctl_OpenSCManagerW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenSCManagerW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenSCManagerW_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_MachineName /* [in] [charset(UTF16),unique] */,
						     const char *_DatabaseName /* [in] [charset(UTF16),unique] */,
						     uint32_t _access_mask /* [in]  */,
						     struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenSCManagerW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenSCManagerW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.MachineName = _MachineName;
	state->orig.in.DatabaseName = _DatabaseName;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_OpenSCManagerW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_OpenSCManagerW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenSCManagerW_done, req);
	return req;
}

static void dcerpc_svcctl_OpenSCManagerW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_OpenSCManagerW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenSCManagerW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_OpenSCManagerW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenSCManagerW_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_svcctl_OpenSCManagerW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenSCManagerW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenSCManagerW(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_MachineName /* [in] [charset(UTF16),unique] */,
				      const char *_DatabaseName /* [in] [charset(UTF16),unique] */,
				      uint32_t _access_mask /* [in]  */,
				      struct policy_handle *_handle /* [out] [ref] */,
				      WERROR *result)
{
	struct svcctl_OpenSCManagerW r;
	NTSTATUS status;

	/* In parameters */
	r.in.MachineName = _MachineName;
	r.in.DatabaseName = _DatabaseName;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_OpenSCManagerW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_OpenServiceW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenServiceW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenServiceW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_OpenServiceW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenServiceW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenServiceW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSERVICEW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenServiceW_r_done, req);

	return req;
}

static void dcerpc_svcctl_OpenServiceW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenServiceW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_OpenServiceW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_OpenServiceW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenServiceW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_OpenServiceW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSERVICEW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_OpenServiceW_state {
	struct svcctl_OpenServiceW orig;
	struct svcctl_OpenServiceW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenServiceW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenServiceW_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_scmanager_handle /* [in] [ref] */,
						   const char *_ServiceName /* [in] [charset(UTF16)] */,
						   uint32_t _access_mask /* [in]  */,
						   struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenServiceW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenServiceW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.scmanager_handle = _scmanager_handle;
	state->orig.in.ServiceName = _ServiceName;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_OpenServiceW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_OpenServiceW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenServiceW_done, req);
	return req;
}

static void dcerpc_svcctl_OpenServiceW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_OpenServiceW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenServiceW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_OpenServiceW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenServiceW_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_svcctl_OpenServiceW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenServiceW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenServiceW(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_scmanager_handle /* [in] [ref] */,
				    const char *_ServiceName /* [in] [charset(UTF16)] */,
				    uint32_t _access_mask /* [in]  */,
				    struct policy_handle *_handle /* [out] [ref] */,
				    WERROR *result)
{
	struct svcctl_OpenServiceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager_handle = _scmanager_handle;
	r.in.ServiceName = _ServiceName;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_OpenServiceW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceConfigW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfigW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfigW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceConfigW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfigW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfigW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIGW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfigW_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceConfigW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceConfigW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceConfigW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceConfigW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIGW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceConfigW_state {
	struct svcctl_QueryServiceConfigW orig;
	struct svcctl_QueryServiceConfigW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfigW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfigW_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  struct QUERY_SERVICE_CONFIG *_query /* [out] [ref] */,
							  uint32_t _offered /* [in] [range(0,8192)] */,
							  uint32_t *_needed /* [out] [range(0,8192),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfigW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfigW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.query = _query;
	state->orig.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceConfigW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceConfigW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfigW_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceConfigW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceConfigW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfigW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceConfigW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.query = *state->tmp.out.query;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigW_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceConfigW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfigW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigW(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   struct QUERY_SERVICE_CONFIG *_query /* [out] [ref] */,
					   uint32_t _offered /* [in] [range(0,8192)] */,
					   uint32_t *_needed /* [out] [range(0,8192),ref] */,
					   WERROR *result)
{
	struct svcctl_QueryServiceConfigW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.query = _query;
	r.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceConfigW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_query = *r.out.query;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceLockStatusW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceLockStatusW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceLockStatusW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceLockStatusW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceLockStatusW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceLockStatusW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICELOCKSTATUSW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceLockStatusW_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceLockStatusW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceLockStatusW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceLockStatusW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceLockStatusW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICELOCKSTATUSW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceLockStatusW_state {
	struct svcctl_QueryServiceLockStatusW orig;
	struct svcctl_QueryServiceLockStatusW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceLockStatusW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceLockStatusW_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle *_handle /* [in] [ref] */,
							      uint32_t _offered /* [in]  */,
							      struct SERVICE_LOCK_STATUS *_lock_status /* [out] [ref] */,
							      uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceLockStatusW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceLockStatusW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.lock_status = _lock_status;
	state->orig.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceLockStatusW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceLockStatusW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceLockStatusW_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceLockStatusW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceLockStatusW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceLockStatusW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceLockStatusW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lock_status = *state->tmp.out.lock_status;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusW_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceLockStatusW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceLockStatusW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusW(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *_handle /* [in] [ref] */,
					       uint32_t _offered /* [in]  */,
					       struct SERVICE_LOCK_STATUS *_lock_status /* [out] [ref] */,
					       uint32_t *_needed /* [out] [ref] */,
					       WERROR *result)
{
	struct svcctl_QueryServiceLockStatusW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.lock_status = _lock_status;
	r.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceLockStatusW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lock_status = *r.out.lock_status;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_StartServiceW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_StartServiceW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_StartServiceW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_StartServiceW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_StartServiceW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_StartServiceW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_STARTSERVICEW, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_StartServiceW_r_done, req);

	return req;
}

static void dcerpc_svcctl_StartServiceW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_StartServiceW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_StartServiceW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_StartServiceW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_StartServiceW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_StartServiceW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_STARTSERVICEW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_StartServiceW_state {
	struct svcctl_StartServiceW orig;
	struct svcctl_StartServiceW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_StartServiceW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_StartServiceW_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in] [ref] */,
						    uint32_t _NumArgs /* [in] [range(0,SC_MAX_ARGUMENTS)] */,
						    struct svcctl_ArgumentString *_Arguments /* [in] [size_is(NumArgs),unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_StartServiceW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_StartServiceW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.NumArgs = _NumArgs;
	state->orig.in.Arguments = _Arguments;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_StartServiceW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_StartServiceW_done, req);
	return req;
}

static void dcerpc_svcctl_StartServiceW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_StartServiceW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_StartServiceW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_StartServiceW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_StartServiceW_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_svcctl_StartServiceW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_StartServiceW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_StartServiceW(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in] [ref] */,
				     uint32_t _NumArgs /* [in] [range(0,SC_MAX_ARGUMENTS)] */,
				     struct svcctl_ArgumentString *_Arguments /* [in] [size_is(NumArgs),unique] */,
				     WERROR *result)
{
	struct svcctl_StartServiceW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.NumArgs = _NumArgs;
	r.in.Arguments = _Arguments;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_StartServiceW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_GetServiceDisplayNameW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceDisplayNameW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceDisplayNameW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_GetServiceDisplayNameW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceDisplayNameW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceDisplayNameW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEDISPLAYNAMEW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceDisplayNameW_r_done, req);

	return req;
}

static void dcerpc_svcctl_GetServiceDisplayNameW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_GetServiceDisplayNameW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_GetServiceDisplayNameW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_GetServiceDisplayNameW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEDISPLAYNAMEW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_GetServiceDisplayNameW_state {
	struct svcctl_GetServiceDisplayNameW orig;
	struct svcctl_GetServiceDisplayNameW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceDisplayNameW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceDisplayNameW_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle *_handle /* [in] [ref] */,
							     const char *_service_name /* [in] [charset(UTF16),unique] */,
							     const char **_display_name /* [out] [charset(UTF16),ref] */,
							     uint32_t *_display_name_length /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceDisplayNameW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceDisplayNameW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.service_name = _service_name;
	state->orig.in.display_name_length = _display_name_length;

	/* Out parameters */
	state->orig.out.display_name = _display_name;
	state->orig.out.display_name_length = _display_name_length;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_GetServiceDisplayNameW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_GetServiceDisplayNameW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceDisplayNameW_done, req);
	return req;
}

static void dcerpc_svcctl_GetServiceDisplayNameW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_GetServiceDisplayNameW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceDisplayNameW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_GetServiceDisplayNameW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.display_name = *state->tmp.out.display_name;
	if (state->orig.out.display_name_length && state->tmp.out.display_name_length) {
		*state->orig.out.display_name_length = *state->tmp.out.display_name_length;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameW_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_svcctl_GetServiceDisplayNameW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceDisplayNameW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameW(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *_handle /* [in] [ref] */,
					      const char *_service_name /* [in] [charset(UTF16),unique] */,
					      const char **_display_name /* [out] [charset(UTF16),ref] */,
					      uint32_t *_display_name_length /* [in,out] [unique] */,
					      WERROR *result)
{
	struct svcctl_GetServiceDisplayNameW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.service_name = _service_name;
	r.in.display_name_length = _display_name_length;

	/* Out parameters */
	r.out.display_name = _display_name;
	r.out.display_name_length = _display_name_length;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_GetServiceDisplayNameW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_display_name = *r.out.display_name;
	if (_display_name_length && r.out.display_name_length) {
		*_display_name_length = *r.out.display_name_length;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_GetServiceKeyNameW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceKeyNameW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceKeyNameW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_GetServiceKeyNameW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceKeyNameW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceKeyNameW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEKEYNAMEW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceKeyNameW_r_done, req);

	return req;
}

static void dcerpc_svcctl_GetServiceKeyNameW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_GetServiceKeyNameW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_GetServiceKeyNameW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_GetServiceKeyNameW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEKEYNAMEW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_GetServiceKeyNameW_state {
	struct svcctl_GetServiceKeyNameW orig;
	struct svcctl_GetServiceKeyNameW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceKeyNameW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceKeyNameW_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_handle /* [in] [ref] */,
							 const char *_service_name /* [in] [charset(UTF16),unique] */,
							 const char **_key_name /* [out] [charset(UTF16),ref] */,
							 uint32_t *_display_name_length /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceKeyNameW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceKeyNameW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.service_name = _service_name;
	state->orig.in.display_name_length = _display_name_length;

	/* Out parameters */
	state->orig.out.key_name = _key_name;
	state->orig.out.display_name_length = _display_name_length;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_GetServiceKeyNameW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_GetServiceKeyNameW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceKeyNameW_done, req);
	return req;
}

static void dcerpc_svcctl_GetServiceKeyNameW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_GetServiceKeyNameW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceKeyNameW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_GetServiceKeyNameW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.key_name = *state->tmp.out.key_name;
	if (state->orig.out.display_name_length && state->tmp.out.display_name_length) {
		*state->orig.out.display_name_length = *state->tmp.out.display_name_length;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameW_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_svcctl_GetServiceKeyNameW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceKeyNameW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameW(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_handle /* [in] [ref] */,
					  const char *_service_name /* [in] [charset(UTF16),unique] */,
					  const char **_key_name /* [out] [charset(UTF16),ref] */,
					  uint32_t *_display_name_length /* [in,out] [unique] */,
					  WERROR *result)
{
	struct svcctl_GetServiceKeyNameW r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.service_name = _service_name;
	r.in.display_name_length = _display_name_length;

	/* Out parameters */
	r.out.key_name = _key_name;
	r.out.display_name_length = _display_name_length;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_GetServiceKeyNameW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_key_name = *r.out.key_name;
	if (_display_name_length && r.out.display_name_length) {
		*_display_name_length = *r.out.display_name_length;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_SCSetServiceBitsA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_SCSetServiceBitsA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_SCSetServiceBitsA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_SCSetServiceBitsA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_SCSetServiceBitsA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_SCSetServiceBitsA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_SCSETSERVICEBITSA, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_SCSetServiceBitsA_r_done, req);

	return req;
}

static void dcerpc_svcctl_SCSetServiceBitsA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_SCSetServiceBitsA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_SCSetServiceBitsA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_SCSetServiceBitsA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_SCSETSERVICEBITSA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_SCSetServiceBitsA_state {
	struct svcctl_SCSetServiceBitsA orig;
	struct svcctl_SCSetServiceBitsA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_SCSetServiceBitsA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_SCSetServiceBitsA_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_handle /* [in] [ref] */,
							uint32_t _bits /* [in]  */,
							uint32_t _bitson /* [in]  */,
							uint32_t _immediate /* [in]  */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_SCSetServiceBitsA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_SCSetServiceBitsA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.bits = _bits;
	state->orig.in.bitson = _bitson;
	state->orig.in.immediate = _immediate;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_SCSetServiceBitsA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_SCSetServiceBitsA_done, req);
	return req;
}

static void dcerpc_svcctl_SCSetServiceBitsA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_SCSetServiceBitsA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_SCSetServiceBitsA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_SCSetServiceBitsA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsA_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_svcctl_SCSetServiceBitsA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_SCSetServiceBitsA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_SCSetServiceBitsA(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_handle /* [in] [ref] */,
					 uint32_t _bits /* [in]  */,
					 uint32_t _bitson /* [in]  */,
					 uint32_t _immediate /* [in]  */,
					 WERROR *result)
{
	struct svcctl_SCSetServiceBitsA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.bits = _bits;
	r.in.bitson = _bitson;
	r.in.immediate = _immediate;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_SCSetServiceBitsA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_ChangeServiceConfigA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfigA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfigA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_ChangeServiceConfigA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfigA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfigA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIGA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfigA_r_done, req);

	return req;
}

static void dcerpc_svcctl_ChangeServiceConfigA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_ChangeServiceConfigA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_ChangeServiceConfigA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_ChangeServiceConfigA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIGA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_ChangeServiceConfigA_state {
	struct svcctl_ChangeServiceConfigA orig;
	struct svcctl_ChangeServiceConfigA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfigA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfigA_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_handle /* [in] [ref] */,
							   uint32_t _type /* [in]  */,
							   enum svcctl_StartType _start_type /* [in]  */,
							   enum svcctl_ErrorControl _error_control /* [in]  */,
							   const char *_binary_path /* [in] [charset(UTF16),unique] */,
							   const char *_load_order_group /* [in] [charset(UTF16),unique] */,
							   uint32_t *_tag_id /* [out] [ref] */,
							   const char *_dependencies /* [in] [charset(UTF16),unique] */,
							   const char *_service_start_name /* [in] [charset(UTF16),unique] */,
							   const char *_password /* [in] [charset(UTF16),unique] */,
							   const char *_display_name /* [in] [charset(UTF16),unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfigA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfigA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.type = _type;
	state->orig.in.start_type = _start_type;
	state->orig.in.error_control = _error_control;
	state->orig.in.binary_path = _binary_path;
	state->orig.in.load_order_group = _load_order_group;
	state->orig.in.dependencies = _dependencies;
	state->orig.in.service_start_name = _service_start_name;
	state->orig.in.password = _password;
	state->orig.in.display_name = _display_name;

	/* Out parameters */
	state->orig.out.tag_id = _tag_id;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_ChangeServiceConfigA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_ChangeServiceConfigA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfigA_done, req);
	return req;
}

static void dcerpc_svcctl_ChangeServiceConfigA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_ChangeServiceConfigA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfigA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_ChangeServiceConfigA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.tag_id = *state->tmp.out.tag_id;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigA_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_svcctl_ChangeServiceConfigA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfigA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfigA(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_handle /* [in] [ref] */,
					    uint32_t _type /* [in]  */,
					    enum svcctl_StartType _start_type /* [in]  */,
					    enum svcctl_ErrorControl _error_control /* [in]  */,
					    const char *_binary_path /* [in] [charset(UTF16),unique] */,
					    const char *_load_order_group /* [in] [charset(UTF16),unique] */,
					    uint32_t *_tag_id /* [out] [ref] */,
					    const char *_dependencies /* [in] [charset(UTF16),unique] */,
					    const char *_service_start_name /* [in] [charset(UTF16),unique] */,
					    const char *_password /* [in] [charset(UTF16),unique] */,
					    const char *_display_name /* [in] [charset(UTF16),unique] */,
					    WERROR *result)
{
	struct svcctl_ChangeServiceConfigA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.type = _type;
	r.in.start_type = _start_type;
	r.in.error_control = _error_control;
	r.in.binary_path = _binary_path;
	r.in.load_order_group = _load_order_group;
	r.in.dependencies = _dependencies;
	r.in.service_start_name = _service_start_name;
	r.in.password = _password;
	r.in.display_name = _display_name;

	/* Out parameters */
	r.out.tag_id = _tag_id;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_ChangeServiceConfigA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_tag_id = *r.out.tag_id;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_CreateServiceA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateServiceA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateServiceA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_CreateServiceA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateServiceA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateServiceA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATESERVICEA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateServiceA_r_done, req);

	return req;
}

static void dcerpc_svcctl_CreateServiceA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateServiceA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_CreateServiceA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_CreateServiceA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateServiceA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_CreateServiceA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATESERVICEA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_CreateServiceA_state {
	struct svcctl_CreateServiceA orig;
	struct svcctl_CreateServiceA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateServiceA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateServiceA_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle *_handle /* [in] [ref] */,
						     const char *_ServiceName /* [in] [charset(UTF16),unique] */,
						     const char *_DisplayName /* [in] [charset(UTF16),unique] */,
						     uint32_t _desired_access /* [in]  */,
						     uint32_t _type /* [in]  */,
						     enum svcctl_StartType _start_type /* [in]  */,
						     enum svcctl_ErrorControl _error_control /* [in]  */,
						     const char *_binary_path /* [in] [charset(UTF16),unique] */,
						     const char *_LoadOrderGroupKey /* [in] [charset(UTF16),unique] */,
						     uint32_t *_TagId /* [out] [unique] */,
						     const char *_dependencies /* [in] [charset(UTF16),unique] */,
						     const char *_service_start_name /* [in] [charset(UTF16),unique] */,
						     const char *_password /* [in] [charset(UTF16),unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateServiceA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateServiceA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.ServiceName = _ServiceName;
	state->orig.in.DisplayName = _DisplayName;
	state->orig.in.desired_access = _desired_access;
	state->orig.in.type = _type;
	state->orig.in.start_type = _start_type;
	state->orig.in.error_control = _error_control;
	state->orig.in.binary_path = _binary_path;
	state->orig.in.LoadOrderGroupKey = _LoadOrderGroupKey;
	state->orig.in.dependencies = _dependencies;
	state->orig.in.service_start_name = _service_start_name;
	state->orig.in.password = _password;

	/* Out parameters */
	state->orig.out.TagId = _TagId;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_CreateServiceA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_CreateServiceA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateServiceA_done, req);
	return req;
}

static void dcerpc_svcctl_CreateServiceA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_CreateServiceA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateServiceA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_CreateServiceA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.TagId && state->tmp.out.TagId) {
		*state->orig.out.TagId = *state->tmp.out.TagId;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateServiceA_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_svcctl_CreateServiceA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateServiceA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateServiceA(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle *_handle /* [in] [ref] */,
				      const char *_ServiceName /* [in] [charset(UTF16),unique] */,
				      const char *_DisplayName /* [in] [charset(UTF16),unique] */,
				      uint32_t _desired_access /* [in]  */,
				      uint32_t _type /* [in]  */,
				      enum svcctl_StartType _start_type /* [in]  */,
				      enum svcctl_ErrorControl _error_control /* [in]  */,
				      const char *_binary_path /* [in] [charset(UTF16),unique] */,
				      const char *_LoadOrderGroupKey /* [in] [charset(UTF16),unique] */,
				      uint32_t *_TagId /* [out] [unique] */,
				      const char *_dependencies /* [in] [charset(UTF16),unique] */,
				      const char *_service_start_name /* [in] [charset(UTF16),unique] */,
				      const char *_password /* [in] [charset(UTF16),unique] */,
				      WERROR *result)
{
	struct svcctl_CreateServiceA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.ServiceName = _ServiceName;
	r.in.DisplayName = _DisplayName;
	r.in.desired_access = _desired_access;
	r.in.type = _type;
	r.in.start_type = _start_type;
	r.in.error_control = _error_control;
	r.in.binary_path = _binary_path;
	r.in.LoadOrderGroupKey = _LoadOrderGroupKey;
	r.in.dependencies = _dependencies;
	r.in.service_start_name = _service_start_name;
	r.in.password = _password;

	/* Out parameters */
	r.out.TagId = _TagId;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_CreateServiceA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_TagId && r.out.TagId) {
		*_TagId = *r.out.TagId;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_EnumDependentServicesA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumDependentServicesA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumDependentServicesA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_EnumDependentServicesA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumDependentServicesA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumDependentServicesA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMDEPENDENTSERVICESA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumDependentServicesA_r_done, req);

	return req;
}

static void dcerpc_svcctl_EnumDependentServicesA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_EnumDependentServicesA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_EnumDependentServicesA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_EnumDependentServicesA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMDEPENDENTSERVICESA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_EnumDependentServicesA_state {
	struct svcctl_EnumDependentServicesA orig;
	struct svcctl_EnumDependentServicesA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumDependentServicesA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumDependentServicesA_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle *_service /* [in] [ref] */,
							     enum svcctl_ServiceState _state /* [in]  */,
							     struct ENUM_SERVICE_STATUSA *_service_status /* [out] [unique] */,
							     uint32_t _offered /* [in]  */,
							     uint32_t *_needed /* [out] [ref] */,
							     uint32_t *_services_returned /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumDependentServicesA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumDependentServicesA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.service = _service;
	state->orig.in.state = _state;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.service_status = _service_status;
	state->orig.out.needed = _needed;
	state->orig.out.services_returned = _services_returned;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_EnumDependentServicesA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_EnumDependentServicesA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumDependentServicesA_done, req);
	return req;
}

static void dcerpc_svcctl_EnumDependentServicesA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_EnumDependentServicesA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumDependentServicesA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_EnumDependentServicesA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.service_status && state->tmp.out.service_status) {
		*state->orig.out.service_status = *state->tmp.out.service_status;
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.services_returned = *state->tmp.out.services_returned;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesA_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_svcctl_EnumDependentServicesA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumDependentServicesA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumDependentServicesA(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *_service /* [in] [ref] */,
					      enum svcctl_ServiceState _state /* [in]  */,
					      struct ENUM_SERVICE_STATUSA *_service_status /* [out] [unique] */,
					      uint32_t _offered /* [in]  */,
					      uint32_t *_needed /* [out] [ref] */,
					      uint32_t *_services_returned /* [out] [ref] */,
					      WERROR *result)
{
	struct svcctl_EnumDependentServicesA r;
	NTSTATUS status;

	/* In parameters */
	r.in.service = _service;
	r.in.state = _state;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.service_status = _service_status;
	r.out.needed = _needed;
	r.out.services_returned = _services_returned;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_EnumDependentServicesA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_service_status && r.out.service_status) {
		*_service_status = *r.out.service_status;
	}
	*_needed = *r.out.needed;
	*_services_returned = *r.out.services_returned;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_EnumServicesStatusA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumServicesStatusA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumServicesStatusA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_EnumServicesStatusA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumServicesStatusA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumServicesStatusA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMSERVICESSTATUSA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumServicesStatusA_r_done, req);

	return req;
}

static void dcerpc_svcctl_EnumServicesStatusA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_EnumServicesStatusA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_EnumServicesStatusA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_EnumServicesStatusA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMSERVICESSTATUSA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_EnumServicesStatusA_state {
	struct svcctl_EnumServicesStatusA orig;
	struct svcctl_EnumServicesStatusA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumServicesStatusA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumServicesStatusA_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint32_t _type /* [in]  */,
							  enum svcctl_ServiceState _state /* [in]  */,
							  uint32_t _offered /* [in]  */,
							  uint8_t *_service /* [out] [size_is(offered)] */,
							  uint32_t *_needed /* [out] [ref] */,
							  uint32_t *_services_returned /* [out] [ref] */,
							  uint32_t *_resume_handle /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumServicesStatusA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumServicesStatusA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.type = _type;
	state->orig.in.state = _state;
	state->orig.in.offered = _offered;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.service = _service;
	state->orig.out.needed = _needed;
	state->orig.out.services_returned = _services_returned;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_EnumServicesStatusA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_EnumServicesStatusA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumServicesStatusA_done, req);
	return req;
}

static void dcerpc_svcctl_EnumServicesStatusA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_EnumServicesStatusA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumServicesStatusA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_EnumServicesStatusA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_service;
		_copy_len_service = state->tmp.in.offered;
		if (state->orig.out.service != state->tmp.out.service) {
			memcpy(state->orig.out.service, state->tmp.out.service, _copy_len_service * sizeof(*state->orig.out.service));
		}
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.services_returned = *state->tmp.out.services_returned;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusA_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_svcctl_EnumServicesStatusA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumServicesStatusA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusA(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   uint32_t _type /* [in]  */,
					   enum svcctl_ServiceState _state /* [in]  */,
					   uint32_t _offered /* [in]  */,
					   uint8_t *_service /* [out] [size_is(offered)] */,
					   uint32_t *_needed /* [out] [ref] */,
					   uint32_t *_services_returned /* [out] [ref] */,
					   uint32_t *_resume_handle /* [in,out] [unique] */,
					   WERROR *result)
{
	struct svcctl_EnumServicesStatusA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.type = _type;
	r.in.state = _state;
	r.in.offered = _offered;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.service = _service;
	r.out.needed = _needed;
	r.out.services_returned = _services_returned;
	r.out.resume_handle = _resume_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_EnumServicesStatusA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_service;
		_copy_len_service = r.in.offered;
		if (_service != r.out.service) {
			memcpy(_service, r.out.service, _copy_len_service * sizeof(*_service));
		}
	}
	*_needed = *r.out.needed;
	*_services_returned = *r.out.services_returned;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_OpenSCManagerA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenSCManagerA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenSCManagerA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_OpenSCManagerA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenSCManagerA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenSCManagerA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSCMANAGERA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenSCManagerA_r_done, req);

	return req;
}

static void dcerpc_svcctl_OpenSCManagerA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenSCManagerA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_OpenSCManagerA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_OpenSCManagerA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenSCManagerA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_OpenSCManagerA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSCMANAGERA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_OpenSCManagerA_state {
	struct svcctl_OpenSCManagerA orig;
	struct svcctl_OpenSCManagerA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenSCManagerA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenSCManagerA_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     const char *_MachineName /* [in] [charset(UTF16),unique] */,
						     const char *_DatabaseName /* [in] [charset(UTF16),unique] */,
						     uint32_t _access_mask /* [in]  */,
						     struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenSCManagerA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenSCManagerA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.MachineName = _MachineName;
	state->orig.in.DatabaseName = _DatabaseName;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_OpenSCManagerA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_OpenSCManagerA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenSCManagerA_done, req);
	return req;
}

static void dcerpc_svcctl_OpenSCManagerA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_OpenSCManagerA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenSCManagerA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_OpenSCManagerA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenSCManagerA_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_svcctl_OpenSCManagerA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenSCManagerA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenSCManagerA(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      const char *_MachineName /* [in] [charset(UTF16),unique] */,
				      const char *_DatabaseName /* [in] [charset(UTF16),unique] */,
				      uint32_t _access_mask /* [in]  */,
				      struct policy_handle *_handle /* [out] [ref] */,
				      WERROR *result)
{
	struct svcctl_OpenSCManagerA r;
	NTSTATUS status;

	/* In parameters */
	r.in.MachineName = _MachineName;
	r.in.DatabaseName = _DatabaseName;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_OpenSCManagerA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_OpenServiceA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenServiceA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenServiceA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_OpenServiceA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenServiceA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenServiceA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSERVICEA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenServiceA_r_done, req);

	return req;
}

static void dcerpc_svcctl_OpenServiceA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenServiceA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_OpenServiceA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_OpenServiceA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenServiceA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_OpenServiceA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSERVICEA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_OpenServiceA_state {
	struct svcctl_OpenServiceA orig;
	struct svcctl_OpenServiceA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenServiceA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenServiceA_send(TALLOC_CTX *mem_ctx,
						   struct tevent_context *ev,
						   struct dcerpc_binding_handle *h,
						   struct policy_handle *_scmanager_handle /* [in] [ref] */,
						   const char *_ServiceName /* [in] [charset(UTF16),unique] */,
						   uint32_t _access_mask /* [in]  */,
						   struct policy_handle *_handle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenServiceA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenServiceA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.scmanager_handle = _scmanager_handle;
	state->orig.in.ServiceName = _ServiceName;
	state->orig.in.access_mask = _access_mask;

	/* Out parameters */
	state->orig.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_OpenServiceA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_OpenServiceA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenServiceA_done, req);
	return req;
}

static void dcerpc_svcctl_OpenServiceA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_OpenServiceA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenServiceA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_OpenServiceA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.handle = *state->tmp.out.handle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenServiceA_recv(struct tevent_req *req,
					 TALLOC_CTX *mem_ctx,
					 WERROR *result)
{
	struct dcerpc_svcctl_OpenServiceA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenServiceA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenServiceA(struct dcerpc_binding_handle *h,
				    TALLOC_CTX *mem_ctx,
				    struct policy_handle *_scmanager_handle /* [in] [ref] */,
				    const char *_ServiceName /* [in] [charset(UTF16),unique] */,
				    uint32_t _access_mask /* [in]  */,
				    struct policy_handle *_handle /* [out] [ref] */,
				    WERROR *result)
{
	struct svcctl_OpenServiceA r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager_handle = _scmanager_handle;
	r.in.ServiceName = _ServiceName;
	r.in.access_mask = _access_mask;

	/* Out parameters */
	r.out.handle = _handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_OpenServiceA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_handle = *r.out.handle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceConfigA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfigA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfigA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceConfigA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfigA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfigA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIGA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfigA_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceConfigA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceConfigA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceConfigA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceConfigA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIGA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceConfigA_state {
	struct svcctl_QueryServiceConfigA orig;
	struct svcctl_QueryServiceConfigA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfigA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfigA_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle *_handle /* [in] [ref] */,
							  uint8_t *_query /* [out]  */,
							  uint32_t _offered /* [in]  */,
							  uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfigA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfigA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.query = _query;
	state->orig.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceConfigA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceConfigA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfigA_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceConfigA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceConfigA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfigA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceConfigA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_query;
		_copy_len_query = state->tmp.in.offered;
		if (state->orig.out.query != state->tmp.out.query) {
			memcpy(state->orig.out.query, state->tmp.out.query, _copy_len_query * sizeof(*state->orig.out.query));
		}
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigA_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceConfigA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfigA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigA(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle *_handle /* [in] [ref] */,
					   uint8_t *_query /* [out]  */,
					   uint32_t _offered /* [in]  */,
					   uint32_t *_needed /* [out] [ref] */,
					   WERROR *result)
{
	struct svcctl_QueryServiceConfigA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.query = _query;
	r.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceConfigA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_query;
		_copy_len_query = r.in.offered;
		if (_query != r.out.query) {
			memcpy(_query, r.out.query, _copy_len_query * sizeof(*_query));
		}
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceLockStatusA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceLockStatusA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceLockStatusA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceLockStatusA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceLockStatusA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceLockStatusA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICELOCKSTATUSA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceLockStatusA_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceLockStatusA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceLockStatusA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceLockStatusA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceLockStatusA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICELOCKSTATUSA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceLockStatusA_state {
	struct svcctl_QueryServiceLockStatusA orig;
	struct svcctl_QueryServiceLockStatusA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceLockStatusA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceLockStatusA_send(TALLOC_CTX *mem_ctx,
							      struct tevent_context *ev,
							      struct dcerpc_binding_handle *h,
							      struct policy_handle *_handle /* [in] [ref] */,
							      uint32_t _offered /* [in]  */,
							      struct SERVICE_LOCK_STATUS *_lock_status /* [out] [ref] */,
							      uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceLockStatusA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceLockStatusA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.lock_status = _lock_status;
	state->orig.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceLockStatusA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceLockStatusA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceLockStatusA_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceLockStatusA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceLockStatusA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceLockStatusA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceLockStatusA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.lock_status = *state->tmp.out.lock_status;
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusA_recv(struct tevent_req *req,
						    TALLOC_CTX *mem_ctx,
						    WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceLockStatusA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceLockStatusA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceLockStatusA(struct dcerpc_binding_handle *h,
					       TALLOC_CTX *mem_ctx,
					       struct policy_handle *_handle /* [in] [ref] */,
					       uint32_t _offered /* [in]  */,
					       struct SERVICE_LOCK_STATUS *_lock_status /* [out] [ref] */,
					       uint32_t *_needed /* [out] [ref] */,
					       WERROR *result)
{
	struct svcctl_QueryServiceLockStatusA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.lock_status = _lock_status;
	r.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceLockStatusA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_lock_status = *r.out.lock_status;
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_StartServiceA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_StartServiceA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_StartServiceA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_StartServiceA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_StartServiceA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_StartServiceA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_STARTSERVICEA, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_StartServiceA_r_done, req);

	return req;
}

static void dcerpc_svcctl_StartServiceA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_StartServiceA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_StartServiceA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_StartServiceA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_StartServiceA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_StartServiceA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_STARTSERVICEA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_StartServiceA_state {
	struct svcctl_StartServiceA orig;
	struct svcctl_StartServiceA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_StartServiceA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_StartServiceA_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h,
						    struct policy_handle *_handle /* [in] [ref] */,
						    uint32_t _NumArgs /* [in]  */,
						    const char *_Arguments /* [in] [charset(UTF16),unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_StartServiceA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_StartServiceA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.NumArgs = _NumArgs;
	state->orig.in.Arguments = _Arguments;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_StartServiceA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_StartServiceA_done, req);
	return req;
}

static void dcerpc_svcctl_StartServiceA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_StartServiceA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_StartServiceA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_StartServiceA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_StartServiceA_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx,
					  WERROR *result)
{
	struct dcerpc_svcctl_StartServiceA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_StartServiceA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_StartServiceA(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx,
				     struct policy_handle *_handle /* [in] [ref] */,
				     uint32_t _NumArgs /* [in]  */,
				     const char *_Arguments /* [in] [charset(UTF16),unique] */,
				     WERROR *result)
{
	struct svcctl_StartServiceA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.NumArgs = _NumArgs;
	r.in.Arguments = _Arguments;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_StartServiceA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_GetServiceDisplayNameA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceDisplayNameA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceDisplayNameA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_GetServiceDisplayNameA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceDisplayNameA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceDisplayNameA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEDISPLAYNAMEA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceDisplayNameA_r_done, req);

	return req;
}

static void dcerpc_svcctl_GetServiceDisplayNameA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_GetServiceDisplayNameA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_GetServiceDisplayNameA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_GetServiceDisplayNameA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEDISPLAYNAMEA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_GetServiceDisplayNameA_state {
	struct svcctl_GetServiceDisplayNameA orig;
	struct svcctl_GetServiceDisplayNameA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceDisplayNameA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceDisplayNameA_send(TALLOC_CTX *mem_ctx,
							     struct tevent_context *ev,
							     struct dcerpc_binding_handle *h,
							     struct policy_handle *_handle /* [in] [ref] */,
							     const char *_service_name /* [in] [charset(UTF16),unique] */,
							     const char **_display_name /* [out] [charset(UTF16),ref] */,
							     uint32_t *_display_name_length /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceDisplayNameA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceDisplayNameA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.service_name = _service_name;
	state->orig.in.display_name_length = _display_name_length;

	/* Out parameters */
	state->orig.out.display_name = _display_name;
	state->orig.out.display_name_length = _display_name_length;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_GetServiceDisplayNameA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_GetServiceDisplayNameA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceDisplayNameA_done, req);
	return req;
}

static void dcerpc_svcctl_GetServiceDisplayNameA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_GetServiceDisplayNameA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceDisplayNameA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_GetServiceDisplayNameA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.display_name = *state->tmp.out.display_name;
	if (state->orig.out.display_name_length && state->tmp.out.display_name_length) {
		*state->orig.out.display_name_length = *state->tmp.out.display_name_length;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameA_recv(struct tevent_req *req,
						   TALLOC_CTX *mem_ctx,
						   WERROR *result)
{
	struct dcerpc_svcctl_GetServiceDisplayNameA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceDisplayNameA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceDisplayNameA(struct dcerpc_binding_handle *h,
					      TALLOC_CTX *mem_ctx,
					      struct policy_handle *_handle /* [in] [ref] */,
					      const char *_service_name /* [in] [charset(UTF16),unique] */,
					      const char **_display_name /* [out] [charset(UTF16),ref] */,
					      uint32_t *_display_name_length /* [in,out] [unique] */,
					      WERROR *result)
{
	struct svcctl_GetServiceDisplayNameA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.service_name = _service_name;
	r.in.display_name_length = _display_name_length;

	/* Out parameters */
	r.out.display_name = _display_name;
	r.out.display_name_length = _display_name_length;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_GetServiceDisplayNameA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_display_name = *r.out.display_name;
	if (_display_name_length && r.out.display_name_length) {
		*_display_name_length = *r.out.display_name_length;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_GetServiceKeyNameA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceKeyNameA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceKeyNameA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_GetServiceKeyNameA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceKeyNameA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceKeyNameA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEKEYNAMEA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceKeyNameA_r_done, req);

	return req;
}

static void dcerpc_svcctl_GetServiceKeyNameA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_GetServiceKeyNameA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_GetServiceKeyNameA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_GetServiceKeyNameA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETSERVICEKEYNAMEA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_GetServiceKeyNameA_state {
	struct svcctl_GetServiceKeyNameA orig;
	struct svcctl_GetServiceKeyNameA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetServiceKeyNameA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetServiceKeyNameA_send(TALLOC_CTX *mem_ctx,
							 struct tevent_context *ev,
							 struct dcerpc_binding_handle *h,
							 struct policy_handle *_handle /* [in] [ref] */,
							 const char *_service_name /* [in] [charset(UTF16),unique] */,
							 const char **_key_name /* [out] [charset(UTF16),ref] */,
							 uint32_t *_display_name_length /* [in,out] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetServiceKeyNameA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetServiceKeyNameA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.service_name = _service_name;
	state->orig.in.display_name_length = _display_name_length;

	/* Out parameters */
	state->orig.out.key_name = _key_name;
	state->orig.out.display_name_length = _display_name_length;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_GetServiceKeyNameA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_GetServiceKeyNameA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetServiceKeyNameA_done, req);
	return req;
}

static void dcerpc_svcctl_GetServiceKeyNameA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_GetServiceKeyNameA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceKeyNameA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_GetServiceKeyNameA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.key_name = *state->tmp.out.key_name;
	if (state->orig.out.display_name_length && state->tmp.out.display_name_length) {
		*state->orig.out.display_name_length = *state->tmp.out.display_name_length;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameA_recv(struct tevent_req *req,
					       TALLOC_CTX *mem_ctx,
					       WERROR *result)
{
	struct dcerpc_svcctl_GetServiceKeyNameA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetServiceKeyNameA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetServiceKeyNameA(struct dcerpc_binding_handle *h,
					  TALLOC_CTX *mem_ctx,
					  struct policy_handle *_handle /* [in] [ref] */,
					  const char *_service_name /* [in] [charset(UTF16),unique] */,
					  const char **_key_name /* [out] [charset(UTF16),ref] */,
					  uint32_t *_display_name_length /* [in,out] [unique] */,
					  WERROR *result)
{
	struct svcctl_GetServiceKeyNameA r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.service_name = _service_name;
	r.in.display_name_length = _display_name_length;

	/* Out parameters */
	r.out.key_name = _key_name;
	r.out.display_name_length = _display_name_length;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_GetServiceKeyNameA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_key_name = *r.out.key_name;
	if (_display_name_length && r.out.display_name_length) {
		*_display_name_length = *r.out.display_name_length;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_ChangeServiceConfig2A_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfig2A_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfig2A_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_ChangeServiceConfig2A *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfig2A_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfig2A_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIG2A, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfig2A_r_done, req);

	return req;
}

static void dcerpc_svcctl_ChangeServiceConfig2A_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2A_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_ChangeServiceConfig2A_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_ChangeServiceConfig2A_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2A_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_ChangeServiceConfig2A *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIG2A, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_ChangeServiceConfig2A_state {
	struct svcctl_ChangeServiceConfig2A orig;
	struct svcctl_ChangeServiceConfig2A tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfig2A_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfig2A_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle *_handle /* [in] [ref] */,
							    uint32_t _info_level /* [in]  */,
							    uint8_t *_info /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfig2A_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfig2A_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.info_level = _info_level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_ChangeServiceConfig2A_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfig2A_done, req);
	return req;
}

static void dcerpc_svcctl_ChangeServiceConfig2A_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_ChangeServiceConfig2A_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfig2A_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_ChangeServiceConfig2A_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2A_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_svcctl_ChangeServiceConfig2A_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfig2A_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2A(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *_handle /* [in] [ref] */,
					     uint32_t _info_level /* [in]  */,
					     uint8_t *_info /* [in] [unique] */,
					     WERROR *result)
{
	struct svcctl_ChangeServiceConfig2A r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.info_level = _info_level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_ChangeServiceConfig2A_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_ChangeServiceConfig2W_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfig2W_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfig2W_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_ChangeServiceConfig2W *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfig2W_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfig2W_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIG2W, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfig2W_r_done, req);

	return req;
}

static void dcerpc_svcctl_ChangeServiceConfig2W_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2W_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_ChangeServiceConfig2W_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_ChangeServiceConfig2W_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2W_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_ChangeServiceConfig2W *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CHANGESERVICECONFIG2W, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_ChangeServiceConfig2W_state {
	struct svcctl_ChangeServiceConfig2W orig;
	struct svcctl_ChangeServiceConfig2W tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ChangeServiceConfig2W_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ChangeServiceConfig2W_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle *_handle /* [in] [ref] */,
							    uint32_t _info_level /* [in]  */,
							    uint8_t *_info /* [in] [unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ChangeServiceConfig2W_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ChangeServiceConfig2W_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.info_level = _info_level;
	state->orig.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_ChangeServiceConfig2W_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ChangeServiceConfig2W_done, req);
	return req;
}

static void dcerpc_svcctl_ChangeServiceConfig2W_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_ChangeServiceConfig2W_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfig2W_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_ChangeServiceConfig2W_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2W_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_svcctl_ChangeServiceConfig2W_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ChangeServiceConfig2W_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ChangeServiceConfig2W(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *_handle /* [in] [ref] */,
					     uint32_t _info_level /* [in]  */,
					     uint8_t *_info /* [in] [unique] */,
					     WERROR *result)
{
	struct svcctl_ChangeServiceConfig2W r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.info_level = _info_level;
	r.in.info = _info;

	/* Out parameters */

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_ChangeServiceConfig2W_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceConfig2A_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfig2A_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfig2A_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceConfig2A *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfig2A_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfig2A_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIG2A, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfig2A_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceConfig2A_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2A_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceConfig2A_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceConfig2A_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2A_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceConfig2A *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIG2A, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceConfig2A_state {
	struct svcctl_QueryServiceConfig2A orig;
	struct svcctl_QueryServiceConfig2A tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfig2A_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfig2A_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_handle /* [in] [ref] */,
							   enum svcctl_ConfigLevel _info_level /* [in]  */,
							   uint8_t *_buffer /* [out]  */,
							   uint32_t _offered /* [in]  */,
							   uint32_t *_needed /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfig2A_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfig2A_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.info_level = _info_level;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceConfig2A_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceConfig2A_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfig2A_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceConfig2A_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceConfig2A_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfig2A_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceConfig2A_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = state->tmp.in.offered;
		if (state->orig.out.buffer != state->tmp.out.buffer) {
			memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
		}
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2A_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceConfig2A_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfig2A_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2A(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_handle /* [in] [ref] */,
					    enum svcctl_ConfigLevel _info_level /* [in]  */,
					    uint8_t *_buffer /* [out]  */,
					    uint32_t _offered /* [in]  */,
					    uint32_t *_needed /* [out] [ref] */,
					    WERROR *result)
{
	struct svcctl_QueryServiceConfig2A r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.info_level = _info_level;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceConfig2A_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = r.in.offered;
		if (_buffer != r.out.buffer) {
			memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
		}
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceConfig2W_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfig2W_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfig2W_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceConfig2W *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfig2W_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfig2W_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIG2W, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfig2W_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceConfig2W_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2W_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceConfig2W_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceConfig2W_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2W_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceConfig2W *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIG2W, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceConfig2W_state {
	struct svcctl_QueryServiceConfig2W orig;
	struct svcctl_QueryServiceConfig2W tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfig2W_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfig2W_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_handle /* [in] [ref] */,
							   enum svcctl_ConfigLevel _info_level /* [in]  */,
							   uint8_t *_buffer /* [out] [ref,size_is(offered)] */,
							   uint32_t _offered /* [in] [range(0,8192)] */,
							   uint32_t *_needed /* [out] [range(0,8192),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfig2W_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfig2W_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.info_level = _info_level;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceConfig2W_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceConfig2W_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfig2W_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceConfig2W_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceConfig2W_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfig2W_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceConfig2W_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = state->tmp.in.offered;
		if (state->orig.out.buffer != state->tmp.out.buffer) {
			memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
		}
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2W_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceConfig2W_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfig2W_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfig2W(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_handle /* [in] [ref] */,
					    enum svcctl_ConfigLevel _info_level /* [in]  */,
					    uint8_t *_buffer /* [out] [ref,size_is(offered)] */,
					    uint32_t _offered /* [in] [range(0,8192)] */,
					    uint32_t *_needed /* [out] [range(0,8192),ref] */,
					    WERROR *result)
{
	struct svcctl_QueryServiceConfig2W r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.info_level = _info_level;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceConfig2W_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = r.in.offered;
		if (_buffer != r.out.buffer) {
			memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
		}
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceStatusEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceStatusEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceStatusEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceStatusEx *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceStatusEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceStatusEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICESTATUSEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceStatusEx_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceStatusEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceStatusEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceStatusEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceStatusEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceStatusEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceStatusEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICESTATUSEX, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceStatusEx_state {
	struct svcctl_QueryServiceStatusEx orig;
	struct svcctl_QueryServiceStatusEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceStatusEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceStatusEx_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle *_handle /* [in] [ref] */,
							   enum svcctl_StatusLevel _info_level /* [in]  */,
							   uint8_t *_buffer /* [out] [ref,size_is(offered)] */,
							   uint32_t _offered /* [in] [range(0,8192)] */,
							   uint32_t *_needed /* [out] [range(0,8192),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceStatusEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceStatusEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.handle = _handle;
	state->orig.in.info_level = _info_level;
	state->orig.in.offered = _offered;

	/* Out parameters */
	state->orig.out.buffer = _buffer;
	state->orig.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceStatusEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceStatusEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceStatusEx_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceStatusEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceStatusEx_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceStatusEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceStatusEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = state->tmp.in.offered;
		if (state->orig.out.buffer != state->tmp.out.buffer) {
			memcpy(state->orig.out.buffer, state->tmp.out.buffer, _copy_len_buffer * sizeof(*state->orig.out.buffer));
		}
	}
	*state->orig.out.needed = *state->tmp.out.needed;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceStatusEx_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceStatusEx_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceStatusEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceStatusEx(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle *_handle /* [in] [ref] */,
					    enum svcctl_StatusLevel _info_level /* [in]  */,
					    uint8_t *_buffer /* [out] [ref,size_is(offered)] */,
					    uint32_t _offered /* [in] [range(0,8192)] */,
					    uint32_t *_needed /* [out] [range(0,8192),ref] */,
					    WERROR *result)
{
	struct svcctl_QueryServiceStatusEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.handle = _handle;
	r.in.info_level = _info_level;
	r.in.offered = _offered;

	/* Out parameters */
	r.out.buffer = _buffer;
	r.out.needed = _needed;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceStatusEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_buffer;
		_copy_len_buffer = r.in.offered;
		if (_buffer != r.out.buffer) {
			memcpy(_buffer, r.out.buffer, _copy_len_buffer * sizeof(*_buffer));
		}
	}
	*_needed = *r.out.needed;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_EnumServicesStatusExA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumServicesStatusExA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumServicesStatusExA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_EnumServicesStatusExA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumServicesStatusExA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumServicesStatusExA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMSERVICESSTATUSEXA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumServicesStatusExA_r_done, req);

	return req;
}

static void dcerpc_svcctl_EnumServicesStatusExA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusExA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_EnumServicesStatusExA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_EnumServicesStatusExA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusExA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_EnumServicesStatusExA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMSERVICESSTATUSEXA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_EnumServicesStatusExA_state {
	struct svcctl_EnumServicesStatusExA orig;
	struct svcctl_EnumServicesStatusExA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumServicesStatusExA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumServicesStatusExA_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle *_scmanager /* [in] [ref] */,
							    uint32_t _info_level /* [in]  */,
							    uint32_t _type /* [in]  */,
							    enum svcctl_ServiceState _state /* [in]  */,
							    uint8_t *_services /* [out]  */,
							    uint32_t _offered /* [in]  */,
							    uint32_t *_needed /* [out] [ref] */,
							    uint32_t *_service_returned /* [out] [ref] */,
							    uint32_t *_resume_handle /* [in,out] [unique] */,
							    const char **_group_name /* [out] [charset(UTF16),ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumServicesStatusExA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumServicesStatusExA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.scmanager = _scmanager;
	state->orig.in.info_level = _info_level;
	state->orig.in.type = _type;
	state->orig.in.state = _state;
	state->orig.in.offered = _offered;
	state->orig.in.resume_handle = _resume_handle;

	/* Out parameters */
	state->orig.out.services = _services;
	state->orig.out.needed = _needed;
	state->orig.out.service_returned = _service_returned;
	state->orig.out.resume_handle = _resume_handle;
	state->orig.out.group_name = _group_name;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_EnumServicesStatusExA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_EnumServicesStatusExA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumServicesStatusExA_done, req);
	return req;
}

static void dcerpc_svcctl_EnumServicesStatusExA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_EnumServicesStatusExA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumServicesStatusExA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_EnumServicesStatusExA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_services;
		_copy_len_services = state->tmp.in.offered;
		if (state->orig.out.services != state->tmp.out.services) {
			memcpy(state->orig.out.services, state->tmp.out.services, _copy_len_services * sizeof(*state->orig.out.services));
		}
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.service_returned = *state->tmp.out.service_returned;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}
	*state->orig.out.group_name = *state->tmp.out.group_name;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusExA_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_svcctl_EnumServicesStatusExA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumServicesStatusExA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusExA(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *_scmanager /* [in] [ref] */,
					     uint32_t _info_level /* [in]  */,
					     uint32_t _type /* [in]  */,
					     enum svcctl_ServiceState _state /* [in]  */,
					     uint8_t *_services /* [out]  */,
					     uint32_t _offered /* [in]  */,
					     uint32_t *_needed /* [out] [ref] */,
					     uint32_t *_service_returned /* [out] [ref] */,
					     uint32_t *_resume_handle /* [in,out] [unique] */,
					     const char **_group_name /* [out] [charset(UTF16),ref] */,
					     WERROR *result)
{
	struct svcctl_EnumServicesStatusExA r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager = _scmanager;
	r.in.info_level = _info_level;
	r.in.type = _type;
	r.in.state = _state;
	r.in.offered = _offered;
	r.in.resume_handle = _resume_handle;

	/* Out parameters */
	r.out.services = _services;
	r.out.needed = _needed;
	r.out.service_returned = _service_returned;
	r.out.resume_handle = _resume_handle;
	r.out.group_name = _group_name;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_EnumServicesStatusExA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_services;
		_copy_len_services = r.in.offered;
		if (_services != r.out.services) {
			memcpy(_services, r.out.services, _copy_len_services * sizeof(*_services));
		}
	}
	*_needed = *r.out.needed;
	*_service_returned = *r.out.service_returned;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}
	*_group_name = *r.out.group_name;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_EnumServicesStatusExW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumServicesStatusExW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumServicesStatusExW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_EnumServicesStatusExW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumServicesStatusExW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumServicesStatusExW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMSERVICESSTATUSEXW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumServicesStatusExW_r_done, req);

	return req;
}

static void dcerpc_svcctl_EnumServicesStatusExW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusExW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_EnumServicesStatusExW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_EnumServicesStatusExW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusExW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_EnumServicesStatusExW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_ENUMSERVICESSTATUSEXW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_EnumServicesStatusExW_state {
	struct svcctl_EnumServicesStatusExW orig;
	struct svcctl_EnumServicesStatusExW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_EnumServicesStatusExW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_EnumServicesStatusExW_send(TALLOC_CTX *mem_ctx,
							    struct tevent_context *ev,
							    struct dcerpc_binding_handle *h,
							    struct policy_handle *_scmanager /* [in] [ref] */,
							    uint32_t _info_level /* [in]  */,
							    uint32_t _type /* [in]  */,
							    enum svcctl_ServiceState _state /* [in]  */,
							    uint8_t *_services /* [out] [ref,size_is(offered)] */,
							    uint32_t _offered /* [in] [range(0,0x40000)] */,
							    uint32_t *_needed /* [out] [range(0,0x40000),ref] */,
							    uint32_t *_service_returned /* [out] [range(0,0x40000),ref] */,
							    uint32_t *_resume_handle /* [in,out] [range(0,0x40000),unique] */,
							    const char *_group_name /* [in] [charset(UTF16),unique] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_EnumServicesStatusExW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_EnumServicesStatusExW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.scmanager = _scmanager;
	state->orig.in.info_level = _info_level;
	state->orig.in.type = _type;
	state->orig.in.state = _state;
	state->orig.in.offered = _offered;
	state->orig.in.resume_handle = _resume_handle;
	state->orig.in.group_name = _group_name;

	/* Out parameters */
	state->orig.out.services = _services;
	state->orig.out.needed = _needed;
	state->orig.out.service_returned = _service_returned;
	state->orig.out.resume_handle = _resume_handle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_EnumServicesStatusExW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_EnumServicesStatusExW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_EnumServicesStatusExW_done, req);
	return req;
}

static void dcerpc_svcctl_EnumServicesStatusExW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_EnumServicesStatusExW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumServicesStatusExW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_EnumServicesStatusExW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	{
		size_t _copy_len_services;
		_copy_len_services = state->tmp.in.offered;
		if (state->orig.out.services != state->tmp.out.services) {
			memcpy(state->orig.out.services, state->tmp.out.services, _copy_len_services * sizeof(*state->orig.out.services));
		}
	}
	*state->orig.out.needed = *state->tmp.out.needed;
	*state->orig.out.service_returned = *state->tmp.out.service_returned;
	if (state->orig.out.resume_handle && state->tmp.out.resume_handle) {
		*state->orig.out.resume_handle = *state->tmp.out.resume_handle;
	}

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusExW_recv(struct tevent_req *req,
						  TALLOC_CTX *mem_ctx,
						  WERROR *result)
{
	struct dcerpc_svcctl_EnumServicesStatusExW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_EnumServicesStatusExW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_EnumServicesStatusExW(struct dcerpc_binding_handle *h,
					     TALLOC_CTX *mem_ctx,
					     struct policy_handle *_scmanager /* [in] [ref] */,
					     uint32_t _info_level /* [in]  */,
					     uint32_t _type /* [in]  */,
					     enum svcctl_ServiceState _state /* [in]  */,
					     uint8_t *_services /* [out] [ref,size_is(offered)] */,
					     uint32_t _offered /* [in] [range(0,0x40000)] */,
					     uint32_t *_needed /* [out] [range(0,0x40000),ref] */,
					     uint32_t *_service_returned /* [out] [range(0,0x40000),ref] */,
					     uint32_t *_resume_handle /* [in,out] [range(0,0x40000),unique] */,
					     const char *_group_name /* [in] [charset(UTF16),unique] */,
					     WERROR *result)
{
	struct svcctl_EnumServicesStatusExW r;
	NTSTATUS status;

	/* In parameters */
	r.in.scmanager = _scmanager;
	r.in.info_level = _info_level;
	r.in.type = _type;
	r.in.state = _state;
	r.in.offered = _offered;
	r.in.resume_handle = _resume_handle;
	r.in.group_name = _group_name;

	/* Out parameters */
	r.out.services = _services;
	r.out.needed = _needed;
	r.out.service_returned = _service_returned;
	r.out.resume_handle = _resume_handle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_EnumServicesStatusExW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	{
		size_t _copy_len_services;
		_copy_len_services = r.in.offered;
		if (_services != r.out.services) {
			memcpy(_services, r.out.services, _copy_len_services * sizeof(*_services));
		}
	}
	*_needed = *r.out.needed;
	*_service_returned = *r.out.service_returned;
	if (_resume_handle && r.out.resume_handle) {
		*_resume_handle = *r.out.resume_handle;
	}

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_CreateServiceWOW64A_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateServiceWOW64A_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateServiceWOW64A_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_CreateServiceWOW64A *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateServiceWOW64A_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateServiceWOW64A_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATESERVICEWOW64A, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateServiceWOW64A_r_done, req);

	return req;
}

static void dcerpc_svcctl_CreateServiceWOW64A_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateServiceWOW64A_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_CreateServiceWOW64A_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_CreateServiceWOW64A_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateServiceWOW64A_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_CreateServiceWOW64A *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATESERVICEWOW64A, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_CreateServiceWOW64A_state {
	struct svcctl_CreateServiceWOW64A orig;
	struct svcctl_CreateServiceWOW64A tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateServiceWOW64A_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateServiceWOW64A_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle _hSCManager /* [in]  */,
							  const char *_lpServiceName /* [in] [charset(DOS),range(0,SC_MAX_NAME_LENGTH),ref] */,
							  const char *_lpDisplayName /* [in] [charset(DOS),range(0,SC_MAX_NAME_LENGTH),unique] */,
							  uint32_t _dwDesiredAccess /* [in]  */,
							  uint32_t _dwServiceType /* [in]  */,
							  uint32_t _dwStartType /* [in]  */,
							  uint32_t _dwErrorControl /* [in]  */,
							  const char *_lpBinaryPathName /* [in] [charset(DOS),range(0,SC_MAX_PATH_LENGTH),ref] */,
							  const char *_lpLoadOrderGroup /* [in] [charset(DOS),range(0,SC_MAX_NAME_LENGTH),unique] */,
							  uint32_t *_lpdwTagId /* [in,out] [unique] */,
							  uint8_t *_lpDependencies /* [in] [size_is(dwDependSize),unique] */,
							  uint32_t _dwDependSize /* [in] [range(0,SC_MAX_DEPEND_SIZE)] */,
							  const char *_lpServiceStartName /* [in] [charset(DOS),range(0,SC_MAX_ACCOUNT_NAME_LENGTH),unique] */,
							  uint8_t *_lpPassword /* [in] [size_is(dwPwSize),unique] */,
							  uint32_t _dwPwSize /* [in] [range(0,SC_MAX_PWD_SIZE)] */,
							  struct policy_handle *_lpServiceHandle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateServiceWOW64A_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateServiceWOW64A_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hSCManager = _hSCManager;
	state->orig.in.lpServiceName = _lpServiceName;
	state->orig.in.lpDisplayName = _lpDisplayName;
	state->orig.in.dwDesiredAccess = _dwDesiredAccess;
	state->orig.in.dwServiceType = _dwServiceType;
	state->orig.in.dwStartType = _dwStartType;
	state->orig.in.dwErrorControl = _dwErrorControl;
	state->orig.in.lpBinaryPathName = _lpBinaryPathName;
	state->orig.in.lpLoadOrderGroup = _lpLoadOrderGroup;
	state->orig.in.lpdwTagId = _lpdwTagId;
	state->orig.in.lpDependencies = _lpDependencies;
	state->orig.in.dwDependSize = _dwDependSize;
	state->orig.in.lpServiceStartName = _lpServiceStartName;
	state->orig.in.lpPassword = _lpPassword;
	state->orig.in.dwPwSize = _dwPwSize;

	/* Out parameters */
	state->orig.out.lpdwTagId = _lpdwTagId;
	state->orig.out.lpServiceHandle = _lpServiceHandle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_CreateServiceWOW64A_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_CreateServiceWOW64A_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateServiceWOW64A_done, req);
	return req;
}

static void dcerpc_svcctl_CreateServiceWOW64A_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_CreateServiceWOW64A_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateServiceWOW64A_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_CreateServiceWOW64A_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.lpdwTagId && state->tmp.out.lpdwTagId) {
		*state->orig.out.lpdwTagId = *state->tmp.out.lpdwTagId;
	}
	*state->orig.out.lpServiceHandle = *state->tmp.out.lpServiceHandle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateServiceWOW64A_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_svcctl_CreateServiceWOW64A_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateServiceWOW64A_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateServiceWOW64A(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle _hSCManager /* [in]  */,
					   const char *_lpServiceName /* [in] [charset(DOS),range(0,SC_MAX_NAME_LENGTH),ref] */,
					   const char *_lpDisplayName /* [in] [charset(DOS),range(0,SC_MAX_NAME_LENGTH),unique] */,
					   uint32_t _dwDesiredAccess /* [in]  */,
					   uint32_t _dwServiceType /* [in]  */,
					   uint32_t _dwStartType /* [in]  */,
					   uint32_t _dwErrorControl /* [in]  */,
					   const char *_lpBinaryPathName /* [in] [charset(DOS),range(0,SC_MAX_PATH_LENGTH),ref] */,
					   const char *_lpLoadOrderGroup /* [in] [charset(DOS),range(0,SC_MAX_NAME_LENGTH),unique] */,
					   uint32_t *_lpdwTagId /* [in,out] [unique] */,
					   uint8_t *_lpDependencies /* [in] [size_is(dwDependSize),unique] */,
					   uint32_t _dwDependSize /* [in] [range(0,SC_MAX_DEPEND_SIZE)] */,
					   const char *_lpServiceStartName /* [in] [charset(DOS),range(0,SC_MAX_ACCOUNT_NAME_LENGTH),unique] */,
					   uint8_t *_lpPassword /* [in] [size_is(dwPwSize),unique] */,
					   uint32_t _dwPwSize /* [in] [range(0,SC_MAX_PWD_SIZE)] */,
					   struct policy_handle *_lpServiceHandle /* [out] [ref] */,
					   WERROR *result)
{
	struct svcctl_CreateServiceWOW64A r;
	NTSTATUS status;

	/* In parameters */
	r.in.hSCManager = _hSCManager;
	r.in.lpServiceName = _lpServiceName;
	r.in.lpDisplayName = _lpDisplayName;
	r.in.dwDesiredAccess = _dwDesiredAccess;
	r.in.dwServiceType = _dwServiceType;
	r.in.dwStartType = _dwStartType;
	r.in.dwErrorControl = _dwErrorControl;
	r.in.lpBinaryPathName = _lpBinaryPathName;
	r.in.lpLoadOrderGroup = _lpLoadOrderGroup;
	r.in.lpdwTagId = _lpdwTagId;
	r.in.lpDependencies = _lpDependencies;
	r.in.dwDependSize = _dwDependSize;
	r.in.lpServiceStartName = _lpServiceStartName;
	r.in.lpPassword = _lpPassword;
	r.in.dwPwSize = _dwPwSize;

	/* Out parameters */
	r.out.lpdwTagId = _lpdwTagId;
	r.out.lpServiceHandle = _lpServiceHandle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_CreateServiceWOW64A_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_lpdwTagId && r.out.lpdwTagId) {
		*_lpdwTagId = *r.out.lpdwTagId;
	}
	*_lpServiceHandle = *r.out.lpServiceHandle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_CreateServiceWOW64W_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateServiceWOW64W_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateServiceWOW64W_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_CreateServiceWOW64W *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateServiceWOW64W_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateServiceWOW64W_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATESERVICEWOW64W, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateServiceWOW64W_r_done, req);

	return req;
}

static void dcerpc_svcctl_CreateServiceWOW64W_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateServiceWOW64W_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_CreateServiceWOW64W_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_CreateServiceWOW64W_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateServiceWOW64W_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_CreateServiceWOW64W *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATESERVICEWOW64W, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_CreateServiceWOW64W_state {
	struct svcctl_CreateServiceWOW64W orig;
	struct svcctl_CreateServiceWOW64W tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateServiceWOW64W_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateServiceWOW64W_send(TALLOC_CTX *mem_ctx,
							  struct tevent_context *ev,
							  struct dcerpc_binding_handle *h,
							  struct policy_handle _hSCManager /* [in]  */,
							  const char *_lpServiceName /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),ref] */,
							  const char *_lpDisplayName /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */,
							  uint32_t _dwDesiredAccess /* [in]  */,
							  uint32_t _dwServiceType /* [in]  */,
							  uint32_t _dwStartType /* [in]  */,
							  uint32_t _dwErrorControl /* [in]  */,
							  const char *_lpBinaryPathName /* [in] [charset(UTF16),range(0,SC_MAX_PATH_LENGTH),ref] */,
							  const char *_lpLoadOrderGroup /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */,
							  uint32_t *_lpdwTagId /* [in,out] [unique] */,
							  uint8_t *_lpDependencies /* [in] [size_is(dwDependSize),unique] */,
							  uint32_t _dwDependSize /* [in] [range(0,SC_MAX_DEPEND_SIZE)] */,
							  const char *_lpServiceStartName /* [in] [charset(UTF16),range(0,SC_MAX_ACCOUNT_NAME_LENGTH),unique] */,
							  uint8_t *_lpPassword /* [in] [size_is(dwPwSize),unique] */,
							  uint32_t _dwPwSize /* [in] [range(0,SC_MAX_PWD_SIZE)] */,
							  struct policy_handle *_lpServiceHandle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateServiceWOW64W_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateServiceWOW64W_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hSCManager = _hSCManager;
	state->orig.in.lpServiceName = _lpServiceName;
	state->orig.in.lpDisplayName = _lpDisplayName;
	state->orig.in.dwDesiredAccess = _dwDesiredAccess;
	state->orig.in.dwServiceType = _dwServiceType;
	state->orig.in.dwStartType = _dwStartType;
	state->orig.in.dwErrorControl = _dwErrorControl;
	state->orig.in.lpBinaryPathName = _lpBinaryPathName;
	state->orig.in.lpLoadOrderGroup = _lpLoadOrderGroup;
	state->orig.in.lpdwTagId = _lpdwTagId;
	state->orig.in.lpDependencies = _lpDependencies;
	state->orig.in.dwDependSize = _dwDependSize;
	state->orig.in.lpServiceStartName = _lpServiceStartName;
	state->orig.in.lpPassword = _lpPassword;
	state->orig.in.dwPwSize = _dwPwSize;

	/* Out parameters */
	state->orig.out.lpdwTagId = _lpdwTagId;
	state->orig.out.lpServiceHandle = _lpServiceHandle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_CreateServiceWOW64W_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_CreateServiceWOW64W_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateServiceWOW64W_done, req);
	return req;
}

static void dcerpc_svcctl_CreateServiceWOW64W_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_CreateServiceWOW64W_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateServiceWOW64W_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_CreateServiceWOW64W_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.lpdwTagId && state->tmp.out.lpdwTagId) {
		*state->orig.out.lpdwTagId = *state->tmp.out.lpdwTagId;
	}
	*state->orig.out.lpServiceHandle = *state->tmp.out.lpServiceHandle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateServiceWOW64W_recv(struct tevent_req *req,
						TALLOC_CTX *mem_ctx,
						WERROR *result)
{
	struct dcerpc_svcctl_CreateServiceWOW64W_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateServiceWOW64W_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateServiceWOW64W(struct dcerpc_binding_handle *h,
					   TALLOC_CTX *mem_ctx,
					   struct policy_handle _hSCManager /* [in]  */,
					   const char *_lpServiceName /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),ref] */,
					   const char *_lpDisplayName /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */,
					   uint32_t _dwDesiredAccess /* [in]  */,
					   uint32_t _dwServiceType /* [in]  */,
					   uint32_t _dwStartType /* [in]  */,
					   uint32_t _dwErrorControl /* [in]  */,
					   const char *_lpBinaryPathName /* [in] [charset(UTF16),range(0,SC_MAX_PATH_LENGTH),ref] */,
					   const char *_lpLoadOrderGroup /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */,
					   uint32_t *_lpdwTagId /* [in,out] [unique] */,
					   uint8_t *_lpDependencies /* [in] [size_is(dwDependSize),unique] */,
					   uint32_t _dwDependSize /* [in] [range(0,SC_MAX_DEPEND_SIZE)] */,
					   const char *_lpServiceStartName /* [in] [charset(UTF16),range(0,SC_MAX_ACCOUNT_NAME_LENGTH),unique] */,
					   uint8_t *_lpPassword /* [in] [size_is(dwPwSize),unique] */,
					   uint32_t _dwPwSize /* [in] [range(0,SC_MAX_PWD_SIZE)] */,
					   struct policy_handle *_lpServiceHandle /* [out] [ref] */,
					   WERROR *result)
{
	struct svcctl_CreateServiceWOW64W r;
	NTSTATUS status;

	/* In parameters */
	r.in.hSCManager = _hSCManager;
	r.in.lpServiceName = _lpServiceName;
	r.in.lpDisplayName = _lpDisplayName;
	r.in.dwDesiredAccess = _dwDesiredAccess;
	r.in.dwServiceType = _dwServiceType;
	r.in.dwStartType = _dwStartType;
	r.in.dwErrorControl = _dwErrorControl;
	r.in.lpBinaryPathName = _lpBinaryPathName;
	r.in.lpLoadOrderGroup = _lpLoadOrderGroup;
	r.in.lpdwTagId = _lpdwTagId;
	r.in.lpDependencies = _lpDependencies;
	r.in.dwDependSize = _dwDependSize;
	r.in.lpServiceStartName = _lpServiceStartName;
	r.in.lpPassword = _lpPassword;
	r.in.dwPwSize = _dwPwSize;

	/* Out parameters */
	r.out.lpdwTagId = _lpdwTagId;
	r.out.lpServiceHandle = _lpServiceHandle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_CreateServiceWOW64W_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_lpdwTagId && r.out.lpdwTagId) {
		*_lpdwTagId = *r.out.lpdwTagId;
	}
	*_lpServiceHandle = *r.out.lpServiceHandle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum46NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum46NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum46NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum46NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum46NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum46NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM46NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum46NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum46NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum46NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum46NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum46NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum46NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum46NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM46NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum46NotUsedOnWire_state {
	struct Opnum46NotUsedOnWire orig;
	struct Opnum46NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum46NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum46NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum46NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum46NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum46NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum46NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum46NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum46NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum46NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum46NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum46NotUsedOnWire_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum46NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum46NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum46NotUsedOnWire(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx)
{
	struct Opnum46NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	status = dcerpc_Opnum46NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_NotifyServiceStatusChange_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_NotifyServiceStatusChange_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_NotifyServiceStatusChange_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_NotifyServiceStatusChange *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_NotifyServiceStatusChange_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_NotifyServiceStatusChange_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_NOTIFYSERVICESTATUSCHANGE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_NotifyServiceStatusChange_r_done, req);

	return req;
}

static void dcerpc_svcctl_NotifyServiceStatusChange_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_NotifyServiceStatusChange_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_NotifyServiceStatusChange_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_NotifyServiceStatusChange_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_NotifyServiceStatusChange_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_NotifyServiceStatusChange *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_NOTIFYSERVICESTATUSCHANGE, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_NotifyServiceStatusChange_state {
	struct svcctl_NotifyServiceStatusChange orig;
	struct svcctl_NotifyServiceStatusChange tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_NotifyServiceStatusChange_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_NotifyServiceStatusChange_send(TALLOC_CTX *mem_ctx,
								struct tevent_context *ev,
								struct dcerpc_binding_handle *h,
								struct policy_handle _hService /* [in]  */,
								struct SC_RPC_NOTIFY_PARAMS _NotifyParams /* [in]  */,
								struct GUID *_pClientProcessGuid /* [in] [ref] */,
								struct GUID *_pSCMProcessGuid /* [out] [ref] */,
								uint32_t *_pfCreateRemoteQueue /* [out] [ref] */,
								struct policy_handle *_phNotify /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_NotifyServiceStatusChange_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_NotifyServiceStatusChange_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hService = _hService;
	state->orig.in.NotifyParams = _NotifyParams;
	state->orig.in.pClientProcessGuid = _pClientProcessGuid;

	/* Out parameters */
	state->orig.out.pSCMProcessGuid = _pSCMProcessGuid;
	state->orig.out.pfCreateRemoteQueue = _pfCreateRemoteQueue;
	state->orig.out.phNotify = _phNotify;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_NotifyServiceStatusChange_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_NotifyServiceStatusChange_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_NotifyServiceStatusChange_done, req);
	return req;
}

static void dcerpc_svcctl_NotifyServiceStatusChange_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_NotifyServiceStatusChange_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_NotifyServiceStatusChange_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_NotifyServiceStatusChange_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pSCMProcessGuid = *state->tmp.out.pSCMProcessGuid;
	*state->orig.out.pfCreateRemoteQueue = *state->tmp.out.pfCreateRemoteQueue;
	*state->orig.out.phNotify = *state->tmp.out.phNotify;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_NotifyServiceStatusChange_recv(struct tevent_req *req,
						      TALLOC_CTX *mem_ctx,
						      WERROR *result)
{
	struct dcerpc_svcctl_NotifyServiceStatusChange_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_NotifyServiceStatusChange_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_NotifyServiceStatusChange(struct dcerpc_binding_handle *h,
						 TALLOC_CTX *mem_ctx,
						 struct policy_handle _hService /* [in]  */,
						 struct SC_RPC_NOTIFY_PARAMS _NotifyParams /* [in]  */,
						 struct GUID *_pClientProcessGuid /* [in] [ref] */,
						 struct GUID *_pSCMProcessGuid /* [out] [ref] */,
						 uint32_t *_pfCreateRemoteQueue /* [out] [ref] */,
						 struct policy_handle *_phNotify /* [out] [ref] */,
						 WERROR *result)
{
	struct svcctl_NotifyServiceStatusChange r;
	NTSTATUS status;

	/* In parameters */
	r.in.hService = _hService;
	r.in.NotifyParams = _NotifyParams;
	r.in.pClientProcessGuid = _pClientProcessGuid;

	/* Out parameters */
	r.out.pSCMProcessGuid = _pSCMProcessGuid;
	r.out.pfCreateRemoteQueue = _pfCreateRemoteQueue;
	r.out.phNotify = _phNotify;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_NotifyServiceStatusChange_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pSCMProcessGuid = *r.out.pSCMProcessGuid;
	*_pfCreateRemoteQueue = *r.out.pfCreateRemoteQueue;
	*_phNotify = *r.out.phNotify;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_GetNotifyResults_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetNotifyResults_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetNotifyResults_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_GetNotifyResults *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetNotifyResults_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetNotifyResults_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETNOTIFYRESULTS, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetNotifyResults_r_done, req);

	return req;
}

static void dcerpc_svcctl_GetNotifyResults_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetNotifyResults_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_GetNotifyResults_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_GetNotifyResults_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetNotifyResults_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_GetNotifyResults *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_GETNOTIFYRESULTS, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_GetNotifyResults_state {
	struct svcctl_GetNotifyResults orig;
	struct svcctl_GetNotifyResults tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_GetNotifyResults_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_GetNotifyResults_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hNotify /* [in]  */,
						       struct SC_RPC_NOTIFY_PARAMS_LIST *_ppNotifyParams /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_GetNotifyResults_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_GetNotifyResults_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hNotify = _hNotify;

	/* Out parameters */
	state->orig.out.ppNotifyParams = _ppNotifyParams;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_GetNotifyResults_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_GetNotifyResults_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_GetNotifyResults_done, req);
	return req;
}

static void dcerpc_svcctl_GetNotifyResults_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_GetNotifyResults_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetNotifyResults_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_GetNotifyResults_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ppNotifyParams = *state->tmp.out.ppNotifyParams;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_GetNotifyResults_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_svcctl_GetNotifyResults_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_GetNotifyResults_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_GetNotifyResults(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hNotify /* [in]  */,
					struct SC_RPC_NOTIFY_PARAMS_LIST *_ppNotifyParams /* [out] [ref] */,
					WERROR *result)
{
	struct svcctl_GetNotifyResults r;
	NTSTATUS status;

	/* In parameters */
	r.in.hNotify = _hNotify;

	/* Out parameters */
	r.out.ppNotifyParams = _ppNotifyParams;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_GetNotifyResults_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ppNotifyParams = *r.out.ppNotifyParams;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_CloseNotifyHandle_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CloseNotifyHandle_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CloseNotifyHandle_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_CloseNotifyHandle *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CloseNotifyHandle_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CloseNotifyHandle_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CLOSENOTIFYHANDLE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CloseNotifyHandle_r_done, req);

	return req;
}

static void dcerpc_svcctl_CloseNotifyHandle_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CloseNotifyHandle_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_CloseNotifyHandle_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_CloseNotifyHandle_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CloseNotifyHandle_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_CloseNotifyHandle *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CLOSENOTIFYHANDLE, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_CloseNotifyHandle_state {
	struct svcctl_CloseNotifyHandle orig;
	struct svcctl_CloseNotifyHandle tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CloseNotifyHandle_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CloseNotifyHandle_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle *_phNotify /* [in,out] [ref] */,
							uint32_t *_pfApcFired /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CloseNotifyHandle_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CloseNotifyHandle_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.phNotify = _phNotify;

	/* Out parameters */
	state->orig.out.phNotify = _phNotify;
	state->orig.out.pfApcFired = _pfApcFired;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_CloseNotifyHandle_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_CloseNotifyHandle_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CloseNotifyHandle_done, req);
	return req;
}

static void dcerpc_svcctl_CloseNotifyHandle_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_CloseNotifyHandle_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CloseNotifyHandle_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_CloseNotifyHandle_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.phNotify = *state->tmp.out.phNotify;
	*state->orig.out.pfApcFired = *state->tmp.out.pfApcFired;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CloseNotifyHandle_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_svcctl_CloseNotifyHandle_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CloseNotifyHandle_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CloseNotifyHandle(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle *_phNotify /* [in,out] [ref] */,
					 uint32_t *_pfApcFired /* [out] [ref] */,
					 WERROR *result)
{
	struct svcctl_CloseNotifyHandle r;
	NTSTATUS status;

	/* In parameters */
	r.in.phNotify = _phNotify;

	/* Out parameters */
	r.out.phNotify = _phNotify;
	r.out.pfApcFired = _pfApcFired;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_CloseNotifyHandle_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_phNotify = *r.out.phNotify;
	*_pfApcFired = *r.out.pfApcFired;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_ControlServiceExA_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ControlServiceExA_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ControlServiceExA_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_ControlServiceExA *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ControlServiceExA_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ControlServiceExA_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CONTROLSERVICEEXA, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ControlServiceExA_r_done, req);

	return req;
}

static void dcerpc_svcctl_ControlServiceExA_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ControlServiceExA_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_ControlServiceExA_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_ControlServiceExA_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ControlServiceExA_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_ControlServiceExA *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CONTROLSERVICEEXA, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_ControlServiceExA_state {
	struct svcctl_ControlServiceExA orig;
	struct svcctl_ControlServiceExA tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ControlServiceExA_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ControlServiceExA_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hService /* [in]  */,
							enum SERVICE_CONTROL _dwControl /* [in]  */,
							uint32_t _dwInfoLevel /* [in]  */,
							union SC_RPC_SERVICE_CONTROL_IN_PARAMSA *_pControlInParams /* [in] [ref,switch_is(dwInfoLevel)] */,
							union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA *_pControlOutParams /* [out] [ref,switch_is(dwInfoLevel)] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ControlServiceExA_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ControlServiceExA_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hService = _hService;
	state->orig.in.dwControl = _dwControl;
	state->orig.in.dwInfoLevel = _dwInfoLevel;
	state->orig.in.pControlInParams = _pControlInParams;

	/* Out parameters */
	state->orig.out.pControlOutParams = _pControlOutParams;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_ControlServiceExA_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_ControlServiceExA_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ControlServiceExA_done, req);
	return req;
}

static void dcerpc_svcctl_ControlServiceExA_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_ControlServiceExA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ControlServiceExA_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_ControlServiceExA_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pControlOutParams = *state->tmp.out.pControlOutParams;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ControlServiceExA_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_svcctl_ControlServiceExA_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ControlServiceExA_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ControlServiceExA(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hService /* [in]  */,
					 enum SERVICE_CONTROL _dwControl /* [in]  */,
					 uint32_t _dwInfoLevel /* [in]  */,
					 union SC_RPC_SERVICE_CONTROL_IN_PARAMSA *_pControlInParams /* [in] [ref,switch_is(dwInfoLevel)] */,
					 union SC_RPC_SERVICE_CONTROL_OUT_PARAMSA *_pControlOutParams /* [out] [ref,switch_is(dwInfoLevel)] */,
					 WERROR *result)
{
	struct svcctl_ControlServiceExA r;
	NTSTATUS status;

	/* In parameters */
	r.in.hService = _hService;
	r.in.dwControl = _dwControl;
	r.in.dwInfoLevel = _dwInfoLevel;
	r.in.pControlInParams = _pControlInParams;

	/* Out parameters */
	r.out.pControlOutParams = _pControlOutParams;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_ControlServiceExA_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pControlOutParams = *r.out.pControlOutParams;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_ControlServiceExW_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ControlServiceExW_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ControlServiceExW_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_ControlServiceExW *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ControlServiceExW_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ControlServiceExW_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CONTROLSERVICEEXW, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ControlServiceExW_r_done, req);

	return req;
}

static void dcerpc_svcctl_ControlServiceExW_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ControlServiceExW_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_ControlServiceExW_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_ControlServiceExW_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ControlServiceExW_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_ControlServiceExW *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CONTROLSERVICEEXW, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_ControlServiceExW_state {
	struct svcctl_ControlServiceExW orig;
	struct svcctl_ControlServiceExW tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_ControlServiceExW_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_ControlServiceExW_send(TALLOC_CTX *mem_ctx,
							struct tevent_context *ev,
							struct dcerpc_binding_handle *h,
							struct policy_handle _hService /* [in]  */,
							enum SERVICE_CONTROL _dwControl /* [in]  */,
							uint32_t _dwInfoLevel /* [in]  */,
							union SC_RPC_SERVICE_CONTROL_IN_PARAMSW *_pControlInParams /* [in] [ref,switch_is(dwInfoLevel)] */,
							union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW *_pControlOutParams /* [out] [ref,switch_is(dwInfoLevel)] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_ControlServiceExW_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_ControlServiceExW_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hService = _hService;
	state->orig.in.dwControl = _dwControl;
	state->orig.in.dwInfoLevel = _dwInfoLevel;
	state->orig.in.pControlInParams = _pControlInParams;

	/* Out parameters */
	state->orig.out.pControlOutParams = _pControlOutParams;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_ControlServiceExW_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_ControlServiceExW_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_ControlServiceExW_done, req);
	return req;
}

static void dcerpc_svcctl_ControlServiceExW_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_ControlServiceExW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ControlServiceExW_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_ControlServiceExW_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pControlOutParams = *state->tmp.out.pControlOutParams;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_ControlServiceExW_recv(struct tevent_req *req,
					      TALLOC_CTX *mem_ctx,
					      WERROR *result)
{
	struct dcerpc_svcctl_ControlServiceExW_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_ControlServiceExW_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_ControlServiceExW(struct dcerpc_binding_handle *h,
					 TALLOC_CTX *mem_ctx,
					 struct policy_handle _hService /* [in]  */,
					 enum SERVICE_CONTROL _dwControl /* [in]  */,
					 uint32_t _dwInfoLevel /* [in]  */,
					 union SC_RPC_SERVICE_CONTROL_IN_PARAMSW *_pControlInParams /* [in] [ref,switch_is(dwInfoLevel)] */,
					 union SC_RPC_SERVICE_CONTROL_OUT_PARAMSW *_pControlOutParams /* [out] [ref,switch_is(dwInfoLevel)] */,
					 WERROR *result)
{
	struct svcctl_ControlServiceExW r;
	NTSTATUS status;

	/* In parameters */
	r.in.hService = _hService;
	r.in.dwControl = _dwControl;
	r.in.dwInfoLevel = _dwInfoLevel;
	r.in.pControlInParams = _pControlInParams;

	/* Out parameters */
	r.out.pControlOutParams = _pControlOutParams;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_ControlServiceExW_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pControlOutParams = *r.out.pControlOutParams;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum52NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum52NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum52NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum52NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum52NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum52NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM52NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum52NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum52NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum52NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum52NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum52NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum52NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum52NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM52NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum52NotUsedOnWire_state {
	struct Opnum52NotUsedOnWire orig;
	struct Opnum52NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum52NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum52NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum52NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum52NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum52NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum52NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum52NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum52NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum52NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum52NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum52NotUsedOnWire_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum52NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum52NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum52NotUsedOnWire(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx)
{
	struct Opnum52NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	status = dcerpc_Opnum52NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_Opnum53NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum53NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum53NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum53NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum53NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum53NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM53NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum53NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum53NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum53NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum53NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum53NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum53NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum53NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM53NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum53NotUsedOnWire_state {
	struct Opnum53NotUsedOnWire orig;
	struct Opnum53NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum53NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum53NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum53NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum53NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum53NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum53NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum53NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum53NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum53NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum53NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum53NotUsedOnWire_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum53NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum53NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum53NotUsedOnWire(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx)
{
	struct Opnum53NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	status = dcerpc_Opnum53NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_Opnum54NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum54NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum54NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum54NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum54NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum54NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM54NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum54NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum54NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum54NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum54NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum54NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum54NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum54NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM54NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum54NotUsedOnWire_state {
	struct Opnum54NotUsedOnWire orig;
	struct Opnum54NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum54NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum54NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum54NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum54NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum54NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum54NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum54NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum54NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum54NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum54NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum54NotUsedOnWire_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum54NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum54NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum54NotUsedOnWire(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx)
{
	struct Opnum54NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	status = dcerpc_Opnum54NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_Opnum55NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum55NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum55NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum55NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum55NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum55NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM55NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum55NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum55NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum55NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum55NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum55NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum55NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum55NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM55NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum55NotUsedOnWire_state {
	struct Opnum55NotUsedOnWire orig;
	struct Opnum55NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum55NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum55NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum55NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum55NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum55NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum55NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum55NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum55NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum55NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum55NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum55NotUsedOnWire_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum55NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum55NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum55NotUsedOnWire(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx)
{
	struct Opnum55NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	status = dcerpc_Opnum55NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_QueryServiceConfigEx_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfigEx_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfigEx_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_QueryServiceConfigEx *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfigEx_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfigEx_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIGEX, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfigEx_r_done, req);

	return req;
}

static void dcerpc_svcctl_QueryServiceConfigEx_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigEx_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_QueryServiceConfigEx_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_QueryServiceConfigEx_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigEx_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_QueryServiceConfigEx *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_QUERYSERVICECONFIGEX, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_QueryServiceConfigEx_state {
	struct svcctl_QueryServiceConfigEx orig;
	struct svcctl_QueryServiceConfigEx tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_QueryServiceConfigEx_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_QueryServiceConfigEx_send(TALLOC_CTX *mem_ctx,
							   struct tevent_context *ev,
							   struct dcerpc_binding_handle *h,
							   struct policy_handle _hService /* [in]  */,
							   uint32_t _dwInfoLevel /* [in]  */,
							   struct SC_RPC_CONFIG_INFOW *_pInfo /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_QueryServiceConfigEx_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_QueryServiceConfigEx_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hService = _hService;
	state->orig.in.dwInfoLevel = _dwInfoLevel;

	/* Out parameters */
	state->orig.out.pInfo = _pInfo;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_QueryServiceConfigEx_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_QueryServiceConfigEx_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_QueryServiceConfigEx_done, req);
	return req;
}

static void dcerpc_svcctl_QueryServiceConfigEx_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_QueryServiceConfigEx_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfigEx_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_QueryServiceConfigEx_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pInfo = *state->tmp.out.pInfo;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigEx_recv(struct tevent_req *req,
						 TALLOC_CTX *mem_ctx,
						 WERROR *result)
{
	struct dcerpc_svcctl_QueryServiceConfigEx_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_QueryServiceConfigEx_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_QueryServiceConfigEx(struct dcerpc_binding_handle *h,
					    TALLOC_CTX *mem_ctx,
					    struct policy_handle _hService /* [in]  */,
					    uint32_t _dwInfoLevel /* [in]  */,
					    struct SC_RPC_CONFIG_INFOW *_pInfo /* [out] [ref] */,
					    WERROR *result)
{
	struct svcctl_QueryServiceConfigEx r;
	NTSTATUS status;

	/* In parameters */
	r.in.hService = _hService;
	r.in.dwInfoLevel = _dwInfoLevel;

	/* Out parameters */
	r.out.pInfo = _pInfo;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_QueryServiceConfigEx_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pInfo = *r.out.pInfo;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_Opnum57NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum57NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum57NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum57NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum57NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum57NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM57NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum57NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum57NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum57NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum57NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum57NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum57NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum57NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM57NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum57NotUsedOnWire_state {
	struct Opnum57NotUsedOnWire orig;
	struct Opnum57NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum57NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum57NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum57NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum57NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum57NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum57NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum57NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum57NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum57NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum57NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum57NotUsedOnWire_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum57NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum57NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum57NotUsedOnWire(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx)
{
	struct Opnum57NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	status = dcerpc_Opnum57NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_Opnum58NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum58NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum58NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum58NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum58NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum58NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM58NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum58NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum58NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum58NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum58NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum58NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum58NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum58NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM58NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum58NotUsedOnWire_state {
	struct Opnum58NotUsedOnWire orig;
	struct Opnum58NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum58NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum58NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum58NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum58NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum58NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum58NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum58NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum58NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum58NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum58NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum58NotUsedOnWire_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum58NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum58NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum58NotUsedOnWire(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx)
{
	struct Opnum58NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	status = dcerpc_Opnum58NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_Opnum59NotUsedOnWire_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum59NotUsedOnWire_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum59NotUsedOnWire_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct Opnum59NotUsedOnWire *r)
{
	struct tevent_req *req;
	struct dcerpc_Opnum59NotUsedOnWire_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum59NotUsedOnWire_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM59NOTUSEDONWIRE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum59NotUsedOnWire_r_done, req);

	return req;
}

static void dcerpc_Opnum59NotUsedOnWire_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum59NotUsedOnWire_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum59NotUsedOnWire_r_state *state =
		tevent_req_data(req,
		struct dcerpc_Opnum59NotUsedOnWire_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum59NotUsedOnWire_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct Opnum59NotUsedOnWire *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_OPNUM59NOTUSEDONWIRE, mem_ctx, r);

	return status;
}

struct dcerpc_Opnum59NotUsedOnWire_state {
	struct Opnum59NotUsedOnWire orig;
	struct Opnum59NotUsedOnWire tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_Opnum59NotUsedOnWire_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_Opnum59NotUsedOnWire_send(TALLOC_CTX *mem_ctx,
						    struct tevent_context *ev,
						    struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_Opnum59NotUsedOnWire_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_Opnum59NotUsedOnWire_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_Opnum59NotUsedOnWire_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_Opnum59NotUsedOnWire_done, req);
	return req;
}

static void dcerpc_Opnum59NotUsedOnWire_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_Opnum59NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum59NotUsedOnWire_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_Opnum59NotUsedOnWire_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_Opnum59NotUsedOnWire_recv(struct tevent_req *req,
					  TALLOC_CTX *mem_ctx)
{
	struct dcerpc_Opnum59NotUsedOnWire_state *state = tevent_req_data(
		req, struct dcerpc_Opnum59NotUsedOnWire_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_Opnum59NotUsedOnWire(struct dcerpc_binding_handle *h,
				     TALLOC_CTX *mem_ctx)
{
	struct Opnum59NotUsedOnWire r;
	NTSTATUS status;

	/* In parameters */

	/* Out parameters */

	status = dcerpc_Opnum59NotUsedOnWire_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_CreateWowService_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateWowService_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateWowService_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_CreateWowService *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateWowService_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateWowService_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATEWOWSERVICE, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateWowService_r_done, req);

	return req;
}

static void dcerpc_svcctl_CreateWowService_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateWowService_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_CreateWowService_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_CreateWowService_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateWowService_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_CreateWowService *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_CREATEWOWSERVICE, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_CreateWowService_state {
	struct svcctl_CreateWowService orig;
	struct svcctl_CreateWowService tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_CreateWowService_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_CreateWowService_send(TALLOC_CTX *mem_ctx,
						       struct tevent_context *ev,
						       struct dcerpc_binding_handle *h,
						       struct policy_handle _hSCManager /* [in]  */,
						       const char *_lpServiceName /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),ref] */,
						       const char *_lpDisplayName /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */,
						       uint32_t _dwDesiredAccess /* [in]  */,
						       uint32_t _dwServiceType /* [in]  */,
						       uint32_t _dwStartType /* [in]  */,
						       uint32_t _dwErrorControl /* [in]  */,
						       const char *_lpBinaryPathName /* [in] [charset(UTF16),range(0,SC_MAX_PATH_LENGTH),ref] */,
						       const char *_lpLoadOrderGroup /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */,
						       uint32_t *_lpdwTagId /* [in,out] [unique] */,
						       uint8_t *_lpDependencies /* [in] [size_is(dwDependSize),unique] */,
						       uint32_t _dwDependSize /* [in] [range(0,SC_MAX_DEPEND_SIZE)] */,
						       const char *_lpServiceStartName /* [in] [charset(UTF16),range(0,SC_MAX_ACCOUNT_NAME_LENGTH),unique] */,
						       uint8_t *_lpPassword /* [in] [size_is(dwPwSize),unique] */,
						       uint32_t _dwPwSize /* [in] [range(0,SC_MAX_PWD_SIZE)] */,
						       uint16_t _dwServiceWowType /* [in]  */,
						       struct policy_handle *_lpServiceHandle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_CreateWowService_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_CreateWowService_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.hSCManager = _hSCManager;
	state->orig.in.lpServiceName = _lpServiceName;
	state->orig.in.lpDisplayName = _lpDisplayName;
	state->orig.in.dwDesiredAccess = _dwDesiredAccess;
	state->orig.in.dwServiceType = _dwServiceType;
	state->orig.in.dwStartType = _dwStartType;
	state->orig.in.dwErrorControl = _dwErrorControl;
	state->orig.in.lpBinaryPathName = _lpBinaryPathName;
	state->orig.in.lpLoadOrderGroup = _lpLoadOrderGroup;
	state->orig.in.lpdwTagId = _lpdwTagId;
	state->orig.in.lpDependencies = _lpDependencies;
	state->orig.in.dwDependSize = _dwDependSize;
	state->orig.in.lpServiceStartName = _lpServiceStartName;
	state->orig.in.lpPassword = _lpPassword;
	state->orig.in.dwPwSize = _dwPwSize;
	state->orig.in.dwServiceWowType = _dwServiceWowType;

	/* Out parameters */
	state->orig.out.lpdwTagId = _lpdwTagId;
	state->orig.out.lpServiceHandle = _lpServiceHandle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_CreateWowService_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_CreateWowService_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_CreateWowService_done, req);
	return req;
}

static void dcerpc_svcctl_CreateWowService_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_CreateWowService_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateWowService_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_CreateWowService_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	if (state->orig.out.lpdwTagId && state->tmp.out.lpdwTagId) {
		*state->orig.out.lpdwTagId = *state->tmp.out.lpdwTagId;
	}
	*state->orig.out.lpServiceHandle = *state->tmp.out.lpServiceHandle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_CreateWowService_recv(struct tevent_req *req,
					     TALLOC_CTX *mem_ctx,
					     WERROR *result)
{
	struct dcerpc_svcctl_CreateWowService_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_CreateWowService_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_CreateWowService(struct dcerpc_binding_handle *h,
					TALLOC_CTX *mem_ctx,
					struct policy_handle _hSCManager /* [in]  */,
					const char *_lpServiceName /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),ref] */,
					const char *_lpDisplayName /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */,
					uint32_t _dwDesiredAccess /* [in]  */,
					uint32_t _dwServiceType /* [in]  */,
					uint32_t _dwStartType /* [in]  */,
					uint32_t _dwErrorControl /* [in]  */,
					const char *_lpBinaryPathName /* [in] [charset(UTF16),range(0,SC_MAX_PATH_LENGTH),ref] */,
					const char *_lpLoadOrderGroup /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */,
					uint32_t *_lpdwTagId /* [in,out] [unique] */,
					uint8_t *_lpDependencies /* [in] [size_is(dwDependSize),unique] */,
					uint32_t _dwDependSize /* [in] [range(0,SC_MAX_DEPEND_SIZE)] */,
					const char *_lpServiceStartName /* [in] [charset(UTF16),range(0,SC_MAX_ACCOUNT_NAME_LENGTH),unique] */,
					uint8_t *_lpPassword /* [in] [size_is(dwPwSize),unique] */,
					uint32_t _dwPwSize /* [in] [range(0,SC_MAX_PWD_SIZE)] */,
					uint16_t _dwServiceWowType /* [in]  */,
					struct policy_handle *_lpServiceHandle /* [out] [ref] */,
					WERROR *result)
{
	struct svcctl_CreateWowService r;
	NTSTATUS status;

	/* In parameters */
	r.in.hSCManager = _hSCManager;
	r.in.lpServiceName = _lpServiceName;
	r.in.lpDisplayName = _lpDisplayName;
	r.in.dwDesiredAccess = _dwDesiredAccess;
	r.in.dwServiceType = _dwServiceType;
	r.in.dwStartType = _dwStartType;
	r.in.dwErrorControl = _dwErrorControl;
	r.in.lpBinaryPathName = _lpBinaryPathName;
	r.in.lpLoadOrderGroup = _lpLoadOrderGroup;
	r.in.lpdwTagId = _lpdwTagId;
	r.in.lpDependencies = _lpDependencies;
	r.in.dwDependSize = _dwDependSize;
	r.in.lpServiceStartName = _lpServiceStartName;
	r.in.lpPassword = _lpPassword;
	r.in.dwPwSize = _dwPwSize;
	r.in.dwServiceWowType = _dwServiceWowType;

	/* Out parameters */
	r.out.lpdwTagId = _lpdwTagId;
	r.out.lpServiceHandle = _lpServiceHandle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_CreateWowService_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	if (_lpdwTagId && r.out.lpdwTagId) {
		*_lpdwTagId = *r.out.lpdwTagId;
	}
	*_lpServiceHandle = *r.out.lpServiceHandle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_svcctl_OpenSCManager2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenSCManager2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenSCManager2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct svcctl_OpenSCManager2 *r)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenSCManager2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenSCManager2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSCMANAGER2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenSCManager2_r_done, req);

	return req;
}

static void dcerpc_svcctl_OpenSCManager2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenSCManager2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_svcctl_OpenSCManager2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_svcctl_OpenSCManager2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenSCManager2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct svcctl_OpenSCManager2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_svcctl,
			NDR_SVCCTL_OPENSCMANAGER2, mem_ctx, r);

	return status;
}

struct dcerpc_svcctl_OpenSCManager2_state {
	struct svcctl_OpenSCManager2 orig;
	struct svcctl_OpenSCManager2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_svcctl_OpenSCManager2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_svcctl_OpenSCManager2_send(TALLOC_CTX *mem_ctx,
						     struct tevent_context *ev,
						     struct dcerpc_binding_handle *h,
						     struct policy_handle _BindingHandle /* [in]  */,
						     const char *_DatabaseName /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */,
						     uint32_t _DesiredAccess /* [in]  */,
						     struct policy_handle *_ScmHandle /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_svcctl_OpenSCManager2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_svcctl_OpenSCManager2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.BindingHandle = _BindingHandle;
	state->orig.in.DatabaseName = _DatabaseName;
	state->orig.in.DesiredAccess = _DesiredAccess;

	/* Out parameters */
	state->orig.out.ScmHandle = _ScmHandle;

	/* Result */
	NDR_ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_svcctl_OpenSCManager2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_svcctl_OpenSCManager2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_svcctl_OpenSCManager2_done, req);
	return req;
}

static void dcerpc_svcctl_OpenSCManager2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_svcctl_OpenSCManager2_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenSCManager2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_svcctl_OpenSCManager2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (tevent_req_nterror(req, status)) {
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ScmHandle = *state->tmp.out.ScmHandle;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	NDR_ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_svcctl_OpenSCManager2_recv(struct tevent_req *req,
					   TALLOC_CTX *mem_ctx,
					   WERROR *result)
{
	struct dcerpc_svcctl_OpenSCManager2_state *state = tevent_req_data(
		req, struct dcerpc_svcctl_OpenSCManager2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_svcctl_OpenSCManager2(struct dcerpc_binding_handle *h,
				      TALLOC_CTX *mem_ctx,
				      struct policy_handle _BindingHandle /* [in]  */,
				      const char *_DatabaseName /* [in] [charset(UTF16),range(0,SC_MAX_NAME_LENGTH),unique] */,
				      uint32_t _DesiredAccess /* [in]  */,
				      struct policy_handle *_ScmHandle /* [out] [ref] */,
				      WERROR *result)
{
	struct svcctl_OpenSCManager2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.BindingHandle = _BindingHandle;
	r.in.DatabaseName = _DatabaseName;
	r.in.DesiredAccess = _DesiredAccess;

	/* Out parameters */
	r.out.ScmHandle = _ScmHandle;

	/* Result */
	NDR_ZERO_STRUCT(r.out.result);

	status = dcerpc_svcctl_OpenSCManager2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ScmHandle = *r.out.ScmHandle;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

