/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_wkssvc.h"
#include "bin/default/librpc/gen_ndr/ndr_wkssvc_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* wkssvc - dcerpc server boilerplate generated by pidl */
static NTSTATUS wkssvc__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_WKSSVC_BIND
	return DCESRV_INTERFACE_WKSSVC_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void wkssvc__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_WKSSVC_UNBIND
	DCESRV_INTERFACE_WKSSVC_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS wkssvc__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_wkssvc.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_wkssvc.calls[opnum].struct_size, "struct %s", ndr_table_wkssvc.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_wkssvc.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS wkssvc__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* wkssvc_NetWkstaGetInfo */
		struct wkssvc_NetWkstaGetInfo *r2 = (struct wkssvc_NetWkstaGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaGetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union wkssvc_NetWkstaInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wkssvc_NetWkstaGetInfo(p, r2);
		break;
	}
	case 1: { /* wkssvc_NetWkstaSetInfo */
		struct wkssvc_NetWkstaSetInfo *r2 = (struct wkssvc_NetWkstaSetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaSetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.parm_error = r2->in.parm_error;
		r2->out.result = _wkssvc_NetWkstaSetInfo(p, r2);
		break;
	}
	case 2: { /* wkssvc_NetWkstaEnumUsers */
		struct wkssvc_NetWkstaEnumUsers *r2 = (struct wkssvc_NetWkstaEnumUsers *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaEnumUsers, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = r2->in.info;
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.entries_read = talloc_zero(r2, uint32_t);
		if (r2->out.entries_read == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wkssvc_NetWkstaEnumUsers(p, r2);
		break;
	}
	case 3: { /* wkssvc_NetrWkstaUserGetInfo */
		struct wkssvc_NetrWkstaUserGetInfo *r2 = (struct wkssvc_NetrWkstaUserGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaUserGetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union wkssvc_NetrWkstaUserInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wkssvc_NetrWkstaUserGetInfo(p, r2);
		break;
	}
	case 4: { /* wkssvc_NetrWkstaUserSetInfo */
		struct wkssvc_NetrWkstaUserSetInfo *r2 = (struct wkssvc_NetrWkstaUserSetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaUserSetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.parm_err = r2->in.parm_err;
		r2->out.result = _wkssvc_NetrWkstaUserSetInfo(p, r2);
		break;
	}
	case 5: { /* wkssvc_NetWkstaTransportEnum */
		struct wkssvc_NetWkstaTransportEnum *r2 = (struct wkssvc_NetWkstaTransportEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaTransportEnum, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = r2->in.info;
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.total_entries = talloc_zero(r2, uint32_t);
		if (r2->out.total_entries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wkssvc_NetWkstaTransportEnum(p, r2);
		break;
	}
	case 6: { /* wkssvc_NetrWkstaTransportAdd */
		struct wkssvc_NetrWkstaTransportAdd *r2 = (struct wkssvc_NetrWkstaTransportAdd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaTransportAdd, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.parm_err = r2->in.parm_err;
		r2->out.result = _wkssvc_NetrWkstaTransportAdd(p, r2);
		break;
	}
	case 7: { /* wkssvc_NetrWkstaTransportDel */
		struct wkssvc_NetrWkstaTransportDel *r2 = (struct wkssvc_NetrWkstaTransportDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaTransportDel, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrWkstaTransportDel(p, r2);
		break;
	}
	case 8: { /* wkssvc_NetrUseAdd */
		struct wkssvc_NetrUseAdd *r2 = (struct wkssvc_NetrUseAdd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseAdd, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.parm_err = r2->in.parm_err;
		r2->out.result = _wkssvc_NetrUseAdd(p, r2);
		break;
	}
	case 9: { /* wkssvc_NetrUseGetInfo */
		struct wkssvc_NetrUseGetInfo *r2 = (struct wkssvc_NetrUseGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseGetInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ctr = talloc_zero(r2, union wkssvc_NetrUseGetInfoCtr);
		if (r2->out.ctr == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wkssvc_NetrUseGetInfo(p, r2);
		break;
	}
	case 10: { /* wkssvc_NetrUseDel */
		struct wkssvc_NetrUseDel *r2 = (struct wkssvc_NetrUseDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseDel, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrUseDel(p, r2);
		break;
	}
	case 11: { /* wkssvc_NetrUseEnum */
		struct wkssvc_NetrUseEnum *r2 = (struct wkssvc_NetrUseEnum *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseEnum, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = r2->in.info;
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.entries_read = talloc_zero(r2, uint32_t);
		if (r2->out.entries_read == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wkssvc_NetrUseEnum(p, r2);
		break;
	}
	case 12: { /* wkssvc_NetrMessageBufferSend */
		struct wkssvc_NetrMessageBufferSend *r2 = (struct wkssvc_NetrMessageBufferSend *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrMessageBufferSend, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrMessageBufferSend(p, r2);
		break;
	}
	case 13: { /* wkssvc_NetrWorkstationStatisticsGet */
		struct wkssvc_NetrWorkstationStatisticsGet *r2 = (struct wkssvc_NetrWorkstationStatisticsGet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWorkstationStatisticsGet, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, struct wkssvc_NetrWorkstationStatistics *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wkssvc_NetrWorkstationStatisticsGet(p, r2);
		break;
	}
	case 14: { /* wkssvc_NetrLogonDomainNameAdd */
		struct wkssvc_NetrLogonDomainNameAdd *r2 = (struct wkssvc_NetrLogonDomainNameAdd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrLogonDomainNameAdd, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrLogonDomainNameAdd(p, r2);
		break;
	}
	case 15: { /* wkssvc_NetrLogonDomainNameDel */
		struct wkssvc_NetrLogonDomainNameDel *r2 = (struct wkssvc_NetrLogonDomainNameDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrLogonDomainNameDel, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrLogonDomainNameDel(p, r2);
		break;
	}
	case 16: { /* wkssvc_NetrJoinDomain */
		struct wkssvc_NetrJoinDomain *r2 = (struct wkssvc_NetrJoinDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrJoinDomain, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrJoinDomain(p, r2);
		break;
	}
	case 17: { /* wkssvc_NetrUnjoinDomain */
		struct wkssvc_NetrUnjoinDomain *r2 = (struct wkssvc_NetrUnjoinDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUnjoinDomain, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrUnjoinDomain(p, r2);
		break;
	}
	case 18: { /* wkssvc_NetrRenameMachineInDomain */
		struct wkssvc_NetrRenameMachineInDomain *r2 = (struct wkssvc_NetrRenameMachineInDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRenameMachineInDomain, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrRenameMachineInDomain(p, r2);
		break;
	}
	case 19: { /* wkssvc_NetrValidateName */
		struct wkssvc_NetrValidateName *r2 = (struct wkssvc_NetrValidateName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrValidateName, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrValidateName(p, r2);
		break;
	}
	case 20: { /* wkssvc_NetrGetJoinInformation */
		struct wkssvc_NetrGetJoinInformation *r2 = (struct wkssvc_NetrGetJoinInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrGetJoinInformation, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.name_buffer = r2->in.name_buffer;
		r2->out.name_type = talloc_zero(r2, enum wkssvc_NetJoinStatus);
		if (r2->out.name_type == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wkssvc_NetrGetJoinInformation(p, r2);
		break;
	}
	case 21: { /* wkssvc_NetrGetJoinableOus */
		struct wkssvc_NetrGetJoinableOus *r2 = (struct wkssvc_NetrGetJoinableOus *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrGetJoinableOus, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.num_ous = r2->in.num_ous;
		r2->out.ous = talloc_zero(r2, const char **);
		if (r2->out.ous == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wkssvc_NetrGetJoinableOus(p, r2);
		break;
	}
	case 22: { /* wkssvc_NetrJoinDomain2 */
		struct wkssvc_NetrJoinDomain2 *r2 = (struct wkssvc_NetrJoinDomain2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrJoinDomain2, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrJoinDomain2(p, r2);
		break;
	}
	case 23: { /* wkssvc_NetrUnjoinDomain2 */
		struct wkssvc_NetrUnjoinDomain2 *r2 = (struct wkssvc_NetrUnjoinDomain2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUnjoinDomain2, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrUnjoinDomain2(p, r2);
		break;
	}
	case 24: { /* wkssvc_NetrRenameMachineInDomain2 */
		struct wkssvc_NetrRenameMachineInDomain2 *r2 = (struct wkssvc_NetrRenameMachineInDomain2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRenameMachineInDomain2, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrRenameMachineInDomain2(p, r2);
		break;
	}
	case 25: { /* wkssvc_NetrValidateName2 */
		struct wkssvc_NetrValidateName2 *r2 = (struct wkssvc_NetrValidateName2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrValidateName2, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrValidateName2(p, r2);
		break;
	}
	case 26: { /* wkssvc_NetrGetJoinableOus2 */
		struct wkssvc_NetrGetJoinableOus2 *r2 = (struct wkssvc_NetrGetJoinableOus2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrGetJoinableOus2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.num_ous = r2->in.num_ous;
		r2->out.ous = talloc_zero(r2, const char **);
		if (r2->out.ous == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wkssvc_NetrGetJoinableOus2(p, r2);
		break;
	}
	case 27: { /* wkssvc_NetrAddAlternateComputerName */
		struct wkssvc_NetrAddAlternateComputerName *r2 = (struct wkssvc_NetrAddAlternateComputerName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrAddAlternateComputerName, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrAddAlternateComputerName(p, r2);
		break;
	}
	case 28: { /* wkssvc_NetrRemoveAlternateComputerName */
		struct wkssvc_NetrRemoveAlternateComputerName *r2 = (struct wkssvc_NetrRemoveAlternateComputerName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRemoveAlternateComputerName, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrRemoveAlternateComputerName(p, r2);
		break;
	}
	case 29: { /* wkssvc_NetrSetPrimaryComputername */
		struct wkssvc_NetrSetPrimaryComputername *r2 = (struct wkssvc_NetrSetPrimaryComputername *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrSetPrimaryComputername, NDR_IN, r2);
		}
		r2->out.result = _wkssvc_NetrSetPrimaryComputername(p, r2);
		break;
	}
	case 30: { /* wkssvc_NetrEnumerateComputerNames */
		struct wkssvc_NetrEnumerateComputerNames *r2 = (struct wkssvc_NetrEnumerateComputerNames *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrEnumerateComputerNames, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ctr = talloc_zero(r2, struct wkssvc_ComputerNamesCtr *);
		if (r2->out.ctr == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _wkssvc_NetrEnumerateComputerNames(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS wkssvc__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return wkssvc__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS wkssvc__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* wkssvc_NetWkstaGetInfo */
		struct wkssvc_NetWkstaGetInfo *r2 = (struct wkssvc_NetWkstaGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetWkstaGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* wkssvc_NetWkstaSetInfo */
		struct wkssvc_NetWkstaSetInfo *r2 = (struct wkssvc_NetWkstaSetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaSetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaSetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetWkstaSetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* wkssvc_NetWkstaEnumUsers */
		struct wkssvc_NetWkstaEnumUsers *r2 = (struct wkssvc_NetWkstaEnumUsers *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaEnumUsers replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaEnumUsers, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetWkstaEnumUsers\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* wkssvc_NetrWkstaUserGetInfo */
		struct wkssvc_NetrWkstaUserGetInfo *r2 = (struct wkssvc_NetrWkstaUserGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWkstaUserGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaUserGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrWkstaUserGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* wkssvc_NetrWkstaUserSetInfo */
		struct wkssvc_NetrWkstaUserSetInfo *r2 = (struct wkssvc_NetrWkstaUserSetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWkstaUserSetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaUserSetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrWkstaUserSetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* wkssvc_NetWkstaTransportEnum */
		struct wkssvc_NetWkstaTransportEnum *r2 = (struct wkssvc_NetWkstaTransportEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetWkstaTransportEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetWkstaTransportEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetWkstaTransportEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* wkssvc_NetrWkstaTransportAdd */
		struct wkssvc_NetrWkstaTransportAdd *r2 = (struct wkssvc_NetrWkstaTransportAdd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWkstaTransportAdd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaTransportAdd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrWkstaTransportAdd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* wkssvc_NetrWkstaTransportDel */
		struct wkssvc_NetrWkstaTransportDel *r2 = (struct wkssvc_NetrWkstaTransportDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWkstaTransportDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWkstaTransportDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrWkstaTransportDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* wkssvc_NetrUseAdd */
		struct wkssvc_NetrUseAdd *r2 = (struct wkssvc_NetrUseAdd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUseAdd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseAdd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrUseAdd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* wkssvc_NetrUseGetInfo */
		struct wkssvc_NetrUseGetInfo *r2 = (struct wkssvc_NetrUseGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUseGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrUseGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* wkssvc_NetrUseDel */
		struct wkssvc_NetrUseDel *r2 = (struct wkssvc_NetrUseDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUseDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrUseDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 11: { /* wkssvc_NetrUseEnum */
		struct wkssvc_NetrUseEnum *r2 = (struct wkssvc_NetrUseEnum *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUseEnum replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUseEnum, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrUseEnum\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 12: { /* wkssvc_NetrMessageBufferSend */
		struct wkssvc_NetrMessageBufferSend *r2 = (struct wkssvc_NetrMessageBufferSend *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrMessageBufferSend replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrMessageBufferSend, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrMessageBufferSend\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 13: { /* wkssvc_NetrWorkstationStatisticsGet */
		struct wkssvc_NetrWorkstationStatisticsGet *r2 = (struct wkssvc_NetrWorkstationStatisticsGet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrWorkstationStatisticsGet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrWorkstationStatisticsGet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrWorkstationStatisticsGet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 14: { /* wkssvc_NetrLogonDomainNameAdd */
		struct wkssvc_NetrLogonDomainNameAdd *r2 = (struct wkssvc_NetrLogonDomainNameAdd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrLogonDomainNameAdd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrLogonDomainNameAdd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrLogonDomainNameAdd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 15: { /* wkssvc_NetrLogonDomainNameDel */
		struct wkssvc_NetrLogonDomainNameDel *r2 = (struct wkssvc_NetrLogonDomainNameDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrLogonDomainNameDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrLogonDomainNameDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrLogonDomainNameDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 16: { /* wkssvc_NetrJoinDomain */
		struct wkssvc_NetrJoinDomain *r2 = (struct wkssvc_NetrJoinDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrJoinDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrJoinDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrJoinDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 17: { /* wkssvc_NetrUnjoinDomain */
		struct wkssvc_NetrUnjoinDomain *r2 = (struct wkssvc_NetrUnjoinDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUnjoinDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUnjoinDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrUnjoinDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 18: { /* wkssvc_NetrRenameMachineInDomain */
		struct wkssvc_NetrRenameMachineInDomain *r2 = (struct wkssvc_NetrRenameMachineInDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrRenameMachineInDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRenameMachineInDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrRenameMachineInDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 19: { /* wkssvc_NetrValidateName */
		struct wkssvc_NetrValidateName *r2 = (struct wkssvc_NetrValidateName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrValidateName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrValidateName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrValidateName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 20: { /* wkssvc_NetrGetJoinInformation */
		struct wkssvc_NetrGetJoinInformation *r2 = (struct wkssvc_NetrGetJoinInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrGetJoinInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrGetJoinInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrGetJoinInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 21: { /* wkssvc_NetrGetJoinableOus */
		struct wkssvc_NetrGetJoinableOus *r2 = (struct wkssvc_NetrGetJoinableOus *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrGetJoinableOus replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrGetJoinableOus, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrGetJoinableOus\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 22: { /* wkssvc_NetrJoinDomain2 */
		struct wkssvc_NetrJoinDomain2 *r2 = (struct wkssvc_NetrJoinDomain2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrJoinDomain2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrJoinDomain2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrJoinDomain2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 23: { /* wkssvc_NetrUnjoinDomain2 */
		struct wkssvc_NetrUnjoinDomain2 *r2 = (struct wkssvc_NetrUnjoinDomain2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrUnjoinDomain2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrUnjoinDomain2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrUnjoinDomain2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 24: { /* wkssvc_NetrRenameMachineInDomain2 */
		struct wkssvc_NetrRenameMachineInDomain2 *r2 = (struct wkssvc_NetrRenameMachineInDomain2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrRenameMachineInDomain2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRenameMachineInDomain2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrRenameMachineInDomain2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 25: { /* wkssvc_NetrValidateName2 */
		struct wkssvc_NetrValidateName2 *r2 = (struct wkssvc_NetrValidateName2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrValidateName2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrValidateName2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrValidateName2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 26: { /* wkssvc_NetrGetJoinableOus2 */
		struct wkssvc_NetrGetJoinableOus2 *r2 = (struct wkssvc_NetrGetJoinableOus2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrGetJoinableOus2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrGetJoinableOus2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrGetJoinableOus2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 27: { /* wkssvc_NetrAddAlternateComputerName */
		struct wkssvc_NetrAddAlternateComputerName *r2 = (struct wkssvc_NetrAddAlternateComputerName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrAddAlternateComputerName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrAddAlternateComputerName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrAddAlternateComputerName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 28: { /* wkssvc_NetrRemoveAlternateComputerName */
		struct wkssvc_NetrRemoveAlternateComputerName *r2 = (struct wkssvc_NetrRemoveAlternateComputerName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrRemoveAlternateComputerName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrRemoveAlternateComputerName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrRemoveAlternateComputerName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 29: { /* wkssvc_NetrSetPrimaryComputername */
		struct wkssvc_NetrSetPrimaryComputername *r2 = (struct wkssvc_NetrSetPrimaryComputername *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrSetPrimaryComputername replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrSetPrimaryComputername, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrSetPrimaryComputername\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 30: { /* wkssvc_NetrEnumerateComputerNames */
		struct wkssvc_NetrEnumerateComputerNames *r2 = (struct wkssvc_NetrEnumerateComputerNames *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function wkssvc_NetrEnumerateComputerNames replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(wkssvc_NetrEnumerateComputerNames, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in wkssvc_NetrEnumerateComputerNames\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS wkssvc__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_wkssvc.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS wkssvc__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return wkssvc__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_wkssvc_interface = {
	.name      = "wkssvc",
	.syntax_id = {{0x6bffd098,0xa112,0x3610,{0x98,0x33},{0x46,0xc3,0xf8,0x7e,0x34,0x5a}},1.0},
	.bind      = wkssvc__op_bind,
	.unbind    = wkssvc__op_unbind,
	.ndr_pull  = wkssvc__op_ndr_pull,
	.dispatch  = wkssvc__op_dispatch,
	.reply     = wkssvc__op_reply,
	.ndr_push  = wkssvc__op_ndr_push,
	.local     = wkssvc__op_local,
#ifdef DCESRV_INTERFACE_WKSSVC_FLAGS
	.flags     = DCESRV_INTERFACE_WKSSVC_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS wkssvc__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_WKSSVC_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_WKSSVC_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_wkssvc.endpoints->count;i++) {
		const char *name = ndr_table_wkssvc.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_wkssvc_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS wkssvc__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool wkssvc__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_wkssvc_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_wkssvc_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_wkssvc_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool wkssvc__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_wkssvc_interface.name, name)==0) {
		memcpy(iface, &dcesrv_wkssvc_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server wkssvc_ep_server = {
	/* fill in our name */
	.name = "wkssvc",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_WKSSVC_INIT_SERVER
	.init_server = DCESRV_INTERFACE_WKSSVC_INIT_SERVER,
#else
	.init_server = wkssvc__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_WKSSVC_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_WKSSVC_SHUTDOWN_SERVER,
#else
	.shutdown_server = wkssvc__op_shutdown_server,
#endif
	.interface_by_uuid = wkssvc__op_interface_by_uuid,
	.interface_by_name = wkssvc__op_interface_by_name
};

const struct dcesrv_endpoint_server *wkssvc_get_ep_server(void)
{
	return &wkssvc_ep_server;
}
