
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_auth.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
#include "librpc/gen_ndr/security.h"
#include "librpc/gen_ndr/lsa.h"
#include "librpc/gen_ndr/krb5pac.h"
static PyTypeObject auth_user_info_Type;
static PyTypeObject auth_user_info_torture_Type;
static PyTypeObject auth_user_info_unix_Type;
static PyTypeObject auth_SidAttr_Type;
static PyTypeObject auth_user_info_dc_Type;
static PyTypeObject auth_session_info_Type;
static PyTypeObject auth_session_info_transport_Type;

static PyTypeObject *BaseObject_Type;
static PyTypeObject *dom_sid_Type;
static PyTypeObject *security_token_Type;
static PyTypeObject *security_unix_token_Type;
static PyTypeObject *GUID_Type;
#include "librpc/ndr/py_auth.c"


static PyObject *py_auth_user_info_get_account_name(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_account_name;
	if (object->account_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->account_name == NULL) {
		py_account_name = Py_None;
		Py_INCREF(py_account_name);
	} else {
		if (object->account_name == NULL) {
			py_account_name = Py_None;
			Py_INCREF(py_account_name);
		} else {
			py_account_name = PyUnicode_Decode(object->account_name, strlen(object->account_name), "utf-8", "ignore");
		}
	}
	return py_account_name;
}

static int py_auth_user_info_set_account_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->account_name");
		return -1;
	}
	if (value == Py_None) {
		object->account_name = NULL;
	} else {
		object->account_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->account_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_user_principal_name(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_user_principal_name;
	if (object->user_principal_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->user_principal_name == NULL) {
		py_user_principal_name = Py_None;
		Py_INCREF(py_user_principal_name);
	} else {
		if (object->user_principal_name == NULL) {
			py_user_principal_name = Py_None;
			Py_INCREF(py_user_principal_name);
		} else {
			py_user_principal_name = PyUnicode_Decode(object->user_principal_name, strlen(object->user_principal_name), "utf-8", "ignore");
		}
	}
	return py_user_principal_name;
}

static int py_auth_user_info_set_user_principal_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_principal_name");
		return -1;
	}
	if (value == Py_None) {
		object->user_principal_name = NULL;
	} else {
		object->user_principal_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->user_principal_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_user_principal_constructed(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_user_principal_constructed;
	py_user_principal_constructed = PyLong_FromLong((uint16_t)(object->user_principal_constructed));
	return py_user_principal_constructed;
}

static int py_auth_user_info_set_user_principal_constructed(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_principal_constructed");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->user_principal_constructed));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->user_principal_constructed = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_domain_name(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_domain_name;
	if (object->domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->domain_name == NULL) {
		py_domain_name = Py_None;
		Py_INCREF(py_domain_name);
	} else {
		if (object->domain_name == NULL) {
			py_domain_name = Py_None;
			Py_INCREF(py_domain_name);
		} else {
			py_domain_name = PyUnicode_Decode(object->domain_name, strlen(object->domain_name), "utf-8", "ignore");
		}
	}
	return py_domain_name;
}

static int py_auth_user_info_set_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->domain_name");
		return -1;
	}
	if (value == Py_None) {
		object->domain_name = NULL;
	} else {
		object->domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->domain_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_dns_domain_name(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_dns_domain_name;
	if (object->dns_domain_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->dns_domain_name == NULL) {
		py_dns_domain_name = Py_None;
		Py_INCREF(py_dns_domain_name);
	} else {
		if (object->dns_domain_name == NULL) {
			py_dns_domain_name = Py_None;
			Py_INCREF(py_dns_domain_name);
		} else {
			py_dns_domain_name = PyUnicode_Decode(object->dns_domain_name, strlen(object->dns_domain_name), "utf-8", "ignore");
		}
	}
	return py_dns_domain_name;
}

static int py_auth_user_info_set_dns_domain_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dns_domain_name");
		return -1;
	}
	if (value == Py_None) {
		object->dns_domain_name = NULL;
	} else {
		object->dns_domain_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->dns_domain_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_full_name(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_full_name;
	if (object->full_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->full_name == NULL) {
		py_full_name = Py_None;
		Py_INCREF(py_full_name);
	} else {
		if (object->full_name == NULL) {
			py_full_name = Py_None;
			Py_INCREF(py_full_name);
		} else {
			py_full_name = PyUnicode_Decode(object->full_name, strlen(object->full_name), "utf-8", "ignore");
		}
	}
	return py_full_name;
}

static int py_auth_user_info_set_full_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->full_name");
		return -1;
	}
	if (value == Py_None) {
		object->full_name = NULL;
	} else {
		object->full_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->full_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_logon_script(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_script;
	if (object->logon_script == NULL) {
		Py_RETURN_NONE;
	}
	if (object->logon_script == NULL) {
		py_logon_script = Py_None;
		Py_INCREF(py_logon_script);
	} else {
		if (object->logon_script == NULL) {
			py_logon_script = Py_None;
			Py_INCREF(py_logon_script);
		} else {
			py_logon_script = PyUnicode_Decode(object->logon_script, strlen(object->logon_script), "utf-8", "ignore");
		}
	}
	return py_logon_script;
}

static int py_auth_user_info_set_logon_script(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_script");
		return -1;
	}
	if (value == Py_None) {
		object->logon_script = NULL;
	} else {
		object->logon_script = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->logon_script = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_profile_path(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_profile_path;
	if (object->profile_path == NULL) {
		Py_RETURN_NONE;
	}
	if (object->profile_path == NULL) {
		py_profile_path = Py_None;
		Py_INCREF(py_profile_path);
	} else {
		if (object->profile_path == NULL) {
			py_profile_path = Py_None;
			Py_INCREF(py_profile_path);
		} else {
			py_profile_path = PyUnicode_Decode(object->profile_path, strlen(object->profile_path), "utf-8", "ignore");
		}
	}
	return py_profile_path;
}

static int py_auth_user_info_set_profile_path(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->profile_path");
		return -1;
	}
	if (value == Py_None) {
		object->profile_path = NULL;
	} else {
		object->profile_path = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->profile_path = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_home_directory(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_home_directory;
	if (object->home_directory == NULL) {
		Py_RETURN_NONE;
	}
	if (object->home_directory == NULL) {
		py_home_directory = Py_None;
		Py_INCREF(py_home_directory);
	} else {
		if (object->home_directory == NULL) {
			py_home_directory = Py_None;
			Py_INCREF(py_home_directory);
		} else {
			py_home_directory = PyUnicode_Decode(object->home_directory, strlen(object->home_directory), "utf-8", "ignore");
		}
	}
	return py_home_directory;
}

static int py_auth_user_info_set_home_directory(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_directory");
		return -1;
	}
	if (value == Py_None) {
		object->home_directory = NULL;
	} else {
		object->home_directory = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->home_directory = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_home_drive(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_home_drive;
	if (object->home_drive == NULL) {
		Py_RETURN_NONE;
	}
	if (object->home_drive == NULL) {
		py_home_drive = Py_None;
		Py_INCREF(py_home_drive);
	} else {
		if (object->home_drive == NULL) {
			py_home_drive = Py_None;
			Py_INCREF(py_home_drive);
		} else {
			py_home_drive = PyUnicode_Decode(object->home_drive, strlen(object->home_drive), "utf-8", "ignore");
		}
	}
	return py_home_drive;
}

static int py_auth_user_info_set_home_drive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->home_drive");
		return -1;
	}
	if (value == Py_None) {
		object->home_drive = NULL;
	} else {
		object->home_drive = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->home_drive = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_logon_server(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_server;
	if (object->logon_server == NULL) {
		Py_RETURN_NONE;
	}
	if (object->logon_server == NULL) {
		py_logon_server = Py_None;
		Py_INCREF(py_logon_server);
	} else {
		if (object->logon_server == NULL) {
			py_logon_server = Py_None;
			Py_INCREF(py_logon_server);
		} else {
			py_logon_server = PyUnicode_Decode(object->logon_server, strlen(object->logon_server), "utf-8", "ignore");
		}
	}
	return py_logon_server;
}

static int py_auth_user_info_set_logon_server(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_server");
		return -1;
	}
	if (value == Py_None) {
		object->logon_server = NULL;
	} else {
		object->logon_server = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->logon_server = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_last_logon(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_last_logon;
	py_last_logon = PyLong_FromUnsignedLongLong(object->last_logon);
	return py_last_logon;
}

static int py_auth_user_info_set_last_logon(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_logon");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_logon));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_logon = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_last_logoff(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_last_logoff;
	py_last_logoff = PyLong_FromUnsignedLongLong(object->last_logoff);
	return py_last_logoff;
}

static int py_auth_user_info_set_last_logoff(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_logoff");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_logoff));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_logoff = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_acct_expiry(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_expiry;
	py_acct_expiry = PyLong_FromUnsignedLongLong(object->acct_expiry);
	return py_acct_expiry;
}

static int py_auth_user_info_set_acct_expiry(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_expiry");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_expiry));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_expiry = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_last_password_change(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_last_password_change;
	py_last_password_change = PyLong_FromUnsignedLongLong(object->last_password_change);
	return py_last_password_change;
}

static int py_auth_user_info_set_last_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->last_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->last_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->last_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_allow_password_change(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_allow_password_change;
	py_allow_password_change = PyLong_FromUnsignedLongLong(object->allow_password_change);
	return py_allow_password_change;
}

static int py_auth_user_info_set_allow_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->allow_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->allow_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->allow_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_force_password_change(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_force_password_change;
	py_force_password_change = PyLong_FromUnsignedLongLong(object->force_password_change);
	return py_force_password_change;
}

static int py_auth_user_info_set_force_password_change(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->force_password_change");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->force_password_change));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->force_password_change = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_logon_count(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_logon_count;
	py_logon_count = PyLong_FromLong((uint16_t)(object->logon_count));
	return py_logon_count;
}

static int py_auth_user_info_set_logon_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->logon_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->logon_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->logon_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_bad_password_count(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_bad_password_count;
	py_bad_password_count = PyLong_FromLong((uint16_t)(object->bad_password_count));
	return py_bad_password_count;
}

static int py_auth_user_info_set_bad_password_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bad_password_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bad_password_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bad_password_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_acct_flags(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_acct_flags;
	py_acct_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->acct_flags));
	return py_acct_flags;
}

static int py_auth_user_info_set_acct_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->acct_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->acct_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->acct_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_get_user_flags(PyObject *obj, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(obj);
	PyObject *py_user_flags;
	py_user_flags = PyLong_FromUnsignedLongLong((uint32_t)(object->user_flags));
	return py_user_flags;
}

static int py_auth_user_info_set_user_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->user_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->user_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_auth_user_info_getsetters[] = {
	{
		.name = discard_const_p(char, "account_name"),
		.get = py_auth_user_info_get_account_name,
		.set = py_auth_user_info_set_account_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "user_principal_name"),
		.get = py_auth_user_info_get_user_principal_name,
		.set = py_auth_user_info_set_user_principal_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "user_principal_constructed"),
		.get = py_auth_user_info_get_user_principal_constructed,
		.set = py_auth_user_info_set_user_principal_constructed,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "domain_name"),
		.get = py_auth_user_info_get_domain_name,
		.set = py_auth_user_info_set_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "dns_domain_name"),
		.get = py_auth_user_info_get_dns_domain_name,
		.set = py_auth_user_info_set_dns_domain_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "full_name"),
		.get = py_auth_user_info_get_full_name,
		.set = py_auth_user_info_set_full_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "logon_script"),
		.get = py_auth_user_info_get_logon_script,
		.set = py_auth_user_info_set_logon_script,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "profile_path"),
		.get = py_auth_user_info_get_profile_path,
		.set = py_auth_user_info_set_profile_path,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "home_directory"),
		.get = py_auth_user_info_get_home_directory,
		.set = py_auth_user_info_set_home_directory,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "home_drive"),
		.get = py_auth_user_info_get_home_drive,
		.set = py_auth_user_info_set_home_drive,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "logon_server"),
		.get = py_auth_user_info_get_logon_server,
		.set = py_auth_user_info_set_logon_server,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "last_logon"),
		.get = py_auth_user_info_get_last_logon,
		.set = py_auth_user_info_set_last_logon,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_logoff"),
		.get = py_auth_user_info_get_last_logoff,
		.set = py_auth_user_info_set_last_logoff,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "acct_expiry"),
		.get = py_auth_user_info_get_acct_expiry,
		.set = py_auth_user_info_set_acct_expiry,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "last_password_change"),
		.get = py_auth_user_info_get_last_password_change,
		.set = py_auth_user_info_set_last_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "allow_password_change"),
		.get = py_auth_user_info_get_allow_password_change,
		.set = py_auth_user_info_set_allow_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "force_password_change"),
		.get = py_auth_user_info_get_force_password_change,
		.set = py_auth_user_info_set_force_password_change,
		.doc = discard_const_p(char, "PIDL-generated element of base type NTTIME")
	},
	{
		.name = discard_const_p(char, "logon_count"),
		.get = py_auth_user_info_get_logon_count,
		.set = py_auth_user_info_set_logon_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "bad_password_count"),
		.get = py_auth_user_info_get_bad_password_count,
		.set = py_auth_user_info_set_bad_password_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "acct_flags"),
		.get = py_auth_user_info_get_acct_flags,
		.set = py_auth_user_info_set_acct_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "user_flags"),
		.get = py_auth_user_info_get_user_flags,
		.set = py_auth_user_info_set_user_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_auth_user_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct auth_user_info, type);
}

static PyObject *py_auth_user_info_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_auth_user_info);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_auth_user_info_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_auth_user_info_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_user_info *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_user_info, "auth_user_info", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_user_info, "auth_user_info", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_auth_user_info_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_auth_user_info_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_auth_user_info_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_auth_user_info_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject auth_user_info_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "auth.user_info",
	.tp_getset = py_auth_user_info_getsetters,
	.tp_methods = py_auth_user_info_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_auth_user_info_new,
};


static PyObject *py_auth_user_info_torture_get_num_dc_sids(PyObject *obj, void *closure)
{
	struct auth_user_info_torture *object = pytalloc_get_ptr(obj);
	PyObject *py_num_dc_sids;
	py_num_dc_sids = PyLong_FromUnsignedLongLong((uint32_t)(object->num_dc_sids));
	return py_num_dc_sids;
}

static int py_auth_user_info_torture_set_num_dc_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_torture *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_dc_sids");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_dc_sids));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_dc_sids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_torture_get_dc_sids(PyObject *obj, void *closure)
{
	struct auth_user_info_torture *object = pytalloc_get_ptr(obj);
	PyObject *py_dc_sids;
	py_dc_sids = PyList_New(object->num_dc_sids);
	if (py_dc_sids == NULL) {
		return NULL;
	}
	{
		int dc_sids_cntr_0;
		for (dc_sids_cntr_0 = 0; dc_sids_cntr_0 < (object->num_dc_sids); dc_sids_cntr_0++) {
			PyObject *py_dc_sids_0;
			py_dc_sids_0 = pytalloc_reference_ex(&auth_SidAttr_Type, object->dc_sids, &(object->dc_sids)[dc_sids_cntr_0]);
			PyList_SetItem(py_dc_sids, dc_sids_cntr_0, py_dc_sids_0);
		}
	}
	return py_dc_sids;
}

static int py_auth_user_info_torture_set_dc_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_torture *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->dc_sids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int dc_sids_cntr_0;
		object->dc_sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->dc_sids, PyList_GET_SIZE(value));
		if (!object->dc_sids) { return -1; }
		talloc_set_name_const(object->dc_sids, "ARRAY: object->dc_sids");
		for (dc_sids_cntr_0 = 0; dc_sids_cntr_0 < PyList_GET_SIZE(value); dc_sids_cntr_0++) {
			if (PyList_GET_ITEM(value, dc_sids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->dc_sids)[dc_sids_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&auth_SidAttr_Type, PyList_GET_ITEM(value, dc_sids_cntr_0), return -1;);
			if (talloc_reference(object->dc_sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, dc_sids_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->dc_sids)[dc_sids_cntr_0] = *(struct auth_SidAttr *)pytalloc_get_ptr(PyList_GET_ITEM(value, dc_sids_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_auth_user_info_torture_getsetters[] = {
	{
		.name = discard_const_p(char, "num_dc_sids"),
		.get = py_auth_user_info_torture_get_num_dc_sids,
		.set = py_auth_user_info_torture_set_num_dc_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "dc_sids"),
		.get = py_auth_user_info_torture_get_dc_sids,
		.set = py_auth_user_info_torture_set_dc_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type auth_SidAttr")
	},
	{ .name = NULL }
};

static PyObject *py_auth_user_info_torture_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct auth_user_info_torture, type);
}

static PyObject *py_auth_user_info_torture_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct auth_user_info_torture *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_auth_user_info_torture);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_auth_user_info_torture_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_user_info_torture *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info_torture);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info_torture);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_auth_user_info_torture_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_user_info_torture *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_user_info_torture, "auth_user_info_torture", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_user_info_torture, "auth_user_info_torture", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_auth_user_info_torture_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_auth_user_info_torture_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_auth_user_info_torture_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_auth_user_info_torture_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject auth_user_info_torture_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "auth.user_info_torture",
	.tp_getset = py_auth_user_info_torture_getsetters,
	.tp_methods = py_auth_user_info_torture_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_auth_user_info_torture_new,
};


static PyObject *py_auth_user_info_unix_get_unix_name(PyObject *obj, void *closure)
{
	struct auth_user_info_unix *object = pytalloc_get_ptr(obj);
	PyObject *py_unix_name;
	if (object->unix_name == NULL) {
		Py_RETURN_NONE;
	}
	if (object->unix_name == NULL) {
		py_unix_name = Py_None;
		Py_INCREF(py_unix_name);
	} else {
		if (object->unix_name == NULL) {
			py_unix_name = Py_None;
			Py_INCREF(py_unix_name);
		} else {
			py_unix_name = PyUnicode_Decode(object->unix_name, strlen(object->unix_name), "utf-8", "ignore");
		}
	}
	return py_unix_name;
}

static int py_auth_user_info_unix_set_unix_name(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_unix *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unix_name");
		return -1;
	}
	if (value == Py_None) {
		object->unix_name = NULL;
	} else {
		object->unix_name = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->unix_name = talloc_str;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_unix_get_sanitized_username(PyObject *obj, void *closure)
{
	struct auth_user_info_unix *object = pytalloc_get_ptr(obj);
	PyObject *py_sanitized_username;
	if (object->sanitized_username == NULL) {
		Py_RETURN_NONE;
	}
	if (object->sanitized_username == NULL) {
		py_sanitized_username = Py_None;
		Py_INCREF(py_sanitized_username);
	} else {
		if (object->sanitized_username == NULL) {
			py_sanitized_username = Py_None;
			Py_INCREF(py_sanitized_username);
		} else {
			py_sanitized_username = PyUnicode_Decode(object->sanitized_username, strlen(object->sanitized_username), "utf-8", "ignore");
		}
	}
	return py_sanitized_username;
}

static int py_auth_user_info_unix_set_sanitized_username(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_unix *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sanitized_username");
		return -1;
	}
	if (value == Py_None) {
		object->sanitized_username = NULL;
	} else {
		object->sanitized_username = NULL;
		{
			const char *test_str;
			const char *talloc_str;
			PyObject *unicode = NULL;
			if (PyUnicode_Check(value)) {
				unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
				if (unicode == NULL) {
					return -1;
				}
				test_str = PyBytes_AS_STRING(unicode);
			} else if (PyBytes_Check(value)) {
				test_str = PyBytes_AS_STRING(value);
			} else {
				PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
				return -1;
			}
			talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
			if (unicode != NULL) {
				Py_DECREF(unicode);
			}
			if (talloc_str == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			object->sanitized_username = talloc_str;
		}
	}
	return 0;
}

static PyGetSetDef py_auth_user_info_unix_getsetters[] = {
	{
		.name = discard_const_p(char, "unix_name"),
		.get = py_auth_user_info_unix_get_unix_name,
		.set = py_auth_user_info_unix_set_unix_name,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "sanitized_username"),
		.get = py_auth_user_info_unix_get_sanitized_username,
		.set = py_auth_user_info_unix_set_sanitized_username,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_auth_user_info_unix_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct auth_user_info_unix, type);
}

static PyObject *py_auth_user_info_unix_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct auth_user_info_unix *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_auth_user_info_unix);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_auth_user_info_unix_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_user_info_unix *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info_unix);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info_unix);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_auth_user_info_unix_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_user_info_unix *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_user_info_unix, "auth_user_info_unix", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_user_info_unix, "auth_user_info_unix", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_auth_user_info_unix_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_auth_user_info_unix_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_auth_user_info_unix_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_auth_user_info_unix_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject auth_user_info_unix_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "auth.user_info_unix",
	.tp_getset = py_auth_user_info_unix_getsetters,
	.tp_methods = py_auth_user_info_unix_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_auth_user_info_unix_new,
};


static PyObject *py_auth_SidAttr_get_sid(PyObject *obj, void *closure)
{
	struct auth_SidAttr *object = pytalloc_get_ptr(obj);
	PyObject *py_sid;
	py_sid = pytalloc_reference_ex(dom_sid_Type, pytalloc_get_mem_ctx(obj), &object->sid);
	return py_sid;
}

static int py_auth_SidAttr_set_sid(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_SidAttr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sid");
		return -1;
	}
	PY_CHECK_TYPE(dom_sid_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->sid = *(struct dom_sid *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_auth_SidAttr_get_attrs(PyObject *obj, void *closure)
{
	struct auth_SidAttr *object = pytalloc_get_ptr(obj);
	PyObject *py_attrs;
	py_attrs = PyLong_FromUnsignedLongLong((uint32_t)(object->attrs));
	return py_attrs;
}

static int py_auth_SidAttr_set_attrs(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_SidAttr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->attrs");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->attrs));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->attrs = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_SidAttr_get_origin(PyObject *obj, void *closure)
{
	struct auth_SidAttr *object = pytalloc_get_ptr(obj);
	PyObject *py_origin;
	py_origin = PyLong_FromLong((uint16_t)(object->origin));
	return py_origin;
}

static int py_auth_SidAttr_set_origin(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_SidAttr *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->origin");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->origin));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->origin = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_auth_SidAttr_getsetters[] = {
	{
		.name = discard_const_p(char, "sid"),
		.get = py_auth_SidAttr_get_sid,
		.set = py_auth_SidAttr_set_sid,
		.doc = discard_const_p(char, "PIDL-generated element of base type dom_sid")
	},
	{
		.name = discard_const_p(char, "attrs"),
		.get = py_auth_SidAttr_get_attrs,
		.set = py_auth_SidAttr_set_attrs,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_GroupAttrs")
	},
	{
		.name = discard_const_p(char, "origin"),
		.get = py_auth_SidAttr_get_origin,
		.set = py_auth_SidAttr_set_origin,
		.doc = discard_const_p(char, "PIDL-generated element of base type auth_sid_origin")
	},
	{ .name = NULL }
};

static PyObject *py_auth_SidAttr_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct auth_SidAttr, type);
}


static PyTypeObject auth_SidAttr_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "auth.SidAttr",
	.tp_getset = py_auth_SidAttr_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_auth_SidAttr_new,
};


static PyObject *py_auth_user_info_dc_get_num_sids(PyObject *obj, void *closure)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(obj);
	PyObject *py_num_sids;
	py_num_sids = PyLong_FromUnsignedLongLong((uint32_t)(object->num_sids));
	return py_num_sids;
}

static int py_auth_user_info_dc_set_num_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_sids");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_sids));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_sids = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_dc_get_sids(PyObject *obj, void *closure)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(obj);
	PyObject *py_sids;
	py_sids = PyList_New(object->num_sids);
	if (py_sids == NULL) {
		return NULL;
	}
	{
		int sids_cntr_0;
		for (sids_cntr_0 = 0; sids_cntr_0 < (object->num_sids); sids_cntr_0++) {
			PyObject *py_sids_0;
			py_sids_0 = pytalloc_reference_ex(&auth_SidAttr_Type, object->sids, &(object->sids)[sids_cntr_0]);
			PyList_SetItem(py_sids, sids_cntr_0, py_sids_0);
		}
	}
	return py_sids;
}

static int py_auth_user_info_dc_set_sids(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->sids");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int sids_cntr_0;
		object->sids = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->sids, PyList_GET_SIZE(value));
		if (!object->sids) { return -1; }
		talloc_set_name_const(object->sids, "ARRAY: object->sids");
		for (sids_cntr_0 = 0; sids_cntr_0 < PyList_GET_SIZE(value); sids_cntr_0++) {
			if (PyList_GET_ITEM(value, sids_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->sids)[sids_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&auth_SidAttr_Type, PyList_GET_ITEM(value, sids_cntr_0), return -1;);
			if (talloc_reference(object->sids, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, sids_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->sids)[sids_cntr_0] = *(struct auth_SidAttr *)pytalloc_get_ptr(PyList_GET_ITEM(value, sids_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_auth_user_info_dc_get_info(PyObject *obj, void *closure)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&auth_user_info_Type, object->info, object->info);
	}
	return py_info;
}

static int py_auth_user_info_dc_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&auth_user_info_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct auth_user_info *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_user_info_dc_get_user_session_key(PyObject *obj, void *closure)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(obj);
	PyObject *py_user_session_key;
	py_user_session_key = PyBytes_FromStringAndSize((char *)(object->user_session_key).data, (object->user_session_key).length);
	return py_user_session_key;
}

static int py_auth_user_info_dc_set_user_session_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->user_session_key");
		return -1;
	}
	object->user_session_key = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_auth_user_info_dc_get_lm_session_key(PyObject *obj, void *closure)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(obj);
	PyObject *py_lm_session_key;
	py_lm_session_key = PyBytes_FromStringAndSize((char *)(object->lm_session_key).data, (object->lm_session_key).length);
	return py_lm_session_key;
}

static int py_auth_user_info_dc_set_lm_session_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->lm_session_key");
		return -1;
	}
	object->lm_session_key = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_auth_user_info_dc_get_ticket_type(PyObject *obj, void *closure)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(obj);
	PyObject *py_ticket_type;
	py_ticket_type = PyLong_FromLong((uint16_t)(object->ticket_type));
	return py_ticket_type;
}

static int py_auth_user_info_dc_set_ticket_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ticket_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ticket_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ticket_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_auth_user_info_dc_getsetters[] = {
	{
		.name = discard_const_p(char, "num_sids"),
		.get = py_auth_user_info_dc_get_num_sids,
		.set = py_auth_user_info_dc_set_num_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "sids"),
		.get = py_auth_user_info_dc_get_sids,
		.set = py_auth_user_info_dc_set_sids,
		.doc = discard_const_p(char, "PIDL-generated element of base type auth_SidAttr")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_auth_user_info_dc_get_info,
		.set = py_auth_user_info_dc_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type auth_user_info")
	},
	{
		.name = discard_const_p(char, "user_session_key"),
		.get = py_auth_user_info_dc_get_user_session_key,
		.set = py_auth_user_info_dc_set_user_session_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "lm_session_key"),
		.get = py_auth_user_info_dc_get_lm_session_key,
		.set = py_auth_user_info_dc_set_lm_session_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "ticket_type"),
		.get = py_auth_user_info_dc_get_ticket_type,
		.set = py_auth_user_info_dc_set_ticket_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type ticket_type")
	},
	{ .name = NULL }
};

static PyObject *py_auth_user_info_dc_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct auth_user_info_dc, type);
}

static PyObject *py_auth_user_info_dc_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_auth_user_info_dc);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_auth_user_info_dc_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info_dc);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_user_info_dc);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_auth_user_info_dc_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_user_info_dc *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_user_info_dc, "auth_user_info_dc", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_user_info_dc, "auth_user_info_dc", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_auth_user_info_dc_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_auth_user_info_dc_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_auth_user_info_dc_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_auth_user_info_dc_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject auth_user_info_dc_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "auth.user_info_dc",
	.tp_getset = py_auth_user_info_dc_getsetters,
	.tp_methods = py_auth_user_info_dc_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_auth_user_info_dc_new,
};


static PyObject *py_auth_session_info_get_security_token(PyObject *obj, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_security_token;
	if (object->security_token == NULL) {
		Py_RETURN_NONE;
	}
	if (object->security_token == NULL) {
		py_security_token = Py_None;
		Py_INCREF(py_security_token);
	} else {
		py_security_token = pytalloc_reference_ex(security_token_Type, object->security_token, object->security_token);
	}
	return py_security_token;
}

static int py_auth_session_info_set_security_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->security_token));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->security_token");
		return -1;
	}
	if (value == Py_None) {
		object->security_token = NULL;
	} else {
		object->security_token = NULL;
		PY_CHECK_TYPE(security_token_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->security_token = (struct security_token *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_session_info_get_unix_token(PyObject *obj, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_unix_token;
	if (object->unix_token == NULL) {
		Py_RETURN_NONE;
	}
	if (object->unix_token == NULL) {
		py_unix_token = Py_None;
		Py_INCREF(py_unix_token);
	} else {
		py_unix_token = pytalloc_reference_ex(security_unix_token_Type, object->unix_token, object->unix_token);
	}
	return py_unix_token;
}

static int py_auth_session_info_set_unix_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->unix_token));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unix_token");
		return -1;
	}
	if (value == Py_None) {
		object->unix_token = NULL;
	} else {
		object->unix_token = NULL;
		PY_CHECK_TYPE(security_unix_token_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->unix_token = (struct security_unix_token *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_session_info_get_info(PyObject *obj, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_info;
	if (object->info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->info == NULL) {
		py_info = Py_None;
		Py_INCREF(py_info);
	} else {
		py_info = pytalloc_reference_ex(&auth_user_info_Type, object->info, object->info);
	}
	return py_info;
}

static int py_auth_session_info_set_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->info");
		return -1;
	}
	if (value == Py_None) {
		object->info = NULL;
	} else {
		object->info = NULL;
		PY_CHECK_TYPE(&auth_user_info_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->info = (struct auth_user_info *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_session_info_get_unix_info(PyObject *obj, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_unix_info;
	if (object->unix_info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->unix_info == NULL) {
		py_unix_info = Py_None;
		Py_INCREF(py_unix_info);
	} else {
		py_unix_info = pytalloc_reference_ex(&auth_user_info_unix_Type, object->unix_info, object->unix_info);
	}
	return py_unix_info;
}

static int py_auth_session_info_set_unix_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->unix_info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unix_info");
		return -1;
	}
	if (value == Py_None) {
		object->unix_info = NULL;
	} else {
		object->unix_info = NULL;
		PY_CHECK_TYPE(&auth_user_info_unix_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->unix_info = (struct auth_user_info_unix *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_session_info_get_torture(PyObject *obj, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_torture;
	if (object->torture == NULL) {
		Py_RETURN_NONE;
	}
	if (object->torture == NULL) {
		py_torture = Py_None;
		Py_INCREF(py_torture);
	} else {
		py_torture = pytalloc_reference_ex(&auth_user_info_torture_Type, object->torture, object->torture);
	}
	return py_torture;
}

static int py_auth_session_info_set_torture(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->torture));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->torture");
		return -1;
	}
	if (value == Py_None) {
		object->torture = NULL;
	} else {
		object->torture = NULL;
		PY_CHECK_TYPE(&auth_user_info_torture_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->torture = (struct auth_user_info_torture *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_session_info_get_session_key(PyObject *obj, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_session_key;
	py_session_key = PyBytes_FromStringAndSize((char *)(object->session_key).data, (object->session_key).length);
	return py_session_key;
}

static int py_auth_session_info_set_session_key(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->session_key");
		return -1;
	}
	object->session_key = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_auth_session_info_get_credentials(PyObject *obj, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_credentials;
	if (object->credentials == NULL) {
		Py_RETURN_NONE;
	}
	if (object->credentials == NULL) {
		py_credentials = Py_None;
		Py_INCREF(py_credentials);
	} else {
		py_credentials = NULL;
		PyErr_SetString(PyExc_NotImplementedError, "Cannot convert NDR object->credentials to Python");
		return NULL;
	}
	return py_credentials;
}

static int py_auth_session_info_set_credentials(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->credentials));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->credentials");
		return -1;
	}
	if (value == Py_None) {
		object->credentials = NULL;
	} else {
		object->credentials = NULL;
		PyErr_SetString(PyExc_TypeError, "Cannot convert Python object to NDR object->credentials");
		return -1;
	}
	return 0;
}

static PyObject *py_auth_session_info_get_unique_session_token(PyObject *obj, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_unique_session_token;
	py_unique_session_token = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->unique_session_token);
	return py_unique_session_token;
}

static int py_auth_session_info_set_unique_session_token(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->unique_session_token");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->unique_session_token = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_auth_session_info_get_ticket_type(PyObject *obj, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(obj);
	PyObject *py_ticket_type;
	py_ticket_type = PyLong_FromLong((uint16_t)(object->ticket_type));
	return py_ticket_type;
}

static int py_auth_session_info_set_ticket_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ticket_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ticket_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ticket_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_auth_session_info_getsetters[] = {
	{
		.name = discard_const_p(char, "security_token"),
		.get = py_auth_session_info_get_security_token,
		.set = py_auth_session_info_set_security_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_token")
	},
	{
		.name = discard_const_p(char, "unix_token"),
		.get = py_auth_session_info_get_unix_token,
		.set = py_auth_session_info_set_unix_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type security_unix_token")
	},
	{
		.name = discard_const_p(char, "info"),
		.get = py_auth_session_info_get_info,
		.set = py_auth_session_info_set_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type auth_user_info")
	},
	{
		.name = discard_const_p(char, "unix_info"),
		.get = py_auth_session_info_get_unix_info,
		.set = py_auth_session_info_set_unix_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type auth_user_info_unix")
	},
	{
		.name = discard_const_p(char, "torture"),
		.get = py_auth_session_info_get_torture,
		.set = py_auth_session_info_set_torture,
		.doc = discard_const_p(char, "PIDL-generated element of base type auth_user_info_torture")
	},
	{
		.name = discard_const_p(char, "session_key"),
		.get = py_auth_session_info_get_session_key,
		.set = py_auth_session_info_set_session_key,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "credentials"),
		.get = py_auth_session_info_get_credentials,
		.set = py_auth_session_info_set_credentials,
		.doc = discard_const_p(char, "PIDL-generated element of base type cli_credentials")
	},
	{
		.name = discard_const_p(char, "unique_session_token"),
		.get = py_auth_session_info_get_unique_session_token,
		.set = py_auth_session_info_set_unique_session_token,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "ticket_type"),
		.get = py_auth_session_info_get_ticket_type,
		.set = py_auth_session_info_set_ticket_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type ticket_type")
	},
	{ .name = NULL }
};

static PyObject *py_auth_session_info_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct auth_session_info, type);
}

static PyObject *py_auth_session_info_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct auth_session_info *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_auth_session_info);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_auth_session_info_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_session_info *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_session_info);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_session_info);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_auth_session_info_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_session_info *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_session_info, "auth_session_info", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_session_info, "auth_session_info", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_auth_session_info_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_auth_session_info_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_auth_session_info_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_auth_session_info_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject auth_session_info_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "auth.session_info",
	.tp_getset = py_auth_session_info_getsetters,
	.tp_methods = py_auth_session_info_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_auth_session_info_new,
};


static PyObject *py_auth_session_info_transport_get_session_info(PyObject *obj, void *closure)
{
	struct auth_session_info_transport *object = pytalloc_get_ptr(obj);
	PyObject *py_session_info;
	if (object->session_info == NULL) {
		Py_RETURN_NONE;
	}
	if (object->session_info == NULL) {
		py_session_info = Py_None;
		Py_INCREF(py_session_info);
	} else {
		py_session_info = pytalloc_reference_ex(&auth_session_info_Type, object->session_info, object->session_info);
	}
	return py_session_info;
}

static int py_auth_session_info_transport_set_session_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info_transport *object = pytalloc_get_ptr(py_obj);
	talloc_unlink(pytalloc_get_mem_ctx(py_obj), discard_const(object->session_info));
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->session_info");
		return -1;
	}
	if (value == Py_None) {
		object->session_info = NULL;
	} else {
		object->session_info = NULL;
		PY_CHECK_TYPE(&auth_session_info_Type, value, return -1;);
		if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->session_info = (struct auth_session_info *)pytalloc_get_ptr(value);
	}
	return 0;
}

static PyObject *py_auth_session_info_transport_get_exported_gssapi_credentials(PyObject *obj, void *closure)
{
	struct auth_session_info_transport *object = pytalloc_get_ptr(obj);
	PyObject *py_exported_gssapi_credentials;
	py_exported_gssapi_credentials = PyBytes_FromStringAndSize((char *)(object->exported_gssapi_credentials).data, (object->exported_gssapi_credentials).length);
	return py_exported_gssapi_credentials;
}

static int py_auth_session_info_transport_set_exported_gssapi_credentials(PyObject *py_obj, PyObject *value, void *closure)
{
	struct auth_session_info_transport *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->exported_gssapi_credentials");
		return -1;
	}
	object->exported_gssapi_credentials = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_auth_session_info_transport_getsetters[] = {
	{
		.name = discard_const_p(char, "session_info"),
		.get = py_auth_session_info_transport_get_session_info,
		.set = py_auth_session_info_transport_set_session_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type auth_session_info")
	},
	{
		.name = discard_const_p(char, "exported_gssapi_credentials"),
		.get = py_auth_session_info_transport_get_exported_gssapi_credentials,
		.set = py_auth_session_info_transport_set_exported_gssapi_credentials,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_auth_session_info_transport_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct auth_session_info_transport, type);
}

static PyObject *py_auth_session_info_transport_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct auth_session_info_transport *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_auth_session_info_transport);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_auth_session_info_transport_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_session_info_transport *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_session_info_transport);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_auth_session_info_transport);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_auth_session_info_transport_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct auth_session_info_transport *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_session_info_transport, "auth_session_info_transport", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_auth_session_info_transport, "auth_session_info_transport", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_auth_session_info_transport_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_auth_session_info_transport_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_auth_session_info_transport_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_auth_session_info_transport_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject auth_session_info_transport_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "auth.session_info_transport",
	.tp_getset = py_auth_session_info_transport_getsetters,
	.tp_methods = py_auth_session_info_transport_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_auth_session_info_transport_new,
};

static PyMethodDef auth_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "auth",
	.m_doc = "auth DCE/RPC",
	.m_size = -1,
	.m_methods = auth_methods,
};
MODULE_INIT_FUNC(auth)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_samba_dcerpc_security = NULL;
	PyObject *dep_samba_dcerpc_lsa = NULL;
	PyObject *dep_samba_dcerpc_krb5pac = NULL;
	PyObject *dep_talloc = NULL;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_samba_dcerpc_security = PyImport_ImportModule("samba.dcerpc.security");
	if (dep_samba_dcerpc_security == NULL)
		goto out;

	dep_samba_dcerpc_lsa = PyImport_ImportModule("samba.dcerpc.lsa");
	if (dep_samba_dcerpc_lsa == NULL)
		goto out;

	dep_samba_dcerpc_krb5pac = PyImport_ImportModule("samba.dcerpc.krb5pac");
	if (dep_samba_dcerpc_krb5pac == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	dom_sid_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "dom_sid");
	if (dom_sid_Type == NULL)
		goto out;

	security_token_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "token");
	if (security_token_Type == NULL)
		goto out;

	security_unix_token_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_security, "unix_token");
	if (security_unix_token_Type == NULL)
		goto out;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		goto out;

	auth_user_info_Type.tp_base = BaseObject_Type;
	auth_user_info_Type.tp_basicsize = pytalloc_BaseObject_size();

	auth_user_info_torture_Type.tp_base = BaseObject_Type;
	auth_user_info_torture_Type.tp_basicsize = pytalloc_BaseObject_size();

	auth_user_info_unix_Type.tp_base = BaseObject_Type;
	auth_user_info_unix_Type.tp_basicsize = pytalloc_BaseObject_size();

	auth_SidAttr_Type.tp_base = BaseObject_Type;
	auth_SidAttr_Type.tp_basicsize = pytalloc_BaseObject_size();

	auth_user_info_dc_Type.tp_base = BaseObject_Type;
	auth_user_info_dc_Type.tp_basicsize = pytalloc_BaseObject_size();

	auth_session_info_Type.tp_base = BaseObject_Type;
	auth_session_info_Type.tp_basicsize = pytalloc_BaseObject_size();

	auth_session_info_transport_Type.tp_base = BaseObject_Type;
	auth_session_info_transport_Type.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&auth_user_info_Type) < 0)
		goto out;
	if (PyType_Ready(&auth_user_info_torture_Type) < 0)
		goto out;
	if (PyType_Ready(&auth_user_info_unix_Type) < 0)
		goto out;
	if (PyType_Ready(&auth_SidAttr_Type) < 0)
		goto out;
	if (PyType_Ready(&auth_user_info_dc_Type) < 0)
		goto out;
	if (PyType_Ready(&auth_session_info_Type) < 0)
		goto out;
	if (PyType_Ready(&auth_session_info_transport_Type) < 0)
		goto out;
#ifdef PY_USER_INFO_PATCH
	PY_USER_INFO_PATCH(&auth_user_info_Type);
#endif
#ifdef PY_USER_INFO_TORTURE_PATCH
	PY_USER_INFO_TORTURE_PATCH(&auth_user_info_torture_Type);
#endif
#ifdef PY_USER_INFO_UNIX_PATCH
	PY_USER_INFO_UNIX_PATCH(&auth_user_info_unix_Type);
#endif
#ifdef PY_SIDATTR_PATCH
	PY_SIDATTR_PATCH(&auth_SidAttr_Type);
#endif
#ifdef PY_USER_INFO_DC_PATCH
	PY_USER_INFO_DC_PATCH(&auth_user_info_dc_Type);
#endif
#ifdef PY_SESSION_INFO_PATCH
	PY_SESSION_INFO_PATCH(&auth_session_info_Type);
#endif
#ifdef PY_SESSION_INFO_TRANSPORT_PATCH
	PY_SESSION_INFO_TRANSPORT_PATCH(&auth_session_info_transport_Type);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "SEC_AUTH_METHOD_UNAUTHENTICATED", PyLong_FromLong((uint16_t)(SEC_AUTH_METHOD_UNAUTHENTICATED)));
	PyModule_AddObject(m, "SEC_AUTH_METHOD_NTLM", PyLong_FromLong((uint16_t)(SEC_AUTH_METHOD_NTLM)));
	PyModule_AddObject(m, "SEC_AUTH_METHOD_KERBEROS", PyLong_FromLong((uint16_t)(SEC_AUTH_METHOD_KERBEROS)));
	PyModule_AddObject(m, "TICKET_TYPE_UNKNOWN", PyLong_FromLong((uint16_t)(TICKET_TYPE_UNKNOWN)));
	PyModule_AddObject(m, "TICKET_TYPE_TGT", PyLong_FromLong((uint16_t)(TICKET_TYPE_TGT)));
	PyModule_AddObject(m, "TICKET_TYPE_NON_TGT", PyLong_FromLong((uint16_t)(TICKET_TYPE_NON_TGT)));
	PyModule_AddObject(m, "AUTH_GROUP_INCLUSION_INVALID", PyLong_FromLong((uint16_t)(AUTH_GROUP_INCLUSION_INVALID)));
	PyModule_AddObject(m, "AUTH_INCLUDE_RESOURCE_GROUPS", PyLong_FromLong((uint16_t)(AUTH_INCLUDE_RESOURCE_GROUPS)));
	PyModule_AddObject(m, "AUTH_INCLUDE_RESOURCE_GROUPS_COMPRESSED", PyLong_FromLong((uint16_t)(AUTH_INCLUDE_RESOURCE_GROUPS_COMPRESSED)));
	PyModule_AddObject(m, "AUTH_EXCLUDE_RESOURCE_GROUPS", PyLong_FromLong((uint16_t)(AUTH_EXCLUDE_RESOURCE_GROUPS)));
	PyModule_AddObject(m, "AUTH_SID_ORIGIN_UNKNOWN", PyLong_FromLong((uint16_t)(AUTH_SID_ORIGIN_UNKNOWN)));
	PyModule_AddObject(m, "AUTH_SID_ORIGIN_BASE", PyLong_FromLong((uint16_t)(AUTH_SID_ORIGIN_BASE)));
	PyModule_AddObject(m, "AUTH_SID_ORIGIN_EXTRA", PyLong_FromLong((uint16_t)(AUTH_SID_ORIGIN_EXTRA)));
	PyModule_AddObject(m, "AUTH_SID_ORIGIN_RESOURCE", PyLong_FromLong((uint16_t)(AUTH_SID_ORIGIN_RESOURCE)));
	Py_INCREF((PyObject *)(void *)&auth_user_info_Type);
	PyModule_AddObject(m, "user_info", (PyObject *)(void *)&auth_user_info_Type);
	Py_INCREF((PyObject *)(void *)&auth_user_info_torture_Type);
	PyModule_AddObject(m, "user_info_torture", (PyObject *)(void *)&auth_user_info_torture_Type);
	Py_INCREF((PyObject *)(void *)&auth_user_info_unix_Type);
	PyModule_AddObject(m, "user_info_unix", (PyObject *)(void *)&auth_user_info_unix_Type);
	Py_INCREF((PyObject *)(void *)&auth_SidAttr_Type);
	PyModule_AddObject(m, "SidAttr", (PyObject *)(void *)&auth_SidAttr_Type);
	Py_INCREF((PyObject *)(void *)&auth_user_info_dc_Type);
	PyModule_AddObject(m, "user_info_dc", (PyObject *)(void *)&auth_user_info_dc_Type);
	Py_INCREF((PyObject *)(void *)&auth_session_info_Type);
	PyModule_AddObject(m, "session_info", (PyObject *)(void *)&auth_session_info_Type);
	Py_INCREF((PyObject *)(void *)&auth_session_info_transport_Type);
	PyModule_AddObject(m, "session_info_transport", (PyObject *)(void *)&auth_session_info_transport_Type);
#ifdef PY_MOD_AUTH_PATCH
	PY_MOD_AUTH_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_samba_dcerpc_security);
	Py_XDECREF(dep_samba_dcerpc_lsa);
	Py_XDECREF(dep_samba_dcerpc_krb5pac);
	Py_XDECREF(dep_talloc);
	return m;

}
