
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_keycredlink.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

static PyTypeObject EncodedExtendedCKI_Type;
static PyTypeObject CUSTOM_KEY_INFORMATION_Type;
static PyTypeObject KEYCREDENTIALLINK_ENTRY_Value_Type;
static PyTypeObject KEYCREDENTIALLINK_ENTRY_Type;
static PyTypeObject KEYCREDENTIALLINK_BLOB_Type;
static PyTypeObject KeyMaterialInternal_Type;

static PyTypeObject *BaseObject_Type;

static PyObject *py_EncodedExtendedCKI_get_version(PyObject *obj, void *closure)
{
	struct EncodedExtendedCKI *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromLong((uint16_t)(object->version));
	return py_version;
}

static int py_EncodedExtendedCKI_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EncodedExtendedCKI *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_EncodedExtendedCKI_get_size(PyObject *obj, void *closure)
{
	struct EncodedExtendedCKI *object = pytalloc_get_ptr(obj);
	PyObject *py_size;
	py_size = PyLong_FromLong((uint16_t)(object->size));
	return py_size;
}

static int py_EncodedExtendedCKI_set_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EncodedExtendedCKI *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_EncodedExtendedCKI_get_data(PyObject *obj, void *closure)
{
	struct EncodedExtendedCKI *object = pytalloc_get_ptr(obj);
	PyObject *py_data;
	py_data = PyList_New(object->size);
	if (py_data == NULL) {
		return NULL;
	}
	{
		int data_cntr_0;
		for (data_cntr_0 = 0; data_cntr_0 < (object->size); data_cntr_0++) {
			PyObject *py_data_0;
			py_data_0 = PyLong_FromLong((uint16_t)((object->data)[data_cntr_0]));
			PyList_SetItem(py_data, data_cntr_0, py_data_0);
		}
	}
	return py_data;
}

static int py_EncodedExtendedCKI_set_data(PyObject *py_obj, PyObject *value, void *closure)
{
	struct EncodedExtendedCKI *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->data");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int data_cntr_0;
		object->data = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->data, PyList_GET_SIZE(value));
		if (!object->data) { return -1; }
		talloc_set_name_const(object->data, "ARRAY: object->data");
		for (data_cntr_0 = 0; data_cntr_0 < PyList_GET_SIZE(value); data_cntr_0++) {
			if (PyList_GET_ITEM(value, data_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->data)[data_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->data)[data_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, data_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, data_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->data)[data_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_EncodedExtendedCKI_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_EncodedExtendedCKI_get_version,
		.set = py_EncodedExtendedCKI_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "size"),
		.get = py_EncodedExtendedCKI_get_size,
		.set = py_EncodedExtendedCKI_set_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "data"),
		.get = py_EncodedExtendedCKI_get_data,
		.set = py_EncodedExtendedCKI_set_data,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_EncodedExtendedCKI_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct EncodedExtendedCKI, type);
}

static PyObject *py_EncodedExtendedCKI_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct EncodedExtendedCKI *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_EncodedExtendedCKI);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_EncodedExtendedCKI_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct EncodedExtendedCKI *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EncodedExtendedCKI);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_EncodedExtendedCKI);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_EncodedExtendedCKI_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct EncodedExtendedCKI *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_EncodedExtendedCKI, "EncodedExtendedCKI", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_EncodedExtendedCKI, "EncodedExtendedCKI", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_EncodedExtendedCKI_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_EncodedExtendedCKI_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_EncodedExtendedCKI_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_EncodedExtendedCKI_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject EncodedExtendedCKI_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "keycredlink.EncodedExtendedCKI",
	.tp_getset = py_EncodedExtendedCKI_getsetters,
	.tp_methods = py_EncodedExtendedCKI_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_EncodedExtendedCKI_new,
};


static PyObject *py_CUSTOM_KEY_INFORMATION_get_version(PyObject *obj, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromLong((uint16_t)(object->version));
	return py_version;
}

static int py_CUSTOM_KEY_INFORMATION_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CUSTOM_KEY_INFORMATION_get_flags(PyObject *obj, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromLong((uint16_t)(object->flags));
	return py_flags;
}

static int py_CUSTOM_KEY_INFORMATION_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CUSTOM_KEY_INFORMATION_get_isExtended(PyObject *obj, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(obj);
	PyObject *py_isExtended;
	py_isExtended = PyLong_FromLong((uint16_t)(object->isExtended));
	return py_isExtended;
}

static int py_CUSTOM_KEY_INFORMATION_set_isExtended(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->isExtended");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->isExtended));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->isExtended = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CUSTOM_KEY_INFORMATION_get_volType(PyObject *obj, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(obj);
	PyObject *py_volType;
	py_volType = PyLong_FromLong((uint16_t)(object->volType));
	return py_volType;
}

static int py_CUSTOM_KEY_INFORMATION_set_volType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->volType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->volType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->volType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CUSTOM_KEY_INFORMATION_get_supportsNotification(PyObject *obj, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(obj);
	PyObject *py_supportsNotification;
	py_supportsNotification = PyLong_FromLong((uint16_t)(object->supportsNotification));
	return py_supportsNotification;
}

static int py_CUSTOM_KEY_INFORMATION_set_supportsNotification(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->supportsNotification");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->supportsNotification));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->supportsNotification = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CUSTOM_KEY_INFORMATION_get_fekKeyVersion(PyObject *obj, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(obj);
	PyObject *py_fekKeyVersion;
	py_fekKeyVersion = PyLong_FromLong((uint16_t)(object->fekKeyVersion));
	return py_fekKeyVersion;
}

static int py_CUSTOM_KEY_INFORMATION_set_fekKeyVersion(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fekKeyVersion");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fekKeyVersion));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fekKeyVersion = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CUSTOM_KEY_INFORMATION_get_keyStrength(PyObject *obj, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(obj);
	PyObject *py_keyStrength;
	py_keyStrength = PyLong_FromLong((uint16_t)(object->keyStrength));
	return py_keyStrength;
}

static int py_CUSTOM_KEY_INFORMATION_set_keyStrength(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->keyStrength");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->keyStrength));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->keyStrength = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CUSTOM_KEY_INFORMATION_get_reserved(PyObject *obj, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyList_New(10);
	if (py_reserved == NULL) {
		return NULL;
	}
	{
		int reserved_cntr_0;
		for (reserved_cntr_0 = 0; reserved_cntr_0 < (10); reserved_cntr_0++) {
			PyObject *py_reserved_0;
			py_reserved_0 = PyLong_FromLong((uint16_t)((object->reserved)[reserved_cntr_0]));
			PyList_SetItem(py_reserved, reserved_cntr_0, py_reserved_0);
		}
	}
	return py_reserved;
}

static int py_CUSTOM_KEY_INFORMATION_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int reserved_cntr_0;
		if (ARRAY_SIZE(object->reserved) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->reserved),  PyList_GET_SIZE(value));
			return -1;
		}
		for (reserved_cntr_0 = 0; reserved_cntr_0 < PyList_GET_SIZE(value); reserved_cntr_0++) {
			if (PyList_GET_ITEM(value, reserved_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->reserved)[reserved_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->reserved)[reserved_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, reserved_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, reserved_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->reserved)[reserved_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_CUSTOM_KEY_INFORMATION_get_count(PyObject *obj, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_CUSTOM_KEY_INFORMATION_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_CUSTOM_KEY_INFORMATION_get_cki(PyObject *obj, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(obj);
	PyObject *py_cki;
	py_cki = PyList_New(object->count);
	if (py_cki == NULL) {
		return NULL;
	}
	{
		int cki_cntr_0;
		for (cki_cntr_0 = 0; cki_cntr_0 < (object->count); cki_cntr_0++) {
			PyObject *py_cki_0;
			py_cki_0 = pytalloc_reference_ex(&EncodedExtendedCKI_Type, object->cki, &(object->cki)[cki_cntr_0]);
			PyList_SetItem(py_cki, cki_cntr_0, py_cki_0);
		}
	}
	return py_cki;
}

static int py_CUSTOM_KEY_INFORMATION_set_cki(PyObject *py_obj, PyObject *value, void *closure)
{
	struct CUSTOM_KEY_INFORMATION *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->cki");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int cki_cntr_0;
		object->cki = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->cki, PyList_GET_SIZE(value));
		if (!object->cki) { return -1; }
		talloc_set_name_const(object->cki, "ARRAY: object->cki");
		for (cki_cntr_0 = 0; cki_cntr_0 < PyList_GET_SIZE(value); cki_cntr_0++) {
			if (PyList_GET_ITEM(value, cki_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->cki)[cki_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&EncodedExtendedCKI_Type, PyList_GET_ITEM(value, cki_cntr_0), return -1;);
			if (talloc_reference(object->cki, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, cki_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->cki)[cki_cntr_0] = *(struct EncodedExtendedCKI *)pytalloc_get_ptr(PyList_GET_ITEM(value, cki_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_CUSTOM_KEY_INFORMATION_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_CUSTOM_KEY_INFORMATION_get_version,
		.set = py_CUSTOM_KEY_INFORMATION_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_CUSTOM_KEY_INFORMATION_get_flags,
		.set = py_CUSTOM_KEY_INFORMATION_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type CUSTOM_KEY_INFO_Flags")
	},
	{
		.name = discard_const_p(char, "isExtended"),
		.get = py_CUSTOM_KEY_INFORMATION_get_isExtended,
		.set = py_CUSTOM_KEY_INFORMATION_set_isExtended,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "volType"),
		.get = py_CUSTOM_KEY_INFORMATION_get_volType,
		.set = py_CUSTOM_KEY_INFORMATION_set_volType,
		.doc = discard_const_p(char, "PIDL-generated element of base type CUSTOM_KEY_INFO_VolType")
	},
	{
		.name = discard_const_p(char, "supportsNotification"),
		.get = py_CUSTOM_KEY_INFORMATION_get_supportsNotification,
		.set = py_CUSTOM_KEY_INFORMATION_set_supportsNotification,
		.doc = discard_const_p(char, "PIDL-generated element of base type CUSTOM_KEY_INFO_SupportsNotification")
	},
	{
		.name = discard_const_p(char, "fekKeyVersion"),
		.get = py_CUSTOM_KEY_INFORMATION_get_fekKeyVersion,
		.set = py_CUSTOM_KEY_INFORMATION_set_fekKeyVersion,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "keyStrength"),
		.get = py_CUSTOM_KEY_INFORMATION_get_keyStrength,
		.set = py_CUSTOM_KEY_INFORMATION_set_keyStrength,
		.doc = discard_const_p(char, "PIDL-generated element of base type CUSTOM_KEY_INFO_KeyStrength")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_CUSTOM_KEY_INFORMATION_get_reserved,
		.set = py_CUSTOM_KEY_INFORMATION_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_CUSTOM_KEY_INFORMATION_get_count,
		.set = py_CUSTOM_KEY_INFORMATION_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "cki"),
		.get = py_CUSTOM_KEY_INFORMATION_get_cki,
		.set = py_CUSTOM_KEY_INFORMATION_set_cki,
		.doc = discard_const_p(char, "PIDL-generated element of base type EncodedExtendedCKI")
	},
	{ .name = NULL }
};

static PyObject *py_CUSTOM_KEY_INFORMATION_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct CUSTOM_KEY_INFORMATION, type);
}


static PyTypeObject CUSTOM_KEY_INFORMATION_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "keycredlink.CUSTOM_KEY_INFORMATION",
	.tp_getset = py_CUSTOM_KEY_INFORMATION_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_CUSTOM_KEY_INFORMATION_new,
};

static PyObject *py_import_KEYCREDENTIALLINK_ENTRY_Value(TALLOC_CTX *mem_ctx, int level, union KEYCREDENTIALLINK_ENTRY_Value *in)
{
	PyObject *ret;

	switch (level) {
		case KeyID:
			ret = PyList_New(32);
			if (ret == NULL) {
				return NULL;
			}
			{
				int keyId_cntr_0;
				for (keyId_cntr_0 = 0; keyId_cntr_0 < (32); keyId_cntr_0++) {
					PyObject *py_keyId_0;
					py_keyId_0 = PyLong_FromLong((uint16_t)((in->keyId)[keyId_cntr_0]));
					PyList_SetItem(ret, keyId_cntr_0, py_keyId_0);
				}
			}
			return ret;

		case KeyHash:
			ret = PyList_New(32);
			if (ret == NULL) {
				return NULL;
			}
			{
				int keyHash_cntr_0;
				for (keyHash_cntr_0 = 0; keyHash_cntr_0 < (32); keyHash_cntr_0++) {
					PyObject *py_keyHash_0;
					py_keyHash_0 = PyLong_FromLong((uint16_t)((in->keyHash)[keyHash_cntr_0]));
					PyList_SetItem(ret, keyHash_cntr_0, py_keyHash_0);
				}
			}
			return ret;

		case KeyUsage:
			ret = PyLong_FromLong((uint16_t)(in->keyUsage));
			return ret;

		case KeySource:
			ret = PyLong_FromLong((uint16_t)(in->keySource));
			return ret;

		case KeyMaterial:
			ret = PyBytes_FromStringAndSize((char *)(in->keyMaterial).data, (in->keyMaterial).length);
			return ret;

		case DeviceId:
			ret = PyList_New(16);
			if (ret == NULL) {
				return NULL;
			}
			{
				int deviceId_cntr_0;
				for (deviceId_cntr_0 = 0; deviceId_cntr_0 < (16); deviceId_cntr_0++) {
					PyObject *py_deviceId_0;
					py_deviceId_0 = PyLong_FromLong((uint16_t)((in->deviceId)[deviceId_cntr_0]));
					PyList_SetItem(ret, deviceId_cntr_0, py_deviceId_0);
				}
			}
			return ret;

		case CustomKeyInformation:
			ret = pytalloc_reference_ex(&CUSTOM_KEY_INFORMATION_Type, mem_ctx, &in->customKeyInformation);
			return ret;

		case KeyApproximateLastLogonTimeStamp:
			ret = PyLong_FromUnsignedLongLong(in->lastLogon);
			return ret;

		case KeyCreationTime:
			ret = PyLong_FromUnsignedLongLong(in->created);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union KEYCREDENTIALLINK_ENTRY_Value *py_export_KEYCREDENTIALLINK_ENTRY_Value(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union KEYCREDENTIALLINK_ENTRY_Value *ret = talloc_zero(mem_ctx, union KEYCREDENTIALLINK_ENTRY_Value);
	switch (level) {
		case KeyID:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->keyId");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PyList_Type, in, talloc_free(ret); return NULL;);
			{
				int keyId_cntr_0;
				if (ARRAY_SIZE(ret->keyId) != PyList_GET_SIZE(in)) {
					PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(in)->tp_name, ARRAY_SIZE(ret->keyId),  PyList_GET_SIZE(in));
					talloc_free(ret); return NULL;
				}
				for (keyId_cntr_0 = 0; keyId_cntr_0 < PyList_GET_SIZE(in); keyId_cntr_0++) {
					if (PyList_GET_ITEM(in, keyId_cntr_0) == NULL) {
						PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (ret->keyId)[keyId_cntr_0]");
						talloc_free(ret); return NULL;
					}
					{
						const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((ret->keyId)[keyId_cntr_0]));
						if (PyLong_Check(PyList_GET_ITEM(in, keyId_cntr_0))) {
							unsigned long long test_var;
							test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(in, keyId_cntr_0));
							if (PyErr_Occurred() != NULL) {
								talloc_free(ret); return NULL;
							}
							if (test_var > uint_max) {
								PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
								  PyLong_Type.tp_name, uint_max, test_var);
								talloc_free(ret); return NULL;
							}
							(ret->keyId)[keyId_cntr_0] = test_var;
						} else {
							PyErr_Format(PyExc_TypeError, "Expected type %s",
							  PyLong_Type.tp_name);
							talloc_free(ret); return NULL;
						}
					}
				}
			}
			break;

		case KeyHash:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->keyHash");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PyList_Type, in, talloc_free(ret); return NULL;);
			{
				int keyHash_cntr_0;
				if (ARRAY_SIZE(ret->keyHash) != PyList_GET_SIZE(in)) {
					PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(in)->tp_name, ARRAY_SIZE(ret->keyHash),  PyList_GET_SIZE(in));
					talloc_free(ret); return NULL;
				}
				for (keyHash_cntr_0 = 0; keyHash_cntr_0 < PyList_GET_SIZE(in); keyHash_cntr_0++) {
					if (PyList_GET_ITEM(in, keyHash_cntr_0) == NULL) {
						PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (ret->keyHash)[keyHash_cntr_0]");
						talloc_free(ret); return NULL;
					}
					{
						const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((ret->keyHash)[keyHash_cntr_0]));
						if (PyLong_Check(PyList_GET_ITEM(in, keyHash_cntr_0))) {
							unsigned long long test_var;
							test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(in, keyHash_cntr_0));
							if (PyErr_Occurred() != NULL) {
								talloc_free(ret); return NULL;
							}
							if (test_var > uint_max) {
								PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
								  PyLong_Type.tp_name, uint_max, test_var);
								talloc_free(ret); return NULL;
							}
							(ret->keyHash)[keyHash_cntr_0] = test_var;
						} else {
							PyErr_Format(PyExc_TypeError, "Expected type %s",
							  PyLong_Type.tp_name);
							talloc_free(ret); return NULL;
						}
					}
				}
			}
			break;

		case KeyUsage:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->keyUsage");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->keyUsage));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->keyUsage = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case KeySource:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->keySource");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->keySource));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->keySource = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case KeyMaterial:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->keyMaterial");
				talloc_free(ret); return NULL;
			}
			ret->keyMaterial = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

		case DeviceId:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->deviceId");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&PyList_Type, in, talloc_free(ret); return NULL;);
			{
				int deviceId_cntr_0;
				if (ARRAY_SIZE(ret->deviceId) != PyList_GET_SIZE(in)) {
					PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(in)->tp_name, ARRAY_SIZE(ret->deviceId),  PyList_GET_SIZE(in));
					talloc_free(ret); return NULL;
				}
				for (deviceId_cntr_0 = 0; deviceId_cntr_0 < PyList_GET_SIZE(in); deviceId_cntr_0++) {
					if (PyList_GET_ITEM(in, deviceId_cntr_0) == NULL) {
						PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (ret->deviceId)[deviceId_cntr_0]");
						talloc_free(ret); return NULL;
					}
					{
						const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((ret->deviceId)[deviceId_cntr_0]));
						if (PyLong_Check(PyList_GET_ITEM(in, deviceId_cntr_0))) {
							unsigned long long test_var;
							test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(in, deviceId_cntr_0));
							if (PyErr_Occurred() != NULL) {
								talloc_free(ret); return NULL;
							}
							if (test_var > uint_max) {
								PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
								  PyLong_Type.tp_name, uint_max, test_var);
								talloc_free(ret); return NULL;
							}
							(ret->deviceId)[deviceId_cntr_0] = test_var;
						} else {
							PyErr_Format(PyExc_TypeError, "Expected type %s",
							  PyLong_Type.tp_name);
							talloc_free(ret); return NULL;
						}
					}
				}
			}
			break;

		case CustomKeyInformation:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->customKeyInformation");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&CUSTOM_KEY_INFORMATION_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->customKeyInformation = *(struct CUSTOM_KEY_INFORMATION *)pytalloc_get_ptr(in);
			break;

		case KeyApproximateLastLogonTimeStamp:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->lastLogon");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->lastLogon));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->lastLogon = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case KeyCreationTime:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->created");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->created));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->created = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_KEYCREDENTIALLINK_ENTRY_Value_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union KEYCREDENTIALLINK_ENTRY_Value *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union KEYCREDENTIALLINK_ENTRY_Value *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union KEYCREDENTIALLINK_ENTRY_Value!");
		return NULL;
	}

	return py_import_KEYCREDENTIALLINK_ENTRY_Value(mem_ctx, level, in);
}

static PyObject *py_KEYCREDENTIALLINK_ENTRY_Value_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union KEYCREDENTIALLINK_ENTRY_Value *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_KEYCREDENTIALLINK_ENTRY_Value(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_KEYCREDENTIALLINK_ENTRY_Value_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_KEYCREDENTIALLINK_ENTRY_Value_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_KEYCREDENTIALLINK_ENTRY_Value_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_KEYCREDENTIALLINK_ENTRY_Value_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject KEYCREDENTIALLINK_ENTRY_Value_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "keycredlink.KEYCREDENTIALLINK_ENTRY_Value",
	.tp_getset = NULL,
	.tp_methods = py_KEYCREDENTIALLINK_ENTRY_Value_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_KEYCREDENTIALLINK_ENTRY_Value_new,
};


static PyObject *py_KEYCREDENTIALLINK_ENTRY_get_length(PyObject *obj, void *closure)
{
	struct KEYCREDENTIALLINK_ENTRY *object = pytalloc_get_ptr(obj);
	PyObject *py_length;
	py_length = PyLong_FromLong((uint16_t)(object->length));
	return py_length;
}

static int py_KEYCREDENTIALLINK_ENTRY_set_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KEYCREDENTIALLINK_ENTRY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KEYCREDENTIALLINK_ENTRY_get_identifier(PyObject *obj, void *closure)
{
	struct KEYCREDENTIALLINK_ENTRY *object = pytalloc_get_ptr(obj);
	PyObject *py_identifier;
	py_identifier = PyLong_FromLong((uint16_t)(object->identifier));
	return py_identifier;
}

static int py_KEYCREDENTIALLINK_ENTRY_set_identifier(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KEYCREDENTIALLINK_ENTRY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->identifier");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->identifier));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->identifier = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KEYCREDENTIALLINK_ENTRY_get_value(PyObject *obj, void *closure)
{
	struct KEYCREDENTIALLINK_ENTRY *object = pytalloc_get_ptr(obj);
	PyObject *py_value;
	py_value = pyrpc_import_union(&KEYCREDENTIALLINK_ENTRY_Value_Type, pytalloc_get_mem_ctx(obj), object->identifier, &object->value, "union KEYCREDENTIALLINK_ENTRY_Value");
	if (py_value == NULL) {
		return NULL;
	}
	return py_value;
}

static int py_KEYCREDENTIALLINK_ENTRY_set_value(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KEYCREDENTIALLINK_ENTRY *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->value");
		return -1;
	}
	{
		union KEYCREDENTIALLINK_ENTRY_Value *value_switch_0;
		value_switch_0 = (union KEYCREDENTIALLINK_ENTRY_Value *)pyrpc_export_union(&KEYCREDENTIALLINK_ENTRY_Value_Type, pytalloc_get_mem_ctx(py_obj), object->identifier, value, "union KEYCREDENTIALLINK_ENTRY_Value");
		if (value_switch_0 == NULL) {
			return -1;
		}
		object->value = *value_switch_0;
	}
	return 0;
}

static PyGetSetDef py_KEYCREDENTIALLINK_ENTRY_getsetters[] = {
	{
		.name = discard_const_p(char, "length"),
		.get = py_KEYCREDENTIALLINK_ENTRY_get_length,
		.set = py_KEYCREDENTIALLINK_ENTRY_set_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "identifier"),
		.get = py_KEYCREDENTIALLINK_ENTRY_get_identifier,
		.set = py_KEYCREDENTIALLINK_ENTRY_set_identifier,
		.doc = discard_const_p(char, "PIDL-generated element of base type KEYCREDENTIALLINK_ENTRY_Identifier")
	},
	{
		.name = discard_const_p(char, "value"),
		.get = py_KEYCREDENTIALLINK_ENTRY_get_value,
		.set = py_KEYCREDENTIALLINK_ENTRY_set_value,
		.doc = discard_const_p(char, "PIDL-generated element of base type KEYCREDENTIALLINK_ENTRY_Value")
	},
	{ .name = NULL }
};

static PyObject *py_KEYCREDENTIALLINK_ENTRY_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct KEYCREDENTIALLINK_ENTRY, type);
}

static PyObject *py_KEYCREDENTIALLINK_ENTRY_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct KEYCREDENTIALLINK_ENTRY *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_KEYCREDENTIALLINK_ENTRY);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_KEYCREDENTIALLINK_ENTRY_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct KEYCREDENTIALLINK_ENTRY *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_KEYCREDENTIALLINK_ENTRY);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_KEYCREDENTIALLINK_ENTRY);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_KEYCREDENTIALLINK_ENTRY_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct KEYCREDENTIALLINK_ENTRY *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_KEYCREDENTIALLINK_ENTRY, "KEYCREDENTIALLINK_ENTRY", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_KEYCREDENTIALLINK_ENTRY, "KEYCREDENTIALLINK_ENTRY", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_KEYCREDENTIALLINK_ENTRY_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_KEYCREDENTIALLINK_ENTRY_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_KEYCREDENTIALLINK_ENTRY_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_KEYCREDENTIALLINK_ENTRY_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject KEYCREDENTIALLINK_ENTRY_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "keycredlink.KEYCREDENTIALLINK_ENTRY",
	.tp_getset = py_KEYCREDENTIALLINK_ENTRY_getsetters,
	.tp_methods = py_KEYCREDENTIALLINK_ENTRY_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_KEYCREDENTIALLINK_ENTRY_new,
};


static PyObject *py_KEYCREDENTIALLINK_BLOB_get_version(PyObject *obj, void *closure)
{
	struct KEYCREDENTIALLINK_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_KEYCREDENTIALLINK_BLOB_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KEYCREDENTIALLINK_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KEYCREDENTIALLINK_BLOB_get_count(PyObject *obj, void *closure)
{
	struct KEYCREDENTIALLINK_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromUnsignedLongLong((uint32_t)(object->count));
	return py_count;
}

static int py_KEYCREDENTIALLINK_BLOB_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KEYCREDENTIALLINK_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KEYCREDENTIALLINK_BLOB_get_entries(PyObject *obj, void *closure)
{
	struct KEYCREDENTIALLINK_BLOB *object = pytalloc_get_ptr(obj);
	PyObject *py_entries;
	py_entries = PyList_New(object->count);
	if (py_entries == NULL) {
		return NULL;
	}
	{
		int entries_cntr_0;
		for (entries_cntr_0 = 0; entries_cntr_0 < (object->count); entries_cntr_0++) {
			PyObject *py_entries_0;
			py_entries_0 = pytalloc_reference_ex(&KEYCREDENTIALLINK_ENTRY_Type, object->entries, &(object->entries)[entries_cntr_0]);
			PyList_SetItem(py_entries, entries_cntr_0, py_entries_0);
		}
	}
	return py_entries;
}

static int py_KEYCREDENTIALLINK_BLOB_set_entries(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KEYCREDENTIALLINK_BLOB *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->entries");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int entries_cntr_0;
		object->entries = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->entries, PyList_GET_SIZE(value));
		if (!object->entries) { return -1; }
		talloc_set_name_const(object->entries, "ARRAY: object->entries");
		for (entries_cntr_0 = 0; entries_cntr_0 < PyList_GET_SIZE(value); entries_cntr_0++) {
			if (PyList_GET_ITEM(value, entries_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->entries)[entries_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&KEYCREDENTIALLINK_ENTRY_Type, PyList_GET_ITEM(value, entries_cntr_0), return -1;);
			if (talloc_reference(object->entries, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, entries_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->entries)[entries_cntr_0] = *(struct KEYCREDENTIALLINK_ENTRY *)pytalloc_get_ptr(PyList_GET_ITEM(value, entries_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_KEYCREDENTIALLINK_BLOB_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_KEYCREDENTIALLINK_BLOB_get_version,
		.set = py_KEYCREDENTIALLINK_BLOB_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_KEYCREDENTIALLINK_BLOB_get_count,
		.set = py_KEYCREDENTIALLINK_BLOB_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "entries"),
		.get = py_KEYCREDENTIALLINK_BLOB_get_entries,
		.set = py_KEYCREDENTIALLINK_BLOB_set_entries,
		.doc = discard_const_p(char, "PIDL-generated element of base type KEYCREDENTIALLINK_ENTRY")
	},
	{ .name = NULL }
};

static PyObject *py_KEYCREDENTIALLINK_BLOB_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct KEYCREDENTIALLINK_BLOB, type);
}

static PyObject *py_KEYCREDENTIALLINK_BLOB_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct KEYCREDENTIALLINK_BLOB *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_KEYCREDENTIALLINK_BLOB);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_KEYCREDENTIALLINK_BLOB_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct KEYCREDENTIALLINK_BLOB *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_KEYCREDENTIALLINK_BLOB);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_KEYCREDENTIALLINK_BLOB);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_KEYCREDENTIALLINK_BLOB_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct KEYCREDENTIALLINK_BLOB *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_KEYCREDENTIALLINK_BLOB, "KEYCREDENTIALLINK_BLOB", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_KEYCREDENTIALLINK_BLOB, "KEYCREDENTIALLINK_BLOB", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_KEYCREDENTIALLINK_BLOB_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_KEYCREDENTIALLINK_BLOB_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_KEYCREDENTIALLINK_BLOB_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_KEYCREDENTIALLINK_BLOB_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject KEYCREDENTIALLINK_BLOB_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "keycredlink.KEYCREDENTIALLINK_BLOB",
	.tp_getset = py_KEYCREDENTIALLINK_BLOB_getsetters,
	.tp_methods = py_KEYCREDENTIALLINK_BLOB_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_KEYCREDENTIALLINK_BLOB_new,
};


static PyObject *py_KeyMaterialInternal_get_bit_size(PyObject *obj, void *closure)
{
	struct KeyMaterialInternal *object = pytalloc_get_ptr(obj);
	PyObject *py_bit_size;
	py_bit_size = PyLong_FromLong((uint16_t)(object->bit_size));
	return py_bit_size;
}

static int py_KeyMaterialInternal_set_bit_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyMaterialInternal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->bit_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->bit_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->bit_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_KeyMaterialInternal_get_modulus(PyObject *obj, void *closure)
{
	struct KeyMaterialInternal *object = pytalloc_get_ptr(obj);
	PyObject *py_modulus;
	py_modulus = PyBytes_FromStringAndSize((char *)(object->modulus).data, (object->modulus).length);
	return py_modulus;
}

static int py_KeyMaterialInternal_set_modulus(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyMaterialInternal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->modulus");
		return -1;
	}
	object->modulus = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_KeyMaterialInternal_get_exponent(PyObject *obj, void *closure)
{
	struct KeyMaterialInternal *object = pytalloc_get_ptr(obj);
	PyObject *py_exponent;
	py_exponent = PyBytes_FromStringAndSize((char *)(object->exponent).data, (object->exponent).length);
	return py_exponent;
}

static int py_KeyMaterialInternal_set_exponent(PyObject *py_obj, PyObject *value, void *closure)
{
	struct KeyMaterialInternal *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->exponent");
		return -1;
	}
	object->exponent = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_KeyMaterialInternal_getsetters[] = {
	{
		.name = discard_const_p(char, "bit_size"),
		.get = py_KeyMaterialInternal_get_bit_size,
		.set = py_KeyMaterialInternal_set_bit_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "modulus"),
		.get = py_KeyMaterialInternal_get_modulus,
		.set = py_KeyMaterialInternal_set_modulus,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "exponent"),
		.get = py_KeyMaterialInternal_get_exponent,
		.set = py_KeyMaterialInternal_set_exponent,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_KeyMaterialInternal_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct KeyMaterialInternal, type);
}

static PyObject *py_KeyMaterialInternal_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct KeyMaterialInternal *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_KeyMaterialInternal);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_KeyMaterialInternal_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct KeyMaterialInternal *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_KeyMaterialInternal);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_KeyMaterialInternal);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_KeyMaterialInternal_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct KeyMaterialInternal *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_KeyMaterialInternal, "KeyMaterialInternal", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_KeyMaterialInternal, "KeyMaterialInternal", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_KeyMaterialInternal_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_KeyMaterialInternal_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_KeyMaterialInternal_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_KeyMaterialInternal_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject KeyMaterialInternal_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "keycredlink.KeyMaterialInternal",
	.tp_getset = py_KeyMaterialInternal_getsetters,
	.tp_methods = py_KeyMaterialInternal_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_KeyMaterialInternal_new,
};

static PyMethodDef keycredlink_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "keycredlink",
	.m_doc = "keycredlink DCE/RPC",
	.m_size = -1,
	.m_methods = keycredlink_methods,
};
MODULE_INIT_FUNC(keycredlink)
{
	PyObject *m = NULL;
	PyObject *dep_talloc = NULL;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	EncodedExtendedCKI_Type.tp_base = BaseObject_Type;
	EncodedExtendedCKI_Type.tp_basicsize = pytalloc_BaseObject_size();

	CUSTOM_KEY_INFORMATION_Type.tp_base = BaseObject_Type;
	CUSTOM_KEY_INFORMATION_Type.tp_basicsize = pytalloc_BaseObject_size();

	KEYCREDENTIALLINK_ENTRY_Value_Type.tp_base = BaseObject_Type;
	KEYCREDENTIALLINK_ENTRY_Value_Type.tp_basicsize = pytalloc_BaseObject_size();

	KEYCREDENTIALLINK_ENTRY_Type.tp_base = BaseObject_Type;
	KEYCREDENTIALLINK_ENTRY_Type.tp_basicsize = pytalloc_BaseObject_size();

	KEYCREDENTIALLINK_BLOB_Type.tp_base = BaseObject_Type;
	KEYCREDENTIALLINK_BLOB_Type.tp_basicsize = pytalloc_BaseObject_size();

	KeyMaterialInternal_Type.tp_base = BaseObject_Type;
	KeyMaterialInternal_Type.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&EncodedExtendedCKI_Type) < 0)
		goto out;
	if (PyType_Ready(&CUSTOM_KEY_INFORMATION_Type) < 0)
		goto out;
	if (PyType_Ready(&KEYCREDENTIALLINK_ENTRY_Value_Type) < 0)
		goto out;
	if (PyType_Ready(&KEYCREDENTIALLINK_ENTRY_Type) < 0)
		goto out;
	if (PyType_Ready(&KEYCREDENTIALLINK_BLOB_Type) < 0)
		goto out;
	if (PyType_Ready(&KeyMaterialInternal_Type) < 0)
		goto out;
#ifdef PY_ENCODEDEXTENDEDCKI_PATCH
	PY_ENCODEDEXTENDEDCKI_PATCH(&EncodedExtendedCKI_Type);
#endif
#ifdef PY_CUSTOM_KEY_INFORMATION_PATCH
	PY_CUSTOM_KEY_INFORMATION_PATCH(&CUSTOM_KEY_INFORMATION_Type);
#endif
#ifdef PY_KEYCREDENTIALLINK_ENTRY_VALUE_PATCH
	PY_KEYCREDENTIALLINK_ENTRY_VALUE_PATCH(&KEYCREDENTIALLINK_ENTRY_Value_Type);
#endif
#ifdef PY_KEYCREDENTIALLINK_ENTRY_PATCH
	PY_KEYCREDENTIALLINK_ENTRY_PATCH(&KEYCREDENTIALLINK_ENTRY_Type);
#endif
#ifdef PY_KEYCREDENTIALLINK_BLOB_PATCH
	PY_KEYCREDENTIALLINK_BLOB_PATCH(&KEYCREDENTIALLINK_BLOB_Type);
#endif
#ifdef PY_KEYMATERIALINTERNAL_PATCH
	PY_KEYMATERIALINTERNAL_PATCH(&KeyMaterialInternal_Type);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "KeyID", PyLong_FromLong((uint16_t)(KeyID)));
	PyModule_AddObject(m, "KeyHash", PyLong_FromLong((uint16_t)(KeyHash)));
	PyModule_AddObject(m, "KeyMaterial", PyLong_FromLong((uint16_t)(KeyMaterial)));
	PyModule_AddObject(m, "KeyUsage", PyLong_FromLong((uint16_t)(KeyUsage)));
	PyModule_AddObject(m, "KeySource", PyLong_FromLong((uint16_t)(KeySource)));
	PyModule_AddObject(m, "DeviceId", PyLong_FromLong((uint16_t)(DeviceId)));
	PyModule_AddObject(m, "CustomKeyInformation", PyLong_FromLong((uint16_t)(CustomKeyInformation)));
	PyModule_AddObject(m, "KeyApproximateLastLogonTimeStamp", PyLong_FromLong((uint16_t)(KeyApproximateLastLogonTimeStamp)));
	PyModule_AddObject(m, "KeyCreationTime", PyLong_FromLong((uint16_t)(KeyCreationTime)));
	PyModule_AddObject(m, "KEY_USAGE_NGC", PyLong_FromLong((uint16_t)(KEY_USAGE_NGC)));
	PyModule_AddObject(m, "KEY_USAGE_FIDO", PyLong_FromLong((uint16_t)(KEY_USAGE_FIDO)));
	PyModule_AddObject(m, "KEY_USAGE_FEK", PyLong_FromLong((uint16_t)(KEY_USAGE_FEK)));
	PyModule_AddObject(m, "KEY_SOURCE_AD", PyLong_FromLong((uint16_t)(KEY_SOURCE_AD)));
	PyModule_AddObject(m, "CUSTOM_KEY_INFO_FLAGS_ATTESTATION", PyLong_FromLong((uint16_t)(CUSTOM_KEY_INFO_FLAGS_ATTESTATION)));
	PyModule_AddObject(m, "CUSTOM_KEY_INFO_FLAGS_MFA_NOT_USED", PyLong_FromLong((uint16_t)(CUSTOM_KEY_INFO_FLAGS_MFA_NOT_USED)));
	PyModule_AddObject(m, "Unspecified", PyLong_FromLong((uint16_t)(Unspecified)));
	PyModule_AddObject(m, "OSV", PyLong_FromLong((uint16_t)(OSV)));
	PyModule_AddObject(m, "FDV", PyLong_FromLong((uint16_t)(FDV)));
	PyModule_AddObject(m, "RDV", PyLong_FromLong((uint16_t)(RDV)));
	PyModule_AddObject(m, "Unsupported", PyLong_FromLong((uint16_t)(Unsupported)));
	PyModule_AddObject(m, "Supported", PyLong_FromLong((uint16_t)(Supported)));
	PyModule_AddObject(m, "Unknown", PyLong_FromLong((uint16_t)(Unknown)));
	PyModule_AddObject(m, "Weak", PyLong_FromLong((uint16_t)(Weak)));
	PyModule_AddObject(m, "Normal", PyLong_FromLong((uint16_t)(Normal)));
	Py_INCREF((PyObject *)(void *)&EncodedExtendedCKI_Type);
	PyModule_AddObject(m, "EncodedExtendedCKI", (PyObject *)(void *)&EncodedExtendedCKI_Type);
	Py_INCREF((PyObject *)(void *)&CUSTOM_KEY_INFORMATION_Type);
	PyModule_AddObject(m, "CUSTOM_KEY_INFORMATION", (PyObject *)(void *)&CUSTOM_KEY_INFORMATION_Type);
	Py_INCREF((PyObject *)(void *)&KEYCREDENTIALLINK_ENTRY_Value_Type);
	PyModule_AddObject(m, "KEYCREDENTIALLINK_ENTRY_Value", (PyObject *)(void *)&KEYCREDENTIALLINK_ENTRY_Value_Type);
	Py_INCREF((PyObject *)(void *)&KEYCREDENTIALLINK_ENTRY_Type);
	PyModule_AddObject(m, "KEYCREDENTIALLINK_ENTRY", (PyObject *)(void *)&KEYCREDENTIALLINK_ENTRY_Type);
	Py_INCREF((PyObject *)(void *)&KEYCREDENTIALLINK_BLOB_Type);
	PyModule_AddObject(m, "KEYCREDENTIALLINK_BLOB", (PyObject *)(void *)&KEYCREDENTIALLINK_BLOB_Type);
	Py_INCREF((PyObject *)(void *)&KeyMaterialInternal_Type);
	PyModule_AddObject(m, "KeyMaterialInternal", (PyObject *)(void *)&KeyMaterialInternal_Type);
#ifdef PY_MOD_KEYCREDLINK_PATCH
	PY_MOD_KEYCREDLINK_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_talloc);
	return m;

}
