/* ARMPartDecoder.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ARMPartDecoder.vala, do not modify */

/*
* Copyright (c) 2020 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "system.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define ABOUT_ARM_PART_DECODER_TYPE_ARM_PART (about_arm_part_decoder_arm_part_get_type ())
typedef struct _AboutARMPartDecoderARMPart AboutARMPartDecoderARMPart;

#define ABOUT_ARM_PART_DECODER_TYPE_ARM_IMPLEMENTER (about_arm_part_decoder_arm_implementer_get_type ())
typedef struct _AboutARMPartDecoderARMImplementer AboutARMPartDecoderARMImplementer;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AboutParamSpecARMPartDecoder AboutParamSpecARMPartDecoder;

struct _AboutARMPartDecoderARMPart {
	gint id;
	gchar* name;
};

struct _AboutARMPartDecoderARMImplementer {
	gint id;
	AboutARMPartDecoderARMPart* parts;
	gint parts_length1;
	gint _parts_size_;
	gchar* name;
};

struct _AboutParamSpecARMPartDecoder {
	GParamSpec parent_instance;
};

static gpointer about_arm_part_decoder_parent_class = NULL;

static GType about_arm_part_decoder_arm_part_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static AboutARMPartDecoderARMPart* about_arm_part_decoder_arm_part_dup (const AboutARMPartDecoderARMPart* self);
static void about_arm_part_decoder_arm_part_free (AboutARMPartDecoderARMPart* self);
static void about_arm_part_decoder_arm_part_copy (const AboutARMPartDecoderARMPart* self,
                                           AboutARMPartDecoderARMPart* dest);
static void about_arm_part_decoder_arm_part_destroy (AboutARMPartDecoderARMPart* self);
static GType about_arm_part_decoder_arm_implementer_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static AboutARMPartDecoderARMImplementer* about_arm_part_decoder_arm_implementer_dup (const AboutARMPartDecoderARMImplementer* self);
static void about_arm_part_decoder_arm_implementer_free (AboutARMPartDecoderARMImplementer* self);
static void about_arm_part_decoder_arm_implementer_copy (const AboutARMPartDecoderARMImplementer* self,
                                                  AboutARMPartDecoderARMImplementer* dest);
static void about_arm_part_decoder_arm_implementer_destroy (AboutARMPartDecoderARMImplementer* self);
static void _vala_AboutARMPartDecoderARMPart_array_free (AboutARMPartDecoderARMPart * array,
                                                  gssize array_length);
static AboutARMPartDecoderARMPart* _vala_array_dup3 (AboutARMPartDecoderARMPart* self,
                                              gssize length);
static void about_arm_part_decoder_finalize (AboutARMPartDecoder * obj);
static GType about_arm_part_decoder_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const AboutARMPartDecoderARMPart ABOUT_ARM_PART_DECODER_ARM_PARTS[45] = {{0x810, "ARM810"}, {0x920, "ARM920"}, {0x922, "ARM922"}, {0x926, "ARM926"}, {0x940, "ARM940"}, {0x946, "ARM946"}, {0x966, "ARM966"}, {0xa20, "ARM1020"}, {0xa22, "ARM1022"}, {0xa26, "ARM1026"}, {0xb02, "ARM11 MPCore"}, {0xb36, "ARM1136"}, {0xb56, "ARM1156"}, {0xb76, "ARM1176"}, {0xc05, "Cortex-A5"}, {0xc07, "Cortex-A7"}, {0xc08, "Cortex-A8"}, {0xc09, "Cortex-A9"}, {0xc0d, "Cortex-A17"}, {0xc0f, "Cortex-A15"}, {0xc0e, "Cortex-A17"}, {0xc14, "Cortex-R4"}, {0xc15, "Cortex-R5"}, {0xc17, "Cortex-R7"}, {0xc18, "Cortex-R8"}, {0xc20, "Cortex-M0"}, {0xc21, "Cortex-M1"}, {0xc23, "Cortex-M3"}, {0xc24, "Cortex-M4"}, {0xc27, "Cortex-M7"}, {0xc60, "Cortex-M0+"}, {0xd01, "Cortex-A32"}, {0xd03, "Cortex-A53"}, {0xd04, "Cortex-A35"}, {0xd05, "Cortex-A55"}, {0xd07, "Cortex-A57"}, {0xd08, "Cortex-A72"}, {0xd09, "Cortex-A73"}, {0xd0a, "Cortex-A75"}, {0xd0b, "Cortex-A76"}, {0xd0c, "Neoverse-N1"}, {0xd13, "Cortex-R52"}, {0xd20, "Cortex-M23"}, {0xd21, "Cortex-M33"}, {0xd4a, "Neoverse-E1"}};
static const AboutARMPartDecoderARMPart ABOUT_ARM_PART_DECODER_BROADCOM_PARTS[2] = {{0x0f, "Brahma B15"}, {0x100, "Brahma B53"}};
static const AboutARMPartDecoderARMPart ABOUT_ARM_PART_DECODER_DEC_PARTS[2] = {{0xa10, "SA110"}, {0xa11, "SA1100"}};
static const AboutARMPartDecoderARMPart ABOUT_ARM_PART_DECODER_CAVIUM_PARTS[5] = {{0x0a0, "ThunderX"}, {0x0a1, "ThunderX 88XX"}, {0x0a2, "ThunderX 81XX"}, {0x0a3, "ThunderX 83XX"}, {0x0af, "ThunderX2 99xx"}};
static const AboutARMPartDecoderARMPart ABOUT_ARM_PART_DECODER_APM_PARTS[1] = {{0x000, "X-Gene"}};
static const AboutARMPartDecoderARMPart ABOUT_ARM_PART_DECODER_QUALCOMM_PARTS[11] = {{0x00f, "Scorpion"}, {0x02d, "Scorpion"}, {0x04d, "Krait"}, {0x06f, "Krait"}, {0x201, "Kryo"}, {0x205, "Kryo"}, {0x211, "Kryo"}, {0x800, "Falkor V1/Kryo"}, {0x801, "Kryo V2"}, {0xc00, "Falkor"}, {0xc01, "Saphira"}};
static const AboutARMPartDecoderARMPart ABOUT_ARM_PART_DECODER_SAMSUNG_PARTS[1] = {{0x001, "exynos-m1"}};
static const AboutARMPartDecoderARMPart ABOUT_ARM_PART_DECODER_NVIDIA_PARTS[2] = {{0x000, "Denver"}, {0x003, "Denver 2"}};
static const AboutARMPartDecoderARMPart ABOUT_ARM_PART_DECODER_MARVELL_PARTS[3] = {{0x131, "Feroceon 88FR131"}, {0x581, "PJ4/PJ4b"}, {0x584, "PJ4B-MP"}};
static const AboutARMPartDecoderARMPart ABOUT_ARM_PART_DECODER_FARADAY_PARTS[2] = {{0x526, "FA526"}, {0x626, "FA626"}};
static const AboutARMPartDecoderARMPart ABOUT_ARM_PART_DECODER_INTEL_PARTS[21] = {{0x200, "i80200"}, {0x210, "PXA250A"}, {0x212, "PXA210A"}, {0x242, "i80321-400"}, {0x243, "i80321-600"}, {0x290, "PXA250B/PXA26x"}, {0x292, "PXA210B"}, {0x2c2, "i80321-400-B0"}, {0x2c3, "i80321-600-B0"}, {0x2d0, "PXA250C/PXA255/PXA26x"}, {0x2d2, "PXA210C"}, {0x411, "PXA27x"}, {0x41c, "IPX425-533"}, {0x41d, "IPX425-400"}, {0x41f, "IPX425-266"}, {0x682, "PXA32x"}, {0x683, "PXA930/PXA935"}, {0x688, "PXA30x"}, {0x689, "PXA31x"}, {0xb11, "SA1110"}, {0xc12, "IPX1200"}};
static const AboutARMPartDecoderARMPart ABOUT_ARM_PART_DECODER_HISILICON_PARTS[1] = {{0xd01, "Kunpeng-920"}};
static const AboutARMPartDecoderARMImplementer ABOUT_ARM_PART_DECODER_ARM_IMPLEMENTERS[12] = {{0x41, ABOUT_ARM_PART_DECODER_ARM_PARTS, G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_ARM_PARTS), G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_ARM_PARTS), "ARM"}, {0x42, ABOUT_ARM_PART_DECODER_BROADCOM_PARTS, G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_BROADCOM_PARTS), G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_BROADCOM_PARTS), "Broadcom"}, {0x43, ABOUT_ARM_PART_DECODER_CAVIUM_PARTS, G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_CAVIUM_PARTS), G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_CAVIUM_PARTS), "Cavium"}, {0x44, ABOUT_ARM_PART_DECODER_DEC_PARTS, G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_DEC_PARTS), G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_DEC_PARTS), "DEC"}, {0x48, ABOUT_ARM_PART_DECODER_HISILICON_PARTS, G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_HISILICON_PARTS), G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_HISILICON_PARTS), "HiSilicon"}, {0x4e, ABOUT_ARM_PART_DECODER_NVIDIA_PARTS, G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_NVIDIA_PARTS), G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_NVIDIA_PARTS), "Nvidia"}, {0x50, ABOUT_ARM_PART_DECODER_APM_PARTS, G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_APM_PARTS), G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_APM_PARTS), "APM"}, {0x51, ABOUT_ARM_PART_DECODER_QUALCOMM_PARTS, G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_QUALCOMM_PARTS), G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_QUALCOMM_PARTS), "Qualcomm"}, {0x53, ABOUT_ARM_PART_DECODER_SAMSUNG_PARTS, G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_SAMSUNG_PARTS), G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_SAMSUNG_PARTS), "Samsung"}, {0x56, ABOUT_ARM_PART_DECODER_MARVELL_PARTS, G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_MARVELL_PARTS), G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_MARVELL_PARTS), "Marvell"}, {0x66, ABOUT_ARM_PART_DECODER_FARADAY_PARTS, G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_FARADAY_PARTS), G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_FARADAY_PARTS), "Faraday"}, {0x69, ABOUT_ARM_PART_DECODER_INTEL_PARTS, G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_INTEL_PARTS), G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_INTEL_PARTS), "Intel"}};

static glong
long_parse (const gchar* str,
            guint _base)
{
	glong result;
	g_return_val_if_fail (str != NULL, 0L);
	result = strtol (str, NULL, (gint) _base);
	return result;
}

gchar*
about_arm_part_decoder_decode_arm_model (const gchar* cpu_implementer,
                                         const gchar* cpu_part)
{
	gchar* _result_ = NULL;
	gboolean _tmp0_ = FALSE;
	gint cpu_implementer_int = 0;
	gint cpu_part_int = 0;
	gboolean _tmp1_ = FALSE;
	gchar* result;
	g_return_val_if_fail (cpu_implementer != NULL, NULL);
	g_return_val_if_fail (cpu_part != NULL, NULL);
	_result_ = NULL;
	if (cpu_implementer == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = cpu_part == NULL;
	}
	if (_tmp0_) {
		result = _result_;
		return result;
	}
	cpu_implementer_int = (gint) long_parse (cpu_implementer, (guint) 0);
	cpu_part_int = (gint) long_parse (cpu_part, (guint) 0);
	if (cpu_implementer_int == 0) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = cpu_part_int == 0;
	}
	if (_tmp1_) {
		result = _result_;
		return result;
	}
	{
		AboutARMPartDecoderARMImplementer* implementer_collection = NULL;
		gint implementer_collection_length1 = 0;
		gint _implementer_collection_size_ = 0;
		gint implementer_it = 0;
		implementer_collection = ABOUT_ARM_PART_DECODER_ARM_IMPLEMENTERS;
		implementer_collection_length1 = G_N_ELEMENTS (ABOUT_ARM_PART_DECODER_ARM_IMPLEMENTERS);
		for (implementer_it = 0; implementer_it < implementer_collection_length1; implementer_it = implementer_it + 1) {
			AboutARMPartDecoderARMImplementer implementer = {0};
			implementer = implementer_collection[implementer_it];
			{
				AboutARMPartDecoderARMImplementer _tmp2_;
				_tmp2_ = implementer;
				if (cpu_implementer_int == _tmp2_.id) {
					AboutARMPartDecoderARMImplementer _tmp3_;
					const gchar* _tmp4_;
					gchar* _tmp5_;
					AboutARMPartDecoderARMImplementer _tmp6_;
					AboutARMPartDecoderARMPart* _tmp7_;
					gint _tmp7__length1;
					_tmp3_ = implementer;
					_tmp4_ = _tmp3_.name;
					_tmp5_ = g_strconcat (_tmp4_, " ", NULL);
					_g_free0 (_result_);
					_result_ = _tmp5_;
					_tmp6_ = implementer;
					_tmp7_ = _tmp6_.parts;
					_tmp7__length1 = _tmp6_.parts_length1;
					{
						AboutARMPartDecoderARMPart* part_collection = NULL;
						gint part_collection_length1 = 0;
						gint _part_collection_size_ = 0;
						gint part_it = 0;
						part_collection = _tmp7_;
						part_collection_length1 = _tmp7__length1;
						for (part_it = 0; part_it < part_collection_length1; part_it = part_it + 1) {
							AboutARMPartDecoderARMPart _tmp8_;
							AboutARMPartDecoderARMPart _tmp9_ = {0};
							AboutARMPartDecoderARMPart part = {0};
							_tmp8_ = part_collection[part_it];
							about_arm_part_decoder_arm_part_copy (&_tmp8_, &_tmp9_);
							part = _tmp9_;
							{
								AboutARMPartDecoderARMPart _tmp10_;
								_tmp10_ = part;
								if (cpu_part_int == _tmp10_.id) {
									const gchar* _tmp11_;
									AboutARMPartDecoderARMPart _tmp12_;
									const gchar* _tmp13_;
									gchar* _tmp14_;
									_tmp11_ = _result_;
									_tmp12_ = part;
									_tmp13_ = _tmp12_.name;
									_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
									_g_free0 (_result_);
									_result_ = _tmp14_;
								}
								about_arm_part_decoder_arm_part_destroy (&part);
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	return result;
}

AboutARMPartDecoder*
about_arm_part_decoder_construct (GType object_type)
{
	AboutARMPartDecoder* self = NULL;
	self = (AboutARMPartDecoder*) g_type_create_instance (object_type);
	return self;
}

AboutARMPartDecoder*
about_arm_part_decoder_new (void)
{
	return about_arm_part_decoder_construct (ABOUT_TYPE_ARM_PART_DECODER);
}

static void
about_arm_part_decoder_arm_part_copy (const AboutARMPartDecoderARMPart* self,
                                      AboutARMPartDecoderARMPart* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	(*dest).id = (*self).id;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
}

static void
about_arm_part_decoder_arm_part_destroy (AboutARMPartDecoderARMPart* self)
{
	_g_free0 ((*self).name);
}

static AboutARMPartDecoderARMPart*
about_arm_part_decoder_arm_part_dup (const AboutARMPartDecoderARMPart* self)
{
	AboutARMPartDecoderARMPart* dup;
	dup = g_new0 (AboutARMPartDecoderARMPart, 1);
	about_arm_part_decoder_arm_part_copy (self, dup);
	return dup;
}

static void
about_arm_part_decoder_arm_part_free (AboutARMPartDecoderARMPart* self)
{
	about_arm_part_decoder_arm_part_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
about_arm_part_decoder_arm_part_get_type_once (void)
{
	GType about_arm_part_decoder_arm_part_type_id;
	about_arm_part_decoder_arm_part_type_id = g_boxed_type_register_static ("AboutARMPartDecoderARMPart", (GBoxedCopyFunc) about_arm_part_decoder_arm_part_dup, (GBoxedFreeFunc) about_arm_part_decoder_arm_part_free);
	return about_arm_part_decoder_arm_part_type_id;
}

static GType
about_arm_part_decoder_arm_part_get_type (void)
{
	static volatile gsize about_arm_part_decoder_arm_part_type_id__once = 0;
	if (g_once_init_enter (&about_arm_part_decoder_arm_part_type_id__once)) {
		GType about_arm_part_decoder_arm_part_type_id;
		about_arm_part_decoder_arm_part_type_id = about_arm_part_decoder_arm_part_get_type_once ();
		g_once_init_leave (&about_arm_part_decoder_arm_part_type_id__once, about_arm_part_decoder_arm_part_type_id);
	}
	return about_arm_part_decoder_arm_part_type_id__once;
}

static void
_vala_AboutARMPartDecoderARMPart_array_free (AboutARMPartDecoderARMPart * array,
                                             gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			about_arm_part_decoder_arm_part_destroy (&array[i]);
		}
	}
	g_free (array);
}

static AboutARMPartDecoderARMPart*
_vala_array_dup3 (AboutARMPartDecoderARMPart* self,
                  gssize length)
{
	if (length > 0) {
		AboutARMPartDecoderARMPart* result;
		gssize i;
		result = g_new0 (AboutARMPartDecoderARMPart, length);
		for (i = 0; i < length; i++) {
			AboutARMPartDecoderARMPart _tmp0_;
			AboutARMPartDecoderARMPart _tmp1_ = {0};
			_tmp0_ = self[i];
			about_arm_part_decoder_arm_part_copy (&_tmp0_, &_tmp1_);
			result[i] = _tmp1_;
		}
		return result;
	}
	return NULL;
}

static void
about_arm_part_decoder_arm_implementer_copy (const AboutARMPartDecoderARMImplementer* self,
                                             AboutARMPartDecoderARMImplementer* dest)
{
	AboutARMPartDecoderARMPart* _tmp0_;
	gint _tmp0__length1;
	AboutARMPartDecoderARMPart* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	(*dest).id = (*self).id;
	_tmp0_ = (*self).parts;
	_tmp0__length1 = (*self).parts_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup3 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	(*dest).parts = (_vala_AboutARMPartDecoderARMPart_array_free ((*dest).parts, (*dest).parts_length1), NULL);
	(*dest).parts = _tmp1_;
	(*dest).parts_length1 = _tmp1__length1;
	(*dest)._parts_size_ = (*dest).parts_length1;
	_tmp2_ = (*self).name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp3_;
}

static void
about_arm_part_decoder_arm_implementer_destroy (AboutARMPartDecoderARMImplementer* self)
{
	(*self).parts = (_vala_AboutARMPartDecoderARMPart_array_free ((*self).parts, (*self).parts_length1), NULL);
	_g_free0 ((*self).name);
}

static AboutARMPartDecoderARMImplementer*
about_arm_part_decoder_arm_implementer_dup (const AboutARMPartDecoderARMImplementer* self)
{
	AboutARMPartDecoderARMImplementer* dup;
	dup = g_new0 (AboutARMPartDecoderARMImplementer, 1);
	about_arm_part_decoder_arm_implementer_copy (self, dup);
	return dup;
}

static void
about_arm_part_decoder_arm_implementer_free (AboutARMPartDecoderARMImplementer* self)
{
	about_arm_part_decoder_arm_implementer_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
about_arm_part_decoder_arm_implementer_get_type_once (void)
{
	GType about_arm_part_decoder_arm_implementer_type_id;
	about_arm_part_decoder_arm_implementer_type_id = g_boxed_type_register_static ("AboutARMPartDecoderARMImplementer", (GBoxedCopyFunc) about_arm_part_decoder_arm_implementer_dup, (GBoxedFreeFunc) about_arm_part_decoder_arm_implementer_free);
	return about_arm_part_decoder_arm_implementer_type_id;
}

static GType
about_arm_part_decoder_arm_implementer_get_type (void)
{
	static volatile gsize about_arm_part_decoder_arm_implementer_type_id__once = 0;
	if (g_once_init_enter (&about_arm_part_decoder_arm_implementer_type_id__once)) {
		GType about_arm_part_decoder_arm_implementer_type_id;
		about_arm_part_decoder_arm_implementer_type_id = about_arm_part_decoder_arm_implementer_get_type_once ();
		g_once_init_leave (&about_arm_part_decoder_arm_implementer_type_id__once, about_arm_part_decoder_arm_implementer_type_id);
	}
	return about_arm_part_decoder_arm_implementer_type_id__once;
}

static void
about_value_arm_part_decoder_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
about_value_arm_part_decoder_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		about_arm_part_decoder_unref (value->data[0].v_pointer);
	}
}

static void
about_value_arm_part_decoder_copy_value (const GValue* src_value,
                                         GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = about_arm_part_decoder_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
about_value_arm_part_decoder_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
about_value_arm_part_decoder_collect_value (GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		AboutARMPartDecoder * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = about_arm_part_decoder_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
about_value_arm_part_decoder_lcopy_value (const GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	AboutARMPartDecoder ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = about_arm_part_decoder_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
about_param_spec_arm_part_decoder (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags)
{
	AboutParamSpecARMPartDecoder* spec;
	g_return_val_if_fail (g_type_is_a (object_type, ABOUT_TYPE_ARM_PART_DECODER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
about_value_get_arm_part_decoder (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ABOUT_TYPE_ARM_PART_DECODER), NULL);
	return value->data[0].v_pointer;
}

void
about_value_set_arm_part_decoder (GValue* value,
                                  gpointer v_object)
{
	AboutARMPartDecoder * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ABOUT_TYPE_ARM_PART_DECODER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ABOUT_TYPE_ARM_PART_DECODER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		about_arm_part_decoder_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		about_arm_part_decoder_unref (old);
	}
}

void
about_value_take_arm_part_decoder (GValue* value,
                                   gpointer v_object)
{
	AboutARMPartDecoder * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, ABOUT_TYPE_ARM_PART_DECODER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, ABOUT_TYPE_ARM_PART_DECODER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		about_arm_part_decoder_unref (old);
	}
}

static void
about_arm_part_decoder_class_init (AboutARMPartDecoderClass * klass,
                                   gpointer klass_data)
{
	about_arm_part_decoder_parent_class = g_type_class_peek_parent (klass);
	((AboutARMPartDecoderClass *) klass)->finalize = about_arm_part_decoder_finalize;
}

static void
about_arm_part_decoder_instance_init (AboutARMPartDecoder * self,
                                      gpointer klass)
{
	self->ref_count = 1;
}

static void
about_arm_part_decoder_finalize (AboutARMPartDecoder * obj)
{
	AboutARMPartDecoder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_ARM_PART_DECODER, AboutARMPartDecoder);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
about_arm_part_decoder_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { about_value_arm_part_decoder_init, about_value_arm_part_decoder_free_value, about_value_arm_part_decoder_copy_value, about_value_arm_part_decoder_peek_pointer, "p", about_value_arm_part_decoder_collect_value, "p", about_value_arm_part_decoder_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (AboutARMPartDecoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_arm_part_decoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutARMPartDecoder), 0, (GInstanceInitFunc) about_arm_part_decoder_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType about_arm_part_decoder_type_id;
	about_arm_part_decoder_type_id = g_type_register_fundamental (g_type_fundamental_next (), "AboutARMPartDecoder", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return about_arm_part_decoder_type_id;
}

GType
about_arm_part_decoder_get_type (void)
{
	static volatile gsize about_arm_part_decoder_type_id__once = 0;
	if (g_once_init_enter (&about_arm_part_decoder_type_id__once)) {
		GType about_arm_part_decoder_type_id;
		about_arm_part_decoder_type_id = about_arm_part_decoder_get_type_once ();
		g_once_init_leave (&about_arm_part_decoder_type_id__once, about_arm_part_decoder_type_id);
	}
	return about_arm_part_decoder_type_id__once;
}

gpointer
about_arm_part_decoder_ref (gpointer instance)
{
	AboutARMPartDecoder * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
about_arm_part_decoder_unref (gpointer instance)
{
	AboutARMPartDecoder * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ABOUT_ARM_PART_DECODER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

