/* LocaleManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from LocaleManager.vala, do not modify */

/* Copyright 2011-2019 elementary, Inc. (https://elementary.io)
*
* This program is free software: you can redistribute it
* and/or modify it under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program. If not, see http://www.gnu.org/licenses/.
*/

#include "io.elementary.settings.locale.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <libgnome-desktop/gnome-xkb-info.h>
#include <gee.h>
#include <glib-object.h>
#include <locale.h>
#include <unistd.h>

#define SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_GNOME_DESKTOP_INPUT_SOURCES "org.gnome.desktop.input-sources"
#define SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_GNOME_LOCALE_KEY "org.gnome.system.locale"
#define SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_KEY_INPUT_SOURCES "sources"
#define SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_KEY_INPUT_SELETION "input-selections"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef GDBusProxy AccountProxyProxy;
typedef GDBusProxyClass AccountProxyProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef GDBusProxy Locale1ProxyProxy;
typedef GDBusProxyClass Locale1ProxyProxyClass;
typedef struct _Locale1ProxySetLocaleReadyData Locale1ProxySetLocaleReadyData;
typedef struct _Locale1ProxySetX11KeyboardReadyData Locale1ProxySetX11KeyboardReadyData;
enum  {
	SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_0_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_IS_CONNECTED_PROPERTY,
	SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_locale_locale_manager_properties[SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SwitchboardPlugLocaleLocaleManagerApplyToSystemData SwitchboardPlugLocaleLocaleManagerApplyToSystemData;

struct _Locale1ProxySetLocaleReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar** locale;
	gint locale_length1;
	gboolean interactive;
};

struct _Locale1ProxySetX11KeyboardReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* layout;
	gchar* model;
	gchar* variant;
	gchar* options;
	gboolean convert;
	gboolean interactive;
};

struct _SwitchboardPlugLocaleLocaleManagerPrivate {
	gboolean _is_connected;
	Locale1Proxy* locale1_proxy;
	AccountProxy* account_proxy;
	GSettings* input_settings;
	GSettings* locale_settings;
	GSettings* settings;
	GnomeXkbInfo* xkbinfo;
};

struct _SwitchboardPlugLocaleLocaleManagerApplyToSystemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SwitchboardPlugLocaleLocaleManager* self;
	gchar* language;
	gchar* format;
	gchar** locale;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gint locale_length1;
	gint _locale_size_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	Locale1Proxy* _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GError* e;
	GError* _tmp8_;
	GError* _tmp9_;
	gchar* layouts;
	gchar* _tmp10_;
	gchar* variants;
	gchar* _tmp11_;
	gchar* l;
	gchar* v;
	GVariant* variant;
	GSettings* _tmp12_;
	GVariant* _tmp13_;
	gint nr_keymaps;
	GVariant* _tmp14_;
	gint i;
	gboolean _tmp15_;
	gint _tmp16_;
	GVariant* entry;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	gchar* code;
	GVariant* _tmp19_;
	GVariant* _tmp20_;
	GVariant* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GnomeXkbInfo* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	Locale1Proxy* _tmp41_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	GError* _vala1_e;
	GError* _tmp44_;
	GError* _tmp45_;
	GError* _inner_error0_;
};

static gint SwitchboardPlugLocaleLocaleManager_private_offset;
static gpointer switchboard_plug_locale_locale_manager_parent_class = NULL;
static SwitchboardPlugLocaleLocaleManager* switchboard_plug_locale_locale_manager_instance;
static SwitchboardPlugLocaleLocaleManager* switchboard_plug_locale_locale_manager_instance = NULL;

static GType account_proxy_get_type_once (void);
static void account_proxy_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters);
static void account_proxy_proxy_set_formats_locale (AccountProxy* self,
                                             const gchar* formats_locale,
                                             GError** error);
static void account_proxy_proxy_set_language (AccountProxy* self,
                                       const gchar* language,
                                       GError** error);
static gchar* account_proxy_dbus_proxy_get_formats_locale (AccountProxy* self);
static gchar* account_proxy_dbus_proxy_get_language (AccountProxy* self);
static void account_proxy_proxy_account_proxy_interface_init (AccountProxyIface* iface);
static void _dbus_account_proxy_set_formats_locale (AccountProxy* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_account_proxy_set_language (AccountProxy* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation);
static void account_proxy_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data);
static GVariant* account_proxy_dbus_interface_get_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GError** error,
                                                     gpointer user_data);
static GVariant* _dbus_account_proxy_get_formats_locale (AccountProxy* self);
static GVariant* _dbus_account_proxy_get_language (AccountProxy* self);
static gboolean account_proxy_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data);
static void _account_proxy_unregister_object (gpointer user_data);
static GType locale1_proxy_get_type_once (void);
static void locale1_proxy_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void locale1_proxy_proxy_set_locale_async (Locale1Proxy* self,
                                           gchar** locale,
                                           gint locale_length1,
                                           gboolean interactive,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void locale1_proxy_proxy_set_locale_finish (Locale1Proxy* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void locale1_proxy_proxy_set_x11_keyboard_async (Locale1Proxy* self,
                                                 const gchar* layout,
                                                 const gchar* model,
                                                 const gchar* variant,
                                                 const gchar* options,
                                                 gboolean convert,
                                                 gboolean interactive,
                                                 GAsyncReadyCallback _callback_,
                                                 gpointer _user_data_);
static void locale1_proxy_proxy_set_x11_keyboard_finish (Locale1Proxy* self,
                                                  GAsyncResult* _res_,
                                                  GError** error);
static gchar** locale1_proxy_dbus_proxy_get_locale (Locale1Proxy* self,
                                             gint* result_length1);
static void locale1_proxy_proxy_locale1_proxy_interface_init (Locale1ProxyIface* iface);
static void _dbus_locale1_proxy_set_locale (Locale1Proxy* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void _dbus_locale1_proxy_set_locale_ready (GObject * source_object,
                                           GAsyncResult * _res_,
                                           gpointer _user_data_);
static void _dbus_locale1_proxy_set_x11_keyboard (Locale1Proxy* self,
                                           GVariant* _parameters_,
                                           GDBusMethodInvocation* invocation);
static void _dbus_locale1_proxy_set_x11_keyboard_ready (GObject * source_object,
                                                 GAsyncResult * _res_,
                                                 gpointer _user_data_);
static void locale1_proxy_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data);
static GVariant* locale1_proxy_dbus_interface_get_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GError** error,
                                                     gpointer user_data);
static GVariant* _dbus_locale1_proxy_get_locale (Locale1Proxy* self);
static gboolean locale1_proxy_dbus_interface_set_property (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* property_name,
                                                    GVariant* value,
                                                    GError** error,
                                                    gpointer user_data);
static void _locale1_proxy_unregister_object (gpointer user_data);
static void switchboard_plug_locale_locale_manager_on_settings_changed (SwitchboardPlugLocaleLocaleManager* self,
                                                                 const gchar* key);
static void switchboard_plug_locale_locale_manager_apply_to_system_data_free (gpointer _data);
static gboolean switchboard_plug_locale_locale_manager_apply_to_system_co (SwitchboardPlugLocaleLocaleManagerApplyToSystemData* _data_);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void switchboard_plug_locale_locale_manager_apply_to_system_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
static void switchboard_plug_locale_locale_manager_set_is_connected (SwitchboardPlugLocaleLocaleManager* self,
                                                              gboolean value);
static GObject * switchboard_plug_locale_locale_manager_constructor (GType type,
                                                              guint n_construct_properties,
                                                              GObjectConstructParam * construct_properties);
static void _switchboard_plug_locale_locale_manager_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                                     const gchar* key,
                                                                                     gpointer self);
static void switchboard_plug_locale_locale_manager_finalize (GObject * obj);
static GType switchboard_plug_locale_locale_manager_get_type_once (void);
static void _vala_switchboard_plug_locale_locale_manager_get_property (GObject * object,
                                                                guint property_id,
                                                                GValue * value,
                                                                GParamSpec * pspec);
static void _vala_switchboard_plug_locale_locale_manager_set_property (GObject * object,
                                                                guint property_id,
                                                                const GValue * value,
                                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _account_proxy_dbus_arg_info_set_formats_locale_formats_locale = {-1, "formats_locale", "s", NULL};
static const GDBusArgInfo * const _account_proxy_dbus_arg_info_set_formats_locale_in[] = {&_account_proxy_dbus_arg_info_set_formats_locale_formats_locale, NULL};
static const GDBusArgInfo * const _account_proxy_dbus_arg_info_set_formats_locale_out[] = {NULL};
static const GDBusMethodInfo _account_proxy_dbus_method_info_set_formats_locale = {-1, "SetFormatsLocale", (GDBusArgInfo **) (&_account_proxy_dbus_arg_info_set_formats_locale_in), (GDBusArgInfo **) (&_account_proxy_dbus_arg_info_set_formats_locale_out), NULL};
static const GDBusArgInfo _account_proxy_dbus_arg_info_set_language_language = {-1, "language", "s", NULL};
static const GDBusArgInfo * const _account_proxy_dbus_arg_info_set_language_in[] = {&_account_proxy_dbus_arg_info_set_language_language, NULL};
static const GDBusArgInfo * const _account_proxy_dbus_arg_info_set_language_out[] = {NULL};
static const GDBusMethodInfo _account_proxy_dbus_method_info_set_language = {-1, "SetLanguage", (GDBusArgInfo **) (&_account_proxy_dbus_arg_info_set_language_in), (GDBusArgInfo **) (&_account_proxy_dbus_arg_info_set_language_out), NULL};
static const GDBusMethodInfo * const _account_proxy_dbus_method_info[] = {&_account_proxy_dbus_method_info_set_formats_locale, &_account_proxy_dbus_method_info_set_language, NULL};
static const GDBusSignalInfo * const _account_proxy_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _account_proxy_dbus_property_info_formats_locale = {-1, "FormatsLocale", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _account_proxy_dbus_property_info_language = {-1, "Language", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _account_proxy_dbus_property_info[] = {&_account_proxy_dbus_property_info_formats_locale, &_account_proxy_dbus_property_info_language, NULL};
static const GDBusInterfaceInfo _account_proxy_dbus_interface_info = {-1, "org.freedesktop.Accounts.User", (GDBusMethodInfo **) (&_account_proxy_dbus_method_info), (GDBusSignalInfo **) (&_account_proxy_dbus_signal_info), (GDBusPropertyInfo **) (&_account_proxy_dbus_property_info), NULL};
static const GDBusInterfaceVTable _account_proxy_dbus_interface_vtable = {account_proxy_dbus_interface_method_call, account_proxy_dbus_interface_get_property, account_proxy_dbus_interface_set_property};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_locale_locale = {-1, "locale", "as", NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_locale_interactive = {-1, "interactive", "b", NULL};
static const GDBusArgInfo * const _locale1_proxy_dbus_arg_info_set_locale_in[] = {&_locale1_proxy_dbus_arg_info_set_locale_locale, &_locale1_proxy_dbus_arg_info_set_locale_interactive, NULL};
static const GDBusArgInfo * const _locale1_proxy_dbus_arg_info_set_locale_out[] = {NULL};
static const GDBusMethodInfo _locale1_proxy_dbus_method_info_set_locale = {-1, "SetLocale", (GDBusArgInfo **) (&_locale1_proxy_dbus_arg_info_set_locale_in), (GDBusArgInfo **) (&_locale1_proxy_dbus_arg_info_set_locale_out), NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_x11_keyboard_layout = {-1, "layout", "s", NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_x11_keyboard_model = {-1, "model", "s", NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_x11_keyboard_variant = {-1, "variant", "s", NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_x11_keyboard_options = {-1, "options", "s", NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_x11_keyboard_convert = {-1, "convert", "b", NULL};
static const GDBusArgInfo _locale1_proxy_dbus_arg_info_set_x11_keyboard_interactive = {-1, "interactive", "b", NULL};
static const GDBusArgInfo * const _locale1_proxy_dbus_arg_info_set_x11_keyboard_in[] = {&_locale1_proxy_dbus_arg_info_set_x11_keyboard_layout, &_locale1_proxy_dbus_arg_info_set_x11_keyboard_model, &_locale1_proxy_dbus_arg_info_set_x11_keyboard_variant, &_locale1_proxy_dbus_arg_info_set_x11_keyboard_options, &_locale1_proxy_dbus_arg_info_set_x11_keyboard_convert, &_locale1_proxy_dbus_arg_info_set_x11_keyboard_interactive, NULL};
static const GDBusArgInfo * const _locale1_proxy_dbus_arg_info_set_x11_keyboard_out[] = {NULL};
static const GDBusMethodInfo _locale1_proxy_dbus_method_info_set_x11_keyboard = {-1, "SetX11Keyboard", (GDBusArgInfo **) (&_locale1_proxy_dbus_arg_info_set_x11_keyboard_in), (GDBusArgInfo **) (&_locale1_proxy_dbus_arg_info_set_x11_keyboard_out), NULL};
static const GDBusMethodInfo * const _locale1_proxy_dbus_method_info[] = {&_locale1_proxy_dbus_method_info_set_locale, &_locale1_proxy_dbus_method_info_set_x11_keyboard, NULL};
static const GDBusSignalInfo * const _locale1_proxy_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _locale1_proxy_dbus_property_info_locale = {-1, "Locale", "as", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _locale1_proxy_dbus_property_info[] = {&_locale1_proxy_dbus_property_info_locale, NULL};
static const GDBusInterfaceInfo _locale1_proxy_dbus_interface_info = {-1, "org.freedesktop.locale1", (GDBusMethodInfo **) (&_locale1_proxy_dbus_method_info), (GDBusSignalInfo **) (&_locale1_proxy_dbus_signal_info), (GDBusPropertyInfo **) (&_locale1_proxy_dbus_property_info), NULL};
static const GDBusInterfaceVTable _locale1_proxy_dbus_interface_vtable = {locale1_proxy_dbus_interface_method_call, locale1_proxy_dbus_interface_get_property, locale1_proxy_dbus_interface_set_property};

void
account_proxy_set_formats_locale (AccountProxy* self,
                                  const gchar* formats_locale,
                                  GError** error)
{
	AccountProxyIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ACCOUNT_PROXY_GET_INTERFACE (self);
	if (_iface_->set_formats_locale) {
		_iface_->set_formats_locale (self, formats_locale, error);
	}
}

void
account_proxy_set_language (AccountProxy* self,
                            const gchar* language,
                            GError** error)
{
	AccountProxyIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = ACCOUNT_PROXY_GET_INTERFACE (self);
	if (_iface_->set_language) {
		_iface_->set_language (self, language, error);
	}
}

gchar*
account_proxy_get_formats_locale (AccountProxy* self)
{
	AccountProxyIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ACCOUNT_PROXY_GET_INTERFACE (self);
	if (_iface_->get_formats_locale) {
		return _iface_->get_formats_locale (self);
	}
	return NULL;
}

gchar*
account_proxy_get_language (AccountProxy* self)
{
	AccountProxyIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = ACCOUNT_PROXY_GET_INTERFACE (self);
	if (_iface_->get_language) {
		return _iface_->get_language (self);
	}
	return NULL;
}

static void
account_proxy_default_init (AccountProxyIface * iface,
                            gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
account_proxy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AccountProxyIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) account_proxy_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType account_proxy_type_id;
	account_proxy_type_id = g_type_register_static (G_TYPE_INTERFACE, "AccountProxy", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (account_proxy_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (account_proxy_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) account_proxy_proxy_get_type);
	g_type_set_qdata (account_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Accounts.User");
	g_type_set_qdata (account_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_account_proxy_dbus_interface_info));
	g_type_set_qdata (account_proxy_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) account_proxy_register_object);
	return account_proxy_type_id;
}

GType
account_proxy_get_type (void)
{
	static gsize account_proxy_type_id__once = 0;
	if (g_once_init_enter (&account_proxy_type_id__once)) {
		GType account_proxy_type_id;
		account_proxy_type_id = account_proxy_get_type_once ();
		g_once_init_leave (&account_proxy_type_id__once, account_proxy_type_id);
	}
	return account_proxy_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (AccountProxyProxy, account_proxy_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_ACCOUNT_PROXY, account_proxy_proxy_account_proxy_interface_init) )
static void
account_proxy_proxy_class_init (AccountProxyProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = account_proxy_proxy_g_signal;
}

static void
account_proxy_proxy_g_signal (GDBusProxy* proxy,
                              const gchar* sender_name,
                              const gchar* signal_name,
                              GVariant* parameters)
{
}

static void
account_proxy_proxy_init (AccountProxyProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_account_proxy_dbus_interface_info));
}

static void
account_proxy_proxy_set_formats_locale (AccountProxy* self,
                                        const gchar* formats_locale,
                                        GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Accounts.User", "SetFormatsLocale");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (formats_locale));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
account_proxy_proxy_set_language (AccountProxy* self,
                                  const gchar* language,
                                  GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Accounts.User", "SetLanguage");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (language));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar*
account_proxy_dbus_proxy_get_formats_locale (AccountProxy* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "FormatsLocale");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.Accounts.User"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("FormatsLocale"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
account_proxy_dbus_proxy_get_language (AccountProxy* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Language");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.Accounts.User"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Language"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
account_proxy_proxy_account_proxy_interface_init (AccountProxyIface* iface)
{
	iface->set_formats_locale = account_proxy_proxy_set_formats_locale;
	iface->set_language = account_proxy_proxy_set_language;
	iface->get_formats_locale = account_proxy_dbus_proxy_get_formats_locale;
	iface->get_language = account_proxy_dbus_proxy_get_language;
}

static void
_dbus_account_proxy_set_formats_locale (AccountProxy* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* formats_locale = NULL;
	GVariant* _tmp0_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	formats_locale = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	account_proxy_set_formats_locale (self, formats_locale, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (formats_locale);
	;
}

static void
_dbus_account_proxy_set_language (AccountProxy* self,
                                  GVariant* _parameters_,
                                  GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* language = NULL;
	GVariant* _tmp1_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	language = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	account_proxy_set_language (self, language, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (language);
	;
}

static void
account_proxy_dbus_interface_method_call (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* method_name,
                                          GVariant* parameters,
                                          GDBusMethodInvocation* invocation,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SetFormatsLocale") == 0) {
		_dbus_account_proxy_set_formats_locale (object, parameters, invocation);
	} else if (strcmp (method_name, "SetLanguage") == 0) {
		_dbus_account_proxy_set_language (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_account_proxy_get_formats_locale (AccountProxy* self)
{
	gchar* result;
	GVariant* _reply;
	result = account_proxy_get_formats_locale (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_account_proxy_get_language (AccountProxy* self)
{
	gchar* result;
	GVariant* _reply;
	result = account_proxy_get_language (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
account_proxy_dbus_interface_get_property (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* property_name,
                                           GError** error,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "FormatsLocale") == 0) {
		return _dbus_account_proxy_get_formats_locale (object);
	} else if (strcmp (property_name, "Language") == 0) {
		return _dbus_account_proxy_get_language (object);
	}
	return NULL;
}

static gboolean
account_proxy_dbus_interface_set_property (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* property_name,
                                           GVariant* value,
                                           GError** error,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
account_proxy_register_object (gpointer object,
                               GDBusConnection* connection,
                               const gchar* path,
                               GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_account_proxy_dbus_interface_info), &_account_proxy_dbus_interface_vtable, data, _account_proxy_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_account_proxy_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

void
locale1_proxy_set_locale (Locale1Proxy* self,
                          gchar** locale,
                          gint locale_length1,
                          gboolean interactive,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	Locale1ProxyIface* _iface_;
	_iface_ = LOCALE1_PROXY_GET_INTERFACE (self);
	if (_iface_->set_locale) {
		_iface_->set_locale (self, locale, locale_length1, interactive, _callback_, _user_data_);
	}
}

void
locale1_proxy_set_locale_finish (Locale1Proxy* self,
                                 GAsyncResult* _res_,
                                 GError** error)
{
	Locale1ProxyIface* _iface_;
	_iface_ = LOCALE1_PROXY_GET_INTERFACE (self);
	if (_iface_->set_locale_finish) {
		_iface_->set_locale_finish (self, _res_, error);
	}
}

void
locale1_proxy_set_x11_keyboard (Locale1Proxy* self,
                                const gchar* layout,
                                const gchar* model,
                                const gchar* variant,
                                const gchar* options,
                                gboolean convert,
                                gboolean interactive,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	Locale1ProxyIface* _iface_;
	_iface_ = LOCALE1_PROXY_GET_INTERFACE (self);
	if (_iface_->set_x11_keyboard) {
		_iface_->set_x11_keyboard (self, layout, model, variant, options, convert, interactive, _callback_, _user_data_);
	}
}

void
locale1_proxy_set_x11_keyboard_finish (Locale1Proxy* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	Locale1ProxyIface* _iface_;
	_iface_ = LOCALE1_PROXY_GET_INTERFACE (self);
	if (_iface_->set_x11_keyboard_finish) {
		_iface_->set_x11_keyboard_finish (self, _res_, error);
	}
}

gchar**
locale1_proxy_get_locale (Locale1Proxy* self,
                          gint* result_length1)
{
	Locale1ProxyIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = LOCALE1_PROXY_GET_INTERFACE (self);
	if (_iface_->get_locale) {
		return _iface_->get_locale (self, result_length1);
	}
	return NULL;
}

static void
locale1_proxy_default_init (Locale1ProxyIface * iface,
                            gpointer iface_data)
{
}

 G_GNUC_NO_INLINE static GType
locale1_proxy_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (Locale1ProxyIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) locale1_proxy_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType locale1_proxy_type_id;
	locale1_proxy_type_id = g_type_register_static (G_TYPE_INTERFACE, "Locale1Proxy", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (locale1_proxy_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (locale1_proxy_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) locale1_proxy_proxy_get_type);
	g_type_set_qdata (locale1_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.locale1");
	g_type_set_qdata (locale1_proxy_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_locale1_proxy_dbus_interface_info));
	g_type_set_qdata (locale1_proxy_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) locale1_proxy_register_object);
	return locale1_proxy_type_id;
}

GType
locale1_proxy_get_type (void)
{
	static gsize locale1_proxy_type_id__once = 0;
	if (g_once_init_enter (&locale1_proxy_type_id__once)) {
		GType locale1_proxy_type_id;
		locale1_proxy_type_id = locale1_proxy_get_type_once ();
		g_once_init_leave (&locale1_proxy_type_id__once, locale1_proxy_type_id);
	}
	return locale1_proxy_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (Locale1ProxyProxy, locale1_proxy_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_LOCALE1_PROXY, locale1_proxy_proxy_locale1_proxy_interface_init) )
static void
locale1_proxy_proxy_class_init (Locale1ProxyProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = locale1_proxy_proxy_g_signal;
}

static void
locale1_proxy_proxy_g_signal (GDBusProxy* proxy,
                              const gchar* sender_name,
                              const gchar* signal_name,
                              GVariant* parameters)
{
}

static void
locale1_proxy_proxy_init (Locale1ProxyProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_locale1_proxy_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
locale1_proxy_proxy_set_locale_async (Locale1Proxy* self,
                                      gchar** locale,
                                      gint locale_length1,
                                      gboolean interactive,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp2_;
	GVariantBuilder _tmp3_;
	gint _tmp4_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.locale1", "SetLocale");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp2_ = locale;
	g_variant_builder_init (&_tmp3_, G_VARIANT_TYPE ("as"));
	for (_tmp4_ = 0; _tmp4_ < locale_length1; _tmp4_++) {
		g_variant_builder_add_value (&_tmp3_, g_variant_new_string (*_tmp2_));
		_tmp2_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp3_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (interactive));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
locale1_proxy_proxy_set_locale_finish (Locale1Proxy* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
locale1_proxy_proxy_set_x11_keyboard_async (Locale1Proxy* self,
                                            const gchar* layout,
                                            const gchar* model,
                                            const gchar* variant,
                                            const gchar* options,
                                            gboolean convert,
                                            gboolean interactive,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.locale1", "SetX11Keyboard");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (layout));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (model));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (variant));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (options));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (convert));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (interactive));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
locale1_proxy_proxy_set_x11_keyboard_finish (Locale1Proxy* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar**
locale1_proxy_dbus_proxy_get_locale (Locale1Proxy* self,
                                     gint* result_length1)
{
	GVariant *_inner_reply;
	gchar** _result;
	gint _result_length1;
	gchar** _tmp5_;
	gint _tmp5__length;
	gint _tmp5__size;
	gint _tmp5__length1;
	GVariantIter _tmp6_;
	GVariant* _tmp7_;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Locale");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.locale1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Locale"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result_length1 = 0;
	_tmp5_ = g_new (gchar*, 5);
	_tmp5__length = 0;
	_tmp5__size = 4;
	_tmp5__length1 = 0;
	g_variant_iter_init (&_tmp6_, _inner_reply);
	for (; (_tmp7_ = g_variant_iter_next_value (&_tmp6_)) != NULL; _tmp5__length1++) {
		if (_tmp5__size == _tmp5__length) {
			_tmp5__size = 2 * _tmp5__size;
			_tmp5_ = g_renew (gchar*, _tmp5_, _tmp5__size + 1);
		}
		_tmp5_[_tmp5__length++] = g_variant_dup_string (_tmp7_, NULL);
		g_variant_unref (_tmp7_);
	}
	_result_length1 = _tmp5__length1;
	_tmp5_[_tmp5__length] = NULL;
	_result = _tmp5_;
	*result_length1 = _result_length1;
	g_variant_unref (_inner_reply);
	return _result;
}

static void
locale1_proxy_proxy_locale1_proxy_interface_init (Locale1ProxyIface* iface)
{
	iface->set_locale = locale1_proxy_proxy_set_locale_async;
	iface->set_locale_finish = locale1_proxy_proxy_set_locale_finish;
	iface->set_x11_keyboard = locale1_proxy_proxy_set_x11_keyboard_async;
	iface->set_x11_keyboard_finish = locale1_proxy_proxy_set_x11_keyboard_finish;
	iface->get_locale = locale1_proxy_dbus_proxy_get_locale;
}

static void
_dbus_locale1_proxy_set_locale (Locale1Proxy* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	Locale1ProxySetLocaleReadyData* _ready_data;
	GVariant* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length;
	gint _tmp9__size;
	gint _tmp9__length1;
	GVariantIter _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (Locale1ProxySetLocaleReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp9_ = g_new (gchar*, 5);
	_tmp9__length = 0;
	_tmp9__size = 4;
	_tmp9__length1 = 0;
	g_variant_iter_init (&_tmp10_, _tmp8_);
	for (; (_tmp11_ = g_variant_iter_next_value (&_tmp10_)) != NULL; _tmp9__length1++) {
		if (_tmp9__size == _tmp9__length) {
			_tmp9__size = 2 * _tmp9__size;
			_tmp9_ = g_renew (gchar*, _tmp9_, _tmp9__size + 1);
		}
		_tmp9_[_tmp9__length++] = g_variant_dup_string (_tmp11_, NULL);
		g_variant_unref (_tmp11_);
	}
	_ready_data->locale_length1 = _tmp9__length1;
	_tmp9_[_tmp9__length] = NULL;
	_ready_data->locale = _tmp9_;
	g_variant_unref (_tmp8_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->interactive = g_variant_get_boolean (_tmp12_);
	g_variant_unref (_tmp12_);
	locale1_proxy_set_locale (self, _ready_data->locale, _ready_data->locale_length1, _ready_data->interactive, (GAsyncReadyCallback) _dbus_locale1_proxy_set_locale_ready, _ready_data);
	_error:
	;
}

static void
_dbus_locale1_proxy_set_locale_ready (GObject * source_object,
                                      GAsyncResult * _res_,
                                      gpointer _user_data_)
{
	Locale1ProxySetLocaleReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	locale1_proxy_set_locale_finish ((Locale1Proxy*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_ready_data->locale = (_vala_array_free (_ready_data->locale, _ready_data->locale_length1, (GDestroyNotify) g_free), NULL);
	g_slice_free (Locale1ProxySetLocaleReadyData, _ready_data);
}

static void
_dbus_locale1_proxy_set_x11_keyboard (Locale1Proxy* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	Locale1ProxySetX11KeyboardReadyData* _ready_data;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	GVariant* _tmp18_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (Locale1ProxySetX11KeyboardReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->layout = g_variant_dup_string (_tmp13_, NULL);
	g_variant_unref (_tmp13_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->model = g_variant_dup_string (_tmp14_, NULL);
	g_variant_unref (_tmp14_);
	_tmp15_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->variant = g_variant_dup_string (_tmp15_, NULL);
	g_variant_unref (_tmp15_);
	_tmp16_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->options = g_variant_dup_string (_tmp16_, NULL);
	g_variant_unref (_tmp16_);
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->convert = g_variant_get_boolean (_tmp17_);
	g_variant_unref (_tmp17_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->interactive = g_variant_get_boolean (_tmp18_);
	g_variant_unref (_tmp18_);
	locale1_proxy_set_x11_keyboard (self, _ready_data->layout, _ready_data->model, _ready_data->variant, _ready_data->options, _ready_data->convert, _ready_data->interactive, (GAsyncReadyCallback) _dbus_locale1_proxy_set_x11_keyboard_ready, _ready_data);
	_error:
	;
}

static void
_dbus_locale1_proxy_set_x11_keyboard_ready (GObject * source_object,
                                            GAsyncResult * _res_,
                                            gpointer _user_data_)
{
	Locale1ProxySetX11KeyboardReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	locale1_proxy_set_x11_keyboard_finish ((Locale1Proxy*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->layout);
	_g_free0 (_ready_data->model);
	_g_free0 (_ready_data->variant);
	_g_free0 (_ready_data->options);
	g_slice_free (Locale1ProxySetX11KeyboardReadyData, _ready_data);
}

static void
locale1_proxy_dbus_interface_method_call (GDBusConnection* connection,
                                          const gchar* sender,
                                          const gchar* object_path,
                                          const gchar* interface_name,
                                          const gchar* method_name,
                                          GVariant* parameters,
                                          GDBusMethodInvocation* invocation,
                                          gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SetLocale") == 0) {
		_dbus_locale1_proxy_set_locale (object, parameters, invocation);
	} else if (strcmp (method_name, "SetX11Keyboard") == 0) {
		_dbus_locale1_proxy_set_x11_keyboard (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
_dbus_locale1_proxy_get_locale (Locale1Proxy* self)
{
	gchar** result;
	gint result_length1 = 0;
	GVariant* _reply;
	gchar** _tmp19_;
	GVariantBuilder _tmp20_;
	gint _tmp21_;
	result = locale1_proxy_get_locale (self, &result_length1);
	_tmp19_ = result;
	g_variant_builder_init (&_tmp20_, G_VARIANT_TYPE ("as"));
	for (_tmp21_ = 0; _tmp21_ < result_length1; _tmp21_++) {
		g_variant_builder_add_value (&_tmp20_, g_variant_new_string (*_tmp19_));
		_tmp19_++;
	}
	_reply = g_variant_builder_end (&_tmp20_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	return _reply;
}

static GVariant*
locale1_proxy_dbus_interface_get_property (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* property_name,
                                           GError** error,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Locale") == 0) {
		return _dbus_locale1_proxy_get_locale (object);
	}
	return NULL;
}

static gboolean
locale1_proxy_dbus_interface_set_property (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* property_name,
                                           GVariant* value,
                                           GError** error,
                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
locale1_proxy_register_object (gpointer object,
                               GDBusConnection* connection,
                               const gchar* path,
                               GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_locale1_proxy_dbus_interface_info), &_locale1_proxy_dbus_interface_vtable, data, _locale1_proxy_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_locale1_proxy_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
switchboard_plug_locale_locale_manager_get_instance_private (SwitchboardPlugLocaleLocaleManager* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugLocaleLocaleManager_private_offset);
}

static void
switchboard_plug_locale_locale_manager_on_settings_changed (SwitchboardPlugLocaleLocaleManager* self,
                                                            const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_KEY_INPUT_SELETION) == 0) {
		GVariant* map_array = NULL;
		GSettings* _tmp0_;
		GVariant* _tmp1_;
		GVariantIter* iter = NULL;
		GVariant* _tmp2_;
		GVariantIter* _tmp3_;
		gchar* k = NULL;
		gchar* value = NULL;
		GeeHashMap* map = NULL;
		GeeHashMap* _tmp4_;
		_tmp0_ = self->priv->settings;
		_tmp1_ = g_settings_get_value (_tmp0_, SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_KEY_INPUT_SELETION);
		map_array = _tmp1_;
		_tmp2_ = map_array;
		_tmp3_ = g_variant_iter_new (_tmp2_);
		iter = _tmp3_;
		k = NULL;
		value = NULL;
		_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		map = _tmp4_;
		while (TRUE) {
			GVariantIter* _tmp5_;
			GeeHashMap* _tmp6_;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp5_ = iter;
			if (!g_variant_iter_next (_tmp5_, "(ss)", &k, &value, NULL)) {
				break;
			}
			_tmp6_ = map;
			_tmp7_ = k;
			_tmp8_ = value;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, _tmp7_, _tmp8_);
		}
		_g_object_unref0 (map);
		_g_free0 (value);
		_g_free0 (k);
		_g_variant_iter_free0 (iter);
		_g_variant_unref0 (map_array);
	}
}

void
switchboard_plug_locale_locale_manager_set_user_language (SwitchboardPlugLocaleLocaleManager* self,
                                                          const gchar* language)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (language != NULL);
	g_debug ("LocaleManager.vala:108: Setting user language to %s", language);
	{
		AccountProxy* _tmp0_;
		_tmp0_ = self->priv->account_proxy;
		account_proxy_set_language (_tmp0_, language, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_critical ("LocaleManager.vala:113: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gchar*
switchboard_plug_locale_locale_manager_get_user_language (SwitchboardPlugLocaleLocaleManager* self)
{
	gchar* lang = NULL;
	AccountProxy* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->account_proxy;
	_tmp1_ = account_proxy_get_language (_tmp0_);
	_tmp2_ = _tmp1_;
	lang = _tmp2_;
	_tmp3_ = lang;
	if (!string_contains (_tmp3_, ".UTF-8")) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = lang;
		_tmp5_ = g_strconcat (_tmp4_, ".UTF-8", NULL);
		_g_free0 (lang);
		lang = _tmp5_;
	}
	result = lang;
	return result;
}

void
switchboard_plug_locale_locale_manager_set_user_format (SwitchboardPlugLocaleLocaleManager* self,
                                                        const gchar* language)
{
	GSettings* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (language != NULL);
	g_debug ("LocaleManager.vala:129: Setting user format to %s", language);
	{
		AccountProxy* _tmp0_;
		_tmp0_ = self->priv->account_proxy;
		account_proxy_set_formats_locale (_tmp0_, language, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("LocaleManager.vala:134: Error setting formats on AccountsService: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp3_ = self->priv->locale_settings;
	g_settings_set_string (_tmp3_, "region", language);
}

gchar*
switchboard_plug_locale_locale_manager_get_user_format (SwitchboardPlugLocaleLocaleManager* self)
{
	gboolean _tmp0_ = FALSE;
	AccountProxy* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	gchar* user_format = NULL;
	GSettings* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* monetary = NULL;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* _tmp22_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->account_proxy;
	_tmp2_ = account_proxy_get_formats_locale (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ != NULL;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		AccountProxy* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = self->priv->account_proxy;
		_tmp7_ = account_proxy_get_formats_locale (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp0_ = g_strcmp0 (_tmp9_, "") != 0;
		_g_free0 (_tmp9_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		AccountProxy* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = self->priv->account_proxy;
		_tmp11_ = account_proxy_get_formats_locale (_tmp10_);
		_tmp12_ = _tmp11_;
		result = _tmp12_;
		return result;
	}
	_tmp13_ = self->priv->locale_settings;
	_tmp14_ = g_settings_get_string (_tmp13_, "region");
	user_format = _tmp14_;
	_tmp15_ = user_format;
	if (g_strcmp0 (_tmp15_, "") != 0) {
		result = user_format;
		return result;
	}
	_tmp16_ = setlocale (LC_MONETARY, NULL);
	_tmp17_ = g_strdup (_tmp16_);
	monetary = _tmp17_;
	_tmp18_ = monetary;
	if (_tmp18_ != NULL) {
		result = monetary;
		_g_free0 (user_format);
		return result;
	}
	_tmp20_ = switchboard_plug_locale_locale_manager_get_system_locale (self);
	_tmp19_ = _tmp20_;
	if (_tmp19_ == NULL) {
		gchar* _tmp21_;
		_tmp21_ = g_strdup ("en_US.UTF-8");
		_g_free0 (_tmp19_);
		_tmp19_ = _tmp21_;
	}
	_tmp22_ = _tmp19_;
	_tmp19_ = NULL;
	result = _tmp22_;
	_g_free0 (_tmp19_);
	_g_free0 (monetary);
	_g_free0 (user_format);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gchar*
switchboard_plug_locale_locale_manager_get_system_locale (SwitchboardPlugLocaleLocaleManager* self)
{
	Locale1Proxy* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_ = 0;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->locale1_proxy;
	_tmp1_ = locale1_proxy_get_locale (_tmp0_, &_tmp2_);
	_tmp1__length1 = _tmp2_;
	_tmp3_ = _tmp1_;
	_tmp3__length1 = _tmp1__length1;
	{
		gchar** locale_collection = NULL;
		gint locale_collection_length1 = 0;
		gint _locale_collection_size_ = 0;
		gint locale_it = 0;
		locale_collection = _tmp3_;
		locale_collection_length1 = _tmp3__length1;
		for (locale_it = 0; locale_it < locale_collection_length1; locale_it = locale_it + 1) {
			const gchar* locale = NULL;
			locale = locale_collection[locale_it];
			{
				const gchar* _tmp4_;
				_tmp4_ = locale;
				if (g_str_has_prefix (_tmp4_, "LANG=")) {
					const gchar* _tmp5_;
					gchar* _tmp6_;
					_tmp5_ = locale;
					_tmp6_ = string_replace (_tmp5_, "LANG=", "");
					result = _tmp6_;
					locale_collection = (_vala_array_free (locale_collection, locale_collection_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
		locale_collection = (_vala_array_free (locale_collection, locale_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = NULL;
	return result;
}

static void
switchboard_plug_locale_locale_manager_apply_to_system_data_free (gpointer _data)
{
	SwitchboardPlugLocaleLocaleManagerApplyToSystemData* _data_;
	_data_ = _data;
	_g_free0 (_data_->language);
	_g_free0 (_data_->format);
	_g_object_unref0 (_data_->self);
	g_slice_free (SwitchboardPlugLocaleLocaleManagerApplyToSystemData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
switchboard_plug_locale_locale_manager_apply_to_system (SwitchboardPlugLocaleLocaleManager* self,
                                                        const gchar* language,
                                                        const gchar* format,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	SwitchboardPlugLocaleLocaleManagerApplyToSystemData* _data_;
	SwitchboardPlugLocaleLocaleManager* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (language != NULL);
	_data_ = g_slice_new0 (SwitchboardPlugLocaleLocaleManagerApplyToSystemData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, switchboard_plug_locale_locale_manager_apply_to_system_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (language);
	_g_free0 (_data_->language);
	_data_->language = _tmp1_;
	_tmp2_ = g_strdup (format);
	_g_free0 (_data_->format);
	_data_->format = _tmp2_;
	switchboard_plug_locale_locale_manager_apply_to_system_co (_data_);
}

void
switchboard_plug_locale_locale_manager_apply_to_system_finish (SwitchboardPlugLocaleLocaleManager* self,
                                                               GAsyncResult* _res_,
                                                               GError** error)
{
	SwitchboardPlugLocaleLocaleManagerApplyToSystemData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
switchboard_plug_locale_locale_manager_apply_to_system_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	SwitchboardPlugLocaleLocaleManagerApplyToSystemData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	switchboard_plug_locale_locale_manager_apply_to_system_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
switchboard_plug_locale_locale_manager_apply_to_system_co (SwitchboardPlugLocaleLocaleManagerApplyToSystemData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_strdup_printf ("LANG=%s", _data_->language);
	_data_->_tmp1_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp1_[0] = _data_->_tmp0_;
	_data_->locale = _data_->_tmp1_;
	_data_->locale_length1 = 1;
	_data_->_locale_size_ = _data_->locale_length1;
	if (_data_->format != NULL) {
		_data_->_tmp2_ = g_strdup_printf ("LC_TIME=%s", _data_->format);
		_vala_array_add2 (&_data_->locale, &_data_->locale_length1, &_data_->_locale_size_, _data_->_tmp2_);
		_data_->_tmp3_ = g_strdup_printf ("LC_NUMERIC=%s", _data_->format);
		_vala_array_add3 (&_data_->locale, &_data_->locale_length1, &_data_->_locale_size_, _data_->_tmp3_);
		_data_->_tmp4_ = g_strdup_printf ("LC_MONETARY=%s", _data_->format);
		_vala_array_add4 (&_data_->locale, &_data_->locale_length1, &_data_->_locale_size_, _data_->_tmp4_);
		_data_->_tmp5_ = g_strdup_printf ("LC_MEASUREMENT=%s", _data_->format);
		_vala_array_add5 (&_data_->locale, &_data_->locale_length1, &_data_->_locale_size_, _data_->_tmp5_);
	}
	{
		_data_->_tmp6_ = _data_->self->priv->locale1_proxy;
		_data_->_tmp7_ = _data_->locale;
		_data_->_tmp7__length1 = _data_->locale_length1;
		_data_->_state_ = 1;
		locale1_proxy_set_locale (_data_->_tmp6_, _data_->_tmp7_, (gint) _data_->_tmp7__length1, TRUE, switchboard_plug_locale_locale_manager_apply_to_system_ready, _data_);
		return FALSE;
		_state_1:
		locale1_proxy_set_locale_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp8_ = _data_->e;
		_data_->_tmp9_ = _g_error_copy0 (_data_->_tmp8_);
		_data_->_inner_error0_ = _data_->_tmp9_;
		_g_error_free0 (_data_->e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_data_->locale = (_vala_array_free (_data_->locale, _data_->locale_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp10_ = g_strdup ("");
	_data_->layouts = _data_->_tmp10_;
	_data_->_tmp11_ = g_strdup ("");
	_data_->variants = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->self->priv->input_settings;
	_data_->_tmp13_ = g_settings_get_value (_data_->_tmp12_, SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_KEY_INPUT_SOURCES);
	_data_->variant = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->variant;
	_data_->nr_keymaps = (gint) g_variant_n_children (_data_->_tmp14_);
	{
		_data_->i = 0;
		{
			_data_->_tmp15_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp15_) {
					_data_->_tmp16_ = _data_->i;
					_data_->i = _data_->_tmp16_ + 1;
				}
				_data_->_tmp15_ = FALSE;
				if (!(_data_->i < _data_->nr_keymaps)) {
					break;
				}
				_data_->_tmp17_ = _data_->variant;
				_data_->_tmp18_ = g_variant_get_child_value (_data_->_tmp17_, (gsize) _data_->i);
				_data_->entry = _data_->_tmp18_;
				_data_->_tmp19_ = _data_->entry;
				_data_->_tmp20_ = g_variant_get_child_value (_data_->_tmp19_, (gsize) 1);
				_data_->_tmp21_ = _data_->_tmp20_;
				_data_->_tmp22_ = g_variant_get_string (_data_->_tmp21_, NULL);
				_data_->_tmp23_ = g_strdup (_data_->_tmp22_);
				_data_->_tmp24_ = _data_->_tmp23_;
				_g_variant_unref0 (_data_->_tmp21_);
				_data_->code = _data_->_tmp24_;
				_data_->_tmp25_ = _data_->self->priv->xkbinfo;
				_data_->_tmp26_ = _data_->code;
				_data_->_tmp27_ = NULL;
				_data_->_tmp28_ = NULL;
				gnome_xkb_info_get_layout_info (_data_->_tmp25_, _data_->_tmp26_, NULL, NULL, &_data_->_tmp27_, &_data_->_tmp28_);
				_g_free0 (_data_->l);
				_data_->_tmp29_ = g_strdup (_data_->_tmp27_);
				_data_->l = _data_->_tmp29_;
				_g_free0 (_data_->v);
				_data_->_tmp30_ = g_strdup (_data_->_tmp28_);
				_data_->v = _data_->_tmp30_;
				_data_->_tmp31_ = _data_->layouts;
				_data_->_tmp32_ = _data_->l;
				_data_->_tmp33_ = g_strconcat (_data_->_tmp31_, _data_->_tmp32_, NULL);
				_g_free0 (_data_->layouts);
				_data_->layouts = _data_->_tmp33_;
				_data_->_tmp34_ = _data_->variants;
				_data_->_tmp35_ = _data_->v;
				_data_->_tmp36_ = g_strconcat (_data_->_tmp34_, _data_->_tmp35_, NULL);
				_g_free0 (_data_->variants);
				_data_->variants = _data_->_tmp36_;
				if (_data_->i < (_data_->nr_keymaps - 1)) {
					_data_->_tmp37_ = _data_->layouts;
					_data_->_tmp38_ = g_strconcat (_data_->_tmp37_, ",", NULL);
					_g_free0 (_data_->layouts);
					_data_->layouts = _data_->_tmp38_;
					_data_->_tmp39_ = _data_->variants;
					_data_->_tmp40_ = g_strconcat (_data_->_tmp39_, ",", NULL);
					_g_free0 (_data_->variants);
					_data_->variants = _data_->_tmp40_;
				}
				_g_free0 (_data_->code);
				_g_variant_unref0 (_data_->entry);
			}
		}
	}
	{
		_data_->_tmp41_ = _data_->self->priv->locale1_proxy;
		_data_->_tmp42_ = _data_->layouts;
		_data_->_tmp43_ = _data_->variants;
		_data_->_state_ = 2;
		locale1_proxy_set_x11_keyboard (_data_->_tmp41_, _data_->_tmp42_, "", _data_->_tmp43_, "", TRUE, TRUE, switchboard_plug_locale_locale_manager_apply_to_system_ready, _data_);
		return FALSE;
		_state_2:
		locale1_proxy_set_x11_keyboard_finish (_data_->_tmp41_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp44_ = _data_->_vala1_e;
		_data_->_tmp45_ = _g_error_copy0 (_data_->_tmp44_);
		_data_->_inner_error0_ = _data_->_tmp45_;
		_g_error_free0 (_data_->_vala1_e);
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_variant_unref0 (_data_->variant);
		_g_free0 (_data_->v);
		_g_free0 (_data_->l);
		_g_free0 (_data_->variants);
		_g_free0 (_data_->layouts);
		_data_->locale = (_vala_array_free (_data_->locale, _data_->locale_length1, (GDestroyNotify) g_free), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_variant_unref0 (_data_->variant);
	_g_free0 (_data_->v);
	_g_free0 (_data_->l);
	_g_free0 (_data_->variants);
	_g_free0 (_data_->layouts);
	_data_->locale = (_vala_array_free (_data_->locale, _data_->locale_length1, (GDestroyNotify) g_free), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

SwitchboardPlugLocaleLocaleManager*
switchboard_plug_locale_locale_manager_get_default (void)
{
	SwitchboardPlugLocaleLocaleManager* _tmp0_;
	SwitchboardPlugLocaleLocaleManager* _tmp2_;
	SwitchboardPlugLocaleLocaleManager* result;
	_tmp0_ = switchboard_plug_locale_locale_manager_instance;
	if (_tmp0_ == NULL) {
		SwitchboardPlugLocaleLocaleManager* _tmp1_;
		_tmp1_ = switchboard_plug_locale_locale_manager_new ();
		_g_object_unref0 (switchboard_plug_locale_locale_manager_instance);
		switchboard_plug_locale_locale_manager_instance = _tmp1_;
	}
	_tmp2_ = switchboard_plug_locale_locale_manager_instance;
	result = _tmp2_;
	return result;
}

SwitchboardPlugLocaleLocaleManager*
switchboard_plug_locale_locale_manager_construct (GType object_type)
{
	SwitchboardPlugLocaleLocaleManager * self = NULL;
	self = (SwitchboardPlugLocaleLocaleManager*) g_object_new (object_type, NULL);
	return self;
}

SwitchboardPlugLocaleLocaleManager*
switchboard_plug_locale_locale_manager_new (void)
{
	return switchboard_plug_locale_locale_manager_construct (SWITCHBOARD_PLUG_LOCALE_TYPE_LOCALE_MANAGER);
}

gboolean
switchboard_plug_locale_locale_manager_get_is_connected (SwitchboardPlugLocaleLocaleManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_connected;
	return result;
}

static void
switchboard_plug_locale_locale_manager_set_is_connected (SwitchboardPlugLocaleLocaleManager* self,
                                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_locale_locale_manager_get_is_connected (self);
	if (old_value != value) {
		self->priv->_is_connected = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_locale_locale_manager_properties[SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_IS_CONNECTED_PROPERTY]);
	}
}

static void
_switchboard_plug_locale_locale_manager_on_settings_changed_g_settings_changed (GSettings* _sender,
                                                                                const gchar* key,
                                                                                gpointer self)
{
	switchboard_plug_locale_locale_manager_on_settings_changed ((SwitchboardPlugLocaleLocaleManager*) self, key);
}

static GObject *
switchboard_plug_locale_locale_manager_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugLocaleLocaleManager * self;
	GnomeXkbInfo* _tmp0_;
	guint uid = 0U;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	gboolean _tmp19_ = FALSE;
	AccountProxy* _tmp20_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (switchboard_plug_locale_locale_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_TYPE_LOCALE_MANAGER, SwitchboardPlugLocaleLocaleManager);
	_tmp0_ = gnome_xkb_info_new ();
	_g_object_unref0 (self->priv->xkbinfo);
	self->priv->xkbinfo = _tmp0_;
	uid = (guint) getuid ();
	_tmp1_ = g_settings_new (SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_GNOME_DESKTOP_INPUT_SOURCES);
	_g_object_unref0 (self->priv->input_settings);
	self->priv->input_settings = _tmp1_;
	_tmp2_ = g_settings_new (SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_GNOME_LOCALE_KEY);
	_g_object_unref0 (self->priv->locale_settings);
	self->priv->locale_settings = _tmp2_;
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp3_;
		Locale1Proxy* _tmp4_ = NULL;
		GDBusConnection* _tmp5_;
		Locale1Proxy* _tmp6_;
		Locale1Proxy* _tmp7_;
		AccountProxy* _tmp8_ = NULL;
		GDBusConnection* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		AccountProxy* _tmp12_;
		AccountProxy* _tmp13_;
		AccountProxy* _tmp14_;
		_tmp3_ = g_bus_get_sync (G_BUS_TYPE_SYSTEM, NULL, &_inner_error0_);
		connection = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp5_ = connection;
		_tmp6_ = (Locale1Proxy*) g_initable_new (TYPE_LOCALE1_PROXY_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", "org.freedesktop.locale1", "g-connection", _tmp5_, "g-object-path", "/org/freedesktop/locale1", "g-interface-name", "org.freedesktop.locale1", NULL);
		_tmp4_ = (Locale1Proxy*) _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (connection);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (self->priv->locale1_proxy);
		self->priv->locale1_proxy = _tmp7_;
		_tmp9_ = connection;
		_tmp10_ = g_strdup_printf ("/org/freedesktop/Accounts/User%u", uid);
		_tmp11_ = _tmp10_;
		_tmp12_ = (AccountProxy*) g_initable_new (TYPE_ACCOUNT_PROXY_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_NONE, "g-name", "org.freedesktop.Accounts", "g-connection", _tmp9_, "g-object-path", _tmp11_, "g-interface-name", "org.freedesktop.Accounts.User", NULL);
		_tmp13_ = (AccountProxy*) _tmp12_;
		_g_free0 (_tmp11_);
		_tmp8_ = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp4_);
			_g_object_unref0 (connection);
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
		}
		_tmp14_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (self->priv->account_proxy);
		self->priv->account_proxy = _tmp14_;
		_g_object_unref0 (_tmp8_);
		_g_object_unref0 (_tmp4_);
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		const gchar* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		_tmp16_ = _tmp15_->message;
		g_critical ("LocaleManager.vala:79: %s", _tmp16_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp17_ = g_settings_new ("io.elementary.settings.locale");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp17_;
	_tmp18_ = self->priv->settings;
	g_signal_connect_object (_tmp18_, "changed", (GCallback) _switchboard_plug_locale_locale_manager_on_settings_changed_g_settings_changed, self, 0);
	_tmp20_ = self->priv->account_proxy;
	if (_tmp20_ != NULL) {
		Locale1Proxy* _tmp21_;
		_tmp21_ = self->priv->locale1_proxy;
		_tmp19_ = _tmp21_ != NULL;
	} else {
		_tmp19_ = FALSE;
	}
	switchboard_plug_locale_locale_manager_set_is_connected (self, _tmp19_);
	return obj;
}

static void
switchboard_plug_locale_locale_manager_class_init (SwitchboardPlugLocaleLocaleManagerClass * klass,
                                                   gpointer klass_data)
{
	switchboard_plug_locale_locale_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugLocaleLocaleManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_locale_locale_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_locale_locale_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_locale_locale_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_locale_locale_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_IS_CONNECTED_PROPERTY, switchboard_plug_locale_locale_manager_properties[SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_IS_CONNECTED_PROPERTY] = g_param_spec_boolean ("is-connected", "is-connected", "is-connected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
switchboard_plug_locale_locale_manager_instance_init (SwitchboardPlugLocaleLocaleManager * self,
                                                      gpointer klass)
{
	self->priv = switchboard_plug_locale_locale_manager_get_instance_private (self);
	self->priv->_is_connected = FALSE;
}

static void
switchboard_plug_locale_locale_manager_finalize (GObject * obj)
{
	SwitchboardPlugLocaleLocaleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_LOCALE_TYPE_LOCALE_MANAGER, SwitchboardPlugLocaleLocaleManager);
	_g_object_unref0 (self->priv->locale1_proxy);
	_g_object_unref0 (self->priv->account_proxy);
	_g_object_unref0 (self->priv->input_settings);
	_g_object_unref0 (self->priv->locale_settings);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->xkbinfo);
	G_OBJECT_CLASS (switchboard_plug_locale_locale_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
switchboard_plug_locale_locale_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugLocaleLocaleManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_locale_locale_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugLocaleLocaleManager), 0, (GInstanceInitFunc) switchboard_plug_locale_locale_manager_instance_init, NULL };
	GType switchboard_plug_locale_locale_manager_type_id;
	switchboard_plug_locale_locale_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "SwitchboardPlugLocaleLocaleManager", &g_define_type_info, 0);
	SwitchboardPlugLocaleLocaleManager_private_offset = g_type_add_instance_private (switchboard_plug_locale_locale_manager_type_id, sizeof (SwitchboardPlugLocaleLocaleManagerPrivate));
	return switchboard_plug_locale_locale_manager_type_id;
}

GType
switchboard_plug_locale_locale_manager_get_type (void)
{
	static gsize switchboard_plug_locale_locale_manager_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_locale_locale_manager_type_id__once)) {
		GType switchboard_plug_locale_locale_manager_type_id;
		switchboard_plug_locale_locale_manager_type_id = switchboard_plug_locale_locale_manager_get_type_once ();
		g_once_init_leave (&switchboard_plug_locale_locale_manager_type_id__once, switchboard_plug_locale_locale_manager_type_id);
	}
	return switchboard_plug_locale_locale_manager_type_id__once;
}

static void
_vala_switchboard_plug_locale_locale_manager_get_property (GObject * object,
                                                           guint property_id,
                                                           GValue * value,
                                                           GParamSpec * pspec)
{
	SwitchboardPlugLocaleLocaleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_TYPE_LOCALE_MANAGER, SwitchboardPlugLocaleLocaleManager);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_IS_CONNECTED_PROPERTY:
		g_value_set_boolean (value, switchboard_plug_locale_locale_manager_get_is_connected (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_locale_locale_manager_set_property (GObject * object,
                                                           guint property_id,
                                                           const GValue * value,
                                                           GParamSpec * pspec)
{
	SwitchboardPlugLocaleLocaleManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_LOCALE_TYPE_LOCALE_MANAGER, SwitchboardPlugLocaleLocaleManager);
	switch (property_id) {
		case SWITCHBOARD_PLUG_LOCALE_LOCALE_MANAGER_IS_CONNECTED_PROPERTY:
		switchboard_plug_locale_locale_manager_set_is_connected (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

