/* ExcludeTreeView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ExcludeTreeView.vala, do not modify */

/*-
* Copyright (c) 2014-2017 elementary LLC. (http://launchpad.net/switchboard-plug-security-privacy)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Corentin Noël <corentin@elementaryos.org>
*/

#include "security-privacy.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <float.h>
#include <math.h>
#include <gio/gdesktopappinfo.h>
#include <gee.h>
#include <zeitgeist-datamodel.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	EXCLUDE_TREE_VIEW_0_PROPERTY,
	EXCLUDE_TREE_VIEW_NUM_PROPERTIES
};
static GParamSpec* exclude_tree_view_properties[EXCLUDE_TREE_VIEW_NUM_PROPERTIES];
typedef enum  {
	EXCLUDE_TREE_VIEW_NOT_COLUMNS_NAME,
	EXCLUDE_TREE_VIEW_NOT_COLUMNS_ICON,
	EXCLUDE_TREE_VIEW_NOT_COLUMNS_PATH,
	EXCLUDE_TREE_VIEW_NOT_COLUMNS_IS_APP,
	EXCLUDE_TREE_VIEW_NOT_COLUMNS_N_COLUMNS
} ExcludeTreeViewNotColumns;

#define EXCLUDE_TREE_VIEW_TYPE_NOT_COLUMNS (exclude_tree_view_not_columns_get_type ())
#define _security_privacy_application_blacklist_unref0(var) ((var == NULL) ? NULL : (var = (security_privacy_application_blacklist_unref (var), NULL)))
#define _security_privacy_path_blacklist_unref0(var) ((var == NULL) ? NULL : (var = (security_privacy_path_blacklist_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block8Data Block8Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

struct _ExcludeTreeViewPrivate {
	SecurityPrivacyApplicationBlacklist* app_blacklist;
	SecurityPrivacyPathBlacklist* path_blacklist;
};

struct _Block7Data {
	int _ref_count_;
	ExcludeTreeView* self;
	GtkListStore* list_store;
	GtkTreeView* view;
	GtkButton* remove_button;
};

struct _Block8Data {
	int _ref_count_;
	ExcludeTreeView* self;
	GtkFileDialog* chooser;
};

static gint ExcludeTreeView_private_offset;
static gpointer exclude_tree_view_parent_class = NULL;

static GType exclude_tree_view_not_columns_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GObject * exclude_tree_view_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _exclude_tree_view___lambda6_ (ExcludeTreeView* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda7_ (Block8Data* _data8_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda7__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void __exclude_tree_view___lambda6__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self);
static void _exclude_tree_view___lambda8_ (Block7Data* _data7_);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __exclude_tree_view___lambda8__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self);
static void _exclude_tree_view___lambda9_ (Block7Data* _data7_);
static void __exclude_tree_view___lambda9__gtk_tree_view_cursor_changed (GtkTreeView* _sender,
                                                                  gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _exclude_tree_view___lambda10_ (ExcludeTreeView* self,
                                     GDesktopAppInfo* info);
static void __exclude_tree_view___lambda10__security_privacy_dialogs_app_chooser_app_chosen (SecurityPrivacyDialogsAppChooser* _sender,
                                                                                      GDesktopAppInfo* app_info,
                                                                                      gpointer self);
static void _exclude_tree_view___lambda11_ (Block7Data* _data7_,
                                     const gchar* name,
                                     ZeitgeistEvent* ev);
static void __exclude_tree_view___lambda11__security_privacy_application_blacklist_application_added (SecurityPrivacyApplicationBlacklist* _sender,
                                                                                               const gchar* app,
                                                                                               ZeitgeistEvent* ev,
                                                                                               gpointer self);
static void _exclude_tree_view___lambda12_ (Block7Data* _data7_,
                                     const gchar* path);
static void __exclude_tree_view___lambda12__security_privacy_path_blacklist_folder_added (SecurityPrivacyPathBlacklist* _sender,
                                                                                   const gchar* path,
                                                                                   gpointer self);
static void exclude_tree_view_finalize (GObject * obj);
static GType exclude_tree_view_get_type_once (void);

static inline gpointer
exclude_tree_view_get_instance_private (ExcludeTreeView* self)
{
	return G_STRUCT_MEMBER_P (self, ExcludeTreeView_private_offset);
}

static GType
exclude_tree_view_not_columns_get_type_once (void)
{
	static const GEnumValue values[] = {{EXCLUDE_TREE_VIEW_NOT_COLUMNS_NAME, "EXCLUDE_TREE_VIEW_NOT_COLUMNS_NAME", "name"}, {EXCLUDE_TREE_VIEW_NOT_COLUMNS_ICON, "EXCLUDE_TREE_VIEW_NOT_COLUMNS_ICON", "icon"}, {EXCLUDE_TREE_VIEW_NOT_COLUMNS_PATH, "EXCLUDE_TREE_VIEW_NOT_COLUMNS_PATH", "path"}, {EXCLUDE_TREE_VIEW_NOT_COLUMNS_IS_APP, "EXCLUDE_TREE_VIEW_NOT_COLUMNS_IS_APP", "is-app"}, {EXCLUDE_TREE_VIEW_NOT_COLUMNS_N_COLUMNS, "EXCLUDE_TREE_VIEW_NOT_COLUMNS_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType exclude_tree_view_not_columns_type_id;
	exclude_tree_view_not_columns_type_id = g_enum_register_static ("ExcludeTreeViewNotColumns", values);
	return exclude_tree_view_not_columns_type_id;
}

static GType
exclude_tree_view_not_columns_get_type (void)
{
	static volatile gsize exclude_tree_view_not_columns_type_id__once = 0;
	if (g_once_init_enter (&exclude_tree_view_not_columns_type_id__once)) {
		GType exclude_tree_view_not_columns_type_id;
		exclude_tree_view_not_columns_type_id = exclude_tree_view_not_columns_get_type_once ();
		g_once_init_leave (&exclude_tree_view_not_columns_type_id__once, exclude_tree_view_not_columns_type_id);
	}
	return exclude_tree_view_not_columns_type_id__once;
}

ExcludeTreeView*
exclude_tree_view_construct (GType object_type)
{
	ExcludeTreeView * self = NULL;
	self = (ExcludeTreeView*) g_object_new (object_type, NULL);
	return self;
}

ExcludeTreeView*
exclude_tree_view_new (void)
{
	return exclude_tree_view_construct (TYPE_EXCLUDE_TREE_VIEW);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		ExcludeTreeView* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->remove_button);
		_g_object_unref0 (_data7_->view);
		_g_object_unref0 (_data7_->list_store);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		ExcludeTreeView* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->chooser);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda7_ (Block8Data* _data8_,
            GObject* obj,
            GAsyncResult* res)
{
	ExcludeTreeView* self;
	GError* _inner_error0_ = NULL;
	self = _data8_->self;
	g_return_if_fail (res != NULL);
	{
		GFile* folder = NULL;
		GtkFileDialog* _tmp0_;
		GFile* _tmp1_;
		gchar* folder_path = NULL;
		GFile* _tmp2_;
		gchar* _tmp3_;
		SecurityPrivacyPathBlacklist* _tmp4_;
		const gchar* _tmp5_;
		_tmp0_ = _data8_->chooser;
		_tmp1_ = gtk_file_dialog_select_folder_finish (_tmp0_, res, &_inner_error0_);
		folder = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = folder;
		_tmp3_ = g_file_get_path (_tmp2_);
		folder_path = _tmp3_;
		_tmp4_ = self->priv->path_blacklist;
		_tmp5_ = folder_path;
		if (security_privacy_path_blacklist_is_duplicate (_tmp4_, _tmp5_) == FALSE) {
			SecurityPrivacyPathBlacklist* _tmp6_;
			const gchar* _tmp7_;
			_tmp6_ = self->priv->path_blacklist;
			_tmp7_ = folder_path;
			security_privacy_path_blacklist_block (_tmp6_, _tmp7_);
		}
		_g_free0 (folder_path);
		_g_object_unref0 (folder);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = err;
		_tmp9_ = _tmp8_->message;
		g_warning ("ExcludeTreeView.vala:87: Failed to select excluded folder: %s", _tmp9_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda7__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda7_ (self, source_object, res);
	block8_data_unref (self);
}

static void
_exclude_tree_view___lambda6_ (ExcludeTreeView* self)
{
	Block8Data* _data8_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkFileDialog* _tmp2_ = NULL;
	GtkFileDialog* _tmp3_;
	GtkRoot* _tmp4_;
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = g_strdup (_ ("Select a folder to blacklist"));
	_tmp1_ = g_strdup (_ ("Add"));
	_tmp2_ = gtk_file_dialog_new ();
	gtk_file_dialog_set_title (_tmp2_, _tmp0_);
	_g_free0 (_tmp0_);
	gtk_file_dialog_set_accept_label (_tmp2_, _tmp1_);
	_g_free0 (_tmp1_);
	_data8_->chooser = _tmp2_;
	_tmp3_ = _data8_->chooser;
	_tmp4_ = gtk_widget_get_root ((GtkWidget*) self);
	gtk_file_dialog_select_folder (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_window_get_type (), GtkWindow), NULL, ___lambda7__gasync_ready_callback, block8_data_ref (_data8_));
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
__exclude_tree_view___lambda6__gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self)
{
	_exclude_tree_view___lambda6_ ((ExcludeTreeView*) self);
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
_exclude_tree_view___lambda8_ (Block7Data* _data7_)
{
	ExcludeTreeView* self;
	GtkTreePath* path = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkTreeView* _tmp0_;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeViewColumn* _tmp2_ = NULL;
	GtkTreeViewColumn* _tmp3_;
	GtkTreePath* _tmp4_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp5_;
	GtkTreePath* _tmp6_;
	GtkTreeIter _tmp7_ = {0};
	GValue is_app = {0};
	GtkListStore* _tmp8_;
	GtkTreeIter _tmp9_;
	GValue _tmp10_ = {0};
	GtkListStore* _tmp21_;
	self = _data7_->self;
	_tmp0_ = _data7_->view;
	gtk_tree_view_get_cursor (_tmp0_, &_tmp1_, &_tmp2_);
	__vala_GtkTreePath_free0 (path);
	path = _tmp1_;
	_g_object_unref0 (column);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	column = _tmp3_;
	_tmp4_ = path;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (column);
		__vala_GtkTreePath_free0 (path);
		return;
	}
	_tmp5_ = _data7_->list_store;
	_tmp6_ = path;
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp5_, &_tmp7_, _tmp6_);
	iter = _tmp7_;
	_tmp8_ = _data7_->list_store;
	_tmp9_ = iter;
	gtk_tree_model_get_value ((GtkTreeModel*) _tmp8_, &_tmp9_, (gint) EXCLUDE_TREE_VIEW_NOT_COLUMNS_IS_APP, &_tmp10_);
	G_IS_VALUE (&is_app) ? (g_value_unset (&is_app), NULL) : NULL;
	is_app = _tmp10_;
	if (g_value_get_boolean (&is_app) == TRUE) {
		gchar* name = NULL;
		GtkListStore* _tmp11_;
		GtkTreeIter _tmp12_;
		gchar* _tmp13_ = NULL;
		SecurityPrivacyApplicationBlacklist* _tmp14_;
		const gchar* _tmp15_;
		_tmp11_ = _data7_->list_store;
		_tmp12_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp11_, &_tmp12_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_PATH, &_tmp13_, -1);
		_g_free0 (name);
		name = _tmp13_;
		_tmp14_ = self->priv->app_blacklist;
		_tmp15_ = name;
		security_privacy_application_blacklist_unblock (_tmp14_, _tmp15_);
		_g_free0 (name);
	} else {
		gchar* name = NULL;
		GtkListStore* _tmp16_;
		GtkTreeIter _tmp17_;
		gchar* _tmp18_ = NULL;
		SecurityPrivacyPathBlacklist* _tmp19_;
		const gchar* _tmp20_;
		_tmp16_ = _data7_->list_store;
		_tmp17_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp16_, &_tmp17_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_PATH, &_tmp18_, -1);
		_g_free0 (name);
		name = _tmp18_;
		_tmp19_ = self->priv->path_blacklist;
		_tmp20_ = name;
		security_privacy_path_blacklist_unblock (_tmp19_, _tmp20_);
		_g_free0 (name);
	}
	_tmp21_ = _data7_->list_store;
	gtk_list_store_remove (_tmp21_, &iter);
	G_IS_VALUE (&is_app) ? (g_value_unset (&is_app), NULL) : NULL;
	_g_object_unref0 (column);
	__vala_GtkTreePath_free0 (path);
}

static void
__exclude_tree_view___lambda8__gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self)
{
	_exclude_tree_view___lambda8_ (self);
}

static void
_exclude_tree_view___lambda9_ (Block7Data* _data7_)
{
	ExcludeTreeView* self;
	GtkTreePath* path = NULL;
	GtkTreeViewColumn* column = NULL;
	GtkTreeView* _tmp0_;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreeViewColumn* _tmp2_ = NULL;
	GtkTreeViewColumn* _tmp3_;
	GtkButton* _tmp4_;
	GtkTreePath* _tmp5_;
	self = _data7_->self;
	_tmp0_ = _data7_->view;
	gtk_tree_view_get_cursor (_tmp0_, &_tmp1_, &_tmp2_);
	__vala_GtkTreePath_free0 (path);
	path = _tmp1_;
	_g_object_unref0 (column);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	column = _tmp3_;
	_tmp4_ = _data7_->remove_button;
	_tmp5_ = path;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, _tmp5_ != NULL);
	_g_object_unref0 (column);
	__vala_GtkTreePath_free0 (path);
}

static void
__exclude_tree_view___lambda9__gtk_tree_view_cursor_changed (GtkTreeView* _sender,
                                                             gpointer self)
{
	_exclude_tree_view___lambda9_ (self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_exclude_tree_view___lambda10_ (ExcludeTreeView* self,
                                GDesktopAppInfo* info)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	SecurityPrivacyApplicationBlacklist* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (info != NULL);
	_tmp0_ = g_desktop_app_info_get_filename (info);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = self->priv->app_blacklist;
	_tmp4_ = file;
	_tmp5_ = g_file_get_basename (_tmp4_);
	_tmp6_ = _tmp5_;
	security_privacy_application_blacklist_block (_tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_object_unref0 (file);
}

static void
__exclude_tree_view___lambda10__security_privacy_dialogs_app_chooser_app_chosen (SecurityPrivacyDialogsAppChooser* _sender,
                                                                                 GDesktopAppInfo* app_info,
                                                                                 gpointer self)
{
	_exclude_tree_view___lambda10_ ((ExcludeTreeView*) self, app_info);
}

static void
_exclude_tree_view___lambda11_ (Block7Data* _data7_,
                                const gchar* name,
                                ZeitgeistEvent* ev)
{
	ExcludeTreeView* self;
	GtkTreeIter it = {0};
	GList* _tmp0_;
	self = _data7_->self;
	g_return_if_fail (name != NULL);
	g_return_if_fail (ev != NULL);
	_tmp0_ = g_app_info_get_all ();
	{
		GList* app_info_collection = NULL;
		GList* app_info_it = NULL;
		app_info_collection = _tmp0_;
		for (app_info_it = app_info_collection; app_info_it != NULL; app_info_it = app_info_it->next) {
			GAppInfo* _tmp1_;
			GAppInfo* app_info = NULL;
			_tmp1_ = _g_object_ref0 ((GAppInfo*) app_info_it->data);
			app_info = _tmp1_;
			{
				GAppInfo* _tmp2_;
				_tmp2_ = app_info;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, G_TYPE_DESKTOP_APP_INFO)) {
					GFile* file = NULL;
					GAppInfo* _tmp3_;
					const gchar* _tmp4_;
					const gchar* _tmp5_;
					GFile* _tmp6_;
					GFile* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gboolean _tmp10_;
					_tmp3_ = app_info;
					_tmp4_ = g_desktop_app_info_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo));
					_tmp5_ = _tmp4_;
					_tmp6_ = g_file_new_for_path (_tmp5_);
					file = _tmp6_;
					_tmp7_ = file;
					_tmp8_ = g_file_get_basename (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_strcmp0 (_tmp9_, name) == 0;
					_g_free0 (_tmp9_);
					if (_tmp10_) {
						GtkListStore* _tmp11_;
						GtkTreeIter _tmp12_ = {0};
						GtkListStore* _tmp13_;
						GtkTreeIter _tmp14_;
						GAppInfo* _tmp15_;
						const gchar* _tmp16_;
						gchar* _tmp17_;
						gchar* _tmp18_;
						GAppInfo* _tmp19_;
						GIcon* _tmp20_;
						GFile* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						_tmp11_ = _data7_->list_store;
						gtk_list_store_append (_tmp11_, &_tmp12_);
						it = _tmp12_;
						_tmp13_ = _data7_->list_store;
						_tmp14_ = it;
						_tmp15_ = app_info;
						_tmp16_ = g_app_info_get_display_name (_tmp15_);
						_tmp17_ = g_markup_escape_text (_tmp16_, (gssize) -1);
						_tmp18_ = _tmp17_;
						_tmp19_ = app_info;
						_tmp20_ = g_app_info_get_icon (_tmp19_);
						_tmp21_ = file;
						_tmp22_ = g_file_get_basename (_tmp21_);
						_tmp23_ = _tmp22_;
						gtk_list_store_set (_tmp13_, &_tmp14_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_NAME, _tmp18_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_ICON, _tmp20_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_PATH, _tmp23_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_IS_APP, TRUE, -1);
						_g_free0 (_tmp23_);
						_g_free0 (_tmp18_);
						_g_object_unref0 (file);
						_g_object_unref0 (app_info);
						break;
					}
					_g_object_unref0 (file);
				}
				_g_object_unref0 (app_info);
			}
		}
		(app_info_collection == NULL) ? NULL : (app_info_collection = (_g_list_free__g_object_unref0_ (app_info_collection), NULL));
	}
}

static void
__exclude_tree_view___lambda11__security_privacy_application_blacklist_application_added (SecurityPrivacyApplicationBlacklist* _sender,
                                                                                          const gchar* app,
                                                                                          ZeitgeistEvent* ev,
                                                                                          gpointer self)
{
	_exclude_tree_view___lambda11_ (self, app, ev);
}

static void
_exclude_tree_view___lambda12_ (Block7Data* _data7_,
                                const gchar* path)
{
	ExcludeTreeView* self;
	GtkTreeIter it = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GFile* file = NULL;
	GFile* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GThemedIcon* _tmp10_;
	GThemedIcon* _tmp11_;
	self = _data7_->self;
	g_return_if_fail (path != NULL);
	_tmp0_ = _data7_->list_store;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	it = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	file = _tmp2_;
	_tmp3_ = _data7_->list_store;
	_tmp4_ = it;
	_tmp5_ = file;
	_tmp6_ = g_file_get_basename (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_markup_escape_text (_tmp7_, (gssize) -1);
	_tmp9_ = _tmp8_;
	_tmp10_ = (GThemedIcon*) g_themed_icon_new ("folder");
	_tmp11_ = _tmp10_;
	gtk_list_store_set (_tmp3_, &_tmp4_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_NAME, _tmp9_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_ICON, _tmp11_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_PATH, path, EXCLUDE_TREE_VIEW_NOT_COLUMNS_IS_APP, FALSE, -1);
	_g_object_unref0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_object_unref0 (file);
}

static void
__exclude_tree_view___lambda12__security_privacy_path_blacklist_folder_added (SecurityPrivacyPathBlacklist* _sender,
                                                                              const gchar* path,
                                                                              gpointer self)
{
	_exclude_tree_view___lambda12_ (self, path);
}

static GObject *
exclude_tree_view_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ExcludeTreeView * self;
	Block7Data* _data7_;
	SecurityPrivacyBlacklist* _tmp0_;
	SecurityPrivacyBlacklist* _tmp1_;
	SecurityPrivacyApplicationBlacklist* _tmp2_;
	SecurityPrivacyBlacklist* _tmp3_;
	SecurityPrivacyBlacklist* _tmp4_;
	SecurityPrivacyPathBlacklist* _tmp5_;
	GtkListStore* _tmp6_;
	GtkListStore* _tmp7_;
	GtkTreeView* _tmp8_;
	GtkTreeView* _tmp9_;
	GtkTreeView* _tmp10_;
	GtkCellRendererText* cell = NULL;
	GtkCellRendererText* _tmp11_;
	GtkCellRendererPixbuf* cellpixbuf = NULL;
	GtkCellRendererPixbuf* _tmp12_ = NULL;
	GtkTreeView* _tmp13_;
	GtkCellRendererPixbuf* _tmp14_;
	GtkTreeView* _tmp15_;
	GtkCellRendererText* _tmp16_;
	GtkScrolledWindow* scrolled = NULL;
	GtkTreeView* _tmp17_;
	GtkWidget* _tmp18_;
	GtkScrolledWindow* _tmp19_ = NULL;
	SecurityPrivacyDialogsAppChooser* app_chooser = NULL;
	SecurityPrivacyDialogsAppChooser* _tmp20_;
	GtkMenuButton* add_app_button = NULL;
	gchar* _tmp21_;
	SecurityPrivacyDialogsAppChooser* _tmp22_;
	GtkPopover* _tmp23_;
	gchar* _tmp24_;
	GtkMenuButton* _tmp25_ = NULL;
	GtkButton* add_folder_button = NULL;
	GtkButton* _tmp26_;
	GtkButton* _tmp27_;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GtkButton* _tmp30_;
	GtkButton* _tmp31_;
	GtkButton* _tmp32_;
	GtkActionBar* actionbar = NULL;
	GtkActionBar* _tmp33_;
	GtkActionBar* _tmp34_;
	GtkStyleContext* _tmp35_;
	GtkActionBar* _tmp36_;
	GtkMenuButton* _tmp37_;
	GtkActionBar* _tmp38_;
	GtkButton* _tmp39_;
	GtkActionBar* _tmp40_;
	GtkButton* _tmp41_;
	GtkBox* frame_box = NULL;
	GtkBox* _tmp42_;
	GtkBox* _tmp43_;
	GtkScrolledWindow* _tmp44_;
	GtkBox* _tmp45_;
	GtkActionBar* _tmp46_;
	GtkFrame* frame = NULL;
	GtkBox* _tmp47_;
	GtkWidget* _tmp48_;
	GtkFrame* _tmp49_ = NULL;
	GtkLabel* record_label = NULL;
	GtkLabel* _tmp50_;
	GtkLabel* _tmp51_;
	GtkLabel* _tmp52_;
	GtkFrame* _tmp53_;
	GtkTreeView* _tmp54_;
	GtkTreeIter iter = {0};
	GList* _tmp55_;
	SecurityPrivacyDialogsAppChooser* _tmp103_;
	SecurityPrivacyApplicationBlacklist* _tmp104_;
	SecurityPrivacyPathBlacklist* _tmp105_;
	parent_class = G_OBJECT_CLASS (exclude_tree_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXCLUDE_TREE_VIEW, ExcludeTreeView);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = security_privacy_track_panel_get_blacklist ();
	_tmp1_ = _tmp0_;
	_tmp2_ = security_privacy_application_blacklist_new (_tmp1_);
	_security_privacy_application_blacklist_unref0 (self->priv->app_blacklist);
	self->priv->app_blacklist = _tmp2_;
	_tmp3_ = security_privacy_track_panel_get_blacklist ();
	_tmp4_ = _tmp3_;
	_tmp5_ = security_privacy_path_blacklist_new (_tmp4_);
	_security_privacy_path_blacklist_unref0 (self->priv->path_blacklist);
	self->priv->path_blacklist = _tmp5_;
	_tmp6_ = gtk_list_store_new ((gint) EXCLUDE_TREE_VIEW_NOT_COLUMNS_N_COLUMNS, G_TYPE_STRING, g_icon_get_type (), G_TYPE_STRING, G_TYPE_BOOLEAN, -1);
	_data7_->list_store = _tmp6_;
	_tmp7_ = _data7_->list_store;
	_tmp8_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp7_);
	g_object_ref_sink (_tmp8_);
	_data7_->view = _tmp8_;
	_tmp9_ = _data7_->view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp9_, TRUE);
	_tmp10_ = _data7_->view;
	gtk_tree_view_set_headers_visible (_tmp10_, FALSE);
	_tmp11_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp11_);
	cell = _tmp11_;
	_tmp12_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_set (_tmp12_, "icon-size", GTK_ICON_SIZE_LARGE, NULL);
	g_object_ref_sink (_tmp12_);
	cellpixbuf = _tmp12_;
	_tmp13_ = _data7_->view;
	_tmp14_ = cellpixbuf;
	gtk_tree_view_insert_column_with_attributes (_tmp13_, -1, "", (GtkCellRenderer*) _tmp14_, "gicon", EXCLUDE_TREE_VIEW_NOT_COLUMNS_ICON, NULL);
	_tmp15_ = _data7_->view;
	_tmp16_ = cell;
	gtk_tree_view_insert_column_with_attributes (_tmp15_, -1, "", (GtkCellRenderer*) _tmp16_, "markup", EXCLUDE_TREE_VIEW_NOT_COLUMNS_NAME, NULL);
	_tmp17_ = _data7_->view;
	_tmp18_ = _g_object_ref0 ((GtkWidget*) _tmp17_);
	_tmp19_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp19_, _tmp18_);
	_g_object_unref0 (_tmp18_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp19_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp19_, TRUE);
	g_object_ref_sink (_tmp19_);
	scrolled = _tmp19_;
	_tmp20_ = security_privacy_dialogs_app_chooser_new ();
	g_object_ref_sink (_tmp20_);
	app_chooser = _tmp20_;
	_tmp21_ = g_strdup ("application-add-symbolic");
	_tmp22_ = app_chooser;
	_tmp23_ = _g_object_ref0 ((GtkPopover*) _tmp22_);
	_tmp24_ = g_strdup (_ ("Add Application…"));
	_tmp25_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_menu_button_set_icon_name (_tmp25_, _tmp21_);
	_g_free0 (_tmp21_);
	gtk_menu_button_set_popover (_tmp25_, _tmp23_);
	_g_object_unref0 (_tmp23_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp25_, _tmp24_);
	_g_free0 (_tmp24_);
	g_object_ref_sink (_tmp25_);
	add_app_button = _tmp25_;
	_tmp26_ = (GtkButton*) gtk_button_new_from_icon_name ("folder-new-symbolic");
	g_object_ref_sink (_tmp26_);
	add_folder_button = _tmp26_;
	_tmp27_ = add_folder_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp27_, _ ("Add Folder…"));
	_tmp28_ = add_folder_button;
	g_signal_connect_object (_tmp28_, "clicked", (GCallback) __exclude_tree_view___lambda6__gtk_button_clicked, self, 0);
	_tmp29_ = (GtkButton*) gtk_button_new_from_icon_name ("list-remove-symbolic");
	g_object_ref_sink (_tmp29_);
	_data7_->remove_button = _tmp29_;
	_tmp30_ = _data7_->remove_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp30_, _ ("Delete"));
	_tmp31_ = _data7_->remove_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp31_, FALSE);
	_tmp32_ = _data7_->remove_button;
	g_signal_connect_data (_tmp32_, "clicked", (GCallback) __exclude_tree_view___lambda8__gtk_button_clicked, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp33_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp33_);
	actionbar = _tmp33_;
	_tmp34_ = actionbar;
	_tmp35_ = gtk_widget_get_style_context ((GtkWidget*) _tmp34_);
	gtk_style_context_add_class (_tmp35_, GRANITE_STYLE_CLASS_FLAT);
	_tmp36_ = actionbar;
	_tmp37_ = add_app_button;
	gtk_action_bar_pack_start (_tmp36_, (GtkWidget*) _tmp37_);
	_tmp38_ = actionbar;
	_tmp39_ = add_folder_button;
	gtk_action_bar_pack_start (_tmp38_, (GtkWidget*) _tmp39_);
	_tmp40_ = actionbar;
	_tmp41_ = _data7_->remove_button;
	gtk_action_bar_pack_start (_tmp40_, (GtkWidget*) _tmp41_);
	_tmp42_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp42_);
	frame_box = _tmp42_;
	_tmp43_ = frame_box;
	_tmp44_ = scrolled;
	gtk_box_append (_tmp43_, (GtkWidget*) _tmp44_);
	_tmp45_ = frame_box;
	_tmp46_ = actionbar;
	gtk_box_append (_tmp45_, (GtkWidget*) _tmp46_);
	_tmp47_ = frame_box;
	_tmp48_ = _g_object_ref0 ((GtkWidget*) _tmp47_);
	_tmp49_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp49_, _tmp48_);
	_g_object_unref0 (_tmp48_);
	g_object_ref_sink (_tmp49_);
	frame = _tmp49_;
	_tmp50_ = (GtkLabel*) gtk_label_new (_ ("Do not collect data from the following:"));
	g_object_ref_sink (_tmp50_);
	record_label = _tmp50_;
	_tmp51_ = record_label;
	gtk_label_set_xalign (_tmp51_, (gfloat) 0);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp52_ = record_label;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp52_);
	_tmp53_ = frame;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp53_);
	_tmp54_ = _data7_->view;
	g_signal_connect_data (_tmp54_, "cursor-changed", (GCallback) __exclude_tree_view___lambda9__gtk_tree_view_cursor_changed, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp55_ = g_app_info_get_all ();
	{
		GList* app_info_collection = NULL;
		GList* app_info_it = NULL;
		app_info_collection = _tmp55_;
		for (app_info_it = app_info_collection; app_info_it != NULL; app_info_it = app_info_it->next) {
			GAppInfo* _tmp56_;
			GAppInfo* app_info = NULL;
			_tmp56_ = _g_object_ref0 ((GAppInfo*) app_info_it->data);
			app_info = _tmp56_;
			{
				GAppInfo* _tmp57_;
				_tmp57_ = app_info;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, G_TYPE_DESKTOP_APP_INFO)) {
					GFile* file = NULL;
					GAppInfo* _tmp58_;
					const gchar* _tmp59_;
					const gchar* _tmp60_;
					GFile* _tmp61_;
					SecurityPrivacyApplicationBlacklist* _tmp62_;
					GeeHashSet* _tmp63_;
					GeeHashSet* _tmp64_;
					GFile* _tmp65_;
					gchar* _tmp66_;
					gchar* _tmp67_;
					gboolean _tmp68_;
					_tmp58_ = app_info;
					_tmp59_ = g_desktop_app_info_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, G_TYPE_DESKTOP_APP_INFO, GDesktopAppInfo));
					_tmp60_ = _tmp59_;
					_tmp61_ = g_file_new_for_path (_tmp60_);
					file = _tmp61_;
					_tmp62_ = self->priv->app_blacklist;
					_tmp63_ = security_privacy_application_blacklist_get_all_apps (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = file;
					_tmp66_ = g_file_get_basename (_tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp64_, _tmp67_);
					_g_free0 (_tmp67_);
					if (_tmp68_) {
						GtkListStore* _tmp69_;
						GtkTreeIter _tmp70_ = {0};
						GtkListStore* _tmp71_;
						GtkTreeIter _tmp72_;
						GAppInfo* _tmp73_;
						const gchar* _tmp74_;
						gchar* _tmp75_;
						gchar* _tmp76_;
						GAppInfo* _tmp77_;
						GIcon* _tmp78_;
						GFile* _tmp79_;
						gchar* _tmp80_;
						gchar* _tmp81_;
						_tmp69_ = _data7_->list_store;
						gtk_list_store_append (_tmp69_, &_tmp70_);
						iter = _tmp70_;
						_tmp71_ = _data7_->list_store;
						_tmp72_ = iter;
						_tmp73_ = app_info;
						_tmp74_ = g_app_info_get_display_name (_tmp73_);
						_tmp75_ = g_markup_escape_text (_tmp74_, (gssize) -1);
						_tmp76_ = _tmp75_;
						_tmp77_ = app_info;
						_tmp78_ = g_app_info_get_icon (_tmp77_);
						_tmp79_ = file;
						_tmp80_ = g_file_get_basename (_tmp79_);
						_tmp81_ = _tmp80_;
						gtk_list_store_set (_tmp71_, &_tmp72_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_NAME, _tmp76_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_ICON, _tmp78_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_PATH, _tmp81_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_IS_APP, TRUE, -1);
						_g_free0 (_tmp81_);
						_g_free0 (_tmp76_);
					}
					_g_object_unref0 (file);
				}
				_g_object_unref0 (app_info);
			}
		}
		(app_info_collection == NULL) ? NULL : (app_info_collection = (_g_list_free__g_object_unref0_ (app_info_collection), NULL));
	}
	{
		GeeIterator* _folder_it = NULL;
		SecurityPrivacyPathBlacklist* _tmp82_;
		GeeHashSet* _tmp83_;
		GeeHashSet* _tmp84_;
		GeeIterator* _tmp85_;
		_tmp82_ = self->priv->path_blacklist;
		_tmp83_ = security_privacy_path_blacklist_get_all_folders (_tmp82_);
		_tmp84_ = _tmp83_;
		_tmp85_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp84_);
		_folder_it = _tmp85_;
		while (TRUE) {
			GeeIterator* _tmp86_;
			gchar* folder = NULL;
			GeeIterator* _tmp87_;
			gpointer _tmp88_;
			GtkListStore* _tmp89_;
			GtkTreeIter _tmp90_ = {0};
			GFile* file = NULL;
			const gchar* _tmp91_;
			GFile* _tmp92_;
			GtkListStore* _tmp93_;
			GtkTreeIter _tmp94_;
			GFile* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			GThemedIcon* _tmp100_;
			GThemedIcon* _tmp101_;
			const gchar* _tmp102_;
			_tmp86_ = _folder_it;
			if (!gee_iterator_next (_tmp86_)) {
				break;
			}
			_tmp87_ = _folder_it;
			_tmp88_ = gee_iterator_get (_tmp87_);
			folder = (gchar*) _tmp88_;
			_tmp89_ = _data7_->list_store;
			gtk_list_store_append (_tmp89_, &_tmp90_);
			iter = _tmp90_;
			_tmp91_ = folder;
			_tmp92_ = g_file_new_for_path (_tmp91_);
			file = _tmp92_;
			_tmp93_ = _data7_->list_store;
			_tmp94_ = iter;
			_tmp95_ = file;
			_tmp96_ = g_file_get_basename (_tmp95_);
			_tmp97_ = _tmp96_;
			_tmp98_ = g_markup_escape_text (_tmp97_, (gssize) -1);
			_tmp99_ = _tmp98_;
			_tmp100_ = (GThemedIcon*) g_themed_icon_new ("folder");
			_tmp101_ = _tmp100_;
			_tmp102_ = folder;
			gtk_list_store_set (_tmp93_, &_tmp94_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_NAME, _tmp99_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_ICON, _tmp101_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_PATH, _tmp102_, EXCLUDE_TREE_VIEW_NOT_COLUMNS_IS_APP, FALSE, -1);
			_g_object_unref0 (_tmp101_);
			_g_free0 (_tmp99_);
			_g_free0 (_tmp97_);
			_g_object_unref0 (file);
			_g_free0 (folder);
		}
		_g_object_unref0 (_folder_it);
	}
	_tmp103_ = app_chooser;
	g_signal_connect_object (_tmp103_, "app-chosen", (GCallback) __exclude_tree_view___lambda10__security_privacy_dialogs_app_chooser_app_chosen, self, 0);
	_tmp104_ = self->priv->app_blacklist;
	g_signal_connect_data (_tmp104_, "application-added", (GCallback) __exclude_tree_view___lambda11__security_privacy_application_blacklist_application_added, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp105_ = self->priv->path_blacklist;
	g_signal_connect_data (_tmp105_, "folder-added", (GCallback) __exclude_tree_view___lambda12__security_privacy_path_blacklist_folder_added, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_g_object_unref0 (record_label);
	_g_object_unref0 (frame);
	_g_object_unref0 (frame_box);
	_g_object_unref0 (actionbar);
	_g_object_unref0 (add_folder_button);
	_g_object_unref0 (add_app_button);
	_g_object_unref0 (app_chooser);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (cellpixbuf);
	_g_object_unref0 (cell);
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return obj;
}

static void
exclude_tree_view_class_init (ExcludeTreeViewClass * klass,
                              gpointer klass_data)
{
	exclude_tree_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ExcludeTreeView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = exclude_tree_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = exclude_tree_view_finalize;
}

static void
exclude_tree_view_instance_init (ExcludeTreeView * self,
                                 gpointer klass)
{
	self->priv = exclude_tree_view_get_instance_private (self);
}

static void
exclude_tree_view_finalize (GObject * obj)
{
	ExcludeTreeView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EXCLUDE_TREE_VIEW, ExcludeTreeView);
	_security_privacy_application_blacklist_unref0 (self->priv->app_blacklist);
	_security_privacy_path_blacklist_unref0 (self->priv->path_blacklist);
	G_OBJECT_CLASS (exclude_tree_view_parent_class)->finalize (obj);
}

static GType
exclude_tree_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ExcludeTreeViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) exclude_tree_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ExcludeTreeView), 0, (GInstanceInitFunc) exclude_tree_view_instance_init, NULL };
	GType exclude_tree_view_type_id;
	exclude_tree_view_type_id = g_type_register_static (gtk_box_get_type (), "ExcludeTreeView", &g_define_type_info, 0);
	ExcludeTreeView_private_offset = g_type_add_instance_private (exclude_tree_view_type_id, sizeof (ExcludeTreeViewPrivate));
	return exclude_tree_view_type_id;
}

GType
exclude_tree_view_get_type (void)
{
	static volatile gsize exclude_tree_view_type_id__once = 0;
	if (g_once_init_enter (&exclude_tree_view_type_id__once)) {
		GType exclude_tree_view_type_id;
		exclude_tree_view_type_id = exclude_tree_view_get_type_once ();
		g_once_init_leave (&exclude_tree_view_type_id__once, exclude_tree_view_type_id);
	}
	return exclude_tree_view_type_id__once;
}

