//
// Syd: rock-solid application kernel
// src/kernel/sys_ptrace.rs: ptrace(2) handler
//
// Copyright (c) 2025 Ali Polatel <alip@chesswob.org>
//
// SPDX-License-Identifier: GPL-3.0

use libseccomp::ScmpNotifResp;
use nix::errno::Errno;

use crate::req::UNotifyEventRequest;

pub(crate) fn sys_ptrace(request: UNotifyEventRequest) -> ScmpNotifResp {
    syscall_handler!(request, |request: UNotifyEventRequest| {
        // Note, we only hook into PTRACE_TRACEME requests.
        let req = request.scmpreq;
        let res = request.add_ptrace(req.pid());
        match res {
            // ECANCELED which will result in a no-op.
            Ok(_) => Err(Errno::ECANCELED),
            Err(errno) => Err(errno),
        }
    })
}
