// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at http://mozilla.org/MPL/2.0/.

// Code generated by "cstruct -pkg vfat -struct DirEntry -input direntry.h -endianness LittleEndian"; DO NOT EDIT.

package vfat

import "encoding/binary"

var _ = binary.LittleEndian

// DirEntry is a byte slice representing the direntry.h C header.
type DirEntry []byte

// Get_name returns name.
func (s DirEntry) Get_name() []byte {
	return s[0:11]
}

// Put_name sets name.
func (s DirEntry) Put_name(v []byte) {
	copy(s[0:11], v)
}

// Get_attr returns attr.
func (s DirEntry) Get_attr() byte {
	return s[11]
}

// Put_attr sets attr.
func (s DirEntry) Put_attr(v byte) {
	s[11] = v
}

// Get_time_creat returns time_creat.
func (s DirEntry) Get_time_creat() uint16 {
	return binary.LittleEndian.Uint16(s[12:14])
}

// Put_time_creat sets time_creat.
func (s DirEntry) Put_time_creat(v uint16) {
	binary.LittleEndian.PutUint16(s[12:14], v)
}

// Get_date_creat returns date_creat.
func (s DirEntry) Get_date_creat() uint16 {
	return binary.LittleEndian.Uint16(s[14:16])
}

// Put_date_creat sets date_creat.
func (s DirEntry) Put_date_creat(v uint16) {
	binary.LittleEndian.PutUint16(s[14:16], v)
}

// Get_time_acc returns time_acc.
func (s DirEntry) Get_time_acc() uint16 {
	return binary.LittleEndian.Uint16(s[16:18])
}

// Put_time_acc sets time_acc.
func (s DirEntry) Put_time_acc(v uint16) {
	binary.LittleEndian.PutUint16(s[16:18], v)
}

// Get_date_acc returns date_acc.
func (s DirEntry) Get_date_acc() uint16 {
	return binary.LittleEndian.Uint16(s[18:20])
}

// Put_date_acc sets date_acc.
func (s DirEntry) Put_date_acc(v uint16) {
	binary.LittleEndian.PutUint16(s[18:20], v)
}

// Get_cluster_high returns cluster_high.
func (s DirEntry) Get_cluster_high() uint16 {
	return binary.LittleEndian.Uint16(s[20:22])
}

// Put_cluster_high sets cluster_high.
func (s DirEntry) Put_cluster_high(v uint16) {
	binary.LittleEndian.PutUint16(s[20:22], v)
}

// Get_time_write returns time_write.
func (s DirEntry) Get_time_write() uint16 {
	return binary.LittleEndian.Uint16(s[22:24])
}

// Put_time_write sets time_write.
func (s DirEntry) Put_time_write(v uint16) {
	binary.LittleEndian.PutUint16(s[22:24], v)
}

// Get_date_write returns date_write.
func (s DirEntry) Get_date_write() uint16 {
	return binary.LittleEndian.Uint16(s[24:26])
}

// Put_date_write sets date_write.
func (s DirEntry) Put_date_write(v uint16) {
	binary.LittleEndian.PutUint16(s[24:26], v)
}

// Get_cluster_low returns cluster_low.
func (s DirEntry) Get_cluster_low() uint16 {
	return binary.LittleEndian.Uint16(s[26:28])
}

// Put_cluster_low sets cluster_low.
func (s DirEntry) Put_cluster_low(v uint16) {
	binary.LittleEndian.PutUint16(s[26:28], v)
}

// Get_size returns size.
func (s DirEntry) Get_size() uint32 {
	return binary.LittleEndian.Uint32(s[28:32])
}

// Put_size sets size.
func (s DirEntry) Put_size(v uint32) {
	binary.LittleEndian.PutUint32(s[28:32], v)
}

// DIRENTRY_SIZE is the size of the DirEntry struct.
const DIRENTRY_SIZE = 32
