/* DeleteBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from DeleteBox.vala, do not modify */

/*
 * DeleteBox.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gee.h>
#include <libxapp/xapp-gtk-window.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DELETE_BOX (delete_box_get_type ())
#define DELETE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_BOX, DeleteBox))
#define DELETE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_BOX, DeleteBoxClass))
#define IS_DELETE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_BOX))
#define IS_DELETE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_BOX))
#define DELETE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_BOX, DeleteBoxClass))

typedef struct _DeleteBox DeleteBox;
typedef struct _DeleteBoxClass DeleteBoxClass;
typedef struct _DeleteBoxPrivate DeleteBoxPrivate;
enum  {
	DELETE_BOX_0_PROPERTY,
	DELETE_BOX_NUM_PROPERTIES
};
static GParamSpec* delete_box_properties[DELETE_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AsyncTaskPrivate AsyncTaskPrivate;
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())
typedef struct _DeleteFileTaskPrivate DeleteFileTaskPrivate;

struct _DeleteBox {
	GtkBox parent_instance;
	DeleteBoxPrivate * priv;
	GtkLabel* lbl_msg;
	GtkLabel* lbl_status;
	GtkLabel* lbl_remaining;
	GtkProgressBar* progressbar;
};

struct _DeleteBoxClass {
	GtkBoxClass parent_class;
};

struct _DeleteBoxPrivate {
	GtkSpinner* spinner;
	GtkWindow* parent_window;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _AsyncTask {
	GObject parent_instance;
	AsyncTaskPrivate * priv;
	GDataOutputStream* dos_log;
	GPid child_pid;
	gchar* script_file;
	gchar* working_dir;
	AppStatus status;
	GMutex status_line_mutex;
	gint exit_code;
	GTimer* timer;
	gdouble progress;
	gdouble percent;
	gint64 prg_count;
	gint64 prg_count_total;
};

struct _AsyncTaskClass {
	GObjectClass parent_class;
	void (*prepare) (AsyncTask* self);
	gchar* (*build_script) (AsyncTask* self);
	gboolean (*begin) (AsyncTask* self);
	void (*execute) (AsyncTask* self);
	void (*parse_stdout_line) (AsyncTask* self, const gchar* out_line);
	void (*parse_stderr_line) (AsyncTask* self, const gchar* err_line);
	void (*finish_task) (AsyncTask* self);
};

struct _DeleteFileTask {
	AsyncTask parent_instance;
	DeleteFileTaskPrivate * priv;
	gchar* dest_path;
	gboolean verbose;
	gboolean io_nice;
	gboolean use_rsync;
	gint64 status_line_count;
	gint64 total_size;
	gchar* status_message;
	gchar* time_remaining;
};

struct _DeleteFileTaskClass {
	AsyncTaskClass parent_class;
};

static gint DeleteBox_private_offset;
static gpointer delete_box_parent_class = NULL;
VALA_EXTERN Main* App;

VALA_EXTERN GType delete_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteBox, g_object_unref)
VALA_EXTERN DeleteBox* delete_box_new (GtkWindow* _parent_window);
VALA_EXTERN DeleteBox* delete_box_construct (GType object_type,
                                 GtkWindow* _parent_window);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label_header (GtkBox* box,
                                               const gchar* text,
                                               gboolean large_heading);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label (GtkBox* box,
                                        const gchar* text,
                                        gboolean bold,
                                        gboolean italic,
                                        gboolean large);
VALA_EXTERN gboolean delete_box_delete_snapshots (DeleteBox* self);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN void main_delete_begin (Main* self);
VALA_EXTERN void tee_jee_gtk_helper_gtk_do_events (void);
VALA_EXTERN void tee_jee_system_sleep (gint milliseconds);
VALA_EXTERN gchar* tee_jee_misc_escape_html (const gchar* html);
VALA_EXTERN gchar* async_task_get_status_line (AsyncTask* self);
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* async_task_get_stat_time_remaining (AsyncTask* self);
static void delete_box_finalize (GObject * obj);
static GType delete_box_get_type_once (void);

static inline gpointer
delete_box_get_instance_private (DeleteBox* self)
{
	return G_STRUCT_MEMBER_P (self, DeleteBox_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

DeleteBox*
delete_box_construct (GType object_type,
                      GtkWindow* _parent_window)
{
	DeleteBox * self = NULL;
	GtkWindow* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkBox* hbox_status = NULL;
	GtkBox* _tmp3_;
	GtkSpinner* _tmp4_;
	GtkSpinner* _tmp5_;
	GtkSpinner* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkProgressBar* _tmp12_;
	GtkProgressBar* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	g_return_val_if_fail (_parent_window != NULL, NULL);
	tee_jee_logging_log_debug ("DeleteBox: DeleteBox()");
	self = (DeleteBox*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 6, NULL);
	_tmp0_ = _g_object_ref0 (_parent_window);
	_g_object_unref0 (self->priv->parent_window);
	self->priv->parent_window = _tmp0_;
	g_object_set ((GtkWidget*) self, "margin", 12, NULL);
	_tmp1_ = tee_jee_gtk_helper_add_label_header ((GtkBox*) self, _ ("Deleting Snapshots..."), TRUE);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp3_);
	hbox_status = _tmp3_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) hbox_status);
	_tmp4_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp4_;
	_tmp5_ = self->priv->spinner;
	g_object_set (_tmp5_, "active", TRUE, NULL);
	_tmp6_ = self->priv->spinner;
	gtk_container_add ((GtkContainer*) hbox_status, (GtkWidget*) _tmp6_);
	_tmp7_ = tee_jee_gtk_helper_add_label (hbox_status, _ ("Preparing..."), FALSE, FALSE, FALSE);
	_g_object_unref0 (self->lbl_msg);
	self->lbl_msg = _tmp7_;
	_tmp8_ = self->lbl_msg;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp8_, TRUE);
	_tmp9_ = self->lbl_msg;
	gtk_label_set_ellipsize (_tmp9_, PANGO_ELLIPSIZE_END);
	_tmp10_ = self->lbl_msg;
	gtk_label_set_max_width_chars (_tmp10_, 45);
	_tmp11_ = tee_jee_gtk_helper_add_label (hbox_status, "", FALSE, FALSE, FALSE);
	_g_object_unref0 (self->lbl_remaining);
	self->lbl_remaining = _tmp11_;
	_tmp12_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->progressbar);
	self->progressbar = _tmp12_;
	_tmp13_ = self->progressbar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp13_);
	_tmp14_ = tee_jee_gtk_helper_add_label ((GtkBox*) self, "", FALSE, FALSE, FALSE);
	_g_object_unref0 (self->lbl_status);
	self->lbl_status = _tmp14_;
	_tmp15_ = self->lbl_status;
	gtk_label_set_ellipsize (_tmp15_, PANGO_ELLIPSIZE_MIDDLE);
	_tmp16_ = self->lbl_status;
	gtk_label_set_max_width_chars (_tmp16_, 45);
	_tmp17_ = self->lbl_status;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp17_, 12);
	tee_jee_logging_log_debug ("DeleteBox: DeleteBox(): exit");
	_g_object_unref0 (hbox_status);
	return self;
}

DeleteBox*
delete_box_new (GtkWindow* _parent_window)
{
	return delete_box_construct (TYPE_DELETE_BOX, _parent_window);
}

gboolean
delete_box_delete_snapshots (DeleteBox* self)
{
	Main* _tmp0_;
	Main* _tmp2_;
	Main* _tmp46_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("DeleteBox: delete_snapshots()");
	_tmp0_ = App;
	if (!_tmp0_->thread_delete_running) {
		Main* _tmp1_;
		_tmp1_ = App;
		main_delete_begin (_tmp1_);
	}
	_tmp2_ = App;
	if (_tmp2_->btrfs_mode) {
		GtkWindow* _tmp8_;
		while (TRUE) {
			Main* _tmp3_;
			GtkLabel* _tmp4_;
			Main* _tmp5_;
			const gchar* _tmp6_;
			GtkWindow* _tmp7_;
			_tmp3_ = App;
			if (!_tmp3_->thread_delete_running) {
				break;
			}
			_tmp4_ = self->lbl_msg;
			_tmp5_ = App;
			_tmp6_ = _tmp5_->progress_text;
			gtk_label_set_label (_tmp4_, _tmp6_);
			tee_jee_gtk_helper_gtk_do_events ();
			tee_jee_system_sleep (200);
			_tmp7_ = self->priv->parent_window;
			xapp_set_window_progress_pulse (_tmp7_, TRUE);
		}
		_tmp8_ = self->priv->parent_window;
		xapp_set_window_progress_pulse (_tmp8_, FALSE);
	} else {
		gint wait_interval_millis = 0;
		gint status_line_counter = 0;
		gint status_line_counter_default = 0;
		gchar* status_line = NULL;
		gchar* _tmp9_;
		gchar* last_status_line = NULL;
		gchar* _tmp10_;
		gint remaining_counter = 0;
		GtkWindow* _tmp45_;
		wait_interval_millis = 100;
		status_line_counter = 0;
		status_line_counter_default = 1000 / wait_interval_millis;
		_tmp9_ = g_strdup ("");
		status_line = _tmp9_;
		_tmp10_ = g_strdup ("");
		last_status_line = _tmp10_;
		remaining_counter = 10;
		while (TRUE) {
			Main* _tmp11_;
			Main* _tmp12_;
			DeleteFileTask* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gdouble fraction = 0.0;
			Main* _tmp26_;
			DeleteFileTask* _tmp27_;
			gint _tmp28_;
			GtkLabel* _tmp41_;
			Main* _tmp42_;
			DeleteFileTask* _tmp43_;
			const gchar* _tmp44_;
			_tmp11_ = App;
			if (!_tmp11_->thread_delete_running) {
				break;
			}
			_tmp12_ = App;
			_tmp13_ = _tmp12_->delete_file_task;
			_tmp14_ = async_task_get_status_line ((AsyncTask*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_;
			_tmp17_ = tee_jee_misc_escape_html (_tmp16_);
			_g_free0 (status_line);
			status_line = _tmp17_;
			_g_free0 (_tmp16_);
			_tmp18_ = status_line;
			_tmp19_ = last_status_line;
			if (g_strcmp0 (_tmp18_, _tmp19_) != 0) {
				GtkLabel* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp20_ = self->lbl_status;
				_tmp21_ = status_line;
				gtk_label_set_label (_tmp20_, _tmp21_);
				_tmp22_ = status_line;
				_tmp23_ = g_strdup (_tmp22_);
				_g_free0 (last_status_line);
				last_status_line = _tmp23_;
				status_line_counter = status_line_counter_default;
			} else {
				gint _tmp24_;
				_tmp24_ = status_line_counter;
				status_line_counter = _tmp24_ - 1;
				if (status_line_counter < 0) {
					GtkLabel* _tmp25_;
					status_line_counter = status_line_counter_default;
					_tmp25_ = self->lbl_status;
					gtk_label_set_label (_tmp25_, "");
				}
			}
			_tmp26_ = App;
			_tmp27_ = _tmp26_->delete_file_task;
			fraction = ((AsyncTask*) _tmp27_)->progress;
			_tmp28_ = remaining_counter;
			remaining_counter = _tmp28_ - 1;
			if (remaining_counter == 0) {
				GtkLabel* _tmp29_;
				Main* _tmp30_;
				DeleteFileTask* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp29_ = self->lbl_remaining;
				_tmp30_ = App;
				_tmp31_ = _tmp30_->delete_file_task;
				_tmp32_ = async_task_get_stat_time_remaining ((AsyncTask*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = _tmp33_;
				_tmp35_ = g_strconcat (_tmp34_, " ", NULL);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strconcat (_tmp36_, _ ("remaining"), NULL);
				_tmp38_ = _tmp37_;
				gtk_label_set_label (_tmp29_, _tmp38_);
				_g_free0 (_tmp38_);
				_g_free0 (_tmp36_);
				_g_free0 (_tmp34_);
				remaining_counter = 10;
			}
			if (fraction < 0.99) {
				GtkProgressBar* _tmp39_;
				GtkWindow* _tmp40_;
				_tmp39_ = self->progressbar;
				gtk_progress_bar_set_fraction (_tmp39_, fraction);
				_tmp40_ = self->priv->parent_window;
				xapp_set_window_progress (_tmp40_, (gint) (fraction * 100.0));
			}
			_tmp41_ = self->lbl_msg;
			_tmp42_ = App;
			_tmp43_ = _tmp42_->delete_file_task;
			_tmp44_ = _tmp43_->status_message;
			gtk_label_set_label (_tmp41_, _tmp44_);
			tee_jee_gtk_helper_gtk_do_events ();
			tee_jee_system_sleep (100);
		}
		_tmp45_ = self->priv->parent_window;
		xapp_set_window_progress (_tmp45_, 0);
		_g_free0 (last_status_line);
		_g_free0 (status_line);
	}
	_tmp46_ = App;
	result = _tmp46_->thread_delete_success;
	return result;
}

static void
delete_box_class_init (DeleteBoxClass * klass,
                       gpointer klass_data)
{
	delete_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DeleteBox_private_offset);
	G_OBJECT_CLASS (klass)->finalize = delete_box_finalize;
}

static void
delete_box_instance_init (DeleteBox * self,
                          gpointer klass)
{
	self->priv = delete_box_get_instance_private (self);
}

static void
delete_box_finalize (GObject * obj)
{
	DeleteBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DELETE_BOX, DeleteBox);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->lbl_msg);
	_g_object_unref0 (self->lbl_status);
	_g_object_unref0 (self->lbl_remaining);
	_g_object_unref0 (self->progressbar);
	_g_object_unref0 (self->priv->parent_window);
	G_OBJECT_CLASS (delete_box_parent_class)->finalize (obj);
}

static GType
delete_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DeleteBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) delete_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DeleteBox), 0, (GInstanceInitFunc) delete_box_instance_init, NULL };
	GType delete_box_type_id;
	delete_box_type_id = g_type_register_static (gtk_box_get_type (), "DeleteBox", &g_define_type_info, 0);
	DeleteBox_private_offset = g_type_add_instance_private (delete_box_type_id, sizeof (DeleteBoxPrivate));
	return delete_box_type_id;
}

GType
delete_box_get_type (void)
{
	static volatile gsize delete_box_type_id__once = 0;
	if (g_once_init_enter (&delete_box_type_id__once)) {
		GType delete_box_type_id;
		delete_box_type_id = delete_box_get_type_once ();
		g_once_init_leave (&delete_box_type_id__once, delete_box_type_id);
	}
	return delete_box_type_id__once;
}

