/* SnapshotBackendBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SnapshotBackendBox.vala, do not modify */

/*
 * SnapshotBackendBox.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SNAPSHOT_BACKEND_BOX (snapshot_backend_box_get_type ())
#define SNAPSHOT_BACKEND_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_BACKEND_BOX, SnapshotBackendBox))
#define SNAPSHOT_BACKEND_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_BACKEND_BOX, SnapshotBackendBoxClass))
#define IS_SNAPSHOT_BACKEND_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_BACKEND_BOX))
#define IS_SNAPSHOT_BACKEND_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_BACKEND_BOX))
#define SNAPSHOT_BACKEND_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_BACKEND_BOX, SnapshotBackendBoxClass))

typedef struct _SnapshotBackendBox SnapshotBackendBox;
typedef struct _SnapshotBackendBoxClass SnapshotBackendBoxClass;
typedef struct _SnapshotBackendBoxPrivate SnapshotBackendBoxPrivate;
enum  {
	SNAPSHOT_BACKEND_BOX_0_PROPERTY,
	SNAPSHOT_BACKEND_BOX_NUM_PROPERTIES
};
static GParamSpec* snapshot_backend_box_properties[SNAPSHOT_BACKEND_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SNAPSHOT_BACKEND_BOX_TYPE_CHANGED_SIGNAL,
	SNAPSHOT_BACKEND_BOX_NUM_SIGNALS
};
static guint snapshot_backend_box_signals[SNAPSHOT_BACKEND_BOX_NUM_SIGNALS] = {0};

struct _SnapshotBackendBox {
	GtkBox parent_instance;
	SnapshotBackendBoxPrivate * priv;
};

struct _SnapshotBackendBoxClass {
	GtkBoxClass parent_class;
};

struct _SnapshotBackendBoxPrivate {
	GtkRadioButton* opt_rsync;
	GtkRadioButton* opt_btrfs;
	GtkLabel* lbl_description;
	GtkWindow* parent_window;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

static gint SnapshotBackendBox_private_offset;
static gpointer snapshot_backend_box_parent_class = NULL;
VALA_EXTERN Main* App;
VALA_EXTERN guint64 main_first_snapshot_size;

VALA_EXTERN GType snapshot_backend_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotBackendBox, g_object_unref)
VALA_EXTERN SnapshotBackendBox* snapshot_backend_box_new (GtkWindow* _parent_window);
VALA_EXTERN SnapshotBackendBox* snapshot_backend_box_construct (GType object_type,
                                                    GtkWindow* _parent_window);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
static void snapshot_backend_box_build_ui (SnapshotBackendBox* self);
VALA_EXTERN void snapshot_backend_box_refresh (SnapshotBackendBox* self);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label_header (GtkBox* box,
                                               const gchar* text,
                                               gboolean large_heading);
static void snapshot_backend_box_add_opt_rsync (SnapshotBackendBox* self,
                                         GtkBox* hbox);
static void snapshot_backend_box_add_opt_btrfs (SnapshotBackendBox* self,
                                         GtkBox* hbox);
static void snapshot_backend_box_add_description (SnapshotBackendBox* self);
static void __lambda39_ (SnapshotBackendBox* self);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN void snapshot_backend_box_init_backend (SnapshotBackendBox* self);
static void snapshot_backend_box_update_description (SnapshotBackendBox* self);
static void ___lambda39__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static gboolean snapshot_backend_box_check_for_btrfs_tools (SnapshotBackendBox* self);
static void __lambda40_ (SnapshotBackendBox* self);
static void ___lambda40__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN void main_try_select_default_device_for_backup (Main* self,
                                                GtkWindow* parent_win);
static void snapshot_backend_box_finalize (GObject * obj);
static GType snapshot_backend_box_get_type_once (void);

static inline gpointer
snapshot_backend_box_get_instance_private (SnapshotBackendBox* self)
{
	return G_STRUCT_MEMBER_P (self, SnapshotBackendBox_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SnapshotBackendBox*
snapshot_backend_box_construct (GType object_type,
                                GtkWindow* _parent_window)
{
	SnapshotBackendBox * self = NULL;
	GtkWindow* _tmp0_;
	g_return_val_if_fail (_parent_window != NULL, NULL);
	tee_jee_logging_log_debug ("SnapshotBackendBox: SnapshotBackendBox()");
	self = (SnapshotBackendBox*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 6, NULL);
	_tmp0_ = _g_object_ref0 (_parent_window);
	_g_object_unref0 (self->priv->parent_window);
	self->priv->parent_window = _tmp0_;
	g_object_set ((GtkWidget*) self, "margin", 12, NULL);
	snapshot_backend_box_build_ui (self);
	snapshot_backend_box_refresh (self);
	tee_jee_logging_log_debug ("SnapshotBackendBox: SnapshotBackendBox(): exit");
	return self;
}

SnapshotBackendBox*
snapshot_backend_box_new (GtkWindow* _parent_window)
{
	return snapshot_backend_box_construct (TYPE_SNAPSHOT_BACKEND_BOX, _parent_window);
}

static void
snapshot_backend_box_build_ui (SnapshotBackendBox* self)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkBox* vbox = NULL;
	GtkBox* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tee_jee_gtk_helper_add_label_header ((GtkBox*) self, _ ("Select Snapshot Type"), TRUE);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp2_);
	vbox = _tmp2_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) vbox);
	snapshot_backend_box_add_opt_rsync (self, vbox);
	snapshot_backend_box_add_opt_btrfs (self, vbox);
	snapshot_backend_box_add_description (self);
	_g_object_unref0 (vbox);
}

static void
__lambda39_ (SnapshotBackendBox* self)
{
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->opt_rsync;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Main* _tmp3_;
		_tmp3_ = App;
		_tmp3_->btrfs_mode = FALSE;
		main_first_snapshot_size = (guint64) 0;
		snapshot_backend_box_init_backend (self);
		g_signal_emit (self, snapshot_backend_box_signals[SNAPSHOT_BACKEND_BOX_TYPE_CHANGED_SIGNAL], 0);
		snapshot_backend_box_update_description (self);
	}
}

static void
___lambda39__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda39_ ((SnapshotBackendBox*) self);
}

static void
snapshot_backend_box_add_opt_rsync (SnapshotBackendBox* self,
                                    GtkBox* hbox)
{
	GtkRadioButton* opt = NULL;
	GtkRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	GtkRadioButton* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hbox != NULL);
	_tmp0_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (NULL, _ ("RSYNC"));
	g_object_ref_sink (_tmp0_);
	opt = _tmp0_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) opt, _ ("Create snapshots using RSYNC tool and hard-links"));
	gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) opt);
	_tmp1_ = _g_object_ref0 (opt);
	_g_object_unref0 (self->priv->opt_rsync);
	self->priv->opt_rsync = _tmp1_;
	_tmp2_ = self->priv->opt_rsync;
	g_signal_connect_object ((GtkToggleButton*) _tmp2_, "toggled", (GCallback) ___lambda39__gtk_toggle_button_toggled, self, 0);
	_g_object_unref0 (opt);
}

static void
__lambda40_ (SnapshotBackendBox* self)
{
	GtkRadioButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = self->priv->opt_btrfs;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		Main* _tmp3_;
		_tmp3_ = App;
		_tmp3_->btrfs_mode = TRUE;
		snapshot_backend_box_init_backend (self);
		g_signal_emit (self, snapshot_backend_box_signals[SNAPSHOT_BACKEND_BOX_TYPE_CHANGED_SIGNAL], 0);
		snapshot_backend_box_update_description (self);
	}
}

static void
___lambda40__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda40_ ((SnapshotBackendBox*) self);
}

static void
snapshot_backend_box_add_opt_btrfs (SnapshotBackendBox* self,
                                    GtkBox* hbox)
{
	GtkRadioButton* opt = NULL;
	GtkRadioButton* _tmp0_;
	GtkRadioButton* _tmp1_;
	GtkRadioButton* _tmp2_;
	GtkRadioButton* _tmp3_;
	GtkRadioButton* _tmp4_;
	GtkRadioButton* _tmp5_;
	GtkRadioButton* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hbox != NULL);
	_tmp0_ = self->priv->opt_rsync;
	_tmp1_ = (GtkRadioButton*) gtk_radio_button_new_with_label_from_widget (_tmp0_, _ ("BTRFS"));
	g_object_ref_sink (_tmp1_);
	opt = _tmp1_;
	_tmp2_ = opt;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp2_, _ ("Create snapshots using BTRFS"));
	_tmp3_ = opt;
	gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) _tmp3_);
	_tmp4_ = opt;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->opt_btrfs);
	self->priv->opt_btrfs = _tmp5_;
	if (!snapshot_backend_box_check_for_btrfs_tools (self)) {
		GtkRadioButton* _tmp6_;
		GtkRadioButton* _tmp7_;
		_tmp6_ = opt;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
		_tmp7_ = self->priv->opt_rsync;
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp7_, TRUE);
	}
	_tmp8_ = self->priv->opt_btrfs;
	g_signal_connect_object ((GtkToggleButton*) _tmp8_, "toggled", (GCallback) ___lambda40__gtk_toggle_button_toggled, self, 0);
	_g_object_unref0 (opt);
}

static gpointer
_g_bytes_ref0 (gpointer self)
{
	return self ? g_bytes_ref (self) : NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
snapshot_backend_box_check_for_btrfs_tools (SnapshotBackendBox* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		static const gchar* args[4] = {"lsblk", "-o", "FSTYPE", NULL};
		GSubprocess* proc = NULL;
		GSubprocess* _tmp0_;
		GBytes* stdout = NULL;
		gboolean _tmp1_ = FALSE;
		GSubprocess* _tmp2_;
		GBytes* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp0_ = g_subprocess_newv (args, G_SUBPROCESS_FLAGS_STDOUT_PIPE | G_SUBPROCESS_FLAGS_STDERR_SILENCE, &_inner_error0_);
		proc = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = proc;
		_tmp4_ = g_subprocess_communicate (_tmp2_, NULL, NULL, &_tmp3_, NULL, &_inner_error0_);
		_g_bytes_unref0 (stdout);
		stdout = _tmp3_;
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_bytes_unref0 (stdout);
			_g_object_unref0 (proc);
			goto __catch0_g_error;
		}
		if (_tmp1_) {
			gchar* output = NULL;
			GBytes* _tmp5_;
			GBytes* _tmp6_;
			gsize _tmp7_ = 0;
			guint8* _tmp8_;
			const gchar* _tmp9_;
			_tmp5_ = stdout;
			_tmp6_ = _g_bytes_ref0 (_tmp5_);
			_tmp8_ = g_bytes_unref_to_data (_tmp6_, &_tmp7_);
			output = (gchar*) _tmp8_;
			_tmp9_ = output;
			if (string_contains (_tmp9_, "btrfs")) {
				result = TRUE;
				_g_free0 (output);
				_g_bytes_unref0 (stdout);
				_g_object_unref0 (proc);
				return result;
			}
			_g_free0 (output);
		}
		_g_bytes_unref0 (stdout);
		_g_object_unref0 (proc);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		tee_jee_logging_log_error (_tmp11_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp12_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp12_;
	}
	result = FALSE;
	return result;
}

static void
snapshot_backend_box_add_description (SnapshotBackendBox* self)
{
	GtkExpander* expander = NULL;
	GtkExpander* _tmp0_;
	GtkScrolledWindow* scrolled = NULL;
	GtkScrolledWindow* _tmp1_;
	GtkLabel* lbl = NULL;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkExpander*) gtk_expander_new (_ ("Help"));
	g_object_ref_sink (_tmp0_);
	expander = _tmp0_;
	gtk_expander_set_use_markup (expander, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) expander, 12);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) expander);
	_tmp1_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp1_);
	scrolled = _tmp1_;
	gtk_scrolled_window_set_shadow_type (scrolled, GTK_SHADOW_ETCHED_IN);
	gtk_widget_set_margin_top ((GtkWidget*) scrolled, 6);
	gtk_widget_set_size_request ((GtkWidget*) scrolled, -1, 200);
	g_object_set (scrolled, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_set (scrolled, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	gtk_container_add ((GtkContainer*) expander, (GtkWidget*) scrolled);
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp2_);
	lbl = _tmp2_;
	gtk_label_set_use_markup (lbl, TRUE);
	gtk_label_set_xalign (lbl, (gfloat) 0.0);
	gtk_label_set_yalign (lbl, (gfloat) 0.0);
	g_object_set (lbl, "wrap", TRUE, NULL);
	g_object_set (lbl, "wrap-mode", PANGO_WRAP_WORD, NULL);
	g_object_set ((GtkWidget*) lbl, "margin", 12, NULL);
	gtk_widget_set_vexpand ((GtkWidget*) lbl, TRUE);
	gtk_container_add ((GtkContainer*) scrolled, (GtkWidget*) lbl);
	_tmp3_ = _g_object_ref0 (lbl);
	_g_object_unref0 (self->priv->lbl_description);
	self->priv->lbl_description = _tmp3_;
	_g_object_unref0 (lbl);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (expander);
}

static void
snapshot_backend_box_update_description (SnapshotBackendBox* self)
{
	gchar* bullet = NULL;
	gchar* _tmp0_;
	GtkRadioButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("• ");
	bullet = _tmp0_;
	_tmp1_ = self->priv->opt_btrfs;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		gchar* txt = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		GtkLabel* _tmp57_;
		const gchar* _tmp58_;
		_tmp4_ = g_strconcat ("<b>", _ ("BTRFS Snapshots"), NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, "</b>\n\n", NULL);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		txt = _tmp7_;
		_tmp8_ = txt;
		_tmp9_ = bullet;
		_tmp10_ = g_strconcat (_tmp9_, _ ("Snapshots are created using the built-in features of the BTRFS file sy" \
"stem."), NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, "\n\n", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat (_tmp8_, _tmp13_, NULL);
		_g_free0 (txt);
		txt = _tmp14_;
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_tmp15_ = txt;
		_tmp16_ = bullet;
		_tmp17_ = g_strconcat (_tmp16_, _ ("Snapshots are created and restored instantly. Snapshot creation is an " \
"atomic transaction at the file system level."), NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp18_, "\n\n", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp15_, _tmp20_, NULL);
		_g_free0 (txt);
		txt = _tmp21_;
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_tmp22_ = txt;
		_tmp23_ = bullet;
		_tmp24_ = g_strconcat (_tmp23_, _ ("Snapshots are restored by replacing system subvolumes. Since files are" \
" never copied, deleted or overwritten, there is no risk of data loss. " \
"The existing system is preserved as a new snapshot after restore."), NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp25_, "\n\n", NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp22_, _tmp27_, NULL);
		_g_free0 (txt);
		txt = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_tmp29_ = txt;
		_tmp30_ = bullet;
		_tmp31_ = g_strconcat (_tmp30_, _ ("Snapshots are perfect, byte-for-byte copies of the system. Nothing is " \
"excluded."), NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp32_, "\n\n", NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat (_tmp29_, _tmp34_, NULL);
		_g_free0 (txt);
		txt = _tmp35_;
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		_tmp36_ = txt;
		_tmp37_ = bullet;
		_tmp38_ = g_strconcat (_tmp37_, _ ("Snapshots are saved on the same disk from which they are created (syst" \
"em disk). Storage on other disks is not supported. If system disk fail" \
"s then snapshots stored on it will be lost along with the system."), NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp39_, "\n\n", NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strconcat (_tmp36_, _tmp41_, NULL);
		_g_free0 (txt);
		txt = _tmp42_;
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
		_tmp43_ = txt;
		_tmp44_ = bullet;
		_tmp45_ = g_strconcat (_tmp44_, _ ("Size of BTRFS snapshots are initially zero. As system files gradually " \
"change with time, data gets written to new data blocks which take up d" \
"isk space (copy-on-write). Files in the snapshot continue to point to " \
"original data blocks."), NULL);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_strconcat (_tmp46_, "\n\n", NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strconcat (_tmp43_, _tmp48_, NULL);
		_g_free0 (txt);
		txt = _tmp49_;
		_g_free0 (_tmp48_);
		_g_free0 (_tmp46_);
		_tmp50_ = txt;
		_tmp51_ = bullet;
		_tmp52_ = g_strconcat (_tmp51_, _ ("OS must be installed on a BTRFS partition with Ubuntu-type subvolume l" \
"ayout (@ and @home subvolumes). Other layouts are not supported."), NULL);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strconcat (_tmp53_, "\n\n", NULL);
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strconcat (_tmp50_, _tmp55_, NULL);
		_g_free0 (txt);
		txt = _tmp56_;
		_g_free0 (_tmp55_);
		_g_free0 (_tmp53_);
		_tmp57_ = self->priv->lbl_description;
		_tmp58_ = txt;
		gtk_label_set_label (_tmp57_, _tmp58_);
		_g_free0 (txt);
	} else {
		gchar* txt = NULL;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		const gchar* _tmp63_;
		const gchar* _tmp64_;
		gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		const gchar* _tmp70_;
		const gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		const gchar* _tmp77_;
		const gchar* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		const gchar* _tmp84_;
		const gchar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		GtkLabel* _tmp91_;
		const gchar* _tmp92_;
		_tmp59_ = g_strconcat ("<b>", _ ("RSYNC Snapshots"), NULL);
		_tmp60_ = _tmp59_;
		_tmp61_ = g_strconcat (_tmp60_, "</b>\n\n", NULL);
		_tmp62_ = _tmp61_;
		_g_free0 (_tmp60_);
		txt = _tmp62_;
		_tmp63_ = txt;
		_tmp64_ = bullet;
		_tmp65_ = g_strconcat (_tmp64_, _ ("Snapshots are created by creating copies of system files using rsync, " \
"and hard-linking unchanged files from previous snapshot."), NULL);
		_tmp66_ = _tmp65_;
		_tmp67_ = g_strconcat (_tmp66_, "\n\n", NULL);
		_tmp68_ = _tmp67_;
		_tmp69_ = g_strconcat (_tmp63_, _tmp68_, NULL);
		_g_free0 (txt);
		txt = _tmp69_;
		_g_free0 (_tmp68_);
		_g_free0 (_tmp66_);
		_tmp70_ = txt;
		_tmp71_ = bullet;
		_tmp72_ = g_strconcat (_tmp71_, _ ("All files are copied when first snapshot is created. Subsequent snapsh" \
"ots are incremental. Unchanged files will be hard-linked from the prev" \
"ious snapshot if available."), NULL);
		_tmp73_ = _tmp72_;
		_tmp74_ = g_strconcat (_tmp73_, "\n\n", NULL);
		_tmp75_ = _tmp74_;
		_tmp76_ = g_strconcat (_tmp70_, _tmp75_, NULL);
		_g_free0 (txt);
		txt = _tmp76_;
		_g_free0 (_tmp75_);
		_g_free0 (_tmp73_);
		_tmp77_ = txt;
		_tmp78_ = bullet;
		_tmp79_ = g_strconcat (_tmp78_, _ ("Snapshots can be saved to any disk formatted with a Linux file system." \
" Saving snapshots to non-system or external disk allows the system to " \
"be restored even if system disk is damaged or re-formatted."), NULL);
		_tmp80_ = _tmp79_;
		_tmp81_ = g_strconcat (_tmp80_, "\n\n", NULL);
		_tmp82_ = _tmp81_;
		_tmp83_ = g_strconcat (_tmp77_, _tmp82_, NULL);
		_g_free0 (txt);
		txt = _tmp83_;
		_g_free0 (_tmp82_);
		_g_free0 (_tmp80_);
		_tmp84_ = txt;
		_tmp85_ = bullet;
		_tmp86_ = g_strconcat (_tmp85_, _ ("Files and directories can be excluded to save disk space."), NULL);
		_tmp87_ = _tmp86_;
		_tmp88_ = g_strconcat (_tmp87_, "\n\n", NULL);
		_tmp89_ = _tmp88_;
		_tmp90_ = g_strconcat (_tmp84_, _tmp89_, NULL);
		_g_free0 (txt);
		txt = _tmp90_;
		_g_free0 (_tmp89_);
		_g_free0 (_tmp87_);
		_tmp91_ = self->priv->lbl_description;
		_tmp92_ = txt;
		gtk_label_set_label (_tmp91_, _tmp92_);
		_g_free0 (txt);
	}
	_g_free0 (bullet);
}

void
snapshot_backend_box_init_backend (SnapshotBackendBox* self)
{
	Main* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	_tmp1_ = self->priv->parent_window;
	main_try_select_default_device_for_backup (_tmp0_, _tmp1_);
}

void
snapshot_backend_box_refresh (SnapshotBackendBox* self)
{
	GtkRadioButton* _tmp0_;
	Main* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->opt_btrfs;
	_tmp1_ = App;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, _tmp1_->btrfs_mode);
	g_signal_emit (self, snapshot_backend_box_signals[SNAPSHOT_BACKEND_BOX_TYPE_CHANGED_SIGNAL], 0);
	snapshot_backend_box_update_description (self);
}

static void
snapshot_backend_box_class_init (SnapshotBackendBoxClass * klass,
                                 gpointer klass_data)
{
	snapshot_backend_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SnapshotBackendBox_private_offset);
	G_OBJECT_CLASS (klass)->finalize = snapshot_backend_box_finalize;
	snapshot_backend_box_signals[SNAPSHOT_BACKEND_BOX_TYPE_CHANGED_SIGNAL] = g_signal_new ("type-changed", TYPE_SNAPSHOT_BACKEND_BOX, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
snapshot_backend_box_instance_init (SnapshotBackendBox * self,
                                    gpointer klass)
{
	self->priv = snapshot_backend_box_get_instance_private (self);
}

static void
snapshot_backend_box_finalize (GObject * obj)
{
	SnapshotBackendBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SNAPSHOT_BACKEND_BOX, SnapshotBackendBox);
	_g_object_unref0 (self->priv->opt_rsync);
	_g_object_unref0 (self->priv->opt_btrfs);
	_g_object_unref0 (self->priv->lbl_description);
	_g_object_unref0 (self->priv->parent_window);
	G_OBJECT_CLASS (snapshot_backend_box_parent_class)->finalize (obj);
}

static GType
snapshot_backend_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SnapshotBackendBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) snapshot_backend_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SnapshotBackendBox), 0, (GInstanceInitFunc) snapshot_backend_box_instance_init, NULL };
	GType snapshot_backend_box_type_id;
	snapshot_backend_box_type_id = g_type_register_static (gtk_box_get_type (), "SnapshotBackendBox", &g_define_type_info, 0);
	SnapshotBackendBox_private_offset = g_type_add_instance_private (snapshot_backend_box_type_id, sizeof (SnapshotBackendBoxPrivate));
	return snapshot_backend_box_type_id;
}

GType
snapshot_backend_box_get_type (void)
{
	static volatile gsize snapshot_backend_box_type_id__once = 0;
	if (g_once_init_enter (&snapshot_backend_box_type_id__once)) {
		GType snapshot_backend_box_type_id;
		snapshot_backend_box_type_id = snapshot_backend_box_get_type_once ();
		g_once_init_leave (&snapshot_backend_box_type_id__once, snapshot_backend_box_type_id);
	}
	return snapshot_backend_box_type_id__once;
}

