// python wrapper for ttkConnectedComponents
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkConnectedComponents.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkConnectedComponents(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkConnectedComponents_ClassNew(); }


static PyObject *
PyttkConnectedComponents_SetBackgroundThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBackgroundThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkConnectedComponents *op = static_cast<ttkConnectedComponents *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBackgroundThreshold(temp0);
    }
    else
    {
      op->ttkConnectedComponents::SetBackgroundThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkConnectedComponents_GetBackgroundThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBackgroundThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkConnectedComponents *op = static_cast<ttkConnectedComponents *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetBackgroundThreshold() :
      op->ttkConnectedComponents::GetBackgroundThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkConnectedComponents_SetAugmentSegmentationWithComponentSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAugmentSegmentationWithComponentSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkConnectedComponents *op = static_cast<ttkConnectedComponents *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAugmentSegmentationWithComponentSize(temp0);
    }
    else
    {
      op->ttkConnectedComponents::SetAugmentSegmentationWithComponentSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkConnectedComponents_GetAugmentSegmentationWithComponentSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAugmentSegmentationWithComponentSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkConnectedComponents *op = static_cast<ttkConnectedComponents *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetAugmentSegmentationWithComponentSize() :
      op->ttkConnectedComponents::GetAugmentSegmentationWithComponentSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkConnectedComponents_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkConnectedComponents::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkConnectedComponents_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkConnectedComponents *op = static_cast<ttkConnectedComponents *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkConnectedComponents::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkConnectedComponents_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkConnectedComponents *tempr = ttkConnectedComponents::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkConnectedComponents_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkConnectedComponents *op = static_cast<ttkConnectedComponents *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkConnectedComponents *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkConnectedComponents::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkConnectedComponents_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkConnectedComponents::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkConnectedComponents_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkConnectedComponents *op = static_cast<ttkConnectedComponents *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkConnectedComponents::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkConnectedComponents_Methods[] = {
  {"SetBackgroundThreshold", PyttkConnectedComponents_SetBackgroundThreshold, METH_VARARGS,
   "SetBackgroundThreshold(self, _arg:float) -> None\nC++: virtual void SetBackgroundThreshold(double _arg)\n\n"},
  {"GetBackgroundThreshold", PyttkConnectedComponents_GetBackgroundThreshold, METH_VARARGS,
   "GetBackgroundThreshold(self) -> float\nC++: virtual double GetBackgroundThreshold()\n\n"},
  {"SetAugmentSegmentationWithComponentSize", PyttkConnectedComponents_SetAugmentSegmentationWithComponentSize, METH_VARARGS,
   "SetAugmentSegmentationWithComponentSize(self, _arg:bool) -> None\nC++: virtual void SetAugmentSegmentationWithComponentSize(\n    bool _arg)\n\n"},
  {"GetAugmentSegmentationWithComponentSize", PyttkConnectedComponents_GetAugmentSegmentationWithComponentSize, METH_VARARGS,
   "GetAugmentSegmentationWithComponentSize(self) -> bool\nC++: virtual bool GetAugmentSegmentationWithComponentSize()\n\n"},
  {"IsTypeOf", PyttkConnectedComponents_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkConnectedComponents_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkConnectedComponents_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkConnectedComponents\nC++: static ttkConnectedComponents *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkConnectedComponents_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkConnectedComponents\nC++: ttkConnectedComponents *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkConnectedComponents_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkConnectedComponents_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkConnectedComponents_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("background_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkConnectedComponents_GetBackgroundThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkConnectedComponents_SetBackgroundThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkConnectedComponents_SetBackgroundThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBackgroundThreshold/SetBackgroundThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("augment_segmentation_with_component_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkConnectedComponents_GetAugmentSegmentationWithComponentSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkConnectedComponents_SetAugmentSegmentationWithComponentSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkConnectedComponents_SetAugmentSegmentationWithComponentSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAugmentSegmentationWithComponentSize/SetAugmentSegmentationWithComponentSize\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkConnectedComponents_Doc =
  "ttkConnectedComponents - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Jonas Lukasczyk (jl@jluk.de)\\date 22.02.2022\n\n"
  "TTK VTK-filter that computes connected components based on a scalar\n"
  "field.\n\n"
  "VTK wrapping code for the ttk::ConnectedComponents package.\n\n"
  "This filter consumes a scalar field with a feature mask and computes\n"
  "for each edge connected group of vertices with a non-background mask\n"
  "value a so-called connected component via flood-filling, where the\n"
  "background is masked with values smaller-equal zero. The computed\n"
  "components store the size, seed, and center of mass of each\n"
  "component. The flag UseSeedIdAsComponentId controls if the resulting\n"
  "segmentation is either labeled by the index of the component, or by\n"
  "its seed location (which can be used as a deterministic component\n"
  "label).\n\n"
  "The input data array that contains the feature mask needs to be\n"
  "specified via the standard VTK call SetInputArrayToProcess() with the\n"
  "following parameters:\n"
  "\\param idx 0 (FIXED: the first array the algorithm requires)\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the VTK array)\n\n"
  "\\sa ttk::ConnectedComponents\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkConnectedComponents_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkConnectedComponents.ttkConnectedComponents", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkConnectedComponents_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkConnectedComponents_StaticNew()
{
  return ttkConnectedComponents::New();
}

PyObject *PyttkConnectedComponents_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkConnectedComponents_Type, PyttkConnectedComponents_Methods,
    "ttkConnectedComponents",
 &PyttkConnectedComponents_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkConnectedComponents_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkConnectedComponents(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkConnectedComponents_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkConnectedComponents", o) != 0)
  {
    Py_DECREF(o);
  }

}

