// python wrapper for ttkContourTreeAlignment
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkContourTreeAlignment.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkContourTreeAlignment(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkContourTreeAlignment_ClassNew(); }


static PyObject *
PyttkContourTreeAlignment_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkContourTreeAlignment::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkContourTreeAlignment::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkContourTreeAlignment *tempr = ttkContourTreeAlignment::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkContourTreeAlignment *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkContourTreeAlignment::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkContourTreeAlignment::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkContourTreeAlignment::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_SetRandomSeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRandomSeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRandomSeed(temp0);
    }
    else
    {
      op->ttkContourTreeAlignment::SetRandomSeed(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_GetRandomSeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRandomSeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetRandomSeed() :
      op->ttkContourTreeAlignment::GetRandomSeed());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_SetMatchTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMatchTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMatchTime(temp0);
    }
    else
    {
      op->ttkContourTreeAlignment::SetMatchTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_GetMatchTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMatchTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetMatchTime() :
      op->ttkContourTreeAlignment::GetMatchTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_SetArcMatchMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetArcMatchMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetArcMatchMode(temp0);
    }
    else
    {
      op->ttkContourTreeAlignment::SetArcMatchMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_GetArcMatchMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetArcMatchMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetArcMatchMode() :
      op->ttkContourTreeAlignment::GetArcMatchMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_SetAlignmenttreeType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAlignmenttreeType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAlignmenttreeType(temp0);
    }
    else
    {
      op->ttkContourTreeAlignment::SetAlignmenttreeType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_GetAlignmenttreeType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetAlignmenttreeType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetAlignmenttreeType() :
      op->ttkContourTreeAlignment::GetAlignmenttreeType());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_SetWeightCombinatorialMatch(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWeightCombinatorialMatch");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWeightCombinatorialMatch(temp0);
    }
    else
    {
      op->ttkContourTreeAlignment::SetWeightCombinatorialMatch(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_GetWeightCombinatorialMatch(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWeightCombinatorialMatch");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetWeightCombinatorialMatch() :
      op->ttkContourTreeAlignment::GetWeightCombinatorialMatch());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_SetWeightArcMatch(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWeightArcMatch");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWeightArcMatch(temp0);
    }
    else
    {
      op->ttkContourTreeAlignment::SetWeightArcMatch(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_GetWeightArcMatch(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWeightArcMatch");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetWeightArcMatch() :
      op->ttkContourTreeAlignment::GetWeightArcMatch());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_SetWeightScalarValueMatch(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWeightScalarValueMatch");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWeightScalarValueMatch(temp0);
    }
    else
    {
      op->ttkContourTreeAlignment::SetWeightScalarValueMatch(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_GetWeightScalarValueMatch(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWeightScalarValueMatch");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetWeightScalarValueMatch() :
      op->ttkContourTreeAlignment::GetWeightScalarValueMatch());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_SetExportJSON(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExportJSON");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExportJSON(temp0);
    }
    else
    {
      op->ttkContourTreeAlignment::SetExportJSON(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_GetExportJSON(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExportJSON");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetExportJSON() :
      op->ttkContourTreeAlignment::GetExportJSON());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_SetExportPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetExportPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetExportPath(temp0);
    }
    else
    {
      op->ttkContourTreeAlignment::SetExportPath(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkContourTreeAlignment_GetExportPath(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetExportPath");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkContourTreeAlignment *op = static_cast<ttkContourTreeAlignment *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetExportPath() :
      op->ttkContourTreeAlignment::GetExportPath());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkContourTreeAlignment_Methods[] = {
  {"IsTypeOf", PyttkContourTreeAlignment_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkContourTreeAlignment_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkContourTreeAlignment_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkContourTreeAlignment\nC++: static ttkContourTreeAlignment *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkContourTreeAlignment_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkContourTreeAlignment\nC++: ttkContourTreeAlignment *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkContourTreeAlignment_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkContourTreeAlignment_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetRandomSeed", PyttkContourTreeAlignment_SetRandomSeed, METH_VARARGS,
   "SetRandomSeed(self, _arg:int) -> None\nC++: virtual void SetRandomSeed(int _arg)\n\n"},
  {"GetRandomSeed", PyttkContourTreeAlignment_GetRandomSeed, METH_VARARGS,
   "GetRandomSeed(self) -> int\nC++: virtual int GetRandomSeed()\n\n"},
  {"SetMatchTime", PyttkContourTreeAlignment_SetMatchTime, METH_VARARGS,
   "SetMatchTime(self, _arg:bool) -> None\nC++: virtual void SetMatchTime(bool _arg)\n\n"},
  {"GetMatchTime", PyttkContourTreeAlignment_GetMatchTime, METH_VARARGS,
   "GetMatchTime(self) -> bool\nC++: virtual bool GetMatchTime()\n\n"},
  {"SetArcMatchMode", PyttkContourTreeAlignment_SetArcMatchMode, METH_VARARGS,
   "SetArcMatchMode(self, _arg:int) -> None\nC++: virtual void SetArcMatchMode(int _arg)\n\n"},
  {"GetArcMatchMode", PyttkContourTreeAlignment_GetArcMatchMode, METH_VARARGS,
   "GetArcMatchMode(self) -> int\nC++: virtual int GetArcMatchMode()\n\n"},
  {"SetAlignmenttreeType", PyttkContourTreeAlignment_SetAlignmenttreeType, METH_VARARGS,
   "SetAlignmenttreeType(self, _arg:int) -> None\nC++: virtual void SetAlignmenttreeType(int _arg)\n\n"},
  {"GetAlignmenttreeType", PyttkContourTreeAlignment_GetAlignmenttreeType, METH_VARARGS,
   "GetAlignmenttreeType(self) -> int\nC++: virtual int GetAlignmenttreeType()\n\n"},
  {"SetWeightCombinatorialMatch", PyttkContourTreeAlignment_SetWeightCombinatorialMatch, METH_VARARGS,
   "SetWeightCombinatorialMatch(self, _arg:float) -> None\nC++: virtual void SetWeightCombinatorialMatch(float _arg)\n\n"},
  {"GetWeightCombinatorialMatch", PyttkContourTreeAlignment_GetWeightCombinatorialMatch, METH_VARARGS,
   "GetWeightCombinatorialMatch(self) -> float\nC++: virtual float GetWeightCombinatorialMatch()\n\n"},
  {"SetWeightArcMatch", PyttkContourTreeAlignment_SetWeightArcMatch, METH_VARARGS,
   "SetWeightArcMatch(self, _arg:float) -> None\nC++: virtual void SetWeightArcMatch(float _arg)\n\n"},
  {"GetWeightArcMatch", PyttkContourTreeAlignment_GetWeightArcMatch, METH_VARARGS,
   "GetWeightArcMatch(self) -> float\nC++: virtual float GetWeightArcMatch()\n\n"},
  {"SetWeightScalarValueMatch", PyttkContourTreeAlignment_SetWeightScalarValueMatch, METH_VARARGS,
   "SetWeightScalarValueMatch(self, _arg:float) -> None\nC++: virtual void SetWeightScalarValueMatch(float _arg)\n\n"},
  {"GetWeightScalarValueMatch", PyttkContourTreeAlignment_GetWeightScalarValueMatch, METH_VARARGS,
   "GetWeightScalarValueMatch(self) -> float\nC++: virtual float GetWeightScalarValueMatch()\n\n"},
  {"SetExportJSON", PyttkContourTreeAlignment_SetExportJSON, METH_VARARGS,
   "SetExportJSON(self, _arg:bool) -> None\nC++: virtual void SetExportJSON(bool _arg)\n\n"},
  {"GetExportJSON", PyttkContourTreeAlignment_GetExportJSON, METH_VARARGS,
   "GetExportJSON(self) -> bool\nC++: virtual bool GetExportJSON()\n\n"},
  {"SetExportPath", PyttkContourTreeAlignment_SetExportPath, METH_VARARGS,
   "SetExportPath(self, _arg:str) -> None\nC++: virtual void SetExportPath(const std::string &_arg)\n\n"},
  {"GetExportPath", PyttkContourTreeAlignment_GetExportPath, METH_VARARGS,
   "GetExportPath(self) -> str\nC++: virtual std::string GetExportPath()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkContourTreeAlignment_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("random_seed"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTreeAlignment_GetRandomSeed(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTreeAlignment_SetRandomSeed(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTreeAlignment_SetRandomSeed(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRandomSeed/SetRandomSeed\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("match_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTreeAlignment_GetMatchTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTreeAlignment_SetMatchTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTreeAlignment_SetMatchTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetMatchTime/SetMatchTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("arc_match_mode"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTreeAlignment_GetArcMatchMode(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTreeAlignment_SetArcMatchMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTreeAlignment_SetArcMatchMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetArcMatchMode/SetArcMatchMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("alignmenttree_type"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTreeAlignment_GetAlignmenttreeType(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTreeAlignment_SetAlignmenttreeType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTreeAlignment_SetAlignmenttreeType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetAlignmenttreeType/SetAlignmenttreeType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("weight_combinatorial_match"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTreeAlignment_GetWeightCombinatorialMatch(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTreeAlignment_SetWeightCombinatorialMatch(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTreeAlignment_SetWeightCombinatorialMatch(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWeightCombinatorialMatch/SetWeightCombinatorialMatch\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("weight_arc_match"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTreeAlignment_GetWeightArcMatch(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTreeAlignment_SetWeightArcMatch(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTreeAlignment_SetWeightArcMatch(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWeightArcMatch/SetWeightArcMatch\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("weight_scalar_value_match"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTreeAlignment_GetWeightScalarValueMatch(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTreeAlignment_SetWeightScalarValueMatch(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTreeAlignment_SetWeightScalarValueMatch(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWeightScalarValueMatch/SetWeightScalarValueMatch\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("export_json"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTreeAlignment_GetExportJSON(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTreeAlignment_SetExportJSON(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTreeAlignment_SetExportJSON(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExportJSON/SetExportJSON\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("export_path"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkContourTreeAlignment_GetExportPath(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkContourTreeAlignment_SetExportPath(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkContourTreeAlignment_SetExportPath(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetExportPath/SetExportPath\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkContourTreeAlignment_Doc =
  "ttkContourTreeAlignment - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Florian Wetzels (f_wetzels13@cs.uni-kl.de), Jonas Lukasczyk\n"
  "(jl@jluk.de) \\date 28.01.2020\n\n"
  "TTK VTK-filter that computes an alignment for a multiblock of\n"
  "contourtrees\n\n"
  "This filter takes a multiblock of unstructured grids, where each\n"
  "block represents a contour tree, and computed the alignment of these\n"
  "contour trees. For each tree, a point array for the scalar values, a\n"
  "cell array for the region sizes of arcs and a cell array for the\n"
  "segmentation ids of arcs are required. Contour trees computed by the\n"
  "FTMTree module fulfill these requirements and are the recommended way\n"
  "to use this filter.\n\n"
  "\\param Input vtkMultiBlockDataSet representing the contour trees to\n"
  "    align\n"
  "\\param Output vtkUnstructuredGrid representing the alignment tree\n\n"
  "The input data array for the scalar values needs to be specified via\n"
  "the standard VTK call vtkAlgorithm::SetInputArrayToProcess() with the\n"
  "following parameters: \\param idx 0 (FIXED: the first array the\n"
  "algorithm requires)\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the input array)\n\n"
  "The input data array for the region sizes needs to be specified via\n"
  "the standard VTK call vtkAlgorithm::SetInputArrayToProcess() with the\n"
  "following parameters: \\param idx 1 (FIXED: the second array the\n"
  "algorithm requires)\n"
  "\\param port 0 (FIXED: first port)R\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 1 (FIXED: cell data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the input array)\n\n"
  "The input data array for the segmentation ids needs to be specified\n"
  "via the standard VTK call vtkAlgorithm::SetInputArrayToProcess() with\n"
  "the following parameters: \\param idx 2 (FIXED: the third array the\n"
  "algorithm requires)\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 1 (FIXED: cell data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the input array)\n\n"
  "Related publication:\n\n"
  "'Fuzzy contour trees: Alignment and joint layout of multiple contour\n"
  "trees' Anna Pia Lohfink, Florian Wetzels, Jonas Lukasczyk, Gunther H.\n"
  "Weber, and Christoph Garth. Comput. Graph. Forum, 39(3):343-355,\n"
  "2020.\n\n"
  "\\sa ttk::ContourTreeAlignment\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/contourTreeAlignment/\"\n"
  "  > Contour Tree Alignment example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkContourTreeAlignment_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkContourTreeAlignment.ttkContourTreeAlignment", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkContourTreeAlignment_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkContourTreeAlignment_StaticNew()
{
  return ttkContourTreeAlignment::New();
}

PyObject *PyttkContourTreeAlignment_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkContourTreeAlignment_Type, PyttkContourTreeAlignment_Methods,
    "ttkContourTreeAlignment",
 &PyttkContourTreeAlignment_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkContourTreeAlignment_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkContourTreeAlignment(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkContourTreeAlignment_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkContourTreeAlignment", o) != 0)
  {
    Py_DECREF(o);
  }

}

