// python wrapper for ttkTextureMapFromField
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkTextureMapFromField.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkTextureMapFromField(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkTextureMapFromField_ClassNew(); }


static PyObject *
PyttkTextureMapFromField_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkTextureMapFromField::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTextureMapFromField_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTextureMapFromField *op = static_cast<ttkTextureMapFromField *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkTextureMapFromField::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTextureMapFromField_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkTextureMapFromField *tempr = ttkTextureMapFromField::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTextureMapFromField_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTextureMapFromField *op = static_cast<ttkTextureMapFromField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkTextureMapFromField *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkTextureMapFromField::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTextureMapFromField_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkTextureMapFromField::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTextureMapFromField_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTextureMapFromField *op = static_cast<ttkTextureMapFromField *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkTextureMapFromField::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTextureMapFromField_SetOnlyUComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOnlyUComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTextureMapFromField *op = static_cast<ttkTextureMapFromField *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOnlyUComponent(temp0);
    }
    else
    {
      op->ttkTextureMapFromField::SetOnlyUComponent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTextureMapFromField_GetOnlyUComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOnlyUComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTextureMapFromField *op = static_cast<ttkTextureMapFromField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOnlyUComponent() :
      op->ttkTextureMapFromField::GetOnlyUComponent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTextureMapFromField_SetOnlyVComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOnlyVComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTextureMapFromField *op = static_cast<ttkTextureMapFromField *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetOnlyVComponent(temp0);
    }
    else
    {
      op->ttkTextureMapFromField::SetOnlyVComponent(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTextureMapFromField_GetOnlyVComponent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOnlyVComponent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTextureMapFromField *op = static_cast<ttkTextureMapFromField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetOnlyVComponent() :
      op->ttkTextureMapFromField::GetOnlyVComponent());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTextureMapFromField_SetRepeatUTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRepeatUTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTextureMapFromField *op = static_cast<ttkTextureMapFromField *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRepeatUTexture(temp0);
    }
    else
    {
      op->ttkTextureMapFromField::SetRepeatUTexture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTextureMapFromField_GetRepeatUTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRepeatUTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTextureMapFromField *op = static_cast<ttkTextureMapFromField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRepeatUTexture() :
      op->ttkTextureMapFromField::GetRepeatUTexture());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTextureMapFromField_SetRepeatVTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRepeatVTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTextureMapFromField *op = static_cast<ttkTextureMapFromField *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRepeatVTexture(temp0);
    }
    else
    {
      op->ttkTextureMapFromField::SetRepeatVTexture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTextureMapFromField_GetRepeatVTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRepeatVTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTextureMapFromField *op = static_cast<ttkTextureMapFromField *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetRepeatVTexture() :
      op->ttkTextureMapFromField::GetRepeatVTexture());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkTextureMapFromField_Methods[] = {
  {"IsTypeOf", PyttkTextureMapFromField_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkTextureMapFromField_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkTextureMapFromField_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkTextureMapFromField\nC++: static ttkTextureMapFromField *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkTextureMapFromField_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkTextureMapFromField\nC++: ttkTextureMapFromField *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkTextureMapFromField_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkTextureMapFromField_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetOnlyUComponent", PyttkTextureMapFromField_SetOnlyUComponent, METH_VARARGS,
   "SetOnlyUComponent(self, _arg:bool) -> None\nC++: virtual void SetOnlyUComponent(bool _arg)\n\n"},
  {"GetOnlyUComponent", PyttkTextureMapFromField_GetOnlyUComponent, METH_VARARGS,
   "GetOnlyUComponent(self) -> bool\nC++: virtual bool GetOnlyUComponent()\n\n"},
  {"SetOnlyVComponent", PyttkTextureMapFromField_SetOnlyVComponent, METH_VARARGS,
   "SetOnlyVComponent(self, _arg:bool) -> None\nC++: virtual void SetOnlyVComponent(bool _arg)\n\n"},
  {"GetOnlyVComponent", PyttkTextureMapFromField_GetOnlyVComponent, METH_VARARGS,
   "GetOnlyVComponent(self) -> bool\nC++: virtual bool GetOnlyVComponent()\n\n"},
  {"SetRepeatUTexture", PyttkTextureMapFromField_SetRepeatUTexture, METH_VARARGS,
   "SetRepeatUTexture(self, _arg:bool) -> None\nC++: virtual void SetRepeatUTexture(bool _arg)\n\n"},
  {"GetRepeatUTexture", PyttkTextureMapFromField_GetRepeatUTexture, METH_VARARGS,
   "GetRepeatUTexture(self) -> bool\nC++: virtual bool GetRepeatUTexture()\n\n"},
  {"SetRepeatVTexture", PyttkTextureMapFromField_SetRepeatVTexture, METH_VARARGS,
   "SetRepeatVTexture(self, _arg:bool) -> None\nC++: virtual void SetRepeatVTexture(bool _arg)\n\n"},
  {"GetRepeatVTexture", PyttkTextureMapFromField_GetRepeatVTexture, METH_VARARGS,
   "GetRepeatVTexture(self) -> bool\nC++: virtual bool GetRepeatVTexture()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkTextureMapFromField_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("only_u_component"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTextureMapFromField_GetOnlyUComponent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTextureMapFromField_SetOnlyUComponent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTextureMapFromField_SetOnlyUComponent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOnlyUComponent/SetOnlyUComponent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("only_v_component"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTextureMapFromField_GetOnlyVComponent(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTextureMapFromField_SetOnlyVComponent(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTextureMapFromField_SetOnlyVComponent(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetOnlyVComponent/SetOnlyVComponent\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("repeat_u_texture"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTextureMapFromField_GetRepeatUTexture(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTextureMapFromField_SetRepeatUTexture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTextureMapFromField_SetRepeatUTexture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRepeatUTexture/SetRepeatUTexture\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("repeat_v_texture"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTextureMapFromField_GetRepeatVTexture(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTextureMapFromField_SetRepeatVTexture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTextureMapFromField_SetRepeatVTexture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetRepeatVTexture/SetRepeatVTexture\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkTextureMapFromField_Doc =
  "ttkTextureMapFromField - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Julien Tierny <julien.tierny@lip6.fr>\\date November 2014.\n\n"
  "TTK VTK-filter which generates a texture map from one or two point\n"
  "data scalar fields.\n\n"
  "\\param Input Input data set (vtkDataSet)\n"
  "\\param Output Output data set with texture coordinates (vtkDataSet)\n\n"
  "This filter is useful to convert scalar fields to texture coordinates\n"
  "or to generate texture-based level lines out of a single scalar\n"
  "fields.\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa vtkProjectionFromField\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkTextureMapFromField_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkTextureMapFromField.ttkTextureMapFromField", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkTextureMapFromField_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkTextureMapFromField_StaticNew()
{
  return ttkTextureMapFromField::New();
}

PyObject *PyttkTextureMapFromField_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkTextureMapFromField_Type, PyttkTextureMapFromField_Methods,
    "ttkTextureMapFromField",
 &PyttkTextureMapFromField_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkTextureMapFromField_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkTextureMapFromField(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkTextureMapFromField_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkTextureMapFromField", o) != 0)
  {
    Py_DECREF(o);
  }

}

