// python wrapper for ttkUncertainDataEstimator
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkUncertainDataEstimator.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkUncertainDataEstimator(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkUncertainDataEstimator_ClassNew(); }


static PyObject *
PyttkUncertainDataEstimator_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkUncertainDataEstimator::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkUncertainDataEstimator_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkUncertainDataEstimator *op = static_cast<ttkUncertainDataEstimator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkUncertainDataEstimator::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkUncertainDataEstimator_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkUncertainDataEstimator *tempr = ttkUncertainDataEstimator::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkUncertainDataEstimator_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkUncertainDataEstimator *op = static_cast<ttkUncertainDataEstimator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkUncertainDataEstimator *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkUncertainDataEstimator::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkUncertainDataEstimator_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkUncertainDataEstimator::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkUncertainDataEstimator_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkUncertainDataEstimator *op = static_cast<ttkUncertainDataEstimator *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkUncertainDataEstimator::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkUncertainDataEstimator_GetComputeLowerBound(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeLowerBound");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkUncertainDataEstimator *op = static_cast<ttkUncertainDataEstimator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeLowerBound() :
      op->ttkUncertainDataEstimator::GetComputeLowerBound());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkUncertainDataEstimator_SetComputeLowerBound(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeLowerBound");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkUncertainDataEstimator *op = static_cast<ttkUncertainDataEstimator *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeLowerBound(temp0);
    }
    else
    {
      op->ttkUncertainDataEstimator::SetComputeLowerBound(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkUncertainDataEstimator_GetComputeUpperBound(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeUpperBound");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkUncertainDataEstimator *op = static_cast<ttkUncertainDataEstimator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeUpperBound() :
      op->ttkUncertainDataEstimator::GetComputeUpperBound());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkUncertainDataEstimator_SetComputeUpperBound(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeUpperBound");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkUncertainDataEstimator *op = static_cast<ttkUncertainDataEstimator *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeUpperBound(temp0);
    }
    else
    {
      op->ttkUncertainDataEstimator::SetComputeUpperBound(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkUncertainDataEstimator_GetBinCount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetBinCount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkUncertainDataEstimator *op = static_cast<ttkUncertainDataEstimator *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetBinCount() :
      op->ttkUncertainDataEstimator::GetBinCount());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkUncertainDataEstimator_SetBinCount(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBinCount");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkUncertainDataEstimator *op = static_cast<ttkUncertainDataEstimator *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBinCount(temp0);
    }
    else
    {
      op->ttkUncertainDataEstimator::SetBinCount(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkUncertainDataEstimator_SetBoundToCompute(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBoundToCompute");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkUncertainDataEstimator *op = static_cast<ttkUncertainDataEstimator *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBoundToCompute(temp0);
    }
    else
    {
      op->ttkUncertainDataEstimator::SetBoundToCompute(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyttkUncertainDataEstimator_Methods[] = {
  {"IsTypeOf", PyttkUncertainDataEstimator_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkUncertainDataEstimator_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkUncertainDataEstimator_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkUncertainDataEstimator\nC++: static ttkUncertainDataEstimator *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkUncertainDataEstimator_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkUncertainDataEstimator\nC++: ttkUncertainDataEstimator *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkUncertainDataEstimator_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkUncertainDataEstimator_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetComputeLowerBound", PyttkUncertainDataEstimator_GetComputeLowerBound, METH_VARARGS,
   "GetComputeLowerBound(self) -> bool\nC++: virtual bool GetComputeLowerBound()\n\n"},
  {"SetComputeLowerBound", PyttkUncertainDataEstimator_SetComputeLowerBound, METH_VARARGS,
   "SetComputeLowerBound(self, _arg:bool) -> None\nC++: virtual void SetComputeLowerBound(bool _arg)\n\n"},
  {"GetComputeUpperBound", PyttkUncertainDataEstimator_GetComputeUpperBound, METH_VARARGS,
   "GetComputeUpperBound(self) -> bool\nC++: virtual bool GetComputeUpperBound()\n\n"},
  {"SetComputeUpperBound", PyttkUncertainDataEstimator_SetComputeUpperBound, METH_VARARGS,
   "SetComputeUpperBound(self, _arg:bool) -> None\nC++: virtual void SetComputeUpperBound(bool _arg)\n\n"},
  {"GetBinCount", PyttkUncertainDataEstimator_GetBinCount, METH_VARARGS,
   "GetBinCount(self) -> int\nC++: virtual int GetBinCount()\n\n"},
  {"SetBinCount", PyttkUncertainDataEstimator_SetBinCount, METH_VARARGS,
   "SetBinCount(self, _arg:int) -> None\nC++: virtual void SetBinCount(int _arg)\n\n"},
  {"SetBoundToCompute", PyttkUncertainDataEstimator_SetBoundToCompute, METH_VARARGS,
   "SetBoundToCompute(self, value:int) -> None\nC++: void SetBoundToCompute(int value)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkUncertainDataEstimator_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("compute_lower_bound"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkUncertainDataEstimator_GetComputeLowerBound(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkUncertainDataEstimator_SetComputeLowerBound(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkUncertainDataEstimator_SetComputeLowerBound(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeLowerBound/SetComputeLowerBound\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_upper_bound"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkUncertainDataEstimator_GetComputeUpperBound(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkUncertainDataEstimator_SetComputeUpperBound(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkUncertainDataEstimator_SetComputeUpperBound(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeUpperBound/SetComputeUpperBound\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bin_count"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkUncertainDataEstimator_GetBinCount(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkUncertainDataEstimator_SetBinCount(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkUncertainDataEstimator_SetBinCount(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetBinCount/SetBinCount\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bound_to_compute"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkUncertainDataEstimator_SetBoundToCompute(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkUncertainDataEstimator_SetBoundToCompute(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBoundToCompute\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkUncertainDataEstimator_Doc =
  "ttkUncertainDataEstimator - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Michael Michaux <michauxmichael89@gmail.com>\\date August\n"
  "2016.\n\n"
  "TTK VTK-filter that takes an input ensemble data set\n"
  "(represented by a list of scalar fields) and which computes various\n"
  "vertexwise statistics (PDF estimation, bounds, moments, etc.)\n\n"
  "\\param Input0 Input ensemble scalar field #0 (vtkDataSet)\n"
  "\\param Input1 Input ensemble scalar field #1 (vtkDataSet)\n\n\n"
  "...\n\n"
  "\\param InputN Input ensemble scalar field #%N (vtkDataSet)\n"
  "\\param Output0 Lower and upper bound fields (vtkDataSet)\n"
  "\\param Output1 Histogram estimations of the vertex probability\n"
  "    density\n"
  "functions (vtkDataSet)\n"
  "\\param Output2 Mean field (vtkDataSet)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the corresponding ParaView state file example for a usage example\n"
  "within a VTK pipeline.\n\n"
  "\\sa vtkMandatoryCriticalPoints\n"
  "\\sa ttk::UncertainDataEstimator\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkUncertainDataEstimator_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkUncertainDataEstimator.ttkUncertainDataEstimator", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkUncertainDataEstimator_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkUncertainDataEstimator_StaticNew()
{
  return ttkUncertainDataEstimator::New();
}

PyObject *PyttkUncertainDataEstimator_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkUncertainDataEstimator_Type, PyttkUncertainDataEstimator_Methods,
    "ttkUncertainDataEstimator",
 &PyttkUncertainDataEstimator_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkUncertainDataEstimator_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkUncertainDataEstimator(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkUncertainDataEstimator_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkUncertainDataEstimator", o) != 0)
  {
    Py_DECREF(o);
  }

}

