// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudIamListUserPrincipalsByOrganizationResponse ListUserPrincipalsByOrganizationResponse contains lists of principals for an
// organization.
//
// swagger:model hashicorp.cloud.iam.ListUserPrincipalsByOrganizationResponse
type HashicorpCloudIamListUserPrincipalsByOrganizationResponse struct {

	// Pagination contains the pagination tokens for a subsequent request.
	Pagination *cloud.HashicorpCloudCommonPaginationResponse `json:"pagination,omitempty"`

	// user_principals is a list of user principals.
	UserPrincipals []*HashicorpCloudIamUserPrincipal `json:"user_principals"`
}

// Validate validates this hashicorp cloud iam list user principals by organization response
func (m *HashicorpCloudIamListUserPrincipalsByOrganizationResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePagination(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserPrincipals(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamListUserPrincipalsByOrganizationResponse) validatePagination(formats strfmt.Registry) error {
	if swag.IsZero(m.Pagination) { // not required
		return nil
	}

	if m.Pagination != nil {
		if err := m.Pagination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pagination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pagination")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudIamListUserPrincipalsByOrganizationResponse) validateUserPrincipals(formats strfmt.Registry) error {
	if swag.IsZero(m.UserPrincipals) { // not required
		return nil
	}

	for i := 0; i < len(m.UserPrincipals); i++ {
		if swag.IsZero(m.UserPrincipals[i]) { // not required
			continue
		}

		if m.UserPrincipals[i] != nil {
			if err := m.UserPrincipals[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("user_principals" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("user_principals" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud iam list user principals by organization response based on the context it is used
func (m *HashicorpCloudIamListUserPrincipalsByOrganizationResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePagination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUserPrincipals(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamListUserPrincipalsByOrganizationResponse) contextValidatePagination(ctx context.Context, formats strfmt.Registry) error {

	if m.Pagination != nil {

		if swag.IsZero(m.Pagination) { // not required
			return nil
		}

		if err := m.Pagination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pagination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pagination")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudIamListUserPrincipalsByOrganizationResponse) contextValidateUserPrincipals(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.UserPrincipals); i++ {

		if m.UserPrincipals[i] != nil {

			if swag.IsZero(m.UserPrincipals[i]) { // not required
				return nil
			}

			if err := m.UserPrincipals[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("user_principals" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("user_principals" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudIamListUserPrincipalsByOrganizationResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudIamListUserPrincipalsByOrganizationResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudIamListUserPrincipalsByOrganizationResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
