// Code generated by go-swagger; DO NOT EDIT.

package organization_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// OrganizationServiceGetReader is a Reader for the OrganizationServiceGet structure.
type OrganizationServiceGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *OrganizationServiceGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewOrganizationServiceGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewOrganizationServiceGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewOrganizationServiceGetOK creates a OrganizationServiceGetOK with default headers values
func NewOrganizationServiceGetOK() *OrganizationServiceGetOK {
	return &OrganizationServiceGetOK{}
}

/*
OrganizationServiceGetOK describes a response with status code 200, with default header values.

A successful response.
*/
type OrganizationServiceGetOK struct {
	Payload *models.HashicorpCloudResourcemanagerOrganizationGetResponse
}

// IsSuccess returns true when this organization service get o k response has a 2xx status code
func (o *OrganizationServiceGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this organization service get o k response has a 3xx status code
func (o *OrganizationServiceGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this organization service get o k response has a 4xx status code
func (o *OrganizationServiceGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this organization service get o k response has a 5xx status code
func (o *OrganizationServiceGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this organization service get o k response a status code equal to that given
func (o *OrganizationServiceGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the organization service get o k response
func (o *OrganizationServiceGetOK) Code() int {
	return 200
}

func (o *OrganizationServiceGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/organizations/{id}][%d] organizationServiceGetOK %s", 200, payload)
}

func (o *OrganizationServiceGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/organizations/{id}][%d] organizationServiceGetOK %s", 200, payload)
}

func (o *OrganizationServiceGetOK) GetPayload() *models.HashicorpCloudResourcemanagerOrganizationGetResponse {
	return o.Payload
}

func (o *OrganizationServiceGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudResourcemanagerOrganizationGetResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewOrganizationServiceGetDefault creates a OrganizationServiceGetDefault with default headers values
func NewOrganizationServiceGetDefault(code int) *OrganizationServiceGetDefault {
	return &OrganizationServiceGetDefault{
		_statusCode: code,
	}
}

/*
OrganizationServiceGetDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type OrganizationServiceGetDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this organization service get default response has a 2xx status code
func (o *OrganizationServiceGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this organization service get default response has a 3xx status code
func (o *OrganizationServiceGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this organization service get default response has a 4xx status code
func (o *OrganizationServiceGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this organization service get default response has a 5xx status code
func (o *OrganizationServiceGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this organization service get default response a status code equal to that given
func (o *OrganizationServiceGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the organization service get default response
func (o *OrganizationServiceGetDefault) Code() int {
	return o._statusCode
}

func (o *OrganizationServiceGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/organizations/{id}][%d] OrganizationService_Get default %s", o._statusCode, payload)
}

func (o *OrganizationServiceGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/organizations/{id}][%d] OrganizationService_Get default %s", o._statusCode, payload)
}

func (o *OrganizationServiceGetDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *OrganizationServiceGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
