// Code generated by go-swagger; DO NOT EDIT.

package project_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ProjectServiceTestIamPermissionsReader is a Reader for the ProjectServiceTestIamPermissions structure.
type ProjectServiceTestIamPermissionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ProjectServiceTestIamPermissionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewProjectServiceTestIamPermissionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewProjectServiceTestIamPermissionsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewProjectServiceTestIamPermissionsOK creates a ProjectServiceTestIamPermissionsOK with default headers values
func NewProjectServiceTestIamPermissionsOK() *ProjectServiceTestIamPermissionsOK {
	return &ProjectServiceTestIamPermissionsOK{}
}

/*
ProjectServiceTestIamPermissionsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ProjectServiceTestIamPermissionsOK struct {
	Payload *models.HashicorpCloudResourcemanagerProjectTestIamPermissionsResponse
}

// IsSuccess returns true when this project service test iam permissions o k response has a 2xx status code
func (o *ProjectServiceTestIamPermissionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this project service test iam permissions o k response has a 3xx status code
func (o *ProjectServiceTestIamPermissionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this project service test iam permissions o k response has a 4xx status code
func (o *ProjectServiceTestIamPermissionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this project service test iam permissions o k response has a 5xx status code
func (o *ProjectServiceTestIamPermissionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this project service test iam permissions o k response a status code equal to that given
func (o *ProjectServiceTestIamPermissionsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the project service test iam permissions o k response
func (o *ProjectServiceTestIamPermissionsOK) Code() int {
	return 200
}

func (o *ProjectServiceTestIamPermissionsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /resource-manager/2019-12-10/projects/{id}/test-iam-permissions][%d] projectServiceTestIamPermissionsOK %s", 200, payload)
}

func (o *ProjectServiceTestIamPermissionsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /resource-manager/2019-12-10/projects/{id}/test-iam-permissions][%d] projectServiceTestIamPermissionsOK %s", 200, payload)
}

func (o *ProjectServiceTestIamPermissionsOK) GetPayload() *models.HashicorpCloudResourcemanagerProjectTestIamPermissionsResponse {
	return o.Payload
}

func (o *ProjectServiceTestIamPermissionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudResourcemanagerProjectTestIamPermissionsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProjectServiceTestIamPermissionsDefault creates a ProjectServiceTestIamPermissionsDefault with default headers values
func NewProjectServiceTestIamPermissionsDefault(code int) *ProjectServiceTestIamPermissionsDefault {
	return &ProjectServiceTestIamPermissionsDefault{
		_statusCode: code,
	}
}

/*
ProjectServiceTestIamPermissionsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ProjectServiceTestIamPermissionsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this project service test iam permissions default response has a 2xx status code
func (o *ProjectServiceTestIamPermissionsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this project service test iam permissions default response has a 3xx status code
func (o *ProjectServiceTestIamPermissionsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this project service test iam permissions default response has a 4xx status code
func (o *ProjectServiceTestIamPermissionsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this project service test iam permissions default response has a 5xx status code
func (o *ProjectServiceTestIamPermissionsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this project service test iam permissions default response a status code equal to that given
func (o *ProjectServiceTestIamPermissionsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the project service test iam permissions default response
func (o *ProjectServiceTestIamPermissionsDefault) Code() int {
	return o._statusCode
}

func (o *ProjectServiceTestIamPermissionsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /resource-manager/2019-12-10/projects/{id}/test-iam-permissions][%d] ProjectService_TestIamPermissions default %s", o._statusCode, payload)
}

func (o *ProjectServiceTestIamPermissionsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /resource-manager/2019-12-10/projects/{id}/test-iam-permissions][%d] ProjectService_TestIamPermissions default %s", o._statusCode, payload)
}

func (o *ProjectServiceTestIamPermissionsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ProjectServiceTestIamPermissionsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ProjectServiceTestIamPermissionsBody see ProjectService.TestIamPermissions
swagger:model ProjectServiceTestIamPermissionsBody
*/
type ProjectServiceTestIamPermissionsBody struct {

	// Permissions to test.
	Permissions []string `json:"permissions"`
}

// Validate validates this project service test iam permissions body
func (o *ProjectServiceTestIamPermissionsBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this project service test iam permissions body based on context it is used
func (o *ProjectServiceTestIamPermissionsBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ProjectServiceTestIamPermissionsBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ProjectServiceTestIamPermissionsBody) UnmarshalBinary(b []byte) error {
	var res ProjectServiceTestIamPermissionsBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
