// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetAvailableProvidersParams creates a new GetAvailableProvidersParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAvailableProvidersParams() *GetAvailableProvidersParams {
	return &GetAvailableProvidersParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAvailableProvidersParamsWithTimeout creates a new GetAvailableProvidersParams object
// with the ability to set a timeout on a request.
func NewGetAvailableProvidersParamsWithTimeout(timeout time.Duration) *GetAvailableProvidersParams {
	return &GetAvailableProvidersParams{
		timeout: timeout,
	}
}

// NewGetAvailableProvidersParamsWithContext creates a new GetAvailableProvidersParams object
// with the ability to set a context for a request.
func NewGetAvailableProvidersParamsWithContext(ctx context.Context) *GetAvailableProvidersParams {
	return &GetAvailableProvidersParams{
		Context: ctx,
	}
}

// NewGetAvailableProvidersParamsWithHTTPClient creates a new GetAvailableProvidersParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetAvailableProvidersParamsWithHTTPClient(client *http.Client) *GetAvailableProvidersParams {
	return &GetAvailableProvidersParams{
		HTTPClient: client,
	}
}

/*
GetAvailableProvidersParams contains all the parameters to send to the API endpoint

	for the get available providers operation.

	Typically these are written to a http.Request.
*/
type GetAvailableProvidersParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get available providers params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAvailableProvidersParams) WithDefaults() *GetAvailableProvidersParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get available providers params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAvailableProvidersParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get available providers params
func (o *GetAvailableProvidersParams) WithTimeout(timeout time.Duration) *GetAvailableProvidersParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get available providers params
func (o *GetAvailableProvidersParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get available providers params
func (o *GetAvailableProvidersParams) WithContext(ctx context.Context) *GetAvailableProvidersParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get available providers params
func (o *GetAvailableProvidersParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get available providers params
func (o *GetAvailableProvidersParams) WithHTTPClient(client *http.Client) *GetAvailableProvidersParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get available providers params
func (o *GetAvailableProvidersParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the get available providers params
func (o *GetAvailableProvidersParams) WithLocationOrganizationID(locationOrganizationID string) *GetAvailableProvidersParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get available providers params
func (o *GetAvailableProvidersParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get available providers params
func (o *GetAvailableProvidersParams) WithLocationProjectID(locationProjectID string) *GetAvailableProvidersParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get available providers params
func (o *GetAvailableProvidersParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get available providers params
func (o *GetAvailableProvidersParams) WithLocationRegionProvider(locationRegionProvider *string) *GetAvailableProvidersParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get available providers params
func (o *GetAvailableProvidersParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get available providers params
func (o *GetAvailableProvidersParams) WithLocationRegionRegion(locationRegionRegion *string) *GetAvailableProvidersParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get available providers params
func (o *GetAvailableProvidersParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *GetAvailableProvidersParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
