// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// NewUpdateSnapshotParams creates a new UpdateSnapshotParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateSnapshotParams() *UpdateSnapshotParams {
	return &UpdateSnapshotParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateSnapshotParamsWithTimeout creates a new UpdateSnapshotParams object
// with the ability to set a timeout on a request.
func NewUpdateSnapshotParamsWithTimeout(timeout time.Duration) *UpdateSnapshotParams {
	return &UpdateSnapshotParams{
		timeout: timeout,
	}
}

// NewUpdateSnapshotParamsWithContext creates a new UpdateSnapshotParams object
// with the ability to set a context for a request.
func NewUpdateSnapshotParamsWithContext(ctx context.Context) *UpdateSnapshotParams {
	return &UpdateSnapshotParams{
		Context: ctx,
	}
}

// NewUpdateSnapshotParamsWithHTTPClient creates a new UpdateSnapshotParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateSnapshotParamsWithHTTPClient(client *http.Client) *UpdateSnapshotParams {
	return &UpdateSnapshotParams{
		HTTPClient: client,
	}
}

/*
UpdateSnapshotParams contains all the parameters to send to the API endpoint

	for the update snapshot operation.

	Typically these are written to a http.Request.
*/
type UpdateSnapshotParams struct {

	// Body.
	Body *models.HashicorpCloudVault20201125UpdateSnapshotRequest

	/* SnapshotLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	SnapshotLocationOrganizationID string

	/* SnapshotLocationProjectID.

	   project_id is the projects id.
	*/
	SnapshotLocationProjectID string

	/* SnapshotSnapshotID.

	   snapshot_id is the snapshots UUID.
	*/
	SnapshotSnapshotID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update snapshot params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateSnapshotParams) WithDefaults() *UpdateSnapshotParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update snapshot params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateSnapshotParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update snapshot params
func (o *UpdateSnapshotParams) WithTimeout(timeout time.Duration) *UpdateSnapshotParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update snapshot params
func (o *UpdateSnapshotParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update snapshot params
func (o *UpdateSnapshotParams) WithContext(ctx context.Context) *UpdateSnapshotParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update snapshot params
func (o *UpdateSnapshotParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update snapshot params
func (o *UpdateSnapshotParams) WithHTTPClient(client *http.Client) *UpdateSnapshotParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update snapshot params
func (o *UpdateSnapshotParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update snapshot params
func (o *UpdateSnapshotParams) WithBody(body *models.HashicorpCloudVault20201125UpdateSnapshotRequest) *UpdateSnapshotParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update snapshot params
func (o *UpdateSnapshotParams) SetBody(body *models.HashicorpCloudVault20201125UpdateSnapshotRequest) {
	o.Body = body
}

// WithSnapshotLocationOrganizationID adds the snapshotLocationOrganizationID to the update snapshot params
func (o *UpdateSnapshotParams) WithSnapshotLocationOrganizationID(snapshotLocationOrganizationID string) *UpdateSnapshotParams {
	o.SetSnapshotLocationOrganizationID(snapshotLocationOrganizationID)
	return o
}

// SetSnapshotLocationOrganizationID adds the snapshotLocationOrganizationId to the update snapshot params
func (o *UpdateSnapshotParams) SetSnapshotLocationOrganizationID(snapshotLocationOrganizationID string) {
	o.SnapshotLocationOrganizationID = snapshotLocationOrganizationID
}

// WithSnapshotLocationProjectID adds the snapshotLocationProjectID to the update snapshot params
func (o *UpdateSnapshotParams) WithSnapshotLocationProjectID(snapshotLocationProjectID string) *UpdateSnapshotParams {
	o.SetSnapshotLocationProjectID(snapshotLocationProjectID)
	return o
}

// SetSnapshotLocationProjectID adds the snapshotLocationProjectId to the update snapshot params
func (o *UpdateSnapshotParams) SetSnapshotLocationProjectID(snapshotLocationProjectID string) {
	o.SnapshotLocationProjectID = snapshotLocationProjectID
}

// WithSnapshotSnapshotID adds the snapshotSnapshotID to the update snapshot params
func (o *UpdateSnapshotParams) WithSnapshotSnapshotID(snapshotSnapshotID string) *UpdateSnapshotParams {
	o.SetSnapshotSnapshotID(snapshotSnapshotID)
	return o
}

// SetSnapshotSnapshotID adds the snapshotSnapshotId to the update snapshot params
func (o *UpdateSnapshotParams) SetSnapshotSnapshotID(snapshotSnapshotID string) {
	o.SnapshotSnapshotID = snapshotSnapshotID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateSnapshotParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param snapshot.location.organization_id
	if err := r.SetPathParam("snapshot.location.organization_id", o.SnapshotLocationOrganizationID); err != nil {
		return err
	}

	// path param snapshot.location.project_id
	if err := r.SetPathParam("snapshot.location.project_id", o.SnapshotLocationProjectID); err != nil {
		return err
	}

	// path param snapshot.snapshot_id
	if err := r.SetPathParam("snapshot.snapshot_id", o.SnapshotSnapshotID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
