// Code generated by Microsoft Kiota - DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package models

import (
    i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e "time"
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91 "github.com/microsoft/kiota-abstractions-go/serialization"
)

type RestoreArtifactsBulkRequestBase struct {
    Entity
}
// NewRestoreArtifactsBulkRequestBase instantiates a new RestoreArtifactsBulkRequestBase and sets the default values.
func NewRestoreArtifactsBulkRequestBase()(*RestoreArtifactsBulkRequestBase) {
    m := &RestoreArtifactsBulkRequestBase{
        Entity: *NewEntity(),
    }
    return m
}
// CreateRestoreArtifactsBulkRequestBaseFromDiscriminatorValue creates a new instance of the appropriate class based on discriminator value
// returns a Parsable when successful
func CreateRestoreArtifactsBulkRequestBaseFromDiscriminatorValue(parseNode i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable, error) {
    if parseNode != nil {
        mappingValueNode, err := parseNode.GetChildNode("@odata.type")
        if err != nil {
            return nil, err
        }
        if mappingValueNode != nil {
            mappingValue, err := mappingValueNode.GetStringValue()
            if err != nil {
                return nil, err
            }
            if mappingValue != nil {
                switch *mappingValue {
                    case "#microsoft.graph.driveRestoreArtifactsBulkAdditionRequest":
                        return NewDriveRestoreArtifactsBulkAdditionRequest(), nil
                    case "#microsoft.graph.mailboxRestoreArtifactsBulkAdditionRequest":
                        return NewMailboxRestoreArtifactsBulkAdditionRequest(), nil
                    case "#microsoft.graph.siteRestoreArtifactsBulkAdditionRequest":
                        return NewSiteRestoreArtifactsBulkAdditionRequest(), nil
                }
            }
        }
    }
    return NewRestoreArtifactsBulkRequestBase(), nil
}
// GetCreatedBy gets the createdBy property value. The identity of the person who created the bulk request.
// returns a IdentitySetable when successful
func (m *RestoreArtifactsBulkRequestBase) GetCreatedBy()(IdentitySetable) {
    val, err := m.GetBackingStore().Get("createdBy")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(IdentitySetable)
    }
    return nil
}
// GetCreatedDateTime gets the createdDateTime property value. The time when the bulk request was created.
// returns a *Time when successful
func (m *RestoreArtifactsBulkRequestBase) GetCreatedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("createdDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetDestinationType gets the destinationType property value. Indicates the restoration destination. The possible values are: new, inPlace, unknownFutureValue.
// returns a *DestinationType when successful
func (m *RestoreArtifactsBulkRequestBase) GetDestinationType()(*DestinationType) {
    val, err := m.GetBackingStore().Get("destinationType")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*DestinationType)
    }
    return nil
}
// GetDisplayName gets the displayName property value. Name of the addition request.
// returns a *string when successful
func (m *RestoreArtifactsBulkRequestBase) GetDisplayName()(*string) {
    val, err := m.GetBackingStore().Get("displayName")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*string)
    }
    return nil
}
// GetError gets the error property value. Error details are populated for resource resolution failures.
// returns a PublicErrorable when successful
func (m *RestoreArtifactsBulkRequestBase) GetError()(PublicErrorable) {
    val, err := m.GetBackingStore().Get("error")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(PublicErrorable)
    }
    return nil
}
// GetFieldDeserializers the deserialization information for the current model
// returns a map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error) when successful
func (m *RestoreArtifactsBulkRequestBase) GetFieldDeserializers()(map[string]func(i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode)(error)) {
    res := m.Entity.GetFieldDeserializers()
    res["createdBy"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetObjectValue(CreateIdentitySetFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetCreatedBy(val.(IdentitySetable))
        }
        return nil
    }
    res["createdDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetCreatedDateTime(val)
        }
        return nil
    }
    res["destinationType"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseDestinationType)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetDestinationType(val.(*DestinationType))
        }
        return nil
    }
    res["displayName"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetStringValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetDisplayName(val)
        }
        return nil
    }
    res["error"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetObjectValue(CreatePublicErrorFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetError(val.(PublicErrorable))
        }
        return nil
    }
    res["lastModifiedBy"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetObjectValue(CreateIdentitySetFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetLastModifiedBy(val.(IdentitySetable))
        }
        return nil
    }
    res["lastModifiedDateTime"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetTimeValue()
        if err != nil {
            return err
        }
        if val != nil {
            m.SetLastModifiedDateTime(val)
        }
        return nil
    }
    res["protectionTimePeriod"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetObjectValue(CreateTimePeriodFromDiscriminatorValue)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetProtectionTimePeriod(val.(TimePeriodable))
        }
        return nil
    }
    res["protectionUnitIds"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetCollectionOfPrimitiveValues("string")
        if err != nil {
            return err
        }
        if val != nil {
            res := make([]string, len(val))
            for i, v := range val {
                if v != nil {
                    res[i] = *(v.(*string))
                }
            }
            m.SetProtectionUnitIds(res)
        }
        return nil
    }
    res["restorePointPreference"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseRestorePointPreference)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetRestorePointPreference(val.(*RestorePointPreference))
        }
        return nil
    }
    res["status"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseRestoreArtifactsBulkRequestStatus)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetStatus(val.(*RestoreArtifactsBulkRequestStatus))
        }
        return nil
    }
    res["tags"] = func (n i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.ParseNode) error {
        val, err := n.GetEnumValue(ParseRestorePointTags)
        if err != nil {
            return err
        }
        if val != nil {
            m.SetTags(val.(*RestorePointTags))
        }
        return nil
    }
    return res
}
// GetLastModifiedBy gets the lastModifiedBy property value. Identity of the person who last modified this entity.
// returns a IdentitySetable when successful
func (m *RestoreArtifactsBulkRequestBase) GetLastModifiedBy()(IdentitySetable) {
    val, err := m.GetBackingStore().Get("lastModifiedBy")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(IdentitySetable)
    }
    return nil
}
// GetLastModifiedDateTime gets the lastModifiedDateTime property value. Timestamp when this entity was last modified.
// returns a *Time when successful
func (m *RestoreArtifactsBulkRequestBase) GetLastModifiedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time) {
    val, err := m.GetBackingStore().Get("lastModifiedDateTime")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    }
    return nil
}
// GetProtectionTimePeriod gets the protectionTimePeriod property value. The start and end date and time of the protection period.
// returns a TimePeriodable when successful
func (m *RestoreArtifactsBulkRequestBase) GetProtectionTimePeriod()(TimePeriodable) {
    val, err := m.GetBackingStore().Get("protectionTimePeriod")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(TimePeriodable)
    }
    return nil
}
// GetProtectionUnitIds gets the protectionUnitIds property value. Indicates which protection units to restore. This property isn't implemented yet. Future value; don't use.
// returns a []string when successful
func (m *RestoreArtifactsBulkRequestBase) GetProtectionUnitIds()([]string) {
    val, err := m.GetBackingStore().Get("protectionUnitIds")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.([]string)
    }
    return nil
}
// GetRestorePointPreference gets the restorePointPreference property value. Indicates which restore point to return. The possible values are: oldest, latest, unknownFutureValue.
// returns a *RestorePointPreference when successful
func (m *RestoreArtifactsBulkRequestBase) GetRestorePointPreference()(*RestorePointPreference) {
    val, err := m.GetBackingStore().Get("restorePointPreference")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*RestorePointPreference)
    }
    return nil
}
// GetStatus gets the status property value. The status property
// returns a *RestoreArtifactsBulkRequestStatus when successful
func (m *RestoreArtifactsBulkRequestBase) GetStatus()(*RestoreArtifactsBulkRequestStatus) {
    val, err := m.GetBackingStore().Get("status")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*RestoreArtifactsBulkRequestStatus)
    }
    return nil
}
// GetTags gets the tags property value. The type of the restore point. The possible values are: none, fastRestore, unknownFutureValue.
// returns a *RestorePointTags when successful
func (m *RestoreArtifactsBulkRequestBase) GetTags()(*RestorePointTags) {
    val, err := m.GetBackingStore().Get("tags")
    if err != nil {
        panic(err)
    }
    if val != nil {
        return val.(*RestorePointTags)
    }
    return nil
}
// Serialize serializes information the current object
func (m *RestoreArtifactsBulkRequestBase) Serialize(writer i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.SerializationWriter)(error) {
    err := m.Entity.Serialize(writer)
    if err != nil {
        return err
    }
    {
        err = writer.WriteObjectValue("createdBy", m.GetCreatedBy())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("createdDateTime", m.GetCreatedDateTime())
        if err != nil {
            return err
        }
    }
    if m.GetDestinationType() != nil {
        cast := (*m.GetDestinationType()).String()
        err = writer.WriteStringValue("destinationType", &cast)
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteStringValue("displayName", m.GetDisplayName())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteObjectValue("error", m.GetError())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteObjectValue("lastModifiedBy", m.GetLastModifiedBy())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteTimeValue("lastModifiedDateTime", m.GetLastModifiedDateTime())
        if err != nil {
            return err
        }
    }
    {
        err = writer.WriteObjectValue("protectionTimePeriod", m.GetProtectionTimePeriod())
        if err != nil {
            return err
        }
    }
    if m.GetProtectionUnitIds() != nil {
        err = writer.WriteCollectionOfStringValues("protectionUnitIds", m.GetProtectionUnitIds())
        if err != nil {
            return err
        }
    }
    if m.GetRestorePointPreference() != nil {
        cast := (*m.GetRestorePointPreference()).String()
        err = writer.WriteStringValue("restorePointPreference", &cast)
        if err != nil {
            return err
        }
    }
    if m.GetStatus() != nil {
        cast := (*m.GetStatus()).String()
        err = writer.WriteStringValue("status", &cast)
        if err != nil {
            return err
        }
    }
    if m.GetTags() != nil {
        cast := (*m.GetTags()).String()
        err = writer.WriteStringValue("tags", &cast)
        if err != nil {
            return err
        }
    }
    return nil
}
// SetCreatedBy sets the createdBy property value. The identity of the person who created the bulk request.
func (m *RestoreArtifactsBulkRequestBase) SetCreatedBy(value IdentitySetable)() {
    err := m.GetBackingStore().Set("createdBy", value)
    if err != nil {
        panic(err)
    }
}
// SetCreatedDateTime sets the createdDateTime property value. The time when the bulk request was created.
func (m *RestoreArtifactsBulkRequestBase) SetCreatedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("createdDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetDestinationType sets the destinationType property value. Indicates the restoration destination. The possible values are: new, inPlace, unknownFutureValue.
func (m *RestoreArtifactsBulkRequestBase) SetDestinationType(value *DestinationType)() {
    err := m.GetBackingStore().Set("destinationType", value)
    if err != nil {
        panic(err)
    }
}
// SetDisplayName sets the displayName property value. Name of the addition request.
func (m *RestoreArtifactsBulkRequestBase) SetDisplayName(value *string)() {
    err := m.GetBackingStore().Set("displayName", value)
    if err != nil {
        panic(err)
    }
}
// SetError sets the error property value. Error details are populated for resource resolution failures.
func (m *RestoreArtifactsBulkRequestBase) SetError(value PublicErrorable)() {
    err := m.GetBackingStore().Set("error", value)
    if err != nil {
        panic(err)
    }
}
// SetLastModifiedBy sets the lastModifiedBy property value. Identity of the person who last modified this entity.
func (m *RestoreArtifactsBulkRequestBase) SetLastModifiedBy(value IdentitySetable)() {
    err := m.GetBackingStore().Set("lastModifiedBy", value)
    if err != nil {
        panic(err)
    }
}
// SetLastModifiedDateTime sets the lastModifiedDateTime property value. Timestamp when this entity was last modified.
func (m *RestoreArtifactsBulkRequestBase) SetLastModifiedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)() {
    err := m.GetBackingStore().Set("lastModifiedDateTime", value)
    if err != nil {
        panic(err)
    }
}
// SetProtectionTimePeriod sets the protectionTimePeriod property value. The start and end date and time of the protection period.
func (m *RestoreArtifactsBulkRequestBase) SetProtectionTimePeriod(value TimePeriodable)() {
    err := m.GetBackingStore().Set("protectionTimePeriod", value)
    if err != nil {
        panic(err)
    }
}
// SetProtectionUnitIds sets the protectionUnitIds property value. Indicates which protection units to restore. This property isn't implemented yet. Future value; don't use.
func (m *RestoreArtifactsBulkRequestBase) SetProtectionUnitIds(value []string)() {
    err := m.GetBackingStore().Set("protectionUnitIds", value)
    if err != nil {
        panic(err)
    }
}
// SetRestorePointPreference sets the restorePointPreference property value. Indicates which restore point to return. The possible values are: oldest, latest, unknownFutureValue.
func (m *RestoreArtifactsBulkRequestBase) SetRestorePointPreference(value *RestorePointPreference)() {
    err := m.GetBackingStore().Set("restorePointPreference", value)
    if err != nil {
        panic(err)
    }
}
// SetStatus sets the status property value. The status property
func (m *RestoreArtifactsBulkRequestBase) SetStatus(value *RestoreArtifactsBulkRequestStatus)() {
    err := m.GetBackingStore().Set("status", value)
    if err != nil {
        panic(err)
    }
}
// SetTags sets the tags property value. The type of the restore point. The possible values are: none, fastRestore, unknownFutureValue.
func (m *RestoreArtifactsBulkRequestBase) SetTags(value *RestorePointTags)() {
    err := m.GetBackingStore().Set("tags", value)
    if err != nil {
        panic(err)
    }
}
type RestoreArtifactsBulkRequestBaseable interface {
    Entityable
    i878a80d2330e89d26896388a3f487eef27b0a0e6c010c493bf80be1452208f91.Parsable
    GetCreatedBy()(IdentitySetable)
    GetCreatedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetDestinationType()(*DestinationType)
    GetDisplayName()(*string)
    GetError()(PublicErrorable)
    GetLastModifiedBy()(IdentitySetable)
    GetLastModifiedDateTime()(*i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)
    GetProtectionTimePeriod()(TimePeriodable)
    GetProtectionUnitIds()([]string)
    GetRestorePointPreference()(*RestorePointPreference)
    GetStatus()(*RestoreArtifactsBulkRequestStatus)
    GetTags()(*RestorePointTags)
    SetCreatedBy(value IdentitySetable)()
    SetCreatedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetDestinationType(value *DestinationType)()
    SetDisplayName(value *string)()
    SetError(value PublicErrorable)()
    SetLastModifiedBy(value IdentitySetable)()
    SetLastModifiedDateTime(value *i336074805fc853987abe6f7fe3ad97a6a6f3077a16391fec744f671a015fbd7e.Time)()
    SetProtectionTimePeriod(value TimePeriodable)()
    SetProtectionUnitIds(value []string)()
    SetRestorePointPreference(value *RestorePointPreference)()
    SetStatus(value *RestoreArtifactsBulkRequestStatus)()
    SetTags(value *RestorePointTags)()
}
