// Code generated by Microsoft Kiota - DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package security

import (
    "context"
    i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f "github.com/microsoft/kiota-abstractions-go"
    iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242 "github.com/microsoftgraph/msgraph-sdk-go/models"
    ia572726a95efa92ddd544552cd950653dc691023836923576b2f4bf716cf204a "github.com/microsoftgraph/msgraph-sdk-go/models/odataerrors"
)

// DataSecurityAndGovernanceProtectionScopesRequestBuilder provides operations to manage the protectionScopes property of the microsoft.graph.tenantDataSecurityAndGovernance entity.
type DataSecurityAndGovernanceProtectionScopesRequestBuilder struct {
    i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.BaseRequestBuilder
}
// DataSecurityAndGovernanceProtectionScopesRequestBuilderDeleteRequestConfiguration configuration for the request such as headers, query parameters, and middleware options.
type DataSecurityAndGovernanceProtectionScopesRequestBuilderDeleteRequestConfiguration struct {
    // Request headers
    Headers *i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestHeaders
    // Request options
    Options []i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestOption
}
// DataSecurityAndGovernanceProtectionScopesRequestBuilderGetQueryParameters container for actions related to computing tenant-wide data protection scopes.
type DataSecurityAndGovernanceProtectionScopesRequestBuilderGetQueryParameters struct {
    // Expand related entities
    Expand []string `uriparametername:"%24expand"`
    // Select properties to be returned
    Select []string `uriparametername:"%24select"`
}
// DataSecurityAndGovernanceProtectionScopesRequestBuilderGetRequestConfiguration configuration for the request such as headers, query parameters, and middleware options.
type DataSecurityAndGovernanceProtectionScopesRequestBuilderGetRequestConfiguration struct {
    // Request headers
    Headers *i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestHeaders
    // Request options
    Options []i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestOption
    // Request query parameters
    QueryParameters *DataSecurityAndGovernanceProtectionScopesRequestBuilderGetQueryParameters
}
// DataSecurityAndGovernanceProtectionScopesRequestBuilderPatchRequestConfiguration configuration for the request such as headers, query parameters, and middleware options.
type DataSecurityAndGovernanceProtectionScopesRequestBuilderPatchRequestConfiguration struct {
    // Request headers
    Headers *i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestHeaders
    // Request options
    Options []i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestOption
}
// Compute provides operations to call the compute method.
// returns a *DataSecurityAndGovernanceProtectionScopesComputeRequestBuilder when successful
func (m *DataSecurityAndGovernanceProtectionScopesRequestBuilder) Compute()(*DataSecurityAndGovernanceProtectionScopesComputeRequestBuilder) {
    return NewDataSecurityAndGovernanceProtectionScopesComputeRequestBuilderInternal(m.BaseRequestBuilder.PathParameters, m.BaseRequestBuilder.RequestAdapter)
}
// NewDataSecurityAndGovernanceProtectionScopesRequestBuilderInternal instantiates a new DataSecurityAndGovernanceProtectionScopesRequestBuilder and sets the default values.
func NewDataSecurityAndGovernanceProtectionScopesRequestBuilderInternal(pathParameters map[string]string, requestAdapter i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestAdapter)(*DataSecurityAndGovernanceProtectionScopesRequestBuilder) {
    m := &DataSecurityAndGovernanceProtectionScopesRequestBuilder{
        BaseRequestBuilder: *i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.NewBaseRequestBuilder(requestAdapter, "{+baseurl}/security/dataSecurityAndGovernance/protectionScopes{?%24expand,%24select}", pathParameters),
    }
    return m
}
// NewDataSecurityAndGovernanceProtectionScopesRequestBuilder instantiates a new DataSecurityAndGovernanceProtectionScopesRequestBuilder and sets the default values.
func NewDataSecurityAndGovernanceProtectionScopesRequestBuilder(rawUrl string, requestAdapter i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestAdapter)(*DataSecurityAndGovernanceProtectionScopesRequestBuilder) {
    urlParams := make(map[string]string)
    urlParams["request-raw-url"] = rawUrl
    return NewDataSecurityAndGovernanceProtectionScopesRequestBuilderInternal(urlParams, requestAdapter)
}
// Delete delete navigation property protectionScopes for security
// returns a ODataError error when the service returns a 4XX or 5XX status code
func (m *DataSecurityAndGovernanceProtectionScopesRequestBuilder) Delete(ctx context.Context, requestConfiguration *DataSecurityAndGovernanceProtectionScopesRequestBuilderDeleteRequestConfiguration)(error) {
    requestInfo, err := m.ToDeleteRequestInformation(ctx, requestConfiguration);
    if err != nil {
        return err
    }
    errorMapping := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.ErrorMappings {
        "XXX": ia572726a95efa92ddd544552cd950653dc691023836923576b2f4bf716cf204a.CreateODataErrorFromDiscriminatorValue,
    }
    err = m.BaseRequestBuilder.RequestAdapter.SendNoContent(ctx, requestInfo, errorMapping)
    if err != nil {
        return err
    }
    return nil
}
// Get container for actions related to computing tenant-wide data protection scopes.
// returns a TenantProtectionScopeContainerable when successful
// returns a ODataError error when the service returns a 4XX or 5XX status code
func (m *DataSecurityAndGovernanceProtectionScopesRequestBuilder) Get(ctx context.Context, requestConfiguration *DataSecurityAndGovernanceProtectionScopesRequestBuilderGetRequestConfiguration)(iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.TenantProtectionScopeContainerable, error) {
    requestInfo, err := m.ToGetRequestInformation(ctx, requestConfiguration);
    if err != nil {
        return nil, err
    }
    errorMapping := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.ErrorMappings {
        "XXX": ia572726a95efa92ddd544552cd950653dc691023836923576b2f4bf716cf204a.CreateODataErrorFromDiscriminatorValue,
    }
    res, err := m.BaseRequestBuilder.RequestAdapter.Send(ctx, requestInfo, iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.CreateTenantProtectionScopeContainerFromDiscriminatorValue, errorMapping)
    if err != nil {
        return nil, err
    }
    if res == nil {
        return nil, nil
    }
    return res.(iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.TenantProtectionScopeContainerable), nil
}
// Patch update the navigation property protectionScopes in security
// returns a TenantProtectionScopeContainerable when successful
// returns a ODataError error when the service returns a 4XX or 5XX status code
func (m *DataSecurityAndGovernanceProtectionScopesRequestBuilder) Patch(ctx context.Context, body iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.TenantProtectionScopeContainerable, requestConfiguration *DataSecurityAndGovernanceProtectionScopesRequestBuilderPatchRequestConfiguration)(iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.TenantProtectionScopeContainerable, error) {
    requestInfo, err := m.ToPatchRequestInformation(ctx, body, requestConfiguration);
    if err != nil {
        return nil, err
    }
    errorMapping := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.ErrorMappings {
        "XXX": ia572726a95efa92ddd544552cd950653dc691023836923576b2f4bf716cf204a.CreateODataErrorFromDiscriminatorValue,
    }
    res, err := m.BaseRequestBuilder.RequestAdapter.Send(ctx, requestInfo, iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.CreateTenantProtectionScopeContainerFromDiscriminatorValue, errorMapping)
    if err != nil {
        return nil, err
    }
    if res == nil {
        return nil, nil
    }
    return res.(iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.TenantProtectionScopeContainerable), nil
}
// ToDeleteRequestInformation delete navigation property protectionScopes for security
// returns a *RequestInformation when successful
func (m *DataSecurityAndGovernanceProtectionScopesRequestBuilder) ToDeleteRequestInformation(ctx context.Context, requestConfiguration *DataSecurityAndGovernanceProtectionScopesRequestBuilderDeleteRequestConfiguration)(*i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestInformation, error) {
    requestInfo := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.NewRequestInformationWithMethodAndUrlTemplateAndPathParameters(i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.DELETE, m.BaseRequestBuilder.UrlTemplate, m.BaseRequestBuilder.PathParameters)
    if requestConfiguration != nil {
        requestInfo.Headers.AddAll(requestConfiguration.Headers)
        requestInfo.AddRequestOptions(requestConfiguration.Options)
    }
    requestInfo.Headers.TryAdd("Accept", "application/json")
    return requestInfo, nil
}
// ToGetRequestInformation container for actions related to computing tenant-wide data protection scopes.
// returns a *RequestInformation when successful
func (m *DataSecurityAndGovernanceProtectionScopesRequestBuilder) ToGetRequestInformation(ctx context.Context, requestConfiguration *DataSecurityAndGovernanceProtectionScopesRequestBuilderGetRequestConfiguration)(*i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestInformation, error) {
    requestInfo := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.NewRequestInformationWithMethodAndUrlTemplateAndPathParameters(i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.GET, m.BaseRequestBuilder.UrlTemplate, m.BaseRequestBuilder.PathParameters)
    if requestConfiguration != nil {
        if requestConfiguration.QueryParameters != nil {
            requestInfo.AddQueryParameters(*(requestConfiguration.QueryParameters))
        }
        requestInfo.Headers.AddAll(requestConfiguration.Headers)
        requestInfo.AddRequestOptions(requestConfiguration.Options)
    }
    requestInfo.Headers.TryAdd("Accept", "application/json")
    return requestInfo, nil
}
// ToPatchRequestInformation update the navigation property protectionScopes in security
// returns a *RequestInformation when successful
func (m *DataSecurityAndGovernanceProtectionScopesRequestBuilder) ToPatchRequestInformation(ctx context.Context, body iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.TenantProtectionScopeContainerable, requestConfiguration *DataSecurityAndGovernanceProtectionScopesRequestBuilderPatchRequestConfiguration)(*i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestInformation, error) {
    requestInfo := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.NewRequestInformationWithMethodAndUrlTemplateAndPathParameters(i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.PATCH, m.BaseRequestBuilder.UrlTemplate, m.BaseRequestBuilder.PathParameters)
    if requestConfiguration != nil {
        requestInfo.Headers.AddAll(requestConfiguration.Headers)
        requestInfo.AddRequestOptions(requestConfiguration.Options)
    }
    requestInfo.Headers.TryAdd("Accept", "application/json")
    err := requestInfo.SetContentFromParsable(ctx, m.BaseRequestBuilder.RequestAdapter, "application/json", body)
    if err != nil {
        return nil, err
    }
    return requestInfo, nil
}
// WithUrl returns a request builder with the provided arbitrary URL. Using this method means any other path or query parameters are ignored.
// returns a *DataSecurityAndGovernanceProtectionScopesRequestBuilder when successful
func (m *DataSecurityAndGovernanceProtectionScopesRequestBuilder) WithUrl(rawUrl string)(*DataSecurityAndGovernanceProtectionScopesRequestBuilder) {
    return NewDataSecurityAndGovernanceProtectionScopesRequestBuilder(rawUrl, m.BaseRequestBuilder.RequestAdapter);
}
