/* This file is generated by vkr_device_object.py. */

#ifndef VKR_DEVICE_MEMORY_GEN_H
#define VKR_DEVICE_MEMORY_GEN_H

#include "vkr_common.h"

#include "venus-protocol/vn_protocol_renderer_device_memory.h"

#include "vkr_context.h"
#include "vkr_device.h"

/* create a driver VkDeviceMemory and update the vkr_device_memory */
static inline VkResult
vkr_device_memory_create_driver_handle(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkAllocateMemory *args,
   struct vkr_device_memory *obj)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   /* handles in args are replaced */
   vn_replace_vkAllocateMemory_args_handle(args);
   args->ret = vk->AllocateMemory(args->device, args->pAllocateInfo, NULL,
      &obj->base.handle.device_memory);
   return args->ret;
}

/* create a vkr_device_memory */
static inline struct vkr_device_memory *
vkr_device_memory_create(
   struct vkr_context *ctx,
   struct vn_command_vkAllocateMemory *args)
{
   struct vkr_device_memory *obj = vkr_context_alloc_object(ctx, sizeof(*obj),
      VK_OBJECT_TYPE_DEVICE_MEMORY, args->pMemory);
   if (!obj) {
      args->ret = VK_ERROR_OUT_OF_HOST_MEMORY;
      return NULL;
   }

   /* handles in args are replaced */
   if (vkr_device_memory_create_driver_handle(ctx, args, obj) != VK_SUCCESS) {
      free(obj);
      return NULL;
   }

   return obj;
}

/* create a vkr_device_memory and add it to the vkr_device */
static inline struct vkr_device_memory *
vkr_device_memory_create_and_add(
   struct vkr_context *ctx,
   struct vn_command_vkAllocateMemory *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);

   struct vkr_device_memory *obj = vkr_device_memory_create(ctx, args);
   if (!obj)
      return NULL;

   vkr_device_add_object(ctx, dev, &obj->base);
   return obj;
}

/* destroy a driver VkDeviceMemory */
static inline void
vkr_device_memory_destroy_driver_handle(
   UNUSED struct vkr_context *ctx,
   struct vn_command_vkFreeMemory *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vn_device_proc_table *vk = &dev->proc_table;

   /* handles in args are replaced */
   vn_replace_vkFreeMemory_args_handle(args);
   vk->FreeMemory(args->device, args->memory, NULL);
}

/* remove a vkr_device_memory from the device and destroy it */
static inline void
vkr_device_memory_destroy_and_remove(
   struct vkr_context *ctx,
   struct vn_command_vkFreeMemory *args)
{
   struct vkr_device *dev = vkr_device_from_handle(args->device);
   struct vkr_device_memory *obj = vkr_device_memory_from_handle(args->memory);
   if (!obj)
      return;

   vkr_device_memory_destroy_driver_handle(ctx, args);

   vkr_device_remove_object(ctx, dev, &obj->base);
}

#endif /* VKR_DEVICE_MEMORY_GEN_H */
