// python wrapper for vtkAdaptiveResampleToImage
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkAdaptiveResampleToImage.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkAdaptiveResampleToImage(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkAdaptiveResampleToImage_ClassNew(); }


static PyObject *
PyvtkAdaptiveResampleToImage_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkAdaptiveResampleToImage::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAdaptiveResampleToImage_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAdaptiveResampleToImage *op = static_cast<vtkAdaptiveResampleToImage *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkAdaptiveResampleToImage::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAdaptiveResampleToImage_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkAdaptiveResampleToImage *tempr = vtkAdaptiveResampleToImage::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAdaptiveResampleToImage_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAdaptiveResampleToImage *op = static_cast<vtkAdaptiveResampleToImage *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAdaptiveResampleToImage *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkAdaptiveResampleToImage::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAdaptiveResampleToImage_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkAdaptiveResampleToImage::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAdaptiveResampleToImage_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAdaptiveResampleToImage *op = static_cast<vtkAdaptiveResampleToImage *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkAdaptiveResampleToImage::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAdaptiveResampleToImage_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAdaptiveResampleToImage *op = static_cast<vtkAdaptiveResampleToImage *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkAdaptiveResampleToImage::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAdaptiveResampleToImage_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAdaptiveResampleToImage *op = static_cast<vtkAdaptiveResampleToImage *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkAdaptiveResampleToImage::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAdaptiveResampleToImage_SetNumberOfImages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfImages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAdaptiveResampleToImage *op = static_cast<vtkAdaptiveResampleToImage *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfImages(temp0);
    }
    else
    {
      op->vtkAdaptiveResampleToImage::SetNumberOfImages(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAdaptiveResampleToImage_GetNumberOfImagesMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfImagesMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAdaptiveResampleToImage *op = static_cast<vtkAdaptiveResampleToImage *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfImagesMinValue() :
      op->vtkAdaptiveResampleToImage::GetNumberOfImagesMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAdaptiveResampleToImage_GetNumberOfImagesMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfImagesMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAdaptiveResampleToImage *op = static_cast<vtkAdaptiveResampleToImage *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfImagesMaxValue() :
      op->vtkAdaptiveResampleToImage::GetNumberOfImagesMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAdaptiveResampleToImage_GetNumberOfImages(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfImages");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAdaptiveResampleToImage *op = static_cast<vtkAdaptiveResampleToImage *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfImages() :
      op->vtkAdaptiveResampleToImage::GetNumberOfImages());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAdaptiveResampleToImage_SetSamplingDimensions_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSamplingDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAdaptiveResampleToImage *op = static_cast<vtkAdaptiveResampleToImage *>(vp);

  int temp0;
  int temp1;
  int temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSamplingDimensions(temp0, temp1, temp2);
    }
    else
    {
      op->vtkAdaptiveResampleToImage::SetSamplingDimensions(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAdaptiveResampleToImage_SetSamplingDimensions_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSamplingDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAdaptiveResampleToImage *op = static_cast<vtkAdaptiveResampleToImage *>(vp);

  const size_t size0 = 3;
  int temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetSamplingDimensions(temp0);
    }
    else
    {
      op->vtkAdaptiveResampleToImage::SetSamplingDimensions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkAdaptiveResampleToImage_SetSamplingDimensions(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkAdaptiveResampleToImage_SetSamplingDimensions_s1(self, args);
    case 1:
      return PyvtkAdaptiveResampleToImage_SetSamplingDimensions_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSamplingDimensions");
  return nullptr;
}


static PyObject *
PyvtkAdaptiveResampleToImage_GetSamplingDimensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSamplingDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAdaptiveResampleToImage *op = static_cast<vtkAdaptiveResampleToImage *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetSamplingDimensions() :
      op->vtkAdaptiveResampleToImage::GetSamplingDimensions());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}

static PyMethodDef PyvtkAdaptiveResampleToImage_Methods[] = {
  {"IsTypeOf", PyvtkAdaptiveResampleToImage_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkAdaptiveResampleToImage_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkAdaptiveResampleToImage_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkAdaptiveResampleToImage\nC++: static vtkAdaptiveResampleToImage *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkAdaptiveResampleToImage_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkAdaptiveResampleToImage\nC++: vtkAdaptiveResampleToImage *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkAdaptiveResampleToImage_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkAdaptiveResampleToImage_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetController", PyvtkAdaptiveResampleToImage_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: virtual void SetController(vtkMultiProcessController *)\n\nBy default this filter uses the global controller, but this\nmethod can be used to set another instead.\n"},
  {"GetController", PyvtkAdaptiveResampleToImage_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\n"},
  {"SetNumberOfImages", PyvtkAdaptiveResampleToImage_SetNumberOfImages, METH_VARARGS,
   "SetNumberOfImages(self, _arg:int) -> None\nC++: virtual void SetNumberOfImages(int _arg)\n\nGet/Set a hint to use to indicate how many different refinements\nto split the dataset into. This is just a hint. The actual number\nof images used to resample the input dataset is the nearest\npower-of-two not less than the requested value (@sa\nvtkMath::NearestPowerOfTwo).\n"},
  {"GetNumberOfImagesMinValue", PyvtkAdaptiveResampleToImage_GetNumberOfImagesMinValue, METH_VARARGS,
   "GetNumberOfImagesMinValue(self) -> int\nC++: virtual int GetNumberOfImagesMinValue()\n\n"},
  {"GetNumberOfImagesMaxValue", PyvtkAdaptiveResampleToImage_GetNumberOfImagesMaxValue, METH_VARARGS,
   "GetNumberOfImagesMaxValue(self) -> int\nC++: virtual int GetNumberOfImagesMaxValue()\n\n"},
  {"GetNumberOfImages", PyvtkAdaptiveResampleToImage_GetNumberOfImages, METH_VARARGS,
   "GetNumberOfImages(self) -> int\nC++: virtual int GetNumberOfImages()\n\n"},
  {"SetSamplingDimensions", PyvtkAdaptiveResampleToImage_SetSamplingDimensions, METH_VARARGS,
   "SetSamplingDimensions(self, _arg1:int, _arg2:int, _arg3:int)\n    -> None\nC++: virtual void SetSamplingDimensions(int _arg1, int _arg2,\n    int _arg3)\nSetSamplingDimensions(self, _arg:(int, int, int)) -> None\nC++: virtual void SetSamplingDimensions(const int _arg[3])\n\nSet/Get sampling dimensions along each axis. Each partition will\nbe resampled using these dimensions.\n"},
  {"GetSamplingDimensions", PyvtkAdaptiveResampleToImage_GetSamplingDimensions, METH_VARARGS,
   "GetSamplingDimensions(self) -> (int, int, int)\nC++: virtual int *GetSamplingDimensions()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkAdaptiveResampleToImage_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAdaptiveResampleToImage_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAdaptiveResampleToImage_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAdaptiveResampleToImage_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sampling_dimensions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAdaptiveResampleToImage_GetSamplingDimensions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAdaptiveResampleToImage_SetSamplingDimensions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAdaptiveResampleToImage_SetSamplingDimensions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSamplingDimensions/SetSamplingDimensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_images_min_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAdaptiveResampleToImage_GetNumberOfImagesMinValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfImagesMinValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_images_max_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAdaptiveResampleToImage_GetNumberOfImagesMaxValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfImagesMaxValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_images"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAdaptiveResampleToImage_GetNumberOfImages(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAdaptiveResampleToImage_SetNumberOfImages(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAdaptiveResampleToImage_SetNumberOfImages(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetNumberOfImages/SetNumberOfImages\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkAdaptiveResampleToImage_Doc =
  "vtkAdaptiveResampleToImage - samples a dataset with adaptive\nrefinements.\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "vtkAdaptiveResampleToImage resamples any dataset to a\n"
  "`vtkPartitionedDataSet` comprising of `vtkImageData`. Each partition\n"
  "may have different spacing thus spanning different spatial regions\n"
  "from the input dataset.\n\n"
  "vtkAdaptiveResampleToImage builds a kd-tree with at least as many\n"
  "leaf nodes as requested using `SetNumberOfImages`. The kd tree is\n"
  "built by splitting the points in the input dataset. The bounds of\n"
  "each leaf are then used to determine the bounds (i.e. spacing and\n"
  "origin) for the image dataset for that leaf which will have the\n"
  "dimensions requested (set using `SetSamplingDimensions`).\n\n"
  "`NumberOfImages` is simply a hint and the tree will have exactly as\n"
  "many leaves as the nearest power of two not less than\n"
  "`NumberOfImages` (see `vtkMath::NearestPowerOfTwo`). If set to 0, the\n"
  "number of images requested is assumed to be same as the number of\n"
  "parallel MPI ranks.\n\n"
  "When running in parallel, the leaf nodes of the kd-tree are assigned\n"
  "to individual ranks. If the leaf nodes is exactly same as the number\n"
  "of MPI ranks, then each rank gets a leaf. If the leaf nodes is less\n"
  "than the MPI ranks, the extra ranks will not be assigned any data and\n"
  "will generate an empty `vtkPartitionedDataSet` in the output. If the\n"
  "number of leaf nodes is greater than the number of ranks, then each\n"
  "rank my be assigned more than 1 block. The assignment algorithm,\n"
  "however, preserves the kd-tree across ranks i.e. a rank will always\n"
  "be assigned a complete sub-tree (which may be simply the leaf node).\n"
  "@sa `vtkDIYKdTreeUtilities::CreateAssigner`,\n"
  "`vtkDIYKdTreeUtilities::ComputeAssignments`.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkAdaptiveResampleToImage_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkFiltersParallelDIY2.vtkAdaptiveResampleToImage", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkAdaptiveResampleToImage_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkAdaptiveResampleToImage_StaticNew()
{
  return vtkAdaptiveResampleToImage::New();
}

PyObject *PyvtkAdaptiveResampleToImage_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkAdaptiveResampleToImage_Type, PyvtkAdaptiveResampleToImage_Methods,
    "vtkAdaptiveResampleToImage",
 &PyvtkAdaptiveResampleToImage_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkAdaptiveResampleToImage_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkAdaptiveResampleToImage(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkAdaptiveResampleToImage_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkAdaptiveResampleToImage", o) != 0)
  {
    Py_DECREF(o);
  }

}

