// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "Basis_HGrad_PyrC2Basis.h"

const char *Basis_HGrad_PyrC2Basis =
"const RealT ZERO = 0.;\n"
"const RealT HALF = 0.5;\n"
"const RealT FOURTH = 0.25;\n"
"const RealT NINTH = 1. / 9.;\n"
"const RealT FOURNINTHS = 4. / 9.;\n"
"const RealT ONE = 1.;\n"
"const RealT TWO = 2.;\n"
"const RealT EIGHT = 9.;\n"
"const RealT TWENTYSEVEN = 27.;\n"
"\n"
"const RealT K1 = -FOURTH;\n"
"const RealT K5 = ONE;\n"
"const RealT K6 = -HALF;\n"
"const RealT K10 = -ONE;\n"
"const RealT K14 = ONE;\n"
"const RealT K15A = TWENTYSEVEN / EIGHT;\n"
"const RealT K15B = -TWENTYSEVEN / EIGHT;\n"
"\n"
"// Evaluate common rr,ss,tt multiplication terms\n"
"RealT r2 = rr * rr;\n"
"RealT s2 = ss * ss;\n"
"RealT t2 = tt * tt;\n"
"RealT rs = rr * ss;\n"
"RealT rt = rr * tt;\n"
"RealT st = ss * tt;\n"
"RealT r2s = r2 * ss;\n"
"RealT r2t = r2 * tt;\n"
"RealT rs2 = rr * s2;\n"
"RealT s2t = s2 * tt;\n"
"RealT rt2 = rr * t2;\n"
"RealT st2 = ss * t2;\n"
"RealT r2s2 = r2 * s2;\n"
"\n"
"// Evaluate numerical values of (tt-1), (tt-1)^2, (tt-1)^3, and (tt-1)^4\n"
"RealT tm = tt - ONE;\n"
"RealT tm2 = tm * tm;\n"
"\n"
"// Evaluate numerical value of 1/(tt-1)\n"
"RealT mt = abs(tm) > eps ? ONE / tm : ZERO;\n"
"RealT m2t = abs(tm2) > eps ? ONE / tm2 : ZERO;\n"
"\n"
"// Baseline shape functions:\n"
"basis[0] = K1 * (rr + ss - ONE) * (rs * mt - rr - ss + tt - ONE);\n"
"basis[1] = K1 * (-rr + ss - ONE) * (-rs * mt + rr - ss + tt - ONE);\n"
"basis[2] = K1 * (-rr - ss - ONE) * (rs * mt + rr + ss + tt - ONE);\n"
"basis[3] = K1 * (rr - ss - ONE) * (-rs * mt - rr + ss + tt - ONE);\n"
"basis[4] = K5 * (-tt + TWO * t2);\n"
"basis[5] = K6 * (-r2s * mt + r2 + st - ss - tm2);\n"
"basis[6] = K6 * (rs2 * mt - rt + rr + s2 - tm2);\n"
"basis[7] = K6 * (r2s * mt + r2 - st + ss - tm2);\n"
"basis[8] = K6 * (-rs2 * mt + rt - rr + s2 - tm2);\n"
"basis[9] = K10 * (rs + rs * mt - rt - st - tt + t2);\n"
"basis[10] = K10 * (-rs - rs * mt + rt - st - tt + t2);\n"
"basis[11] = K10 * (rs + rs * mt + rt + st - tt + t2);\n"
"basis[12] = K10 * (-rs - rs * mt - rt + st - tt + t2);\n"
"basis[13] = K14 * (r2s2 * m2t - r2 - s2 + tm2);\n"
"basis[14] = K15A * (r2s + r2s * mt - r2s2 * mt - r2s2 * m2t + st - st2 + s2t);\n"
"basis[15] = K15B * (rs2 + rs2 * mt + rt - rt2 + r2s2 * mt + r2s2 * m2t - r2t);\n"
"basis[16] = K15B * (r2s + r2s * mt + r2s2 * mt + r2s2 * m2t + st - st2 - s2t);\n"
"basis[17] = K15A * (rs2 + rs2 * mt + rt - rt2 - r2s2 * mt - r2s2 * m2t + r2t);\n"
"\n"
"// MODIFICATIONS TO H\n"
"\n"
"basis[0] = basis[0] + FOURTH * basis[13] + NINTH * (basis[14] + basis[17]);\n"
"basis[1] = basis[1] + FOURTH * basis[13] + NINTH * (basis[14] + basis[15]);\n"
"basis[2] = basis[2] + FOURTH * basis[13] + NINTH * (basis[15] + basis[16]);\n"
"basis[3] = basis[3] + FOURTH * basis[13] + NINTH * (basis[16] + basis[17]);\n"
"basis[4] = basis[4] + NINTH * (basis[14] + basis[15] + basis[16] + basis[17]);\n"
"basis[5] = basis[5] - FOURNINTHS * basis[14] - basis[13] * HALF;\n"
"basis[6] = basis[6] - FOURNINTHS * basis[15] - basis[13] * HALF;\n"
"basis[7] = basis[7] - FOURNINTHS * basis[16] - basis[13] * HALF;\n"
"basis[8] = basis[8] - FOURNINTHS * basis[17] - basis[13] * HALF;\n"
"basis[9] = basis[9] - FOURNINTHS * (basis[14] + basis[17]);\n"
"basis[10] = basis[10] - FOURNINTHS * (basis[14] + basis[15]);\n"
"basis[11] = basis[11] - FOURNINTHS * (basis[15] + basis[16]);\n"
"basis[12] = basis[12] - FOURNINTHS * (basis[16] + basis[17]);\n"
"";
