// java wrapper for vtkWindow object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkWindow.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkWindow_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkWindow",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindow_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindow_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWindow_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkWindow_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetWindowInfo_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWindowInfo(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetParentInfo_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParentInfo(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWindow_EnsureDisplay_16(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EnsureDisplay();
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkWindow_GetPosition_17(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetPosition_18(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetPosition_19(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkWindow_GetSize_110(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetSize_111(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetSize_112(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkWindow_GetActualSize_113(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkWindow_GetScreenSize_114(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScreenSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindow_GetMapped_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMapped();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWindow_GetShowWindow_116(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetShowWindow();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetShowWindow_117(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowWindow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_ShowWindowOn_118(JNIEnv* env, jobject obj)
{

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowWindowOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_ShowWindowOff_119(JNIEnv* env, jobject obj)
{

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowWindowOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetUseOffScreenBuffers_120(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseOffScreenBuffers(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWindow_GetUseOffScreenBuffers_121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseOffScreenBuffers();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_UseOffScreenBuffersOn_122(JNIEnv* env, jobject obj)
{

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseOffScreenBuffersOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_UseOffScreenBuffersOff_123(JNIEnv* env, jobject obj)
{

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseOffScreenBuffersOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetErase_124(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetErase(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindow_GetErase_125(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetErase();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_EraseOn_126(JNIEnv* env, jobject obj)
{

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->EraseOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_EraseOff_127(JNIEnv* env, jobject obj)
{

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->EraseOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetDoubleBuffer_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDoubleBuffer(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindow_GetDoubleBuffer_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDoubleBuffer();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_DoubleBufferOn_130(JNIEnv* env, jobject obj)
{

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->DoubleBufferOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_DoubleBufferOff_131(JNIEnv* env, jobject obj)
{

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->DoubleBufferOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkWindow_GetWindowName_132(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWindowName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetWindowName_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWindowName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_Render_134(JNIEnv* env, jobject obj)
{

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_ReleaseGraphicsResources_135(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindow_GetPixelData_136(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jobject id5,jint id6)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  vtkUnsignedCharArray * temp5;
  int   temp6;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = id6;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPixelData(temp0,temp1,temp2,temp3,temp4,temp5,temp6);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindow_GetDPI_137(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDPI();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetDPI_138(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDPI(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindow_GetDPIMinValue_139(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDPIMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindow_GetDPIMaxValue_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDPIMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkWindow_DetectDPI_141(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->DetectDPI();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetOffScreenRendering_142(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOffScreenRendering(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_OffScreenRenderingOn_143(JNIEnv* env, jobject obj)
{

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->OffScreenRenderingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_OffScreenRenderingOff_144(JNIEnv* env, jobject obj)
{

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->OffScreenRenderingOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkWindow_GetOffScreenRendering_145(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOffScreenRendering();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_MakeCurrent_146(JNIEnv* env, jobject obj)
{

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->MakeCurrent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_ReleaseCurrent_147(JNIEnv* env, jobject obj)
{

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseCurrent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetTileScale_148(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTileScale(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetTileScale_149(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTileScale(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkWindow_GetTileScale_150(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTileScale();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetTileScale_151(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTileScale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetTileViewport_152(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTileViewport(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkWindow_SetTileViewport_153(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTileViewport(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkWindow_GetTileViewport_154(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkWindow* op = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTileViewport();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}
