// java wrapper for vtkExplicitStructuredGrid object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkExplicitStructuredGrid.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPointSet_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkExplicitStructuredGrid_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkExplicitStructuredGrid",dType)) { return me; }
  if ((res= vtkPointSet_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExplicitStructuredGrid_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExplicitStructuredGrid_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetDataObjectType_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_Initialize_15(JNIEnv* env, jobject obj)
{

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetCell_16(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetCell_17(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkGenericCell * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id1));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCell(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetCellBounds_18(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[6];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetCellType_19(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetCellSize_110(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetNumberOfCells_111(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetCellPoints_112(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetPointCells_113(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointCells(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetMaxCellSize_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxCellSize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetMaxSpatialDimension_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetMinSpatialDimension_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetCellNeighbors_117(JNIEnv* env, jobject obj,jlong id0,jobject id1,jobject id2)
{
  long long   temp0;
  vtkIdList * temp1;
  vtkIdList * temp2;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellNeighbors(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_CopyStructure_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_ShallowCopy_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_DeepCopy_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetDataDimension_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDimension();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_SetDimensions_122(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_SetDimensions_123(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimensions(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetDimensions_124(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDimensions(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetCellDims_125(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[3];
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellDims(temp0);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetExtentType_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtentType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_SetExtent_127(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jint id3,jint id4,jint id5)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp3;
  int   temp4;
  int   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtent(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_SetExtent_128(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtent(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetExtent_129(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_SetCells_130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellArray * temp0;
  temp0 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCells(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetCells_131(JNIEnv* env, jobject obj)
{
  vtkCellArray * temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCells();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_BuildLinks_132(JNIEnv* env, jobject obj)
{

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLinks();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_SetLinks_133(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractCellLinks * temp0;
  temp0 = static_cast<vtkAbstractCellLinks*>(vtkJavaGetPointerFromObject(env, id0));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLinks(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetLinks_134(JNIEnv* env, jobject obj)
{
  vtkAbstractCellLinks * temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLinks();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExplicitStructuredGrid_ComputeCellId_135(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2,jboolean id3)
{
  int   temp0;
  int   temp1;
  int   temp2;
  bool   temp3;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = (id3 != 0) ? true : false;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeCellId(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_ComputeFacesConnectivityFlagsArray_136(JNIEnv* env, jobject obj)
{

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeFacesConnectivityFlagsArray();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_SetFacesConnectivityFlagsArrayName_137(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFacesConnectivityFlagsArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetFacesConnectivityFlagsArrayName_138(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFacesConnectivityFlagsArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_BlankCell_139(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlankCell(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_UnBlankCell_140(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->UnBlankCell(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkExplicitStructuredGrid_HasAnyBlankCells_141(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyBlankCells();
  return temp20;

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkExplicitStructuredGrid_IsCellVisible_142(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned char   temp20;
  temp0 = id0;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsCellVisible(temp0);
  return temp20;

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkExplicitStructuredGrid_IsCellGhost_143(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
   unsigned char   temp20;
  temp0 = id0;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsCellGhost(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkExplicitStructuredGrid_HasAnyGhostCells_144(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasAnyGhostCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetData_145(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkExplicitStructuredGrid * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetData_146(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkExplicitStructuredGrid * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetActualMemorySize_147(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_CheckAndReorderFaces_148(JNIEnv* env, jobject obj)
{

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->CheckAndReorderFaces();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_GenerateGhostArray_149(JNIEnv* env, jobject obj,jintArray id0,jboolean id1)
{
  int temp0[6];
  bool   temp1;
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));
  temp1 = (id1 != 0) ? true : false;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateGhostArray(temp0,temp1);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkExplicitStructuredGrid_GetCell_150(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  vtkCell * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkExplicitStructuredGrid_GenerateGhostArray_151(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[6];
  env->GetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

  vtkExplicitStructuredGrid* op = static_cast<vtkExplicitStructuredGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateGhostArray(temp0);
  env->SetIntArrayRegion(id0, 0, 6, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkExplicitStructuredGrid_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkExplicitStructuredGrid::New());
}
