// java wrapper for vtkPartitionedDataSet object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPartitionedDataSet.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataObjectTree_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPartitionedDataSet_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPartitionedDataSet",dType)) { return me; }
  if ((res= vtkDataObjectTree_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPartitionedDataSet_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPartitionedDataSet_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPartitionedDataSet_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPartitionedDataSet_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPartitionedDataSet_GetDataObjectType_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPartitionedDataSet_SetNumberOfPartitions_15(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfPartitions(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPartitionedDataSet_GetNumberOfPartitions_16(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPartitions();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPartitionedDataSet_GetPartition_17(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  vtkDataSet * temp20;
  temp0 = id0;

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPartition(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPartitionedDataSet_GetPartitionAsDataObject_18(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  vtkDataObject * temp20;
  temp0 = id0;

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPartitionAsDataObject(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPartitionedDataSet_SetPartition_19(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
   unsigned int   temp0;
  vtkDataObject * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPartition(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPartitionedDataSet_HasMetaData_110(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasMetaData(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPartitionedDataSet_GetMetaData_111(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  vtkInformation * temp20;
  temp0 = id0;

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMetaData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPartitionedDataSet_GetData_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkPartitionedDataSet * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPartitionedDataSet_GetData_113(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkPartitionedDataSet * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPartitionedDataSet_GetMetaData_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCompositeDataIterator * temp0;
  vtkInformation * temp20;
  temp0 = static_cast<vtkCompositeDataIterator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMetaData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPartitionedDataSet_HasMetaData_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCompositeDataIterator * temp0;
  int   temp20;
  temp0 = static_cast<vtkCompositeDataIterator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasMetaData(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPartitionedDataSet_RemoveNullPartitions_116(JNIEnv* env, jobject obj)
{

  vtkPartitionedDataSet* op = static_cast<vtkPartitionedDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveNullPartitions();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPartitionedDataSet_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPartitionedDataSet::New());
}
