// java wrapper for vtkHull object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkHull.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPointSetAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkHull_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkHull",dType)) { return me; }
  if ((res= vtkPointSetAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHull_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHull_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHull_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkHull_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHull_RemoveAllPlanes_14(JNIEnv* env, jobject obj)
{

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllPlanes();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHull_AddPlane_15(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddPlane(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHull_AddPlane_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddPlane(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHull_SetPlane_17(JNIEnv* env, jobject obj,jint id0,jdouble id1,jdouble id2,jdouble id3)
{
  int   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlane(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHull_SetPlane_18(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlane(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHull_AddPlane_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddPlane(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHull_AddPlane_110(JNIEnv* env, jobject obj,jdoubleArray id0,jdouble id1)
{
  double temp0[3];
  double   temp1;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = id1;

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddPlane(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHull_SetPlane_111(JNIEnv* env, jobject obj,jint id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4)
{
  int   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlane(temp0,temp1,temp2,temp3,temp4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHull_SetPlane_112(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jdouble id2)
{
  int   temp0;
  double temp1[3];
  double   temp2;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = id2;

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlane(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHull_SetPlanes_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPlanes * temp0;
  temp0 = static_cast<vtkPlanes*>(vtkJavaGetPointerFromObject(env, id0));

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPlanes(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkHull_GetNumberOfPlanes_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPlanes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHull_AddCubeVertexPlanes_115(JNIEnv* env, jobject obj)
{

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddCubeVertexPlanes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHull_AddCubeEdgePlanes_116(JNIEnv* env, jobject obj)
{

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddCubeEdgePlanes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHull_AddCubeFacePlanes_117(JNIEnv* env, jobject obj)
{

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddCubeFacePlanes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHull_AddRecursiveSpherePlanes_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddRecursiveSpherePlanes(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkHull_GenerateHull_119(JNIEnv* env, jobject obj,jobject id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jdouble id6)
{
  vtkPolyData * temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  double   temp6;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;

  vtkHull* op = static_cast<vtkHull*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateHull(temp0,temp1,temp2,temp3,temp4,temp5,temp6);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkHull_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkHull::New());
}
