// java wrapper for vtkGridTransform object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGridTransform.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWarpTransform_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGridTransform_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGridTransform",dType)) { return me; }
  if ((res= vtkWarpTransform_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridTransform_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridTransform_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridTransform_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridTransform_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridTransform_SetDisplacementGridConnection_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplacementGridConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridTransform_SetDisplacementGridData_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplacementGridData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridTransform_GetDisplacementGrid_16(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplacementGrid();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridTransform_SetDisplacementScale_17(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplacementScale(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGridTransform_GetDisplacementScale_18(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplacementScale();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridTransform_SetDisplacementShift_19(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplacementShift(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkGridTransform_GetDisplacementShift_110(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplacementShift();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridTransform_SetInterpolationMode_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGridTransform_GetInterpolationMode_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridTransform_SetInterpolationModeToNearestNeighbor_113(JNIEnv* env, jobject obj)
{

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationModeToNearestNeighbor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridTransform_SetInterpolationModeToLinear_114(JNIEnv* env, jobject obj)
{

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationModeToLinear();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGridTransform_SetInterpolationModeToCubic_115(JNIEnv* env, jobject obj)
{

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInterpolationModeToCubic();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGridTransform_GetInterpolationModeAsString_116(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInterpolationModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridTransform_MakeTransform_117(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGridTransform_GetMTime_118(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkGridTransform* op = static_cast<vtkGridTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGridTransform_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGridTransform::New());
}
