// java wrapper for vtkSPHKernel object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSPHKernel.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkInterpolationKernel_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSPHKernel_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSPHKernel",dType)) { return me; }
  if ((res= vtkInterpolationKernel_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSPHKernel_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSPHKernel_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSPHKernel_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSPHKernel_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSPHKernel_SetSpatialStep_14(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSpatialStep(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSPHKernel_GetSpatialStepMinValue_15(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpatialStepMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSPHKernel_GetSpatialStepMaxValue_16(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpatialStepMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSPHKernel_GetSpatialStep_17(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSpatialStep();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSPHKernel_SetDimension_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDimension(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSPHKernel_GetDimensionMinValue_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSPHKernel_GetDimensionMaxValue_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimensionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSPHKernel_GetDimension_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDimension();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSPHKernel_GetCutoffFactor_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCutoffFactor();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSPHKernel_SetCutoffArray_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCutoffArray(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSPHKernel_GetCutoffArray_114(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCutoffArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSPHKernel_SetDensityArray_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDensityArray(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSPHKernel_GetDensityArray_116(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDensityArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSPHKernel_SetMassArray_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMassArray(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSPHKernel_GetMassArray_118(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMassArray();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSPHKernel_Initialize_119(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkAbstractPointLocator * temp0;
  vtkDataSet * temp1;
  vtkPointData * temp2;
  temp0 = static_cast<vtkAbstractPointLocator*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id2));

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSPHKernel_ComputeBasis_120(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1,jlong id2)
{
  double temp0[3];
  vtkIdList * temp1;
  long long   temp2;
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeBasis(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSPHKernel_ComputeWeights_121(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1,jobject id2)
{
  double temp0[3];
  vtkIdList * temp1;
  vtkDoubleArray * temp2;
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id2));

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeWeights(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSPHKernel_ComputeDerivWeights_122(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1,jobject id2,jobject id3)
{
  double temp0[3];
  vtkIdList * temp1;
  vtkDoubleArray * temp2;
  vtkDoubleArray * temp3;
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id3));

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeDerivWeights(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSPHKernel_ComputeFunctionWeight_123(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  double   temp20;
  temp0 = id0;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeFunctionWeight(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSPHKernel_ComputeDerivWeight_124(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  double   temp20;
  temp0 = id0;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeDerivWeight(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkSPHKernel_GetNormFactor_125(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkSPHKernel* op = static_cast<vtkSPHKernel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNormFactor();
  return temp20;

}
