// java wrapper for vtkGeoTransform object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGeoTransform.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractTransform_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGeoTransform_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGeoTransform",dType)) { return me; }
  if ((res= vtkAbstractTransform_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeoTransform_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeoTransform_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeoTransform_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeoTransform_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeoTransform_SetSourceProjection_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGeoProjection * temp0;
  temp0 = static_cast<vtkGeoProjection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceProjection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeoTransform_SetSourceProjection_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSourceProjection(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeoTransform_GetSourceProjection_16(JNIEnv* env, jobject obj)
{
  vtkGeoProjection * temp20;

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSourceProjection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeoTransform_SetTransformZCoordinate_17(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTransformZCoordinate(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGeoTransform_GetTransformZCoordinate_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTransformZCoordinate();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeoTransform_SetDestinationProjection_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGeoProjection * temp0;
  temp0 = static_cast<vtkGeoProjection*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDestinationProjection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeoTransform_SetDestinationProjection_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDestinationProjection(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeoTransform_GetDestinationProjection_111(JNIEnv* env, jobject obj)
{
  vtkGeoProjection * temp20;

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDestinationProjection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeoTransform_TransformPoints_112(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkPoints * temp0;
  vtkPoints * temp1;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->TransformPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeoTransform_Inverse_113(JNIEnv* env, jobject obj)
{

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->Inverse();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeoTransform_InternalTransformPoint_114(JNIEnv* env, jobject obj,jfloatArray id0,jfloatArray id1)
{
  float temp0[3];
  float temp1[3];
  env->GetFloatArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformPoint(temp0,temp1);
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGeoTransform_InternalTransformPoint_115(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  op->InternalTransformPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGeoTransform_ComputeUTMZone_116(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeUTMZone(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGeoTransform_MakeTransform_117(JNIEnv* env, jobject obj)
{
  vtkAbstractTransform * temp20;

  vtkGeoTransform* op = static_cast<vtkGeoTransform*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeTransform();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGeoTransform_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGeoTransform::New());
}
