// java wrapper for vtkGraphMapper object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkGraphMapper.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMapper_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkGraphMapper_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkGraphMapper",dType)) { return me; }
  if ((res= vtkMapper_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGraphMapper_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGraphMapper_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraphMapper_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraphMapper_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_Render_14(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkRenderer * temp0;
  vtkActor * temp1;
  temp0 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkActor*>(vtkJavaGetPointerFromObject(env, id1));

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetVertexColorArrayName_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexColorArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGraphMapper_GetVertexColorArrayName_16(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexColorArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetColorVertices_17(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorVertices(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGraphMapper_GetColorVertices_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorVertices();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_ColorVerticesOn_19(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorVerticesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_ColorVerticesOff_110(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorVerticesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetScaledGlyphs_111(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScaledGlyphs(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGraphMapper_GetScaledGlyphs_112(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScaledGlyphs();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_ScaledGlyphsOn_113(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScaledGlyphsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_ScaledGlyphsOff_114(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ScaledGlyphsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetScalingArrayName_115(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScalingArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGraphMapper_GetScalingArrayName_116(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalingArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetEdgeVisibility_117(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGraphMapper_GetEdgeVisibility_118(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_EdgeVisibilityOn_119(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_EdgeVisibilityOff_120(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->EdgeVisibilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetEdgeColorArrayName_121(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeColorArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGraphMapper_GetEdgeColorArrayName_122(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeColorArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetColorEdges_123(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorEdges(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGraphMapper_GetColorEdges_124(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorEdges();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_ColorEdgesOn_125(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorEdgesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_ColorEdgesOff_126(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ColorEdgesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetEnabledEdgesArrayName_127(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnabledEdgesArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGraphMapper_GetEnabledEdgesArrayName_128(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnabledEdgesArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetEnableEdgesByArray_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableEdgesByArray(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGraphMapper_GetEnableEdgesByArray_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableEdgesByArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_EnableEdgesByArrayOn_131(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableEdgesByArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_EnableEdgesByArrayOff_132(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableEdgesByArrayOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetEnabledVerticesArrayName_133(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnabledVerticesArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGraphMapper_GetEnabledVerticesArrayName_134(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnabledVerticesArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetEnableVerticesByArray_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableVerticesByArray(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkGraphMapper_GetEnableVerticesByArray_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableVerticesByArray();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_EnableVerticesByArrayOn_137(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableVerticesByArrayOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_EnableVerticesByArrayOff_138(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableVerticesByArrayOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetIconArrayName_139(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIconArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkGraphMapper_GetIconArrayName_140(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIconArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_AddIconType_141(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddIconType(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_ClearIconTypes_142(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ClearIconTypes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetIconAlignment_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIconAlignment(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraphMapper_GetIconTexture_144(JNIEnv* env, jobject obj)
{
  vtkTexture * temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIconTexture();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetIconTexture_145(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTexture * temp0;
  temp0 = static_cast<vtkTexture*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIconTexture(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetIconVisibility_146(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIconVisibility(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkGraphMapper_GetIconVisibility_147(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIconVisibility();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_IconVisibilityOn_148(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->IconVisibilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_IconVisibilityOff_149(JNIEnv* env, jobject obj)
{

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->IconVisibilityOff();

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkGraphMapper_GetVertexPointSize_150(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexPointSize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetVertexPointSize_151(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexPointSize(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkGraphMapper_GetEdgeLineWidth_152(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeLineWidth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetEdgeLineWidth_153(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeLineWidth(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_ReleaseGraphicsResources_154(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraphMapper_GetMTime_155(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkGraphMapper_SetInputData_156(JNIEnv* env, jobject obj,jobject id0)
{
  vtkGraph * temp0;
  temp0 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id0));

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraphMapper_GetInput_157(JNIEnv* env, jobject obj)
{
  vtkGraph * temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkGraphMapper_GetBounds_158(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraphMapper_GetEdgeLookupTable_159(JNIEnv* env, jobject obj)
{
  vtkLookupTable * temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkGraphMapper_GetVertexLookupTable_160(JNIEnv* env, jobject obj)
{
  vtkLookupTable * temp20;

  vtkGraphMapper* op = static_cast<vtkGraphMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkGraphMapper_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkGraphMapper::New());
}
