// java wrapper for vtkInteractorStyle object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkInteractorStyle.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkInteractorObserver_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkInteractorStyle_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkInteractorStyle",dType)) { return me; }
  if ((res= vtkInteractorObserver_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInteractorStyle_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInteractorStyle_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInteractorStyle_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInteractorStyle_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_SetInteractor_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkRenderWindowInteractor * temp0;
  temp0 = static_cast<vtkRenderWindowInteractor*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractor(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_SetEnabled_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnabled(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_SetAutoAdjustCameraClippingRange_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAutoAdjustCameraClippingRange(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInteractorStyle_GetAutoAdjustCameraClippingRangeMinValue_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutoAdjustCameraClippingRangeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInteractorStyle_GetAutoAdjustCameraClippingRangeMaxValue_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutoAdjustCameraClippingRangeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInteractorStyle_GetAutoAdjustCameraClippingRange_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAutoAdjustCameraClippingRange();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_AutoAdjustCameraClippingRangeOn_110(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoAdjustCameraClippingRangeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_AutoAdjustCameraClippingRangeOff_111(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->AutoAdjustCameraClippingRangeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_FindPokedRenderer_112(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindPokedRenderer(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInteractorStyle_GetState_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetState();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInteractorStyle_GetUseTimers_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseTimers();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_SetUseTimers_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseTimers(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_UseTimersOn_116(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseTimersOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_UseTimersOff_117(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseTimersOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_SetTimerDuration_118(JNIEnv* env, jobject obj,jlong id0)
{
   unsigned long   temp0;
  temp0 = id0;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTimerDuration(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInteractorStyle_GetTimerDurationMinValue_119(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimerDurationMinValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInteractorStyle_GetTimerDurationMaxValue_120(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimerDurationMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInteractorStyle_GetTimerDuration_121(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimerDuration();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_SetHandleObservers_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHandleObservers(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkInteractorStyle_GetHandleObservers_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHandleObservers();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_HandleObserversOn_124(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->HandleObserversOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_HandleObserversOff_125(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->HandleObserversOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnMouseMove_126(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnMouseMove();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnLeftButtonDown_127(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnLeftButtonDown();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnLeftButtonUp_128(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnLeftButtonUp();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnMiddleButtonDown_129(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnMiddleButtonDown();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnMiddleButtonUp_130(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnMiddleButtonUp();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnRightButtonDown_131(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnRightButtonDown();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnRightButtonUp_132(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnRightButtonUp();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnLeftButtonDoubleClick_133(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnLeftButtonDoubleClick();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnMiddleButtonDoubleClick_134(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnMiddleButtonDoubleClick();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnRightButtonDoubleClick_135(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnRightButtonDoubleClick();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnMouseWheelForward_136(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnMouseWheelForward();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnMouseWheelBackward_137(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnMouseWheelBackward();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnMouseWheelLeft_138(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnMouseWheelLeft();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnMouseWheelRight_139(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnMouseWheelRight();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnFourthButtonDown_140(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnFourthButtonDown();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnFourthButtonUp_141(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnFourthButtonUp();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnFifthButtonDown_142(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnFifthButtonDown();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnFifthButtonUp_143(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnFifthButtonUp();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnMove3D_144(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEventData * temp0;
  temp0 = static_cast<vtkEventData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnMove3D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnButton3D_145(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEventData * temp0;
  temp0 = static_cast<vtkEventData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnButton3D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnPick3D_146(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEventData * temp0;
  temp0 = static_cast<vtkEventData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnPick3D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnClip3D_147(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEventData * temp0;
  temp0 = static_cast<vtkEventData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnClip3D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnSelect3D_148(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEventData * temp0;
  temp0 = static_cast<vtkEventData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnSelect3D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnMenu3D_149(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEventData * temp0;
  temp0 = static_cast<vtkEventData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnMenu3D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnNextPose3D_150(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEventData * temp0;
  temp0 = static_cast<vtkEventData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnNextPose3D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnPositionProp3D_151(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEventData * temp0;
  temp0 = static_cast<vtkEventData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnPositionProp3D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnViewerMovement3D_152(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEventData * temp0;
  temp0 = static_cast<vtkEventData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnViewerMovement3D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnElevation3D_153(JNIEnv* env, jobject obj,jobject id0)
{
  vtkEventData * temp0;
  temp0 = static_cast<vtkEventData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnElevation3D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnChar_154(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnChar();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnKeyDown_155(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnKeyDown();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnKeyUp_156(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnKeyUp();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnKeyPress_157(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnKeyPress();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnKeyRelease_158(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnKeyRelease();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnExpose_159(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnExpose();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnConfigure_160(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnConfigure();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnEnter_161(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnEnter();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnLeave_162(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnLeave();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnTimer_163(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnTimer();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_Rotate_164(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->Rotate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_Spin_165(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->Spin();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_Pan_166(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->Pan();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_Dolly_167(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->Dolly();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_Zoom_168(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->Zoom();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_UniformScale_169(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->UniformScale();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_EnvironmentRotate_170(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnvironmentRotate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnStartSwipe_171(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnStartSwipe();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnSwipe_172(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnSwipe();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnEndSwipe_173(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnEndSwipe();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnStartPinch_174(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnStartPinch();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnPinch_175(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnPinch();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnEndPinch_176(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnEndPinch();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnStartRotate_177(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnStartRotate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnRotate_178(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnRotate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnEndRotate_179(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnEndRotate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnStartPan_180(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnStartPan();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnPan_181(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnPan();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnEndPan_182(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnEndPan();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnTap_183(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnTap();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnLongTap_184(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnLongTap();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StartState_185(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartState(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StopState_186(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StopState();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StartAnimate_187(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartAnimate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StopAnimate_188(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StopAnimate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StartRotate_189(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartRotate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_EndRotate_190(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndRotate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StartZoom_191(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartZoom();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_EndZoom_192(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndZoom();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StartPan_193(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartPan();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_EndPan_194(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndPan();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StartSpin_195(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartSpin();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_EndSpin_196(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndSpin();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StartDolly_197(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartDolly();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_EndDolly_198(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndDolly();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StartUniformScale_199(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartUniformScale();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_EndUniformScale_1100(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndUniformScale();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StartTimer_1101(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartTimer();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_EndTimer_1102(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndTimer();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StartTwoPointer_1103(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartTwoPointer();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_EndTwoPointer_1104(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndTwoPointer();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StartGesture_1105(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartGesture();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_EndGesture_1106(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndGesture();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_StartEnvRotate_1107(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartEnvRotate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_EndEnvRotate_1108(JNIEnv* env, jobject obj)
{

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->EndEnvRotate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_OnDropFiles_1109(JNIEnv* env, jobject obj,jobject id0)
{
  vtkStringArray * temp0;
  temp0 = static_cast<vtkStringArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->OnDropFiles(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_HighlightProp_1110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->HighlightProp(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_HighlightActor2D_1111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkActor2D * temp0;
  temp0 = static_cast<vtkActor2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->HighlightActor2D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_HighlightProp3D_1112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp3D * temp0;
  temp0 = static_cast<vtkProp3D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->HighlightProp3D(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_SetPickColor_1113(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPickColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_SetPickColor_1114(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPickColor(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkInteractorStyle_GetPickColor_1115(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPickColor();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_SetMouseWheelMotionFactor_1116(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMouseWheelMotionFactor(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkInteractorStyle_GetMouseWheelMotionFactor_1117(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMouseWheelMotionFactor();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkInteractorStyle_GetTDxStyle_1118(JNIEnv* env, jobject obj)
{
  vtkTDxInteractorStyle * temp20;

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTDxStyle();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkInteractorStyle_SetTDxStyle_1119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTDxInteractorStyle * temp0;
  temp0 = static_cast<vtkTDxInteractorStyle*>(vtkJavaGetPointerFromObject(env, id0));

  vtkInteractorStyle* op = static_cast<vtkInteractorStyle*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTDxStyle(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkInteractorStyle_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkInteractorStyle::New());
}
