// java wrapper for vtkTextMapper object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTextMapper.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMapper2D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTextMapper_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTextMapper",dType)) { return me; }
  if ((res= vtkMapper2D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextMapper_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextMapper_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextMapper_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextMapper_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextMapper_GetSize_14(JNIEnv* env, jobject obj,jobject id0,jintArray id1)
{
  vtkViewport * temp0;
  int temp1[2];
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetIntArrayRegion(id1, 0, 2, reinterpret_cast<jint*>(&temp1[0]));

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSize(temp0,temp1);
  env->SetIntArrayRegion(id1, 0, 2, reinterpret_cast<jint*>(&temp1[0]));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextMapper_GetWidth_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWidth(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextMapper_GetHeight_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeight(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextMapper_SetInput_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInput(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkTextMapper_GetInput_18(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextMapper_SetTextProperty_19(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextMapper_GetTextProperty_110(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextMapper_ShallowCopy_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractMapper * temp0;
  temp0 = static_cast<vtkAbstractMapper*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextMapper_SetConstrainedFontSize_112(JNIEnv* env, jobject obj,jobject id0,jint id1,jint id2)
{
  vtkViewport * temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetConstrainedFontSize(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTextMapper_SetConstrainedFontSize_113(JNIEnv* env, jobject obj,jobject id0,jobject id1,jint id2,jint id3)
{
  vtkTextMapper * temp0;
  vtkViewport * temp1;
  int   temp2;
  int   temp3;
  int   temp20;
  temp0 = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  temp3 = id3;

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetConstrainedFontSize(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextMapper_RenderOverlay_114(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkViewport * temp0;
  vtkActor2D * temp1;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkActor2D*>(vtkJavaGetPointerFromObject(env, id1));

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->RenderOverlay(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTextMapper_ReleaseGraphicsResources_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTextMapper_GetMTime_116(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkTextMapper* op = static_cast<vtkTextMapper*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTextMapper_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTextMapper::New());
}
