// java wrapper for vtkXOpenGLRenderWindow object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkXOpenGLRenderWindow.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkOpenGLRenderWindow_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkXOpenGLRenderWindow_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkXOpenGLRenderWindow",dType)) { return me; }
  if ((res= vtkOpenGLRenderWindow_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXOpenGLRenderWindow_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXOpenGLRenderWindow_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXOpenGLRenderWindow_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkXOpenGLRenderWindow_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_Start_14(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Start();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_Frame_15(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Frame();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_WindowInitialize_16(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->WindowInitialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_Initialize_17(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_Finalize_18(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Finalize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetFullScreen_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFullScreen(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_WindowRemap_110(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->WindowRemap();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetShowWindow_111(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetShowWindow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_PrefFullScreen_112(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrefFullScreen();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetSize_113(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetSize_114(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXOpenGLRenderWindow_GetDesiredDepth_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDesiredDepth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetStereoCapableWindow_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStereoCapableWindow(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetCoverable_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCoverable(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_MakeCurrent_118(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->MakeCurrent();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXOpenGLRenderWindow_IsCurrent_119(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsCurrent();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_ReleaseCurrent_120(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseCurrent();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetForceMakeCurrent_121(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetForceMakeCurrent();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkXOpenGLRenderWindow_ReportCapabilities_122(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ReportCapabilities();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXOpenGLRenderWindow_IsDirect_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsDirect();
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkXOpenGLRenderWindow_GetScreenSize_124(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScreenSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkXOpenGLRenderWindow_GetPosition_125(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXOpenGLRenderWindow_EnsureDisplay_126(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EnsureDisplay();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetWindowName_127(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWindowName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetIcon_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageData * temp0;
  temp0 = static_cast<vtkImageData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIcon(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXOpenGLRenderWindow_InitializeFromCurrentContext_129(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InitializeFromCurrentContext();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXOpenGLRenderWindow_GetPlatformSupportsRenderWindowSharing_130(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPlatformSupportsRenderWindowSharing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetPosition_131(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetPosition_132(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);
  env->SetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_HideCursor_133(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->HideCursor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_ShowCursor_134(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShowCursor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetCurrentCursor_135(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCurrentCursor(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkXOpenGLRenderWindow_GetEventPending_136(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEventPending();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetWindowInfo_137(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWindowInfo(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetNextWindowInfo_138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNextWindowInfo(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetParentInfo_139(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParentInfo(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_Render_140(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->Render();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_PushContext_141(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->PushContext();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkXOpenGLRenderWindow_PopContext_142(JNIEnv* env, jobject obj)
{

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  op->PopContext();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkXOpenGLRenderWindow_SetSwapControl_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkXOpenGLRenderWindow* op = static_cast<vtkXOpenGLRenderWindow*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetSwapControl(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkXOpenGLRenderWindow_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkXOpenGLRenderWindow::New());
}
