// java wrapper for vtkRendererNode object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkRendererNode.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkViewNode_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkRendererNode_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkRendererNode",dType)) { return me; }
  if ((res= vtkViewNode_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRendererNode_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRendererNode_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRendererNode_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRendererNode_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRendererNode_Build_14(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->Build(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkRendererNode_GetSize_15(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSize();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRendererNode_SetSize_16(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRendererNode_SetSize_17(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSize(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkRendererNode_GetViewport_18(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetViewport();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 4);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRendererNode_SetViewport_19(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewport(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRendererNode_SetViewport_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetViewport(temp0);

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkRendererNode_GetScale_111(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScale();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRendererNode_SetScale_112(JNIEnv* env, jobject obj,jint id0,jint id1)
{
  int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScale(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRendererNode_SetScale_113(JNIEnv* env, jobject obj,jintArray id0)
{
  int temp0[2];
  env->GetIntArrayRegion(id0, 0, 2, reinterpret_cast<jint*>(&temp0[0]));

  vtkRendererNode* op = static_cast<vtkRendererNode*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetScale(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkRendererNode_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkRendererNode::New());
}
