// python wrapper for vtkCellType
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkCellType.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCellType(PyObject *dict); }
void PyVTKAddFile_vtkCellType(
  PyObject *dict)
{
  PyObject *o;
  for (int c = 0; c < 65; c++)
  {
    static const struct { const char *name; int value; }
      constants[65] = {
        { "VTK_EMPTY_CELL", VTK_EMPTY_CELL },
        { "VTK_VERTEX", VTK_VERTEX },
        { "VTK_POLY_VERTEX", VTK_POLY_VERTEX },
        { "VTK_LINE", VTK_LINE },
        { "VTK_POLY_LINE", VTK_POLY_LINE },
        { "VTK_TRIANGLE", VTK_TRIANGLE },
        { "VTK_TRIANGLE_STRIP", VTK_TRIANGLE_STRIP },
        { "VTK_POLYGON", VTK_POLYGON },
        { "VTK_PIXEL", VTK_PIXEL },
        { "VTK_QUAD", VTK_QUAD },
        { "VTK_TETRA", VTK_TETRA },
        { "VTK_VOXEL", VTK_VOXEL },
        { "VTK_HEXAHEDRON", VTK_HEXAHEDRON },
        { "VTK_WEDGE", VTK_WEDGE },
        { "VTK_PYRAMID", VTK_PYRAMID },
        { "VTK_PENTAGONAL_PRISM", VTK_PENTAGONAL_PRISM },
        { "VTK_HEXAGONAL_PRISM", VTK_HEXAGONAL_PRISM },
        { "VTK_QUADRATIC_EDGE", VTK_QUADRATIC_EDGE },
        { "VTK_QUADRATIC_TRIANGLE", VTK_QUADRATIC_TRIANGLE },
        { "VTK_QUADRATIC_QUAD", VTK_QUADRATIC_QUAD },
        { "VTK_QUADRATIC_POLYGON", VTK_QUADRATIC_POLYGON },
        { "VTK_QUADRATIC_TETRA", VTK_QUADRATIC_TETRA },
        { "VTK_QUADRATIC_HEXAHEDRON", VTK_QUADRATIC_HEXAHEDRON },
        { "VTK_QUADRATIC_WEDGE", VTK_QUADRATIC_WEDGE },
        { "VTK_QUADRATIC_PYRAMID", VTK_QUADRATIC_PYRAMID },
        { "VTK_BIQUADRATIC_QUAD", VTK_BIQUADRATIC_QUAD },
        { "VTK_TRIQUADRATIC_HEXAHEDRON", VTK_TRIQUADRATIC_HEXAHEDRON },
        { "VTK_TRIQUADRATIC_PYRAMID", VTK_TRIQUADRATIC_PYRAMID },
        { "VTK_QUADRATIC_LINEAR_QUAD", VTK_QUADRATIC_LINEAR_QUAD },
        { "VTK_QUADRATIC_LINEAR_WEDGE", VTK_QUADRATIC_LINEAR_WEDGE },
        { "VTK_BIQUADRATIC_QUADRATIC_WEDGE", VTK_BIQUADRATIC_QUADRATIC_WEDGE },
        { "VTK_BIQUADRATIC_QUADRATIC_HEXAHEDRON", VTK_BIQUADRATIC_QUADRATIC_HEXAHEDRON },
        { "VTK_BIQUADRATIC_TRIANGLE", VTK_BIQUADRATIC_TRIANGLE },
        { "VTK_CUBIC_LINE", VTK_CUBIC_LINE },
        { "VTK_CONVEX_POINT_SET", VTK_CONVEX_POINT_SET },
        { "VTK_POLYHEDRON", VTK_POLYHEDRON },
        { "VTK_PARAMETRIC_CURVE", VTK_PARAMETRIC_CURVE },
        { "VTK_PARAMETRIC_SURFACE", VTK_PARAMETRIC_SURFACE },
        { "VTK_PARAMETRIC_TRI_SURFACE", VTK_PARAMETRIC_TRI_SURFACE },
        { "VTK_PARAMETRIC_QUAD_SURFACE", VTK_PARAMETRIC_QUAD_SURFACE },
        { "VTK_PARAMETRIC_TETRA_REGION", VTK_PARAMETRIC_TETRA_REGION },
        { "VTK_PARAMETRIC_HEX_REGION", VTK_PARAMETRIC_HEX_REGION },
        { "VTK_HIGHER_ORDER_EDGE", VTK_HIGHER_ORDER_EDGE },
        { "VTK_HIGHER_ORDER_TRIANGLE", VTK_HIGHER_ORDER_TRIANGLE },
        { "VTK_HIGHER_ORDER_QUAD", VTK_HIGHER_ORDER_QUAD },
        { "VTK_HIGHER_ORDER_POLYGON", VTK_HIGHER_ORDER_POLYGON },
        { "VTK_HIGHER_ORDER_TETRAHEDRON", VTK_HIGHER_ORDER_TETRAHEDRON },
        { "VTK_HIGHER_ORDER_WEDGE", VTK_HIGHER_ORDER_WEDGE },
        { "VTK_HIGHER_ORDER_PYRAMID", VTK_HIGHER_ORDER_PYRAMID },
        { "VTK_HIGHER_ORDER_HEXAHEDRON", VTK_HIGHER_ORDER_HEXAHEDRON },
        { "VTK_LAGRANGE_CURVE", VTK_LAGRANGE_CURVE },
        { "VTK_LAGRANGE_TRIANGLE", VTK_LAGRANGE_TRIANGLE },
        { "VTK_LAGRANGE_QUADRILATERAL", VTK_LAGRANGE_QUADRILATERAL },
        { "VTK_LAGRANGE_TETRAHEDRON", VTK_LAGRANGE_TETRAHEDRON },
        { "VTK_LAGRANGE_HEXAHEDRON", VTK_LAGRANGE_HEXAHEDRON },
        { "VTK_LAGRANGE_WEDGE", VTK_LAGRANGE_WEDGE },
        { "VTK_LAGRANGE_PYRAMID", VTK_LAGRANGE_PYRAMID },
        { "VTK_BEZIER_CURVE", VTK_BEZIER_CURVE },
        { "VTK_BEZIER_TRIANGLE", VTK_BEZIER_TRIANGLE },
        { "VTK_BEZIER_QUADRILATERAL", VTK_BEZIER_QUADRILATERAL },
        { "VTK_BEZIER_TETRAHEDRON", VTK_BEZIER_TETRAHEDRON },
        { "VTK_BEZIER_HEXAHEDRON", VTK_BEZIER_HEXAHEDRON },
        { "VTK_BEZIER_WEDGE", VTK_BEZIER_WEDGE },
        { "VTK_BEZIER_PYRAMID", VTK_BEZIER_PYRAMID },
        { "VTK_NUMBER_OF_CELL_TYPES", VTK_NUMBER_OF_CELL_TYPES },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(dict, constants[c].name, o);
      Py_DECREF(o);
    }
  }

}

