// python wrapper for vtkGDALRasterReader
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkGDALRasterReader.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkGDALRasterReader(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkGDALRasterReader_ClassNew(); }


static PyObject *
PyvtkGDALRasterReader_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkGDALRasterReader::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkGDALRasterReader::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkGDALRasterReader *tempr = vtkGDALRasterReader::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkGDALRasterReader *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkGDALRasterReader::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkGDALRasterReader::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkGDALRasterReader::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_CanReadFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CanReadFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->CanReadFile(temp0) :
      op->vtkGDALRasterReader::CanReadFile(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetProjectionString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProjectionString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetProjectionString() :
      op->vtkGDALRasterReader::GetProjectionString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetProjectionWKT(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetProjectionWKT");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetProjectionWKT() :
      op->vtkGDALRasterReader::GetProjectionWKT());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetGeoCornerPoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetGeoCornerPoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const double *tempr = (ap.IsBound() ?
      op->GetGeoCornerPoints() :
      op->vtkGDALRasterReader::GetGeoCornerPoints());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_SetCollateBands(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCollateBands");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCollateBands(temp0);
    }
    else
    {
      op->vtkGDALRasterReader::SetCollateBands(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetCollateBands(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCollateBands");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetCollateBands() :
      op->vtkGDALRasterReader::GetCollateBands());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_CollateBandsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CollateBandsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CollateBandsOn();
    }
    else
    {
      op->vtkGDALRasterReader::CollateBandsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_CollateBandsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CollateBandsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CollateBandsOff();
    }
    else
    {
      op->vtkGDALRasterReader::CollateBandsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_SetTargetDimensions_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTargetDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTargetDimensions(temp0, temp1);
    }
    else
    {
      op->vtkGDALRasterReader::SetTargetDimensions(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGDALRasterReader_SetTargetDimensions_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTargetDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetTargetDimensions(temp0);
    }
    else
    {
      op->vtkGDALRasterReader::SetTargetDimensions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkGDALRasterReader_SetTargetDimensions(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkGDALRasterReader_SetTargetDimensions_s1(self, args);
    case 1:
      return PyvtkGDALRasterReader_SetTargetDimensions_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetTargetDimensions");
  return nullptr;
}


static PyObject *
PyvtkGDALRasterReader_GetTargetDimensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTargetDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetTargetDimensions() :
      op->vtkGDALRasterReader::GetTargetDimensions());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetRasterDimensions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRasterDimensions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetRasterDimensions() :
      op->vtkGDALRasterReader::GetRasterDimensions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetMetaData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMetaData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::vector<std::string> *tempr = (ap.IsBound() ?
      &op->GetMetaData() :
      &op->vtkGDALRasterReader::GetMetaData());

    if (!ap.ErrorOccurred())
    {
      if (tempr->empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr->data(), tempr->size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetInvalidValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetInvalidValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  size_t temp0 = 0;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<int> store1(2*size1);
  int *temp1 = store1.Data();
  int *save1 = (size1 == 0 ? nullptr : temp1 + size1);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0, 2) &&
      (ap.NoArgsLeft() || ap.GetValue(temp0)) &&
      (ap.NoArgsLeft() || ap.GetArray(temp1, size1)))
  {
    vtkPythonArgs::Save(temp1, save1, size1);

    double tempr = (ap.IsBound() ?
      op->GetInvalidValue(temp0, temp1) :
      op->vtkGDALRasterReader::GetInvalidValue(temp0, temp1));

    if (vtkPythonArgs::HasChanged(temp1, save1, size1) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(1, temp1, size1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetDomainMetaData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDomainMetaData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    std::vector<std::string> tempr = (ap.IsBound() ?
      op->GetDomainMetaData(temp0) :
      op->vtkGDALRasterReader::GetDomainMetaData(temp0));

    if (!ap.ErrorOccurred())
    {
      if (tempr.empty())
      {
        result = PyTuple_New(0);
      }
      else
      {
        result = vtkPythonArgs::BuildTuple(tempr.data(), tempr.size());
      }
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetDriverShortName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDriverShortName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetDriverShortName() :
      &op->vtkGDALRasterReader::GetDriverShortName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetDriverLongName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDriverLongName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetDriverLongName() :
      &op->vtkGDALRasterReader::GetDriverLongName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetNumberOfCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfCells() :
      op->vtkGDALRasterReader::GetNumberOfCells());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetNumberOfCellArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfCellArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfCellArrays() :
      op->vtkGDALRasterReader::GetNumberOfCellArrays());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetCellArrayName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellArrayName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetCellArrayName(temp0) :
      op->vtkGDALRasterReader::GetCellArrayName(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_GetCellArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCellArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetCellArrayStatus(temp0) :
      op->vtkGDALRasterReader::GetCellArrayStatus(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_SetCellArrayStatus(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCellArrayStatus");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetCellArrayStatus(temp0, temp1);
    }
    else
    {
      op->vtkGDALRasterReader::SetCellArrayStatus(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_DisableAllCellArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DisableAllCellArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->DisableAllCellArrays();
    }
    else
    {
      op->vtkGDALRasterReader::DisableAllCellArrays();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkGDALRasterReader_EnableAllCellArrays(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableAllCellArrays");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkGDALRasterReader *op = static_cast<vtkGDALRasterReader *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableAllCellArrays();
    }
    else
    {
      op->vtkGDALRasterReader::EnableAllCellArrays();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkGDALRasterReader_Methods[] = {
  {"IsTypeOf", PyvtkGDALRasterReader_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkGDALRasterReader_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkGDALRasterReader_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkGDALRasterReader\nC++: static vtkGDALRasterReader *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkGDALRasterReader_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkGDALRasterReader\nC++: vtkGDALRasterReader *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkGDALRasterReader_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkGDALRasterReader_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"CanReadFile", PyvtkGDALRasterReader_CanReadFile, METH_VARARGS,
   "CanReadFile(self, fname:str) -> int\nC++: int CanReadFile(const char *fname) override;\n\nIs this file supported\n"},
  {"GetProjectionString", PyvtkGDALRasterReader_GetProjectionString, METH_VARARGS,
   "GetProjectionString(self) -> str\nC++: const char *GetProjectionString()\n\nReturn proj4 spatial reference\n"},
  {"GetProjectionWKT", PyvtkGDALRasterReader_GetProjectionWKT, METH_VARARGS,
   "GetProjectionWKT(self) -> str\nC++: const char *GetProjectionWKT()\n\nReturns WKT spatial reference.\n"},
  {"GetGeoCornerPoints", PyvtkGDALRasterReader_GetGeoCornerPoints, METH_VARARGS,
   "GetGeoCornerPoints(self) -> Pointer\nC++: const double *GetGeoCornerPoints()\n\nReturn geo-referenced corner points (Upper left, lower left,\nlower right, upper right)\n"},
  {"SetCollateBands", PyvtkGDALRasterReader_SetCollateBands, METH_VARARGS,
   "SetCollateBands(self, _arg:bool) -> None\nC++: virtual void SetCollateBands(bool _arg)\n\nGet/Set if bands are collated in one scalar array. Currently we\ncollate RGB, RGBA, gray alpha and palette. The default is true.\n"},
  {"GetCollateBands", PyvtkGDALRasterReader_GetCollateBands, METH_VARARGS,
   "GetCollateBands(self) -> bool\nC++: virtual bool GetCollateBands()\n\n"},
  {"CollateBandsOn", PyvtkGDALRasterReader_CollateBandsOn, METH_VARARGS,
   "CollateBandsOn(self) -> None\nC++: virtual void CollateBandsOn()\n\n"},
  {"CollateBandsOff", PyvtkGDALRasterReader_CollateBandsOff, METH_VARARGS,
   "CollateBandsOff(self) -> None\nC++: virtual void CollateBandsOff()\n\n"},
  {"SetTargetDimensions", PyvtkGDALRasterReader_SetTargetDimensions, METH_VARARGS,
   "SetTargetDimensions(self, _arg1:int, _arg2:int) -> None\nC++: virtual void SetTargetDimensions(int _arg1, int _arg2)\nSetTargetDimensions(self, _arg:(int, int)) -> None\nC++: void SetTargetDimensions(const int _arg[2])\n\nSet desired width and height of the image\n"},
  {"GetTargetDimensions", PyvtkGDALRasterReader_GetTargetDimensions, METH_VARARGS,
   "GetTargetDimensions(self) -> (int, int)\nC++: virtual int *GetTargetDimensions()\n\n"},
  {"GetRasterDimensions", PyvtkGDALRasterReader_GetRasterDimensions, METH_VARARGS,
   "GetRasterDimensions(self) -> Pointer\nC++: int *GetRasterDimensions()\n\nGet raster width and height in number of pixels (cells)\n"},
  {"GetMetaData", PyvtkGDALRasterReader_GetMetaData, METH_VARARGS,
   "GetMetaData(self) -> (str, ...)\nC++: const std::vector<std::string> &GetMetaData()\n\nReturn metadata as reported by GDAL\n"},
  {"GetInvalidValue", PyvtkGDALRasterReader_GetInvalidValue, METH_VARARGS,
   "GetInvalidValue(self, bandIndex:int=0, hasNoData:[int, ...]=...)\n    -> float\nC++: double GetInvalidValue(size_t bandIndex=0,\n    int *hasNoData=nullptr)\n\nReturn the invalid value for a pixel (for blanking purposes) in a\nspecified raster band. Note bandIndex is a 0 based index while\nGDAL bands are 1 based indexes. hasNoData indicates if there is a\nNoData value associated with this band.\n"},
  {"GetDomainMetaData", PyvtkGDALRasterReader_GetDomainMetaData, METH_VARARGS,
   "GetDomainMetaData(self, domain:str) -> (str, ...)\nC++: std::vector<std::string> GetDomainMetaData(\n    const std::string &domain)\n\nReturn domain metadata\n"},
  {"GetDriverShortName", PyvtkGDALRasterReader_GetDriverShortName, METH_VARARGS,
   "GetDriverShortName(self) -> str\nC++: const std::string &GetDriverShortName()\n\nReturn driver name which was used to read the current data\n"},
  {"GetDriverLongName", PyvtkGDALRasterReader_GetDriverLongName, METH_VARARGS,
   "GetDriverLongName(self) -> str\nC++: const std::string &GetDriverLongName()\n\n"},
  {"GetNumberOfCells", PyvtkGDALRasterReader_GetNumberOfCells, METH_VARARGS,
   "GetNumberOfCells(self) -> int\nC++: vtkIdType GetNumberOfCells()\n\nReturn the number of cells that are not set to GDAL NODATA\n"},
  {"GetNumberOfCellArrays", PyvtkGDALRasterReader_GetNumberOfCellArrays, METH_VARARGS,
   "GetNumberOfCellArrays(self) -> int\nC++: int GetNumberOfCellArrays()\n\nThe following methods allow selective reading of bands. By\ndefault, ALL bands are read.\n"},
  {"GetCellArrayName", PyvtkGDALRasterReader_GetCellArrayName, METH_VARARGS,
   "GetCellArrayName(self, index:int) -> str\nC++: const char *GetCellArrayName(int index)\n\n"},
  {"GetCellArrayStatus", PyvtkGDALRasterReader_GetCellArrayStatus, METH_VARARGS,
   "GetCellArrayStatus(self, name:str) -> int\nC++: int GetCellArrayStatus(const char *name)\n\n"},
  {"SetCellArrayStatus", PyvtkGDALRasterReader_SetCellArrayStatus, METH_VARARGS,
   "SetCellArrayStatus(self, name:str, status:int) -> None\nC++: void SetCellArrayStatus(const char *name, int status)\n\n"},
  {"DisableAllCellArrays", PyvtkGDALRasterReader_DisableAllCellArrays, METH_VARARGS,
   "DisableAllCellArrays(self) -> None\nC++: void DisableAllCellArrays()\n\n"},
  {"EnableAllCellArrays", PyvtkGDALRasterReader_EnableAllCellArrays, METH_VARARGS,
   "EnableAllCellArrays(self) -> None\nC++: void EnableAllCellArrays()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkGDALRasterReader_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("collate_bands"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALRasterReader_GetCollateBands(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGDALRasterReader_SetCollateBands(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGDALRasterReader_SetCollateBands(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCollateBands/SetCollateBands\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("target_dimensions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALRasterReader_GetTargetDimensions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkGDALRasterReader_SetTargetDimensions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkGDALRasterReader_SetTargetDimensions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTargetDimensions/SetTargetDimensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("projection_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALRasterReader_GetProjectionString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetProjectionString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("projection_wkt"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALRasterReader_GetProjectionWKT(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetProjectionWKT\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("geo_corner_points"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALRasterReader_GetGeoCornerPoints(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetGeoCornerPoints\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("raster_dimensions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALRasterReader_GetRasterDimensions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRasterDimensions\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("meta_data"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALRasterReader_GetMetaData(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMetaData\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("driver_short_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALRasterReader_GetDriverShortName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDriverShortName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("driver_long_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALRasterReader_GetDriverLongName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDriverLongName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_cells"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALRasterReader_GetNumberOfCells(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfCells\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_cell_arrays"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkGDALRasterReader_GetNumberOfCellArrays(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfCellArrays\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkGDALRasterReader_Doc =
  "vtkGDALRasterReader - Read raster file formats using GDAL.\n\n"
  "Superclass: vtkImageReader2\n\n"
  "vtkGDALRasterReader is a source object that reads raster files and\n"
  "uses GDAL as the underlying library for the task. GDAL library is\n"
  "required for this reader. The output of the reader is a\n"
  "vtkUniformGrid (vtkImageData with blanking) with cell data. The\n"
  "reader currently supports only north up images. Flips along X or Y\n"
  "direction are also supported. Arbitrary affine geotransforms or GCPs\n"
  "are not supported. See GDAL Data Model for more information\n"
  "https://www.gdal.org/gdal_datamodel.html\n\n"
  "@sa\n"
  "vtkUniformGrid, vtkImageData\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkGDALRasterReader_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkIOGDAL.vtkGDALRasterReader", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkGDALRasterReader_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkGDALRasterReader_StaticNew()
{
  return vtkGDALRasterReader::New();
}

PyObject *PyvtkGDALRasterReader_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkGDALRasterReader_Type, PyvtkGDALRasterReader_Methods,
    "vtkGDALRasterReader",
 &PyvtkGDALRasterReader_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkImageReader2");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkGDALRasterReader_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkGDALRasterReader(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkGDALRasterReader_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkGDALRasterReader", o) != 0)
  {
    Py_DECREF(o);
  }

}

